

CREATE TABLE `accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_balance` double DEFAULT NULL,
  `total_balance` double NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO accounts VALUES("1","CASHBOX","CASH BOX","100","100","Daily Sales","1","1","2023-09-16 17:05:40","2025-03-13 14:08:22");
INSERT INTO accounts VALUES("2","COOP TILL","Cooperative Till","0","0","Coop Till (400200,","0","1","2025-01-04 21:50:15","2025-03-13 14:12:02");
INSERT INTO accounts VALUES("3","MPESA","MPESA","0","0","","","1","2025-01-04 21:52:32","2025-01-04 21:52:32");
INSERT INTO accounts VALUES("4","NASHON EQUITY 01","CAPITAL INJECTION (NASHON)","","0","Nashon Capital (Injections Account)","","1","2025-03-13 14:08:00","2025-03-18 15:03:25");
INSERT INTO accounts VALUES("5","DANIEL EQUITY 02","CAPITAL INJECTION (DANIEL)","","0","Daniel (Capital Injection Account)","","1","2025-03-13 19:16:47","2025-03-18 15:03:46");



CREATE TABLE `adjustments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `warehouse_id` int NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_qty` double NOT NULL,
  `item` int NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO adjustments VALUES("49","adr-20250118-103105","2","","10","1","","2025-01-18 22:31:05","2025-01-18 22:31:05");
INSERT INTO adjustments VALUES("50","adr-20250316-080505","2","","50","1","","2025-03-16 20:05:05","2025-03-16 20:05:05");
INSERT INTO adjustments VALUES("51","adr-20250318-053212","2","","5","1","","2025-03-18 17:32:12","2025-03-18 17:32:12");
INSERT INTO adjustments VALUES("52","adr-20250318-055336","2","","5","1","","2025-03-18 17:53:36","2025-03-18 17:53:36");
INSERT INTO adjustments VALUES("53","adr-20250321-123848","2","","20","1","","2025-03-21 12:38:48","2025-03-21 12:38:48");
INSERT INTO adjustments VALUES("54","adr-20250322-125630","2","","50","1","","2025-03-22 12:56:30","2025-03-22 12:56:30");
INSERT INTO adjustments VALUES("55","adr-20250322-022337","2","","5","1","","2025-03-22 14:23:37","2025-03-22 14:23:37");
INSERT INTO adjustments VALUES("56","adr-20250322-044413","2","","50","1","","2025-03-22 16:44:13","2025-03-22 16:44:13");
INSERT INTO adjustments VALUES("57","adr-20250322-065252","2","","50","1","","2025-03-22 18:52:52","2025-03-22 18:52:52");
INSERT INTO adjustments VALUES("58","adr-20250324-080513","2","","50","1","","2025-03-24 20:05:13","2025-03-24 20:05:13");
INSERT INTO adjustments VALUES("59","adr-20250324-081619","2","","10","1","","2025-03-24 20:16:19","2025-03-24 20:16:19");
INSERT INTO adjustments VALUES("60","adr-20250324-081839","2","","10","1","","2025-03-24 20:18:39","2025-03-24 20:18:39");
INSERT INTO adjustments VALUES("61","adr-20250324-082438","2","","5","1","","2025-03-24 20:24:38","2025-03-24 20:24:38");
INSERT INTO adjustments VALUES("62","adr-20250325-035228","2","","50","1","","2025-03-25 15:52:28","2025-03-25 15:52:28");
INSERT INTO adjustments VALUES("63","adr-20250325-055654","2","","10","1","","2025-03-25 17:56:54","2025-03-25 17:56:54");
INSERT INTO adjustments VALUES("64","adr-20250326-071640","2","","50","1","","2025-03-26 19:16:40","2025-03-26 19:16:40");
INSERT INTO adjustments VALUES("65","adr-20250327-072537","2","","20","1","","2025-03-27 19:25:37","2025-03-27 19:25:37");
INSERT INTO adjustments VALUES("66","adr-20250327-072645","2","","5","1","","2025-03-27 19:26:45","2025-03-27 19:26:45");
INSERT INTO adjustments VALUES("67","adr-20250328-081512","2","","10","1","","2025-03-28 20:15:12","2025-03-28 20:15:12");
INSERT INTO adjustments VALUES("68","adr-20250331-033424","2","","6","1","","2025-03-31 15:34:24","2025-03-31 15:34:24");
INSERT INTO adjustments VALUES("69","adr-20250331-035314","2","","20","1","","2025-03-31 15:53:14","2025-03-31 15:53:14");
INSERT INTO adjustments VALUES("70","adr-20250331-051644","2","","10","1","","2025-03-31 17:16:44","2025-03-31 17:16:44");
INSERT INTO adjustments VALUES("71","adr-20250331-060626","2","","30","1","","2025-03-31 18:06:26","2025-03-31 18:06:26");
INSERT INTO adjustments VALUES("72","adr-20250331-065416","2","","6","1","","2025-03-31 18:54:16","2025-03-31 18:54:16");
INSERT INTO adjustments VALUES("73","adr-20250331-073611","2","","10","1","","2025-03-31 19:36:11","2025-03-31 19:36:11");
INSERT INTO adjustments VALUES("74","adr-20250401-034402","2","","10","1","","2025-04-01 15:44:02","2025-04-01 15:44:02");
INSERT INTO adjustments VALUES("75","adr-20250401-041601","2","","3","1","","2025-04-01 16:16:01","2025-04-01 16:16:01");
INSERT INTO adjustments VALUES("76","adr-20250401-041648","2","","2","1","","2025-04-01 16:16:48","2025-04-01 16:16:48");
INSERT INTO adjustments VALUES("77","adr-20250401-041731","2","","5","1","","2025-04-01 16:17:31","2025-04-01 16:17:31");
INSERT INTO adjustments VALUES("78","adr-20250401-041818","2","","4","1","","2025-04-01 16:18:18","2025-04-01 16:18:18");



CREATE TABLE `attendances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` int NOT NULL,
  `user_id` int NOT NULL,
  `checkin` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkout` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `billers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO billers VALUES("1","GENERAL","20250313090911.png","LIMSA STORE NUNGUNI","","LimsaAgrovet@mail.com","0720686829","Nunguni Market Off Kikoko Rd","NUNGUNI","","00000","Kenya","1","2023-06-21 17:19:18","2025-03-13 21:12:09");



CREATE TABLE `brands` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO brands VALUES("1","Honda","","0","2023-09-11 21:57:27","2025-01-04 17:04:10");
INSERT INTO brands VALUES("2","SIGMA FEEDS","20250226050859.png","1","2025-01-04 17:03:56","2025-02-26 17:08:59");
INSERT INTO brands VALUES("3","SIMLAW SEEDS","20250104050508.jpeg","1","2025-01-04 17:05:08","2025-01-04 17:05:08");
INSERT INTO brands VALUES("4","VET PRO (POUTRY)","20250226050755.png","1","2025-02-25 12:58:52","2025-02-26 17:07:55");
INSERT INTO brands VALUES("5","VET PRO (VET)","20250226050810.png","1","2025-02-25 13:01:05","2025-02-26 17:08:10");
INSERT INTO brands VALUES("6","LOCAL BRAND","20250226051009.png","1","2025-02-26 17:10:09","2025-02-26 17:10:09");
INSERT INTO brands VALUES("7","ELGON","20250227023457.png","1","2025-02-27 14:33:10","2025-02-27 14:34:57");
INSERT INTO brands VALUES("8","YARA","20250227023352.png","1","2025-02-27 14:33:52","2025-02-27 14:33:52");
INSERT INTO brands VALUES("9","BORA BORA","20250227023946.png","1","2025-02-27 14:39:46","2025-02-27 14:39:46");
INSERT INTO brands VALUES("10","UNGA FEEDS","20250227024239.png","1","2025-02-27 14:42:39","2025-02-27 14:42:39");
INSERT INTO brands VALUES("11","OSHO","20250227025242.png","1","2025-02-27 14:52:42","2025-02-27 14:52:42");
INSERT INTO brands VALUES("12","COPPERS","20250331085428.png","1","2025-03-31 20:54:28","2025-03-31 20:54:28");



CREATE TABLE `cash_registers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `cash_in_hand` double NOT NULL,
  `user_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cash_registers VALUES("1","1000","1","1","1","2023-09-11 23:48:57","2023-09-11 23:48:57");
INSERT INTO cash_registers VALUES("2","0","2","1","1","2023-09-13 15:21:11","2023-09-13 15:21:11");
INSERT INTO cash_registers VALUES("3","200","1","2","1","2025-01-04 21:30:32","2025-01-04 21:30:32");
INSERT INTO cash_registers VALUES("4","1000","1","2","1","2025-01-04 21:35:40","2025-01-04 21:35:40");
INSERT INTO cash_registers VALUES("5","100","3","2","1","2025-01-18 22:45:30","2025-01-18 22:45:30");



CREATE TABLE `categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO categories VALUES("1","Spares","","","0","2023-09-11 21:56:32","2025-01-04 16:25:22");
INSERT INTO categories VALUES("2","POUTRY FEED","20250104042550.jpg","5","1","2025-01-04 16:25:08","2025-01-04 16:31:26");
INSERT INTO categories VALUES("3","FEEDS","20250104042639.jpg","5","1","2025-01-04 16:26:39","2025-02-27 14:29:24");
INSERT INTO categories VALUES("4","FARM PRODUCTS","20250104043738.jpg","","1","2025-01-04 16:27:40","2025-01-04 16:37:38");
INSERT INTO categories VALUES("5","ANIMAL PRODUCTS","20250104043032.jpeg","","1","2025-01-04 16:30:32","2025-01-04 16:42:16");
INSERT INTO categories VALUES("6","PESTCIDES","20250104044007.jpeg","4","1","2025-01-04 16:40:07","2025-01-04 16:47:27");
INSERT INTO categories VALUES("7","ANIMAL DRUGS","20250104044153.jpeg","5","1","2025-01-04 16:41:53","2025-01-04 16:41:53");
INSERT INTO categories VALUES("8","FERTILIZERS","20250104044405.jpeg","4","1","2025-01-04 16:44:05","2025-01-04 16:44:05");
INSERT INTO categories VALUES("9","FUNGICIDES","20250104044943.jpeg","4","1","2025-01-04 16:49:43","2025-01-04 16:49:43");
INSERT INTO categories VALUES("10","INSECTICIDES","20250104045336.jpeg","4","1","2025-01-04 16:53:36","2025-01-04 16:53:36");
INSERT INTO categories VALUES("11","ANIMAL SUPLIMENTS","20250104045529.jpeg","5","1","2025-01-04 16:55:29","2025-01-04 16:55:29");
INSERT INTO categories VALUES("12","FARM TOOLS / ACCESORIES","20250104045725.jpeg","4","1","2025-01-04 16:57:25","2025-01-04 16:58:12");
INSERT INTO categories VALUES("13","SEEDS","20250226021644.jpg","4","1","2025-02-26 14:13:38","2025-02-26 14:16:44");



CREATE TABLE `coupons` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `minimum_amount` double DEFAULT NULL,
  `quantity` int NOT NULL,
  `used` int NOT NULL,
  `expired_date` date NOT NULL,
  `user_id` int NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `couriers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` int NOT NULL,
  `text` int NOT NULL,
  `sample` int NOT NULL,
  `is_active` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO couriers VALUES("1","1","1","1","1");



CREATE TABLE `currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currencies VALUES("1","Euro","€","1","2023-06-21 17:04:32","2023-06-21 17:04:32");
INSERT INTO currencies VALUES("2","Kenyan Shilling","KES","1","2023-09-09 15:33:49","2023-09-12 00:17:47");



CREATE TABLE `custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `belongs_to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `option_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `grid_value` int NOT NULL,
  `is_table` tinyint(1) NOT NULL,
  `is_invoice` tinyint(1) NOT NULL,
  `is_required` tinyint(1) NOT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `is_disable` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `customer_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_groups VALUES("1","Default","0","1","2023-06-21 17:16:34","2023-06-21 17:16:34");



CREATE TABLE `customers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` double DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `expense` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers VALUES("1","1","","General Default","None","demo@mail.com","0","","None","None","","","","4945","","","1","2023-06-21 17:17:34","2025-04-01 19:07:10");
INSERT INTO customers VALUES("2","1","","Nashon Muteti","","nashonmuteti@gmail.com","0720686829","","First Freight Lane Embakasi JKIA","Nairobi","","","","","","","1","2025-01-02 15:04:17","2025-01-02 15:04:17");
INSERT INTO customers VALUES("3","1","","Dan","","","0720900624","","nni","nni","","","","16","","","1","2025-01-18 22:19:10","2025-01-18 22:50:23");



CREATE TABLE `deliveries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sale_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivered_by` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recieved_by` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `departments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES("1","Sales","1","2023-09-13 12:57:29","2023-09-13 12:57:29");
INSERT INTO departments VALUES("2","Management","1","2024-12-30 22:29:18","2024-12-30 22:29:18");



CREATE TABLE `deposits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `customer_id` int NOT NULL,
  `user_id` int NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `discount_plan_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `discount_plan_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `discount_plan_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `discount_id` int NOT NULL,
  `discount_plan_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `discount_plans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `applicable_for` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_list` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `valid_from` date NOT NULL,
  `valid_till` date NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` double NOT NULL,
  `minimum_qty` double NOT NULL,
  `maximum_qty` double NOT NULL,
  `days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `dso_alerts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `number_of_products` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employees` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `department_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES("1","Isaac","mahircade36@gmail.com","0758909836","1","2","","","","","0","2023-09-13 12:59:39","2025-01-04 21:48:19");
INSERT INTO employees VALUES("2","MUTUNGA","example@gmail.com","1111","1","5","","","","","1","2025-03-22 21:15:33","2025-03-22 21:15:33");



CREATE TABLE `expense_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expense_categories VALUES("1","67032959","Product Expense","0","2025-01-02 14:49:48","2025-01-04 17:06:31");
INSERT INTO expense_categories VALUES("2","0001","RENT","1","2025-01-04 17:06:09","2025-01-04 17:06:09");
INSERT INTO expense_categories VALUES("3","0002","Miscellaneous","1","2025-01-04 17:06:59","2025-03-22 20:56:50");
INSERT INTO expense_categories VALUES("4","0003","BILLS / LICENSES","1","2025-01-04 17:07:39","2025-03-22 20:57:58");
INSERT INTO expense_categories VALUES("5","0004","Workers / Casuals","1","2025-01-04 17:08:22","2025-03-22 20:58:29");



CREATE TABLE `expenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expense_category_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `account_id` int NOT NULL,
  `user_id` int NOT NULL,
  `cash_register_id` int DEFAULT NULL,
  `amount` double NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expenses VALUES("1","er-20250305-071704","2","2","1","1","3","8000","TC59FMSXZB Confirmed. Ksh8,000.00 sent to JACKSON  MBINGILITI 0712418427 on 5/3/25 at 7:41 AM. New M-PESA balance is Ksh10.01. Transaction cost, Ksh90.00.  Amount you can transact within the day is 486,126.00. To schedule payments on MPESA Ratiba today, dial *334#","2025-03-05 00:00:00","2025-03-05 19:17:04");
INSERT INTO expenses VALUES("2","er-20250322-085949","2","2","1","1","3","8000","","2025-01-31 00:00:00","2025-03-22 20:59:49");
INSERT INTO expenses VALUES("3","er-20250322-090109","5","2","1","1","3","6000","Mutunga","2025-01-31 00:00:00","2025-03-22 21:01:09");
INSERT INTO expenses VALUES("4","er-20250322-090251","3","2","1","1","3","1500","Lunch","2025-01-31 00:00:00","2025-03-22 21:02:51");
INSERT INTO expenses VALUES("5","er-20250322-090336","5","2","1","1","3","500","Watchman","2025-01-31 00:00:00","2025-03-22 21:03:36");
INSERT INTO expenses VALUES("6","er-20250322-090505","4","2","1","1","3","140","Stima","2025-01-31 00:00:00","2025-03-22 21:05:31");
INSERT INTO expenses VALUES("7","er-20250322-090617","3","2","1","1","3","1300","Packing Bags","2025-01-31 00:00:00","2025-03-22 21:06:17");
INSERT INTO expenses VALUES("8","er-20250322-090652","3","2","1","1","3","120","Soap","2025-01-31 00:00:00","2025-03-22 21:06:52");
INSERT INTO expenses VALUES("9","er-20250331-042703","4","2","2","1","3","9500","TCV2TNHU08 Confirmed. Ksh9,500.00 sent to MAKUENI COUNTY GOVERNMENT for account BNZ7737JWD612 on 31/3/25 at 3:25 PM New M-PESA balance is Ksh 66.01. Transaction cost, Ksh42.00","2025-03-31 16:27:03","2025-03-31 16:27:03");



CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `site_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_rtl` tinyint(1) DEFAULT NULL,
  `currency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `package_id` int DEFAULT NULL,
  `staff_access` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `developed_by` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal` int DEFAULT '2',
  `state` int DEFAULT NULL,
  `theme` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `is_zatca` tinyint(1) DEFAULT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_registration_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES("1","LIMSA - Agrovet","20250104042156.png","0","2","","own","d/m/Y","Myne Interactive","standard","0","1","default.css","2023-06-21 03:00:00","2025-03-16 20:31:12","prefix","","0","","");



CREATE TABLE `gift_card_recharges` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `gift_card_id` int NOT NULL,
  `amount` double NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `gift_cards` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `card_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `expense` double NOT NULL,
  `customer_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `expired_date` date DEFAULT NULL,
  `created_by` int NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_cards VALUES("1","5731050836490236","1000","0","","3","2025-01-04","1","1","2025-01-04 21:34:33","2025-01-04 21:34:33");



CREATE TABLE `holidays` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_approved` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `hrm_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `checkin` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkout` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO hrm_settings VALUES("1","7:00am","7:30pm","2024-12-30 23:11:12","2024-12-30 23:11:12");



CREATE TABLE `languages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO languages VALUES("1","en","2018-07-08 01:59:17","2019-12-24 20:34:20");



CREATE TABLE `mail_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `driver` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `host` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `port` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `encryption` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES("1","2014_10_12_000000_create_users_table","1");
INSERT INTO migrations VALUES("2","2014_10_12_100000_create_password_resets_table","1");
INSERT INTO migrations VALUES("3","2018_02_17_060412_create_categories_table","1");
INSERT INTO migrations VALUES("4","2018_02_20_035727_create_brands_table","1");
INSERT INTO migrations VALUES("5","2018_02_25_100635_create_suppliers_table","1");
INSERT INTO migrations VALUES("6","2018_02_27_101619_create_warehouse_table","1");
INSERT INTO migrations VALUES("7","2018_03_03_040448_create_units_table","1");
INSERT INTO migrations VALUES("8","2018_03_04_041317_create_taxes_table","1");
INSERT INTO migrations VALUES("9","2018_03_10_061915_create_customer_groups_table","1");
INSERT INTO migrations VALUES("10","2018_03_10_090534_create_customers_table","1");
INSERT INTO migrations VALUES("11","2018_03_11_095547_create_billers_table","1");
INSERT INTO migrations VALUES("12","2018_04_05_054401_create_products_table","1");
INSERT INTO migrations VALUES("13","2018_04_06_133606_create_purchases_table","1");
INSERT INTO migrations VALUES("14","2018_04_06_154600_create_product_purchases_table","1");
INSERT INTO migrations VALUES("15","2018_04_06_154915_create_product_warhouse_table","1");
INSERT INTO migrations VALUES("16","2018_04_10_085927_create_sales_table","1");
INSERT INTO migrations VALUES("17","2018_04_10_090133_create_product_sales_table","1");
INSERT INTO migrations VALUES("18","2018_04_10_090254_create_payments_table","1");
INSERT INTO migrations VALUES("19","2018_04_10_090341_create_payment_with_cheque_table","1");
INSERT INTO migrations VALUES("20","2018_04_10_090509_create_payment_with_credit_card_table","1");
INSERT INTO migrations VALUES("21","2018_04_13_121436_create_quotation_table","1");
INSERT INTO migrations VALUES("22","2018_04_13_122324_create_product_quotation_table","1");
INSERT INTO migrations VALUES("23","2018_04_14_121802_create_transfers_table","1");
INSERT INTO migrations VALUES("24","2018_04_14_121913_create_product_transfer_table","1");
INSERT INTO migrations VALUES("25","2018_05_13_082847_add_payment_id_and_change_sale_id_to_payments_table","2");
INSERT INTO migrations VALUES("26","2018_05_13_090906_change_customer_id_to_payment_with_credit_card_table","3");
INSERT INTO migrations VALUES("27","2018_05_20_054532_create_adjustments_table","4");
INSERT INTO migrations VALUES("28","2018_05_20_054859_create_product_adjustments_table","4");
INSERT INTO migrations VALUES("29","2018_05_21_163419_create_returns_table","5");
INSERT INTO migrations VALUES("30","2018_05_21_163443_create_product_returns_table","5");
INSERT INTO migrations VALUES("31","2018_06_02_050905_create_roles_table","6");
INSERT INTO migrations VALUES("32","2018_06_02_073430_add_columns_to_users_table","7");
INSERT INTO migrations VALUES("33","2018_06_03_053738_create_permission_tables","8");
INSERT INTO migrations VALUES("34","2018_06_21_063736_create_pos_setting_table","9");
INSERT INTO migrations VALUES("35","2018_06_21_094155_add_user_id_to_sales_table","10");
INSERT INTO migrations VALUES("36","2018_06_21_101529_add_user_id_to_purchases_table","11");
INSERT INTO migrations VALUES("37","2018_06_21_103512_add_user_id_to_transfers_table","12");
INSERT INTO migrations VALUES("38","2018_06_23_061058_add_user_id_to_quotations_table","13");
INSERT INTO migrations VALUES("39","2018_06_23_082427_add_is_deleted_to_users_table","14");
INSERT INTO migrations VALUES("40","2018_06_25_043308_change_email_to_users_table","15");
INSERT INTO migrations VALUES("41","2018_07_06_115449_create_general_settings_table","16");
INSERT INTO migrations VALUES("42","2018_07_08_043944_create_languages_table","17");
INSERT INTO migrations VALUES("43","2018_07_11_102144_add_user_id_to_returns_table","18");
INSERT INTO migrations VALUES("44","2018_07_11_102334_add_user_id_to_payments_table","18");
INSERT INTO migrations VALUES("45","2018_07_22_130541_add_digital_to_products_table","19");
INSERT INTO migrations VALUES("46","2018_07_24_154250_create_deliveries_table","20");
INSERT INTO migrations VALUES("47","2018_08_16_053336_create_expense_categories_table","21");
INSERT INTO migrations VALUES("48","2018_08_17_115415_create_expenses_table","22");
INSERT INTO migrations VALUES("49","2018_08_18_050418_create_gift_cards_table","23");
INSERT INTO migrations VALUES("50","2018_08_19_063119_create_payment_with_gift_card_table","24");
INSERT INTO migrations VALUES("51","2018_08_25_042333_create_gift_card_recharges_table","25");
INSERT INTO migrations VALUES("52","2018_08_25_101354_add_deposit_expense_to_customers_table","26");
INSERT INTO migrations VALUES("53","2018_08_26_043801_create_deposits_table","27");
INSERT INTO migrations VALUES("54","2018_09_02_044042_add_keybord_active_to_pos_setting_table","28");
INSERT INTO migrations VALUES("55","2018_09_09_092713_create_payment_with_paypal_table","29");
INSERT INTO migrations VALUES("56","2018_09_10_051254_add_currency_to_general_settings_table","30");
INSERT INTO migrations VALUES("57","2018_10_22_084118_add_biller_and_store_id_to_users_table","31");
INSERT INTO migrations VALUES("58","2018_10_26_034927_create_coupons_table","32");
INSERT INTO migrations VALUES("59","2018_10_27_090857_add_coupon_to_sales_table","33");
INSERT INTO migrations VALUES("60","2018_11_07_070155_add_currency_position_to_general_settings_table","34");
INSERT INTO migrations VALUES("61","2018_11_19_094650_add_combo_to_products_table","35");
INSERT INTO migrations VALUES("62","2018_12_09_043712_create_accounts_table","36");
INSERT INTO migrations VALUES("63","2018_12_17_112253_add_is_default_to_accounts_table","37");
INSERT INTO migrations VALUES("64","2018_12_19_103941_add_account_id_to_payments_table","38");
INSERT INTO migrations VALUES("65","2018_12_20_065900_add_account_id_to_expenses_table","39");
INSERT INTO migrations VALUES("66","2018_12_20_082753_add_account_id_to_returns_table","40");
INSERT INTO migrations VALUES("67","2018_12_26_064330_create_return_purchases_table","41");
INSERT INTO migrations VALUES("68","2018_12_26_144210_create_purchase_product_return_table","42");
INSERT INTO migrations VALUES("69","2018_12_26_144708_create_purchase_product_return_table","43");
INSERT INTO migrations VALUES("70","2018_12_27_110018_create_departments_table","44");
INSERT INTO migrations VALUES("71","2018_12_30_054844_create_employees_table","45");
INSERT INTO migrations VALUES("72","2018_12_31_125210_create_payrolls_table","46");
INSERT INTO migrations VALUES("73","2018_12_31_150446_add_department_id_to_employees_table","47");
INSERT INTO migrations VALUES("74","2019_01_01_062708_add_user_id_to_expenses_table","48");
INSERT INTO migrations VALUES("75","2019_01_02_075644_create_hrm_settings_table","49");
INSERT INTO migrations VALUES("76","2019_01_02_090334_create_attendances_table","50");
INSERT INTO migrations VALUES("77","2019_01_27_160956_add_three_columns_to_general_settings_table","51");
INSERT INTO migrations VALUES("78","2019_02_15_183303_create_stock_counts_table","52");
INSERT INTO migrations VALUES("79","2019_02_17_101604_add_is_adjusted_to_stock_counts_table","53");
INSERT INTO migrations VALUES("80","2019_04_13_101707_add_tax_no_to_customers_table","54");
INSERT INTO migrations VALUES("81","2019_10_14_111455_create_holidays_table","55");
INSERT INTO migrations VALUES("82","2019_11_13_145619_add_is_variant_to_products_table","56");
INSERT INTO migrations VALUES("83","2019_11_13_150206_create_product_variants_table","57");
INSERT INTO migrations VALUES("84","2019_11_13_153828_create_variants_table","57");
INSERT INTO migrations VALUES("85","2019_11_25_134041_add_qty_to_product_variants_table","58");
INSERT INTO migrations VALUES("86","2019_11_25_134922_add_variant_id_to_product_purchases_table","58");
INSERT INTO migrations VALUES("87","2019_11_25_145341_add_variant_id_to_product_warehouse_table","58");
INSERT INTO migrations VALUES("88","2019_11_29_182201_add_variant_id_to_product_sales_table","59");
INSERT INTO migrations VALUES("89","2019_12_04_121311_add_variant_id_to_product_quotation_table","60");
INSERT INTO migrations VALUES("90","2019_12_05_123802_add_variant_id_to_product_transfer_table","61");
INSERT INTO migrations VALUES("91","2019_12_08_114954_add_variant_id_to_product_returns_table","62");
INSERT INTO migrations VALUES("92","2019_12_08_203146_add_variant_id_to_purchase_product_return_table","63");
INSERT INTO migrations VALUES("93","2020_02_28_103340_create_money_transfers_table","64");
INSERT INTO migrations VALUES("94","2020_07_01_193151_add_image_to_categories_table","65");
INSERT INTO migrations VALUES("95","2020_09_26_130426_add_user_id_to_deliveries_table","66");
INSERT INTO migrations VALUES("96","2020_10_11_125457_create_cash_registers_table","67");
INSERT INTO migrations VALUES("97","2020_10_13_155019_add_cash_register_id_to_sales_table","68");
INSERT INTO migrations VALUES("98","2020_10_13_172624_add_cash_register_id_to_returns_table","69");
INSERT INTO migrations VALUES("99","2020_10_17_212338_add_cash_register_id_to_payments_table","70");
INSERT INTO migrations VALUES("100","2020_10_18_124200_add_cash_register_id_to_expenses_table","71");
INSERT INTO migrations VALUES("101","2020_10_21_121632_add_developed_by_to_general_settings_table","72");
INSERT INTO migrations VALUES("102","2019_08_19_000000_create_failed_jobs_table","73");
INSERT INTO migrations VALUES("103","2020_10_30_135557_create_notifications_table","73");
INSERT INTO migrations VALUES("104","2020_11_01_044954_create_currencies_table","74");
INSERT INTO migrations VALUES("105","2020_11_01_140736_add_price_to_product_warehouse_table","75");
INSERT INTO migrations VALUES("106","2020_11_02_050633_add_is_diff_price_to_products_table","76");
INSERT INTO migrations VALUES("107","2020_11_09_055222_add_user_id_to_customers_table","77");
INSERT INTO migrations VALUES("108","2020_11_17_054806_add_invoice_format_to_general_settings_table","78");
INSERT INTO migrations VALUES("109","2021_02_10_074859_add_variant_id_to_product_adjustments_table","79");
INSERT INTO migrations VALUES("110","2021_03_07_093606_create_product_batches_table","80");
INSERT INTO migrations VALUES("111","2021_03_07_093759_add_product_batch_id_to_product_warehouse_table","80");
INSERT INTO migrations VALUES("112","2021_03_07_093900_add_product_batch_id_to_product_purchases_table","80");
INSERT INTO migrations VALUES("113","2021_03_11_132603_add_product_batch_id_to_product_sales_table","81");
INSERT INTO migrations VALUES("114","2021_03_25_125421_add_is_batch_to_products_table","82");
INSERT INTO migrations VALUES("115","2021_05_19_120127_add_product_batch_id_to_product_returns_table","82");
INSERT INTO migrations VALUES("116","2021_05_22_105611_add_product_batch_id_to_purchase_product_return_table","83");
INSERT INTO migrations VALUES("117","2021_05_23_124848_add_product_batch_id_to_product_transfer_table","84");
INSERT INTO migrations VALUES("118","2021_05_26_153106_add_product_batch_id_to_product_quotation_table","85");
INSERT INTO migrations VALUES("119","2021_06_08_213007_create_reward_point_settings_table","86");
INSERT INTO migrations VALUES("120","2021_06_16_104155_add_points_to_customers_table","87");
INSERT INTO migrations VALUES("121","2021_06_17_101057_add_used_points_to_payments_table","88");
INSERT INTO migrations VALUES("122","2021_07_06_132716_add_variant_list_to_products_table","89");
INSERT INTO migrations VALUES("123","2021_09_27_161141_add_is_imei_to_products_table","90");
INSERT INTO migrations VALUES("124","2021_09_28_170052_add_imei_number_to_product_warehouse_table","91");
INSERT INTO migrations VALUES("125","2021_09_28_170126_add_imei_number_to_product_purchases_table","91");
INSERT INTO migrations VALUES("126","2021_10_03_170652_add_imei_number_to_product_sales_table","92");
INSERT INTO migrations VALUES("127","2021_10_10_145214_add_imei_number_to_product_returns_table","93");
INSERT INTO migrations VALUES("128","2021_10_11_104504_add_imei_number_to_product_transfer_table","94");
INSERT INTO migrations VALUES("129","2021_10_12_160107_add_imei_number_to_purchase_product_return_table","95");
INSERT INTO migrations VALUES("130","2021_10_12_205146_add_is_rtl_to_general_settings_table","96");
INSERT INTO migrations VALUES("131","2021_10_23_142451_add_is_approve_to_payments_table","97");
INSERT INTO migrations VALUES("132","2022_01_13_191242_create_discount_plans_table","97");
INSERT INTO migrations VALUES("133","2022_01_14_174318_create_discount_plan_customers_table","97");
INSERT INTO migrations VALUES("134","2022_01_14_202439_create_discounts_table","98");
INSERT INTO migrations VALUES("135","2022_01_16_153506_create_discount_plan_discounts_table","98");
INSERT INTO migrations VALUES("136","2022_02_05_174210_add_order_discount_type_and_value_to_sales_table","99");
INSERT INTO migrations VALUES("137","2022_05_26_195506_add_daily_sale_objective_to_products_table","100");
INSERT INTO migrations VALUES("138","2022_05_28_104209_create_dso_alerts_table","101");
INSERT INTO migrations VALUES("139","2022_06_01_112100_add_is_embeded_to_products_table","102");
INSERT INTO migrations VALUES("140","2022_06_14_130505_add_sale_id_to_returns_table","103");
INSERT INTO migrations VALUES("141","2022_07_19_115504_add_variant_data_to_products_table","104");
INSERT INTO migrations VALUES("142","2022_07_25_194300_add_additional_cost_to_product_variants_table","104");
INSERT INTO migrations VALUES("143","2022_09_04_195610_add_purchase_id_to_return_purchases_table","105");
INSERT INTO migrations VALUES("144","2023_01_18_123842_alter_table_pos_setting","106");
INSERT INTO migrations VALUES("145","2023_01_18_125040_alter_table_general_settings","107");
INSERT INTO migrations VALUES("146","2023_01_18_133701_alter_table_pos_setting","108");
INSERT INTO migrations VALUES("147","2023_01_25_145309_add_expiry_date_to_general_settings_table","109");
INSERT INTO migrations VALUES("148","2023_02_23_125656_alter_table_sales","110");
INSERT INTO migrations VALUES("149","2023_02_26_124100_add_package_id_to_general_settings_table","111");
INSERT INTO migrations VALUES("150","2023_03_04_120325_create_custom_fields_table","111");
INSERT INTO migrations VALUES("151","2023_03_22_174352_add_currency_id_and_exchange_rate_to_returns_table","112");
INSERT INTO migrations VALUES("152","2023_03_27_114320_add_currency_id_and_exchange_rate_to_purchases_table","113");
INSERT INTO migrations VALUES("153","2023_03_27_132747_add_currency_id_and_exchange_rate_to_return_purchases_table","114");
INSERT INTO migrations VALUES("154","2023_04_25_150236_create_mail_settings_table","115");
INSERT INTO migrations VALUES("155","2023_05_13_125424_add_zatca_to_general_settings_table","116");
INSERT INTO migrations VALUES("156","2023_05_28_155540_create_tables_table","117");
INSERT INTO migrations VALUES("157","2023_05_29_115039_add_is_table_to_pos_setting_table","117");
INSERT INTO migrations VALUES("158","2023_05_29_115301_add_table_id_to_sales_table","117");
INSERT INTO migrations VALUES("159","2023_05_31_165049_add_queue_no_to_sales_table","117");
INSERT INTO migrations VALUES("160","2023_06_19_153445_add_muri_kha_to_sales_table","117");



CREATE TABLE `money_transfers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_account_id` int NOT NULL,
  `to_account_id` int NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `notifications` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notifications VALUES("1b1a17e5-c249-4410-905c-da0b7585be1c","App\Notifications\SendNotification","App\User","4","{"sender_id":"1","receiver_id":"4","reminder_date":"2025-01-23","document_name":null,"message":"test"}","","2025-01-23 15:17:47","2025-01-23 15:17:47");



CREATE TABLE `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_cheque` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `cheque_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_credit_card` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `customer_id` int DEFAULT NULL,
  `customer_stripe_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `charge_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_gift_card` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `gift_card_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_paypal` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int NOT NULL,
  `transaction_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `payment_reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `purchase_id` int DEFAULT NULL,
  `sale_id` int DEFAULT NULL,
  `cash_register_id` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `amount` double NOT NULL,
  `used_points` double DEFAULT NULL,
  `change` double NOT NULL,
  `paying_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=873 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payments VALUES("4","spr-20230914-092302","2","","23","2","","1970","","0","Cash","","2023-09-14 12:23:02","2023-09-14 12:23:02");
INSERT INTO payments VALUES("5","spr-20230915-101545","2","","24","2","","680","","0","Cash","","2023-09-15 13:15:45","2023-09-15 13:15:45");
INSERT INTO payments VALUES("6","spr-20230915-122259","2","","25","2","","2180","","0","Cash","","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO payments VALUES("7","spr-20230915-012527","2","","26","2","","680","","0","Cash","","2023-09-15 16:25:27","2023-09-15 16:25:27");
INSERT INTO payments VALUES("8","spr-20230915-013532","2","","27","2","","680","","0","Cash","","2023-09-15 16:35:32","2023-09-15 16:35:32");
INSERT INTO payments VALUES("9","spr-20230915-014113","2","","28","2","","2000","","0","Cash","","2023-09-15 16:41:13","2023-09-15 16:41:13");
INSERT INTO payments VALUES("10","spr-20230915-014331","2","","29","2","","680","","0","Cash","","2023-09-15 16:43:31","2023-09-15 16:43:31");
INSERT INTO payments VALUES("11","spr-20230915-014440","2","","30","2","","68","","0","Cash","","2023-09-15 16:44:40","2023-09-15 16:44:40");
INSERT INTO payments VALUES("12","spr-20230915-015201","2","","31","2","","375","","0","Cash","","2023-09-15 16:52:01","2023-09-15 16:52:01");
INSERT INTO payments VALUES("13","spr-20230915-020747","2","","32","2","","210","","0","Cash","","2023-09-15 17:07:47","2023-09-15 17:07:47");
INSERT INTO payments VALUES("14","spr-20230915-031205","2","","33","2","","2715","","0","Cash","","2023-09-15 18:12:05","2023-09-15 18:12:05");
INSERT INTO payments VALUES("15","spr-20230915-033655","2","","34","2","","680","","0","Cash","","2023-09-15 18:36:55","2023-09-15 18:36:55");
INSERT INTO payments VALUES("16","spr-20230915-041651","2","","35","2","","680","","0","Cash","","2023-09-15 19:16:51","2023-09-15 19:16:51");
INSERT INTO payments VALUES("17","spr-20230915-043500","2","","36","2","","400","","0","Cash","","2023-09-15 19:35:00","2023-09-15 19:35:00");
INSERT INTO payments VALUES("18","spr-20230915-050928","2","","37","2","","32","","0","Cash","","2023-09-15 20:09:28","2023-09-15 20:09:28");
INSERT INTO payments VALUES("19","spr-20230915-052821","2","","38","2","","587","","0","Cash","","2023-09-15 20:28:21","2023-09-15 20:28:21");
INSERT INTO payments VALUES("20","spr-20230915-054838","2","","39","2","","500","","0","Cash","","2023-09-15 20:48:38","2023-09-15 20:48:38");
INSERT INTO payments VALUES("21","spr-20230915-061054","2","","40","2","","1065","","0","Cash","","2023-09-15 21:10:54","2023-09-15 21:10:54");
INSERT INTO payments VALUES("22","spr-20230915-061155","2","","41","2","","680","","0","Cash","","2023-09-15 21:11:55","2023-09-15 21:11:55");
INSERT INTO payments VALUES("23","spr-20230915-062607","2","","42","2","","680","","0","Cash","","2023-09-15 21:26:07","2023-09-15 21:26:07");
INSERT INTO payments VALUES("24","spr-20230916-095636","2","","43","2","","1970","","0","Cash","","2023-09-16 12:56:36","2023-09-16 12:56:36");
INSERT INTO payments VALUES("25","spr-20230916-101732","2","","44","2","","1000","","0","Cash","","2023-09-16 13:17:32","2023-09-16 13:17:32");
INSERT INTO payments VALUES("26","spr-20230916-103757","2","","45","2","","680","","0","Cash","","2023-09-16 13:37:57","2023-09-16 13:37:57");
INSERT INTO payments VALUES("27","spr-20230916-112202","2","","46","2","","1295","","0","Cash","","2023-09-16 14:22:02","2023-09-16 14:22:02");
INSERT INTO payments VALUES("28","spr-20230916-112515","2","","47","2","","680","","0","Cash","","2023-09-16 14:25:15","2023-09-16 14:25:15");
INSERT INTO payments VALUES("29","spr-20230916-123504","2","","48","2","","680","","0","Cash","","2023-09-16 15:35:04","2023-09-16 15:35:04");
INSERT INTO payments VALUES("30","spr-20230916-013151","2","","49","2","","400","","0","Cash","","2023-09-16 16:31:51","2023-09-16 16:31:51");
INSERT INTO payments VALUES("31","spr-20230916-014630","2","","50","2","","680","","0","Cash","","2023-09-16 16:46:30","2023-09-16 16:46:30");
INSERT INTO payments VALUES("34","spr-20230916-022923","2","","53","2","1","785","","0","Cash","","2023-09-16 17:29:23","2023-09-16 17:29:23");
INSERT INTO payments VALUES("35","spr-20230916-025942","2","","54","2","1","360","","0","Cash","","2023-09-16 17:59:42","2023-09-16 17:59:42");
INSERT INTO payments VALUES("36","spr-20230916-030325","2","","55","2","1","680","","0","Cash","","2023-09-16 18:03:25","2023-09-16 18:03:25");
INSERT INTO payments VALUES("37","spr-20230916-045600","2","","56","2","1","2180","","0","Cash","","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO payments VALUES("38","spr-20230916-062514","2","","57","2","1","235","","0","Cash","","2023-09-16 21:25:14","2023-09-16 21:25:14");
INSERT INTO payments VALUES("39","spr-20230916-064017","2","","58","2","1","680","","0","Cash","","2023-09-16 21:40:17","2023-09-16 21:40:17");
INSERT INTO payments VALUES("40","spr-20230917-113424","2","","59","2","1","35","","0","Cash","","2023-09-17 14:34:24","2023-09-17 14:34:24");
INSERT INTO payments VALUES("41","spr-20230917-115407","2","","60","2","1","250","","0","Cash","","2023-09-17 14:54:07","2023-09-17 14:54:07");
INSERT INTO payments VALUES("42","spr-20230917-121912","2","","61","2","1","712","","0","Cash","","2023-09-17 15:19:12","2023-09-17 15:19:12");
INSERT INTO payments VALUES("43","spr-20230917-124523","2","","62","2","1","1800","","0","Cash","","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO payments VALUES("44","spr-20230917-125758","2","","63","2","1","680","","0","Cash","","2023-09-17 15:57:58","2023-09-17 15:57:58");
INSERT INTO payments VALUES("45","spr-20230917-125918","2","","64","2","1","680","","0","Cash","","2023-09-17 15:59:18","2023-09-17 15:59:18");
INSERT INTO payments VALUES("46","spr-20230917-012101","2","","65","2","1","135","","0","Cash","","2023-09-17 16:21:01","2023-09-17 16:21:01");
INSERT INTO payments VALUES("47","spr-20230917-012151","2","","66","2","1","680","","0","Cash","","2023-09-17 16:21:51","2023-09-17 16:21:51");
INSERT INTO payments VALUES("48","spr-20230917-023253","2","","67","2","1","680","","0","Cash","","2023-09-17 17:32:53","2023-09-17 17:32:53");
INSERT INTO payments VALUES("49","spr-20230917-024939","2","","68","2","1","680","","0","Cash","","2023-09-17 17:49:39","2023-09-17 17:49:39");
INSERT INTO payments VALUES("50","spr-20230917-034750","2","","69","2","1","505","","0","Cash","","2023-09-17 18:47:50","2023-09-17 18:47:50");
INSERT INTO payments VALUES("51","spr-20230917-040809","2","","70","2","1","3815","","0","Cash","","2023-09-17 19:08:09","2023-09-17 19:08:09");
INSERT INTO payments VALUES("52","spr-20230917-051529","2","","71","2","1","680","","0","Cash","","2023-09-17 20:15:29","2023-09-17 20:15:29");
INSERT INTO payments VALUES("53","spr-20230917-064519","2","","72","2","1","2650","","0","Cash","","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO payments VALUES("54","spr-20230918-094734","2","","73","2","1","400","","0","Cash","","2023-09-18 12:47:34","2023-09-18 12:47:34");
INSERT INTO payments VALUES("55","spr-20230918-104815","2","","74","2","1","780","","0","Cash","","2023-09-18 13:48:15","2023-09-18 13:48:15");
INSERT INTO payments VALUES("56","spr-20230918-110035","2","","75","2","1","400","","0","Cash","","2023-09-18 14:00:35","2023-09-18 14:00:35");
INSERT INTO payments VALUES("57","spr-20230918-122618","2","","76","2","1","680","","0","Cash","","2023-09-18 15:26:18","2023-09-18 15:26:18");
INSERT INTO payments VALUES("58","spr-20230918-122826","2","","77","2","1","680","","0","Cash","","2023-09-18 15:28:26","2023-09-18 15:28:26");
INSERT INTO payments VALUES("59","spr-20230918-010617","2","","78","2","1","596","","0","Cash","","2023-09-18 16:06:17","2023-09-18 16:06:17");
INSERT INTO payments VALUES("60","spr-20230918-012212","2","","79","2","1","161","","0","Cash","","2023-09-18 16:22:12","2023-09-18 16:22:12");
INSERT INTO payments VALUES("61","spr-20230918-031548","2","","80","2","1","161","","0","Cash","","2023-09-18 18:15:48","2023-09-18 18:15:48");
INSERT INTO payments VALUES("62","spr-20230918-040115","2","","81","2","1","610","","0","Cash","","2023-09-18 19:01:15","2023-09-18 19:01:15");
INSERT INTO payments VALUES("63","spr-20230918-043100","2","","82","2","1","1465","","0","Cash","","2023-09-18 19:31:00","2023-09-18 19:31:00");
INSERT INTO payments VALUES("64","spr-20230918-045147","2","","83","2","1","380","","0","Cash","","2023-09-18 19:51:47","2023-09-18 19:51:47");
INSERT INTO payments VALUES("65","spr-20230918-063532","2","","84","2","1","25","","0","Cash","","2023-09-18 21:35:32","2023-09-18 21:35:32");
INSERT INTO payments VALUES("66","spr-20230919-093300","2","","85","2","1","680","","0","Cash","","2023-09-19 12:33:00","2023-09-19 12:33:00");
INSERT INTO payments VALUES("67","spr-20230919-100253","2","","86","2","1","2975","","0","Cash","","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO payments VALUES("68","spr-20230919-100435","2","","87","2","1","680","","0","Cash","","2023-09-19 13:04:35","2023-09-19 13:04:35");
INSERT INTO payments VALUES("69","spr-20230919-020741","2","","88","2","1","680","","0","Cash","","2023-09-19 17:07:41","2023-09-19 17:07:41");
INSERT INTO payments VALUES("70","spr-20230919-021348","2","","89","2","1","1295","","0","Cash","","2023-09-19 17:13:48","2023-09-19 17:13:48");
INSERT INTO payments VALUES("71","spr-20230919-022810","2","","90","2","1","1720","","0","Cash","","2023-09-19 17:28:10","2023-09-19 17:28:10");
INSERT INTO payments VALUES("72","spr-20230919-023044","2","","91","2","1","680","","0","Cash","","2023-09-19 17:30:44","2023-09-19 17:30:44");
INSERT INTO payments VALUES("73","spr-20230919-023127","2","","92","2","1","680","","0","Cash","","2023-09-19 17:31:27","2023-09-19 17:31:27");
INSERT INTO payments VALUES("74","spr-20230919-024940","2","","93","2","1","1840","","0","Cash","","2023-09-19 17:49:40","2023-09-19 17:49:40");
INSERT INTO payments VALUES("75","spr-20230919-034521","2","","94","2","1","1830","","0","Cash","","2023-09-19 18:45:21","2023-09-19 18:45:21");
INSERT INTO payments VALUES("76","spr-20230919-041118","2","","95","2","1","490","","0","Cash","","2023-09-19 19:11:18","2023-09-19 19:11:18");
INSERT INTO payments VALUES("77","spr-20230919-042438","2","","96","2","1","290","","0","Cash","","2023-09-19 19:24:38","2023-09-19 19:24:38");
INSERT INTO payments VALUES("78","spr-20230919-043403","2","","97","2","1","680","","0","Cash","","2023-09-19 19:34:03","2023-09-19 19:34:03");
INSERT INTO payments VALUES("79","spr-20230919-043504","2","","98","2","1","680","","0","Cash","","2023-09-19 19:35:04","2023-09-19 19:35:04");
INSERT INTO payments VALUES("80","spr-20230919-044813","2","","99","2","1","1780","","0","Cash","","2023-09-19 19:48:13","2023-09-19 19:48:13");
INSERT INTO payments VALUES("81","spr-20230919-050126","2","","100","2","1","2400","","0","Cash","","2023-09-19 20:01:26","2023-09-19 20:01:26");
INSERT INTO payments VALUES("82","spr-20230919-061038","2","","101","2","1","680","","0","Cash","","2023-09-19 21:10:38","2023-09-19 21:10:38");
INSERT INTO payments VALUES("84","spr-20230920-095141","2","","103","2","1","680","","0","Credit Card","","2023-09-20 12:51:41","2023-09-20 12:51:41");
INSERT INTO payments VALUES("85","spr-20230920-095559","2","","104","2","1","680","","0","Credit Card","","2023-09-20 12:55:59","2023-09-20 12:55:59");
INSERT INTO payments VALUES("86","spr-20230920-104540","2","","105","2","1","4180","","0","Cash","","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO payments VALUES("87","spr-20230920-105000","2","","106","2","1","680","","0","Credit Card","","2023-09-20 13:50:00","2023-09-20 13:50:00");
INSERT INTO payments VALUES("88","spr-20230920-030035","2","","107","2","1","315","","0","Cash","","2023-09-20 18:00:35","2023-09-20 18:00:35");
INSERT INTO payments VALUES("89","spr-20230920-045125","2","","108","2","1","3070","","0","Cash","","2023-09-20 19:51:25","2023-09-20 19:51:25");
INSERT INTO payments VALUES("90","spr-20230920-053313","2","","109","2","1","680","","0","Cash","","2023-09-20 20:33:13","2023-09-20 20:33:13");
INSERT INTO payments VALUES("91","spr-20230920-053748","2","","110","2","1","680","","0","Credit Card","","2023-09-20 20:37:48","2023-09-20 20:37:48");
INSERT INTO payments VALUES("92","spr-20230921-091533","2","","111","2","1","460","","0","Credit Card","","2023-09-21 12:15:33","2023-09-21 12:15:33");
INSERT INTO payments VALUES("93","spr-20230921-091706","2","","112","2","1","680","","0","Credit Card","","2023-09-21 12:17:06","2023-09-21 12:17:06");
INSERT INTO payments VALUES("94","spr-20230921-091803","2","","113","2","1","495","","0","Credit Card","","2023-09-21 12:18:03","2023-09-21 12:18:03");
INSERT INTO payments VALUES("95","spr-20230921-104757","2","","114","2","1","110","","0","Cash","","2023-09-21 13:47:57","2023-09-21 13:47:57");
INSERT INTO payments VALUES("96","spr-20230921-105746","2","","115","2","1","680","","0","Credit Card","","2023-09-21 13:57:46","2023-09-21 13:57:46");
INSERT INTO payments VALUES("97","spr-20230921-111635","2","","116","2","1","990","","0","Credit Card","","2023-09-21 14:16:35","2023-09-21 14:16:35");
INSERT INTO payments VALUES("98","spr-20230921-111836","2","","117","2","1","680","","0","Credit Card","","2023-09-21 14:18:36","2023-09-21 14:18:36");
INSERT INTO payments VALUES("99","spr-20230921-025613","2","","118","2","1","680","","0","Credit Card","","2023-09-21 17:56:13","2023-09-21 17:56:13");
INSERT INTO payments VALUES("100","spr-20230921-061405","2","","119","2","1","680","","0","Cash","","2023-09-21 21:14:05","2023-09-21 21:14:05");
INSERT INTO payments VALUES("101","spr-20230922-095721","2","","120","2","1","680","","0","Credit Card","","2023-09-22 12:57:21","2023-09-22 12:57:21");
INSERT INTO payments VALUES("102","spr-20230922-105515","2","","121","2","1","1100","","0","Credit Card","","2023-09-22 13:55:15","2023-09-22 13:55:15");
INSERT INTO payments VALUES("103","spr-20230922-115651","2","","122","2","1","60","","0","Credit Card","","2023-09-22 14:56:51","2023-09-22 14:56:51");
INSERT INTO payments VALUES("104","spr-20230922-015618","2","","123","2","1","825","","0","Cash","","2023-09-22 16:56:18","2023-09-22 16:56:18");
INSERT INTO payments VALUES("105","spr-20230922-020403","2","","124","2","1","990","","0","Cash","","2023-09-22 17:04:03","2023-09-22 17:04:03");
INSERT INTO payments VALUES("106","spr-20230922-055154","2","","125","2","1","1800","","0","Cash","","2023-09-22 20:51:54","2023-09-22 20:51:54");
INSERT INTO payments VALUES("107","spr-20230922-055542","2","","126","2","1","680","","0","Credit Card","","2023-09-22 20:55:42","2023-09-22 20:55:42");
INSERT INTO payments VALUES("108","spr-20230922-062201","2","","127","2","1","1175","","0","Cash","","2023-09-22 21:22:01","2023-09-22 21:22:01");
INSERT INTO payments VALUES("109","spr-20230922-063010","2","","128","2","1","35","","0","Cash","","2023-09-22 21:30:10","2023-09-22 21:30:10");
INSERT INTO payments VALUES("110","spr-20230923-085240","2","","129","2","1","680","","0","Cash","","2023-09-23 11:52:40","2023-09-23 11:52:40");
INSERT INTO payments VALUES("111","spr-20230923-104332","2","","130","2","1","680","","0","Cash","","2023-09-23 13:43:32","2023-09-23 13:43:32");
INSERT INTO payments VALUES("112","spr-20230923-115453","2","","131","2","1","680","","0","Credit Card","","2023-09-23 14:54:53","2023-09-23 14:54:53");
INSERT INTO payments VALUES("113","spr-20230923-011525","2","","132","2","1","680","","0","Credit Card","","2023-09-23 16:15:25","2023-09-23 16:15:25");
INSERT INTO payments VALUES("114","spr-20230923-012537","2","","133","2","1","290","","0","Cash","","2023-09-23 16:25:37","2023-09-23 16:25:37");
INSERT INTO payments VALUES("115","spr-20230923-013100","2","","134","2","1","195","","0","Cash","","2023-09-23 16:31:00","2023-09-23 16:31:00");
INSERT INTO payments VALUES("116","spr-20230923-015132","2","","135","2","1","1100","","0","Credit Card","","2023-09-23 16:51:32","2023-09-23 16:51:32");
INSERT INTO payments VALUES("117","spr-20230923-035403","2","","136","2","1","680","","0","Credit Card","","2023-09-23 18:54:03","2023-09-23 18:54:03");
INSERT INTO payments VALUES("118","spr-20230923-044813","2","","137","2","1","680","","0","Credit Card","","2023-09-23 19:48:13","2023-09-23 19:48:13");
INSERT INTO payments VALUES("119","spr-20230923-044931","2","","138","2","1","680","","0","Credit Card","","2023-09-23 19:49:31","2023-09-23 19:49:31");
INSERT INTO payments VALUES("120","spr-20230923-064239","2","","139","2","1","680","","0","Cash","","2023-09-23 21:42:39","2023-09-23 21:42:39");
INSERT INTO payments VALUES("121","spr-20230924-102007","2","","140","2","1","680","","0","Credit Card","","2023-09-24 13:20:07","2023-09-24 13:20:07");
INSERT INTO payments VALUES("122","spr-20230924-111010","2","","141","2","1","680","","0","Cash","","2023-09-24 14:10:10","2023-09-24 14:10:10");
INSERT INTO payments VALUES("123","spr-20230924-112110","2","","142","2","1","1660","","0","Cash","","2023-09-24 14:21:10","2023-09-24 14:21:10");
INSERT INTO payments VALUES("124","spr-20230924-011457","2","","143","2","1","680","","0","Cash","","2023-09-24 16:14:57","2023-09-24 16:14:57");
INSERT INTO payments VALUES("125","spr-20230924-011753","2","","144","2","1","680","","0","Credit Card","","2023-09-24 16:17:53","2023-09-24 16:17:53");
INSERT INTO payments VALUES("126","spr-20230924-011753","2","","145","2","1","680","","0","Credit Card","","2023-09-24 16:17:53","2023-09-24 16:17:53");
INSERT INTO payments VALUES("127","spr-20230924-015842","2","","146","2","1","680","","0","Credit Card","","2023-09-24 16:58:42","2023-09-24 16:58:42");
INSERT INTO payments VALUES("128","spr-20230924-035306","2","","147","2","1","105","","0","Cash","","2023-09-24 18:53:06","2023-09-24 18:53:06");
INSERT INTO payments VALUES("129","spr-20230924-045429","2","","148","2","1","680","","0","Credit Card","","2023-09-24 19:54:29","2023-09-24 19:54:29");
INSERT INTO payments VALUES("130","spr-20230924-052117","2","","149","2","1","680","","0","Credit Card","","2023-09-24 20:21:17","2023-09-24 20:21:17");
INSERT INTO payments VALUES("131","spr-20230924-052853","2","","150","2","1","495","","0","Cash","","2023-09-24 20:28:53","2023-09-24 20:28:53");
INSERT INTO payments VALUES("132","spr-20230925-080130","2","","151","2","1","45","","0","Cash","","2023-09-25 11:01:30","2023-09-25 11:01:30");
INSERT INTO payments VALUES("133","spr-20230925-085213","2","","152","2","1","680","","0","Credit Card","","2023-09-25 11:52:13","2023-09-25 11:52:13");
INSERT INTO payments VALUES("134","spr-20230925-092742","2","","153","2","1","495","","0","Credit Card","","2023-09-25 12:27:42","2023-09-25 12:27:42");
INSERT INTO payments VALUES("135","spr-20230925-101528","2","","154","2","1","3145","","0","Cash","","2023-09-25 13:15:28","2023-09-25 13:15:28");
INSERT INTO payments VALUES("136","spr-20230925-112059","2","","155","2","1","290","","0","Credit Card","","2023-09-25 14:20:59","2023-09-25 14:20:59");
INSERT INTO payments VALUES("137","spr-20230925-112149","2","","156","2","1","495","","0","Cash","","2023-09-25 14:21:49","2023-09-25 14:21:49");
INSERT INTO payments VALUES("138","spr-20230925-120732","2","","157","2","1","10161","","0","Credit Card","","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO payments VALUES("139","spr-20230925-122536","2","","158","2","1","90","","0","Cash","","2023-09-25 15:25:36","2023-09-25 15:25:36");
INSERT INTO payments VALUES("140","spr-20230925-013338","2","","159","2","1","680","","0","Credit Card","","2023-09-25 16:33:38","2023-09-25 16:33:38");
INSERT INTO payments VALUES("141","spr-20230925-023115","2","","160","2","1","105","","0","Cash","","2023-09-25 17:31:15","2023-09-25 17:31:15");
INSERT INTO payments VALUES("142","spr-20230925-031448","2","","161","2","1","4135","","0","Credit Card","","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO payments VALUES("143","spr-20230925-031818","2","","162","2","1","810","","0","Credit Card","","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO payments VALUES("144","spr-20230925-032138","2","","163","2","1","1120","","0","Cash","","2023-09-25 18:21:38","2023-09-25 18:21:38");
INSERT INTO payments VALUES("145","spr-20230925-032832","2","","164","2","1","680","","0","Cash","","2023-09-25 18:28:32","2023-09-25 18:28:32");
INSERT INTO payments VALUES("146","spr-20230925-042017","2","","165","2","1","2460","","0","Cash","","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO payments VALUES("147","spr-20230925-044242","2","","166","2","1","680","","0","Credit Card","","2023-09-25 19:42:42","2023-09-25 19:42:42");
INSERT INTO payments VALUES("148","spr-20230925-045913","2","","167","2","1","505","","0","Cash","","2023-09-25 19:59:13","2023-09-25 19:59:13");
INSERT INTO payments VALUES("149","spr-20230925-050653","2","","168","2","1","310","","0","Cash","","2023-09-25 20:06:53","2023-09-25 20:06:53");
INSERT INTO payments VALUES("150","spr-20230925-060027","2","","169","2","1","495","","0","Cash","","2023-09-25 21:00:27","2023-09-25 21:00:27");
INSERT INTO payments VALUES("151","spr-20230926-084908","2","","170","2","1","680","","0","Credit Card","","2023-09-26 11:49:08","2023-09-26 11:49:08");
INSERT INTO payments VALUES("152","spr-20230926-092350","2","","171","2","1","680","","0","Credit Card","","2023-09-26 12:23:50","2023-09-26 12:23:50");
INSERT INTO payments VALUES("153","spr-20230926-101326","2","","172","2","1","896","","0","Credit Card","","2023-09-26 13:13:26","2023-09-26 13:13:26");
INSERT INTO payments VALUES("154","spr-20230926-044130","2","","173","2","1","3620","","0","Credit Card","","2023-09-26 19:41:30","2023-09-26 19:41:30");
INSERT INTO payments VALUES("155","spr-20230926-044333","2","","174","2","1","225","","0","Credit Card","","2023-09-26 19:43:33","2023-09-26 19:43:33");
INSERT INTO payments VALUES("156","spr-20230926-044720","2","","175","2","1","5240","","0","Credit Card","","2023-09-26 19:47:20","2023-09-26 19:47:20");
INSERT INTO payments VALUES("157","spr-20230926-044943","2","","176","2","1","265","","0","Cash","","2023-09-26 19:49:43","2023-09-26 19:49:43");
INSERT INTO payments VALUES("158","spr-20230926-045107","2","","177","2","1","680","","0","Cash","","2023-09-26 19:51:07","2023-09-26 19:51:07");
INSERT INTO payments VALUES("159","spr-20230926-045226","2","","178","2","1","680","","0","Credit Card","","2023-09-26 19:52:26","2023-09-26 19:52:26");
INSERT INTO payments VALUES("160","spr-20230926-045346","2","","179","2","1","680","","0","Credit Card","","2023-09-26 19:53:46","2023-09-26 19:53:46");
INSERT INTO payments VALUES("161","spr-20230926-045458","2","","180","2","1","680","","0","Credit Card","","2023-09-26 19:54:58","2023-09-26 19:54:58");
INSERT INTO payments VALUES("162","spr-20230926-053856","2","","181","2","1","2460","","0","Cash","","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO payments VALUES("163","spr-20230926-062031","2","","182","2","1","680","","0","Credit Card","","2023-09-26 21:20:31","2023-09-26 21:20:31");
INSERT INTO payments VALUES("164","spr-20230927-113031","2","","183","2","1","1780","","0","Credit Card","","2023-09-27 14:30:31","2023-09-27 14:30:31");
INSERT INTO payments VALUES("165","spr-20230927-010755","2","","184","2","1","1800","","0","Credit Card","","2023-09-27 16:07:55","2023-09-27 16:07:55");
INSERT INTO payments VALUES("166","spr-20230927-014147","2","","185","2","1","680","","0","Credit Card","","2023-09-27 16:41:47","2023-09-27 16:41:47");
INSERT INTO payments VALUES("167","spr-20230927-023210","2","","186","2","1","680","","0","Credit Card","","2023-09-27 17:32:10","2023-09-27 17:32:10");
INSERT INTO payments VALUES("168","spr-20230927-031345","2","","187","2","1","2460","","0","Credit Card","","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO payments VALUES("169","spr-20230927-032956","2","","188","2","1","270","","0","Credit Card","","2023-09-27 18:29:56","2023-09-27 18:29:56");
INSERT INTO payments VALUES("170","spr-20230927-041704","2","","189","2","1","1225","","0","Credit Card","","2023-09-27 19:17:04","2023-09-27 19:17:04");
INSERT INTO payments VALUES("171","spr-20230927-042118","2","","190","2","1","680","","0","Credit Card","","2023-09-27 19:21:18","2023-09-27 19:21:18");
INSERT INTO payments VALUES("172","spr-20230927-042524","2","","191","2","1","680","","0","Cash","","2023-09-27 19:25:24","2023-09-27 19:25:24");
INSERT INTO payments VALUES("173","spr-20230927-043703","2","","192","2","1","2910","","0","Cash","","2023-09-27 19:37:03","2023-09-27 19:37:03");
INSERT INTO payments VALUES("174","spr-20230927-050936","2","","193","2","1","290","","0","Credit Card","","2023-09-27 20:09:36","2023-09-27 20:09:36");
INSERT INTO payments VALUES("175","spr-20230927-062357","2","","194","2","1","680","","0","Credit Card","","2023-09-27 21:23:57","2023-09-27 21:23:57");
INSERT INTO payments VALUES("176","spr-20230927-063452","2","","195","2","1","195","","0","Credit Card","","2023-09-27 21:34:52","2023-09-27 21:34:52");
INSERT INTO payments VALUES("177","spr-20230928-113327","2","","196","2","1","75","","0","Credit Card","","2023-09-28 14:33:27","2023-09-28 14:33:27");
INSERT INTO payments VALUES("178","spr-20230928-124958","2","","197","2","1","680","","0","Credit Card","","2023-09-28 15:49:58","2023-09-28 15:49:58");
INSERT INTO payments VALUES("179","spr-20230928-023434","2","","198","2","1","680","","0","Cash","","2023-09-28 17:34:34","2023-09-28 17:34:34");
INSERT INTO payments VALUES("180","spr-20230928-032217","2","","199","2","1","1555","","0","Credit Card","","2023-09-28 18:22:17","2023-09-28 18:22:17");
INSERT INTO payments VALUES("181","spr-20230929-084239","2","","200","2","1","680","","0","Credit Card","","2023-09-29 11:42:39","2023-09-29 11:42:39");
INSERT INTO payments VALUES("182","spr-20230929-091246","2","","201","2","1","680","","0","Cash","","2023-09-29 12:12:46","2023-09-29 12:12:46");
INSERT INTO payments VALUES("183","spr-20230929-101805","2","","202","2","1","680","","0","Credit Card","","2023-09-29 13:18:05","2023-09-29 13:18:05");
INSERT INTO payments VALUES("184","spr-20230929-114636","2","","203","2","1","1110","","0","Credit Card","","2023-09-29 14:46:36","2023-09-29 14:46:36");
INSERT INTO payments VALUES("185","spr-20230929-012919","2","","204","2","1","680","","0","Cash","","2023-09-29 16:29:19","2023-09-29 16:29:19");
INSERT INTO payments VALUES("186","spr-20230929-013020","2","","205","2","1","680","","0","Credit Card","","2023-09-29 16:30:20","2023-09-29 16:30:20");
INSERT INTO payments VALUES("187","spr-20230929-021901","2","","206","2","1","680","","0","Cash","","2023-09-29 17:19:01","2023-09-29 17:19:01");
INSERT INTO payments VALUES("188","spr-20230929-045330","2","","207","2","1","680","","0","Credit Card","","2023-09-29 19:53:30","2023-09-29 19:53:30");
INSERT INTO payments VALUES("189","spr-20230929-055853","2","","208","2","1","430","","0","Credit Card","","2023-09-29 20:58:53","2023-09-29 20:58:53");
INSERT INTO payments VALUES("190","spr-20230930-083639","2","","209","2","1","680","","0","Credit Card","","2023-09-30 11:36:39","2023-09-30 11:36:39");
INSERT INTO payments VALUES("191","spr-20230930-083851","2","","210","2","1","680","","0","Credit Card","","2023-09-30 11:38:51","2023-09-30 11:38:51");
INSERT INTO payments VALUES("192","spr-20230930-092940","2","","211","2","1","680","","0","Credit Card","","2023-09-30 12:29:40","2023-09-30 12:29:40");
INSERT INTO payments VALUES("193","spr-20230930-094629","2","","212","2","1","680","","0","Credit Card","","2023-09-30 12:46:29","2023-09-30 12:46:29");
INSERT INTO payments VALUES("194","spr-20230930-120042","2","","213","2","1","3925","","0","Credit Card","","2023-09-30 15:00:42","2023-09-30 15:00:42");
INSERT INTO payments VALUES("195","spr-20230930-120458","2","","214","2","1","960","","0","Cash","","2023-09-30 15:04:58","2023-09-30 15:04:58");
INSERT INTO payments VALUES("196","spr-20230930-120650","2","","215","2","1","680","","0","Credit Card","","2023-09-30 15:06:50","2023-09-30 15:06:50");
INSERT INTO payments VALUES("197","spr-20230930-120740","2","","216","2","1","2070","","0","Cash","","2023-09-30 15:07:40","2023-09-30 15:07:40");
INSERT INTO payments VALUES("198","spr-20230930-121133","2","","217","2","1","5780","","0","Cash","","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO payments VALUES("199","spr-20230930-123450","2","","218","2","1","680","","0","Credit Card","","2023-09-30 15:34:50","2023-09-30 15:34:50");
INSERT INTO payments VALUES("200","spr-20230930-010123","2","","219","2","1","35","","0","Cash","","2023-09-30 16:01:23","2023-09-30 16:01:23");
INSERT INTO payments VALUES("201","spr-20230930-033031","2","","220","2","1","960","","0","Credit Card","","2023-09-30 18:30:31","2023-09-30 18:30:31");
INSERT INTO payments VALUES("202","spr-20230930-033557","2","","221","2","1","680","","0","Credit Card","","2023-09-30 18:35:57","2023-09-30 18:35:57");
INSERT INTO payments VALUES("203","spr-20230930-035134","2","","222","2","1","3185","","0","Credit Card","","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO payments VALUES("204","spr-20230930-043515","2","","223","2","1","680","","0","Credit Card","","2023-09-30 19:35:15","2023-09-30 19:35:15");
INSERT INTO payments VALUES("205","spr-20230930-044353","2","","224","2","1","680","","0","Credit Card","","2023-09-30 19:43:53","2023-09-30 19:43:53");
INSERT INTO payments VALUES("206","spr-20230930-045000","2","","225","2","1","1655","","0","Credit Card","","2023-09-30 19:50:00","2023-09-30 19:50:00");
INSERT INTO payments VALUES("207","spr-20230930-055937","2","","226","2","1","680","","0","Credit Card","","2023-09-30 20:59:37","2023-09-30 20:59:37");
INSERT INTO payments VALUES("208","spr-20231001-103156","2","","227","2","1","4335","","0","Credit Card","","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO payments VALUES("209","spr-20231001-103848","2","","228","2","1","570","","0","Credit Card","","2023-10-01 13:38:48","2023-10-01 13:38:48");
INSERT INTO payments VALUES("210","spr-20231001-104324","2","","229","2","1","225","","0","Cash","","2023-10-01 13:43:24","2023-10-01 13:43:24");
INSERT INTO payments VALUES("211","spr-20231001-110550","2","","230","2","1","680","","0","Credit Card","","2023-10-01 14:05:50","2023-10-01 14:05:50");
INSERT INTO payments VALUES("212","spr-20231001-121859","2","","231","2","1","225","","0","Credit Card","","2023-10-01 15:18:59","2023-10-01 15:18:59");
INSERT INTO payments VALUES("213","spr-20231001-122850","2","","232","2","1","505","","0","Credit Card","","2023-10-01 15:28:50","2023-10-01 15:28:50");
INSERT INTO payments VALUES("214","spr-20231001-123858","2","","233","2","1","2970","","0","Credit Card","","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO payments VALUES("215","spr-20231001-124922","2","","234","2","1","216","","0","Credit Card","","2023-10-01 15:49:22","2023-10-01 15:49:22");
INSERT INTO payments VALUES("216","spr-20231001-021428","2","","235","2","1","875","","0","Credit Card","","2023-10-01 17:14:28","2023-10-01 17:14:28");
INSERT INTO payments VALUES("217","spr-20231001-024917","2","","236","2","1","680","","0","Cash","","2023-10-01 17:49:17","2023-10-01 17:49:17");
INSERT INTO payments VALUES("218","spr-20231001-031506","2","","237","2","1","680","","0","Cash","","2023-10-01 18:15:06","2023-10-01 18:15:06");
INSERT INTO payments VALUES("219","spr-20231001-034607","2","","238","2","1","680","","0","Credit Card","","2023-10-01 18:46:07","2023-10-01 18:46:07");
INSERT INTO payments VALUES("220","spr-20231001-052337","2","","239","2","1","440","","0","Credit Card","","2023-10-01 20:23:37","2023-10-01 20:23:37");
INSERT INTO payments VALUES("221","spr-20231001-060104","2","","240","2","1","680","","0","Cash","","2023-10-01 21:01:04","2023-10-01 21:01:04");
INSERT INTO payments VALUES("222","spr-20231001-060159","2","","241","2","1","680","","0","Cash","","2023-10-01 21:01:59","2023-10-01 21:01:59");
INSERT INTO payments VALUES("223","spr-20231001-061319","2","","242","2","1","20","","0","Credit Card","","2023-10-01 21:13:19","2023-10-01 21:13:19");
INSERT INTO payments VALUES("224","spr-20231001-061434","2","","243","2","1","20","","0","Cash","","2023-10-01 21:14:34","2023-10-01 21:14:34");
INSERT INTO payments VALUES("225","spr-20231001-062305","2","","244","2","1","290","","0","Credit Card","","2023-10-01 21:23:05","2023-10-01 21:23:05");
INSERT INTO payments VALUES("226","spr-20231001-064724","2","","245","2","1","1160","","0","Credit Card","","2023-10-01 21:47:24","2023-10-01 21:47:24");
INSERT INTO payments VALUES("227","spr-20231002-085128","2","","246","2","1","680","","0","Cash","","2023-10-02 11:51:28","2023-10-02 11:51:28");
INSERT INTO payments VALUES("228","spr-20231002-090826","2","","247","2","1","680","","0","Credit Card","","2023-10-02 12:08:26","2023-10-02 12:08:26");
INSERT INTO payments VALUES("229","spr-20231002-091837","2","","248","2","1","2000","","0","Cash","","2023-10-02 12:18:37","2023-10-02 12:18:37");
INSERT INTO payments VALUES("230","spr-20231002-093253","2","","249","2","1","680","","0","Cash","","2023-10-02 12:32:53","2023-10-02 12:32:53");
INSERT INTO payments VALUES("231","spr-20231002-102213","2","","250","2","1","75","","0","Credit Card","","2023-10-02 13:22:13","2023-10-02 13:22:13");
INSERT INTO payments VALUES("232","spr-20231002-104933","2","","251","2","1","100","","0","Cash","","2023-10-02 13:49:33","2023-10-02 13:49:33");
INSERT INTO payments VALUES("233","spr-20231002-111053","2","","252","2","1","440","","0","Credit Card","","2023-10-02 14:10:53","2023-10-02 14:10:53");
INSERT INTO payments VALUES("234","spr-20231002-111144","2","","253","2","1","680","","0","Credit Card","","2023-10-02 14:11:44","2023-10-02 14:11:44");
INSERT INTO payments VALUES("235","spr-20231002-025153","2","","254","2","1","896","","0","Credit Card","","2023-10-02 17:51:53","2023-10-02 17:51:53");
INSERT INTO payments VALUES("236","spr-20231002-041415","2","","255","2","1","680","","0","Cash","","2023-10-02 19:14:15","2023-10-02 19:14:15");
INSERT INTO payments VALUES("237","spr-20231002-042016","2","","256","2","1","680","","0","Credit Card","","2023-10-02 19:20:16","2023-10-02 19:20:16");
INSERT INTO payments VALUES("238","spr-20231002-045750","2","","257","2","1","90","","0","Cash","","2023-10-02 19:57:50","2023-10-02 19:57:50");
INSERT INTO payments VALUES("239","spr-20231002-050342","2","","258","2","1","680","","0","Credit Card","","2023-10-02 20:03:42","2023-10-02 20:03:42");
INSERT INTO payments VALUES("240","spr-20231002-055130","2","","259","2","1","85","","0","Credit Card","","2023-10-02 20:51:30","2023-10-02 20:51:30");
INSERT INTO payments VALUES("241","spr-20231003-081911","2","","260","2","1","680","","0","Credit Card","","2023-10-03 11:19:11","2023-10-03 11:19:11");
INSERT INTO payments VALUES("242","spr-20231003-081939","2","","261","2","1","680","","0","Cash","","2023-10-03 11:19:39","2023-10-03 11:19:39");
INSERT INTO payments VALUES("243","spr-20231003-090843","2","","262","2","1","470","","0","Cash","","2023-10-03 12:08:43","2023-10-03 12:08:43");
INSERT INTO payments VALUES("244","spr-20231003-100413","2","","263","2","1","680","","0","Credit Card","","2023-10-03 13:04:13","2023-10-03 13:04:13");
INSERT INTO payments VALUES("245","spr-20231003-101052","2","","264","2","1","680","","0","Credit Card","","2023-10-03 13:10:52","2023-10-03 13:10:52");
INSERT INTO payments VALUES("246","spr-20231003-101724","2","","265","2","1","680","","0","Credit Card","","2023-10-03 13:17:24","2023-10-03 13:17:24");
INSERT INTO payments VALUES("247","spr-20231003-103250","2","","266","2","1","680","","0","Cash","","2023-10-03 13:32:50","2023-10-03 13:32:50");
INSERT INTO payments VALUES("248","spr-20231003-103311","2","","267","2","1","680","","0","Credit Card","","2023-10-03 13:33:11","2023-10-03 13:33:11");
INSERT INTO payments VALUES("249","spr-20231003-105057","2","","268","2","1","680","","0","Cash","","2023-10-03 13:50:57","2023-10-03 13:50:57");
INSERT INTO payments VALUES("250","spr-20231003-125849","2","","269","2","1","570","","0","Cash","","2023-10-03 15:58:49","2023-10-03 15:58:49");
INSERT INTO payments VALUES("251","spr-20231003-012021","2","","270","2","1","1180","","0","Credit Card","","2023-10-03 16:20:21","2023-10-03 16:20:21");
INSERT INTO payments VALUES("252","spr-20231003-035505","2","","271","2","1","1080","","0","Credit Card","","2023-10-03 18:55:05","2023-10-03 18:55:05");
INSERT INTO payments VALUES("253","spr-20231003-045707","2","","272","2","1","680","","0","Credit Card","","2023-10-03 19:57:07","2023-10-03 19:57:07");
INSERT INTO payments VALUES("254","spr-20231003-060544","2","","273","2","1","680","","0","Cash","","2023-10-03 21:05:44","2023-10-03 21:05:44");
INSERT INTO payments VALUES("255","spr-20231003-063817","2","","274","2","1","680","","0","Credit Card","","2023-10-03 21:38:17","2023-10-03 21:38:17");
INSERT INTO payments VALUES("256","spr-20231004-083321","2","","275","2","1","1040","","0","Credit Card","","2023-10-04 11:33:21","2023-10-04 11:33:21");
INSERT INTO payments VALUES("257","spr-20231004-090448","2","","276","2","1","680","","0","Cash","","2023-10-04 12:04:48","2023-10-04 12:04:48");
INSERT INTO payments VALUES("258","spr-20231004-093017","2","","277","2","1","1270","","0","Cash","","2023-10-04 12:30:17","2023-10-04 12:30:17");
INSERT INTO payments VALUES("259","spr-20231004-093208","2","","278","2","1","216","","0","Cash","","2023-10-04 12:32:08","2023-10-04 12:32:08");
INSERT INTO payments VALUES("260","spr-20231004-094956","2","","279","2","1","680","","0","Cash","","2023-10-04 12:49:56","2023-10-04 12:49:56");
INSERT INTO payments VALUES("261","spr-20231004-104044","2","","280","2","1","680","","0","Credit Card","","2023-10-04 13:40:44","2023-10-04 13:40:44");
INSERT INTO payments VALUES("262","spr-20231004-105825","2","","281","2","1","75","","0","Credit Card","","2023-10-04 13:58:25","2023-10-04 13:58:25");
INSERT INTO payments VALUES("263","spr-20231004-121308","2","","282","2","1","680","","0","Credit Card","","2023-10-04 15:13:08","2023-10-04 15:13:08");
INSERT INTO payments VALUES("264","spr-20231004-014417","2","","283","2","1","680","","0","Cash","","2023-10-04 16:44:17","2023-10-04 16:44:17");
INSERT INTO payments VALUES("265","spr-20231004-015919","2","","284","2","1","680","","0","Cash","","2023-10-04 16:59:19","2023-10-04 16:59:19");
INSERT INTO payments VALUES("266","spr-20231004-023617","2","","285","2","1","880","","120","Cash","","2023-10-04 17:36:17","2023-10-04 17:36:17");
INSERT INTO payments VALUES("267","spr-20231004-030307","2","","286","2","1","4605","","0","Cash","","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO payments VALUES("268","spr-20231004-030844","2","","287","2","1","3295","","0","Cash","","2023-10-04 18:08:44","2023-10-04 18:08:44");
INSERT INTO payments VALUES("269","spr-20231004-033829","2","","288","2","1","565","","0","Cash","","2023-10-04 18:38:29","2023-10-04 18:38:29");
INSERT INTO payments VALUES("270","spr-20231004-034421","2","","289","2","1","295","","205","Cash","","2023-10-04 18:44:21","2023-10-04 18:44:21");
INSERT INTO payments VALUES("271","spr-20231004-040401","2","","290","2","1","680","","0","Credit Card","","2023-10-04 19:04:01","2023-10-04 19:04:01");
INSERT INTO payments VALUES("272","spr-20231004-055811","2","","291","2","1","100","","0","Credit Card","","2023-10-04 20:58:11","2023-10-04 20:58:11");
INSERT INTO payments VALUES("273","spr-20231004-060456","2","","292","2","1","570","","0","Cash","","2023-10-04 21:04:56","2023-10-04 21:04:56");
INSERT INTO payments VALUES("274","spr-20231004-061115","2","","293","2","1","290","","0","Credit Card","","2023-10-04 21:11:15","2023-10-04 21:11:15");
INSERT INTO payments VALUES("275","spr-20231004-061314","2","","294","2","1","310","","0","Cash","","2023-10-04 21:13:14","2023-10-04 21:13:14");
INSERT INTO payments VALUES("276","spr-20231004-061545","2","","295","2","1","680","","0","Credit Card","","2023-10-04 21:15:45","2023-10-04 21:15:45");
INSERT INTO payments VALUES("277","spr-20231005-095728","2","","296","2","1","440","","0","Credit Card","","2023-10-05 12:57:28","2023-10-05 12:57:28");
INSERT INTO payments VALUES("278","spr-20231005-044456","2","","297","2","1","680","","0","Credit Card","","2023-10-05 19:44:56","2023-10-05 19:44:56");
INSERT INTO payments VALUES("279","spr-20231005-044633","2","","298","2","1","90","","0","Cash","","2023-10-05 19:46:33","2023-10-05 19:46:33");
INSERT INTO payments VALUES("280","spr-20231005-054743","2","","299","2","1","680","","320","Cash","","2023-10-05 20:47:43","2023-10-05 20:47:43");
INSERT INTO payments VALUES("281","spr-20231005-054954","2","","300","2","1","680","","0","Credit Card","","2023-10-05 20:49:54","2023-10-05 20:49:54");
INSERT INTO payments VALUES("282","spr-20231005-055039","2","","301","2","1","680","","0","Cash","","2023-10-05 20:50:39","2023-10-05 20:50:39");
INSERT INTO payments VALUES("283","spr-20231006-091026","2","","302","2","1","680","","0","Credit Card","","2023-10-06 12:10:26","2023-10-06 12:10:26");
INSERT INTO payments VALUES("284","spr-20231006-094732","2","","303","2","1","216","","0","Cash","","2023-10-06 12:47:32","2023-10-06 12:47:32");
INSERT INTO payments VALUES("285","spr-20231006-095240","2","","304","2","1","150","","0","Credit Card","","2023-10-06 12:52:40","2023-10-06 12:52:40");
INSERT INTO payments VALUES("286","spr-20231006-113552","2","","305","2","1","680","","0","Credit Card","","2023-10-06 14:35:52","2023-10-06 14:35:52");
INSERT INTO payments VALUES("287","spr-20231006-031112","2","","306","2","1","680","","0","Credit Card","","2023-10-06 18:11:12","2023-10-06 18:11:12");
INSERT INTO payments VALUES("288","spr-20231006-031629","2","","307","2","1","570","","0","Credit Card","","2023-10-06 18:16:29","2023-10-06 18:16:29");
INSERT INTO payments VALUES("289","spr-20231006-041911","2","","308","2","1","310","","690","Cash","","2023-10-06 19:19:11","2023-10-06 19:19:11");
INSERT INTO payments VALUES("290","spr-20231006-042438","2","","309","2","1","975","","0","Credit Card","","2023-10-06 19:24:38","2023-10-06 19:24:38");
INSERT INTO payments VALUES("291","spr-20231006-045015","2","","310","2","1","680","","0","Credit Card","","2023-10-06 19:50:15","2023-10-06 19:50:15");
INSERT INTO payments VALUES("292","spr-20231006-050441","2","","311","2","1","35","","0","Cash","","2023-10-06 20:04:41","2023-10-06 20:04:41");
INSERT INTO payments VALUES("293","spr-20231006-055618","2","","312","2","1","860","","0","Cash","","2023-10-06 20:56:18","2023-10-06 20:56:18");
INSERT INTO payments VALUES("294","spr-20231006-060145","2","","313","2","1","680","","0","Cash","","2023-10-06 21:01:45","2023-10-06 21:01:45");
INSERT INTO payments VALUES("295","spr-20231006-063725","2","","314","2","1","2590","","0","Credit Card","","2023-10-06 21:37:25","2023-10-06 21:37:25");
INSERT INTO payments VALUES("296","spr-20231006-064858","2","","315","2","1","530","","0","Credit Card","","2023-10-06 21:48:58","2023-10-06 21:48:58");
INSERT INTO payments VALUES("297","spr-20231007-110607","2","","316","2","1","290","","0","Credit Card","","2023-10-07 14:06:07","2023-10-07 14:06:07");
INSERT INTO payments VALUES("298","spr-20231007-112659","2","","317","2","1","1020","","0","Credit Card","","2023-10-07 14:26:59","2023-10-07 14:26:59");
INSERT INTO payments VALUES("299","spr-20231007-113837","2","","318","2","1","45","","0","Credit Card","","2023-10-07 14:38:37","2023-10-07 14:38:37");
INSERT INTO payments VALUES("300","spr-20231007-113927","2","","319","2","1","200","","0","Credit Card","","2023-10-07 14:39:27","2023-10-07 14:39:27");
INSERT INTO payments VALUES("301","spr-20231007-114344","2","","320","2","1","430","","0","Credit Card","","2023-10-07 14:43:44","2023-10-07 14:43:44");
INSERT INTO payments VALUES("302","spr-20231007-114946","2","","321","2","1","0","","0","Credit Card","","2023-10-07 14:49:46","2023-10-07 14:49:46");
INSERT INTO payments VALUES("303","spr-20231007-015841","2","","322","2","1","680","","0","Credit Card","","2023-10-07 16:58:41","2023-10-07 16:58:41");
INSERT INTO payments VALUES("304","spr-20231007-022539","2","","323","2","1","180","","0","Cash","","2023-10-07 17:25:39","2023-10-07 17:25:39");
INSERT INTO payments VALUES("305","spr-20231007-024219","2","","324","2","1","310","","0","Credit Card","","2023-10-07 17:42:19","2023-10-07 17:42:19");
INSERT INTO payments VALUES("306","spr-20231007-024416","2","","325","2","1","680","","0","Credit Card","","2023-10-07 17:44:16","2023-10-07 17:44:16");
INSERT INTO payments VALUES("307","spr-20231007-030144","2","","326","2","1","680","","0","Credit Card","","2023-10-07 18:01:44","2023-10-07 18:01:44");
INSERT INTO payments VALUES("308","spr-20231007-051326","2","","327","2","1","680","","0","Credit Card","","2023-10-07 20:13:26","2023-10-07 20:13:26");
INSERT INTO payments VALUES("309","spr-20231007-054739","2","","328","2","1","680","","0","Credit Card","","2023-10-07 20:47:39","2023-10-07 20:47:39");
INSERT INTO payments VALUES("310","spr-20231008-122318","2","","329","2","1","1080","","0","Cash","","2023-10-08 15:23:18","2023-10-08 15:23:18");
INSERT INTO payments VALUES("311","spr-20231008-122453","2","","330","2","1","680","","0","Credit Card","","2023-10-08 15:24:53","2023-10-08 15:24:53");
INSERT INTO payments VALUES("312","spr-20231008-122723","2","","331","2","1","975","","0","Cash","","2023-10-08 15:27:23","2023-10-08 15:27:23");
INSERT INTO payments VALUES("313","spr-20231008-123405","2","","332","2","1","1130","","0","Cash","","2023-10-08 15:34:05","2023-10-08 15:34:05");
INSERT INTO payments VALUES("314","spr-20231008-125158","2","","333","2","1","835","","0","Credit Card","","2023-10-08 15:51:58","2023-10-08 15:51:58");
INSERT INTO payments VALUES("315","spr-20231008-013431","2","","334","2","1","216","","0","Cash","","2023-10-08 16:34:31","2023-10-08 16:34:31");
INSERT INTO payments VALUES("316","spr-20231008-013534","2","","335","2","1","680","","0","Credit Card","","2023-10-08 16:35:34","2023-10-08 16:35:34");
INSERT INTO payments VALUES("317","spr-20231008-015629","2","","336","2","1","680","","0","Credit Card","","2023-10-08 16:56:29","2023-10-08 16:56:29");
INSERT INTO payments VALUES("318","spr-20231008-031811","2","","337","2","1","1335","","0","Credit Card","","2023-10-08 18:18:11","2023-10-08 18:18:11");
INSERT INTO payments VALUES("319","spr-20231008-040311","2","","338","2","1","195","","0","Cash","","2023-10-08 19:03:11","2023-10-08 19:03:11");
INSERT INTO payments VALUES("320","spr-20231008-040929","2","","339","2","1","375","","125","Cash","","2023-10-08 19:09:29","2023-10-08 19:09:29");
INSERT INTO payments VALUES("321","spr-20231009-093503","2","","340","2","1","680","","0","Credit Card","","2023-10-09 12:35:03","2023-10-09 12:35:03");
INSERT INTO payments VALUES("322","spr-20231009-093621","2","","341","2","1","680","","0","Cash","","2023-10-09 12:36:21","2023-10-09 12:36:21");
INSERT INTO payments VALUES("323","spr-20231009-102844","2","","342","2","1","680","","0","Cash","","2023-10-09 13:28:44","2023-10-09 13:28:44");
INSERT INTO payments VALUES("324","spr-20231009-112435","2","","343","2","1","680","","0","Cash","","2023-10-09 14:24:35","2023-10-09 14:24:35");
INSERT INTO payments VALUES("325","spr-20231009-115236","2","","344","2","1","510","","0","Cash","","2023-10-09 14:52:36","2023-10-09 14:52:36");
INSERT INTO payments VALUES("326","spr-20231009-115627","2","","345","2","1","680","","0","Credit Card","","2023-10-09 14:56:27","2023-10-09 14:56:27");
INSERT INTO payments VALUES("327","spr-20231009-121121","2","","346","2","1","20","","0","Cash","","2023-10-09 15:11:21","2023-10-09 15:11:21");
INSERT INTO payments VALUES("328","spr-20231009-121122","2","","347","2","1","20","","0","Cash","","2023-10-09 15:11:22","2023-10-09 15:11:22");
INSERT INTO payments VALUES("329","spr-20231009-121626","2","","348","2","1","30","","0","Cash","","2023-10-09 15:16:26","2023-10-09 15:16:26");
INSERT INTO payments VALUES("330","spr-20231009-123303","2","","349","2","1","40","","0","Cash","","2023-10-09 15:33:03","2023-10-09 15:33:03");
INSERT INTO payments VALUES("331","spr-20231009-022102","2","","350","2","1","680","","0","Credit Card","","2023-10-09 17:21:02","2023-10-09 17:21:02");
INSERT INTO payments VALUES("332","spr-20231009-024959","2","","351","2","1","680","","0","Cash","","2023-10-09 17:49:59","2023-10-09 17:49:59");
INSERT INTO payments VALUES("333","spr-20231009-024959","2","","352","2","1","680","","0","Cash","","2023-10-09 17:49:59","2023-10-09 17:49:59");
INSERT INTO payments VALUES("334","spr-20231009-030454","2","","353","2","1","680","","0","Cash","","2023-10-09 18:04:54","2023-10-09 18:04:54");
INSERT INTO payments VALUES("335","spr-20231009-040014","2","","354","2","1","975","","0","Credit Card","","2023-10-09 19:00:14","2023-10-09 19:00:14");
INSERT INTO payments VALUES("336","spr-20231009-044105","2","","355","2","1","1655","","0","Credit Card","","2023-10-09 19:41:05","2023-10-09 19:41:05");
INSERT INTO payments VALUES("337","spr-20231009-053446","2","","356","2","1","680","","0","Cash","","2023-10-09 20:34:46","2023-10-09 20:34:46");
INSERT INTO payments VALUES("338","spr-20231009-053641","2","","357","2","1","50","","0","Cash","","2023-10-09 20:36:41","2023-10-09 20:36:41");
INSERT INTO payments VALUES("339","spr-20231009-055939","2","","358","2","1","430","","0","Credit Card","","2023-10-09 20:59:39","2023-10-09 20:59:39");
INSERT INTO payments VALUES("340","spr-20231009-060954","2","","359","2","1","680","","0","Credit Card","","2023-10-09 21:09:54","2023-10-09 21:09:54");
INSERT INTO payments VALUES("341","spr-20231009-060955","2","","360","2","1","680","","0","Credit Card","","2023-10-09 21:09:55","2023-10-09 21:09:55");
INSERT INTO payments VALUES("342","spr-20231010-085009","2","","361","2","1","975","","0","Credit Card","","2023-10-10 11:50:09","2023-10-10 11:50:09");
INSERT INTO payments VALUES("343","spr-20231010-091635","2","","362","2","1","680","","0","Credit Card","","2023-10-10 12:16:35","2023-10-10 12:16:35");
INSERT INTO payments VALUES("344","spr-20231010-094427","2","","363","2","1","745","","0","Credit Card","","2023-10-10 12:44:27","2023-10-10 12:44:27");
INSERT INTO payments VALUES("345","spr-20231010-115800","2","","364","2","1","680","","0","Cash","","2023-10-10 14:58:00","2023-10-10 14:58:00");
INSERT INTO payments VALUES("346","spr-20231010-115820","2","","365","2","1","445","","0","Credit Card","","2023-10-10 14:58:20","2023-10-10 14:58:20");
INSERT INTO payments VALUES("347","spr-20231010-122625","2","","366","2","1","960","","0","Credit Card","","2023-10-10 15:26:25","2023-10-10 15:26:25");
INSERT INTO payments VALUES("348","spr-20231010-125535","2","","367","2","1","310","","0","Credit Card","","2023-10-10 15:55:35","2023-10-10 15:55:35");
INSERT INTO payments VALUES("349","spr-20231010-023414","2","","368","2","1","960","","0","Credit Card","","2023-10-10 17:34:14","2023-10-10 17:34:14");
INSERT INTO payments VALUES("350","spr-20231010-024248","2","","369","2","1","680","","0","Credit Card","","2023-10-10 17:42:48","2023-10-10 17:42:48");
INSERT INTO payments VALUES("351","spr-20231010-024557","2","","370","2","1","680","","0","Credit Card","","2023-10-10 17:45:57","2023-10-10 17:45:57");
INSERT INTO payments VALUES("352","spr-20231010-041844","2","","371","2","1","680","","0","Credit Card","","2023-10-10 19:18:44","2023-10-10 19:18:44");
INSERT INTO payments VALUES("353","spr-20231010-051933","2","","372","2","1","680","","0","Credit Card","","2023-10-10 20:19:33","2023-10-10 20:19:33");
INSERT INTO payments VALUES("354","spr-20231010-052423","2","","373","2","1","680","","0","Credit Card","","2023-10-10 20:24:23","2023-10-10 20:24:23");
INSERT INTO payments VALUES("355","spr-20231010-053613","2","","374","2","1","680","","0","Credit Card","","2023-10-10 20:36:13","2023-10-10 20:36:13");
INSERT INTO payments VALUES("356","spr-20231011-091325","2","","375","2","1","680","","0","Credit Card","","2023-10-11 12:13:25","2023-10-11 12:13:25");
INSERT INTO payments VALUES("357","spr-20231011-110515","2","","376","2","1","480","","520","Cash","","2023-10-11 14:05:15","2023-10-11 14:05:15");
INSERT INTO payments VALUES("358","spr-20231011-110546","2","","377","2","1","680","","0","Cash","","2023-10-11 14:05:46","2023-10-11 14:05:46");
INSERT INTO payments VALUES("359","spr-20231011-124308","2","","378","2","1","8595","","0","Credit Card","","2023-10-11 15:43:08","2023-10-11 15:43:08");
INSERT INTO payments VALUES("360","spr-20231011-021651","2","","379","2","1","680","","0","Credit Card","","2023-10-11 17:16:51","2023-10-11 17:16:51");
INSERT INTO payments VALUES("361","spr-20231011-025915","2","","380","2","1","440","","0","Credit Card","","2023-10-11 17:59:15","2023-10-11 17:59:15");
INSERT INTO payments VALUES("362","spr-20231011-035236","2","","381","2","1","400","","0","Credit Card","","2023-10-11 18:52:36","2023-10-11 18:52:36");
INSERT INTO payments VALUES("363","spr-20231011-050348","2","","382","2","1","680","","0","Cash","","2023-10-11 20:03:48","2023-10-11 20:03:48");
INSERT INTO payments VALUES("364","spr-20231012-100924","2","","383","2","1","680","","0","Credit Card","","2023-10-12 13:09:24","2023-10-12 13:09:24");
INSERT INTO payments VALUES("365","spr-20231012-104556","2","","384","2","1","90","","0","Credit Card","","2023-10-12 13:45:56","2023-10-12 13:45:56");
INSERT INTO payments VALUES("366","spr-20231012-015433","2","","385","2","1","4435","","0","Cash","","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO payments VALUES("367","spr-20231012-024740","2","","386","2","1","360","","0","Cash","","2023-10-12 17:47:40","2023-10-12 17:47:40");
INSERT INTO payments VALUES("368","spr-20231012-034027","2","","387","2","1","1205","","0","Cash","","2023-10-12 18:40:27","2023-10-12 18:40:27");
INSERT INTO payments VALUES("369","spr-20231012-045506","2","","388","2","1","930","","0","Cash","","2023-10-12 19:55:06","2023-10-12 19:55:06");
INSERT INTO payments VALUES("370","spr-20231012-045722","2","","389","2","1","1755","","0","Credit Card","","2023-10-12 19:57:22","2023-10-12 19:57:22");
INSERT INTO payments VALUES("371","spr-20231012-050243","2","","390","2","1","680","","0","Cash","","2023-10-12 20:02:43","2023-10-12 20:02:43");
INSERT INTO payments VALUES("372","spr-20231012-053204","2","","391","2","1","680","","0","Cash","","2023-10-12 20:32:04","2023-10-12 20:32:04");
INSERT INTO payments VALUES("373","spr-20231012-055632","2","","392","2","1","680","","0","Credit Card","","2023-10-12 20:56:32","2023-10-12 20:56:32");
INSERT INTO payments VALUES("374","spr-20231012-070344","2","","393","2","1","850","","0","Cash","","2023-10-12 22:03:44","2023-10-12 22:03:44");
INSERT INTO payments VALUES("375","spr-20231013-081816","2","","394","2","1","680","","0","Credit Card","","2023-10-13 11:18:16","2023-10-13 11:18:16");
INSERT INTO payments VALUES("376","spr-20231013-092735","2","","395","2","1","680","","0","Cash","","2023-10-13 12:27:35","2023-10-13 12:27:35");
INSERT INTO payments VALUES("377","spr-20231013-103709","2","","396","2","1","680","","0","Cash","","2023-10-13 13:37:09","2023-10-13 13:37:09");
INSERT INTO payments VALUES("378","spr-20231013-103709","2","","397","2","1","680","","0","Cash","","2023-10-13 13:37:09","2023-10-13 13:37:09");
INSERT INTO payments VALUES("379","spr-20231013-104244","2","","398","2","1","10","","0","Cash","","2023-10-13 13:42:44","2023-10-13 13:42:44");
INSERT INTO payments VALUES("380","spr-20231013-111401","2","","399","2","1","680","","0","Cash","","2023-10-13 14:14:01","2023-10-13 14:14:01");
INSERT INTO payments VALUES("381","spr-20231013-112039","2","","400","2","1","20","","0","Cash","","2023-10-13 14:20:39","2023-10-13 14:20:39");
INSERT INTO payments VALUES("382","spr-20231013-011652","2","","401","2","1","680","","0","Cash","","2023-10-13 16:16:52","2023-10-13 16:16:52");
INSERT INTO payments VALUES("383","spr-20231013-020054","2","","402","2","1","1480","","0","Credit Card","","2023-10-13 17:00:54","2023-10-13 17:00:54");
INSERT INTO payments VALUES("384","spr-20231013-023048","2","","403","2","1","680","","0","Credit Card","","2023-10-13 17:30:48","2023-10-13 17:30:48");
INSERT INTO payments VALUES("385","spr-20231013-033457","2","","404","2","1","4435","","0","Credit Card","","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO payments VALUES("386","spr-20231013-040918","2","","405","2","1","480","","0","Cash","","2023-10-13 19:09:18","2023-10-13 19:09:18");
INSERT INTO payments VALUES("387","spr-20231013-050800","2","","406","2","1","680","","0","Credit Card","","2023-10-13 20:08:00","2023-10-13 20:08:00");
INSERT INTO payments VALUES("388","spr-20231013-050942","2","","407","2","1","680","","0","Credit Card","","2023-10-13 20:09:42","2023-10-13 20:09:42");
INSERT INTO payments VALUES("389","spr-20231013-051109","2","","408","2","1","1080","","0","Credit Card","","2023-10-13 20:11:09","2023-10-13 20:11:09");
INSERT INTO payments VALUES("390","spr-20231013-051539","2","","409","2","1","225","","0","Credit Card","","2023-10-13 20:15:39","2023-10-13 20:15:39");
INSERT INTO payments VALUES("391","spr-20231013-052256","2","","410","2","1","1545","","0","Credit Card","","2023-10-13 20:22:56","2023-10-13 20:22:56");
INSERT INTO payments VALUES("392","spr-20231014-101726","2","","411","2","1","3635","","0","Credit Card","","2023-10-14 13:17:26","2023-10-14 13:17:26");
INSERT INTO payments VALUES("393","spr-20231014-104624","2","","412","2","1","215","","0","Cash","","2023-10-14 13:46:24","2023-10-14 13:46:24");
INSERT INTO payments VALUES("394","spr-20231014-104749","2","","413","2","1","310","","0","Cash","","2023-10-14 13:47:49","2023-10-14 13:47:49");
INSERT INTO payments VALUES("395","spr-20231014-104853","2","","414","2","1","310","","0","Cash","","2023-10-14 13:48:53","2023-10-14 13:48:53");
INSERT INTO payments VALUES("396","spr-20231014-042629","2","","415","2","1","20","","0","Cash","","2023-10-14 19:26:29","2023-10-14 19:26:29");
INSERT INTO payments VALUES("397","spr-20231014-042838","2","","416","2","1","195","","0","Credit Card","","2023-10-14 19:28:38","2023-10-14 19:28:38");
INSERT INTO payments VALUES("398","spr-20231014-052145","2","","417","2","1","200","","0","Credit Card","","2023-10-14 20:21:45","2023-10-14 20:21:45");
INSERT INTO payments VALUES("399","spr-20231014-052826","2","","418","2","1","10","","0","Cash","","2023-10-14 20:28:26","2023-10-14 20:28:26");
INSERT INTO payments VALUES("400","spr-20231014-054102","2","","419","2","1","30","","0","Cash","","2023-10-14 20:41:02","2023-10-14 20:41:02");
INSERT INTO payments VALUES("401","spr-20231015-100510","2","","420","2","1","310","","0","Credit Card","","2023-10-15 13:05:10","2023-10-15 13:05:10");
INSERT INTO payments VALUES("402","spr-20231015-104212","2","","421","2","1","320","","0","Cash","","2023-10-15 13:42:12","2023-10-15 13:42:12");
INSERT INTO payments VALUES("403","spr-20231015-112350","2","","422","2","1","105","","0","Cash","","2023-10-15 14:23:50","2023-10-15 14:23:50");
INSERT INTO payments VALUES("404","spr-20231015-112429","2","","423","2","1","680","","0","Credit Card","","2023-10-15 14:24:29","2023-10-15 14:24:29");
INSERT INTO payments VALUES("405","spr-20231015-112625","2","","424","2","1","2040","","0","Credit Card","","2023-10-15 14:26:25","2023-10-15 14:26:25");
INSERT INTO payments VALUES("406","spr-20231015-121748","2","","425","2","1","420","","0","Cash","","2023-10-15 15:17:48","2023-10-15 15:17:48");
INSERT INTO payments VALUES("407","spr-20231015-122525","2","","426","2","1","195","","0","Cash","","2023-10-15 15:25:25","2023-10-15 15:25:25");
INSERT INTO payments VALUES("408","spr-20231015-021342","2","","427","2","1","680","","0","Credit Card","","2023-10-15 17:13:42","2023-10-15 17:13:42");
INSERT INTO payments VALUES("409","spr-20231015-032427","2","","428","2","1","1230","","0","Credit Card","","2023-10-15 18:24:27","2023-10-15 18:24:27");
INSERT INTO payments VALUES("410","spr-20231015-035131","2","","429","2","1","1545","","0","Credit Card","","2023-10-15 18:51:31","2023-10-15 18:51:31");
INSERT INTO payments VALUES("411","spr-20231015-045234","2","","430","2","1","10","","0","Cash","","2023-10-15 19:52:34","2023-10-15 19:52:34");
INSERT INTO payments VALUES("412","spr-20231015-053237","2","","431","2","1","400","","0","Credit Card","","2023-10-15 20:32:37","2023-10-15 20:32:37");
INSERT INTO payments VALUES("413","spr-20231015-053415","2","","432","2","1","310","","0","Credit Card","","2023-10-15 20:34:15","2023-10-15 20:34:15");
INSERT INTO payments VALUES("414","spr-20231015-061812","2","","433","2","1","680","","0","Cash","","2023-10-15 21:18:12","2023-10-15 21:18:12");
INSERT INTO payments VALUES("415","spr-20231016-094345","2","","434","2","1","680","","0","Cash","","2023-10-16 12:43:45","2023-10-16 12:43:45");
INSERT INTO payments VALUES("416","spr-20231016-094436","2","","435","2","1","680","","0","Cash","","2023-10-16 12:44:36","2023-10-16 12:44:36");
INSERT INTO payments VALUES("417","spr-20231016-094535","2","","436","2","1","680","","0","Cash","","2023-10-16 12:45:35","2023-10-16 12:45:35");
INSERT INTO payments VALUES("418","spr-20231016-094959","2","","437","2","1","310","","0","Cash","","2023-10-16 12:49:59","2023-10-16 12:49:59");
INSERT INTO payments VALUES("419","spr-20231016-125940","2","","438","2","1","680","","0","Credit Card","","2023-10-16 15:59:40","2023-10-16 15:59:40");
INSERT INTO payments VALUES("420","spr-20231016-020028","2","","439","2","1","440","","0","Credit Card","","2023-10-16 17:00:28","2023-10-16 17:00:28");
INSERT INTO payments VALUES("421","spr-20231016-020142","2","","440","2","1","680","","320","Cash","","2023-10-16 17:01:42","2023-10-16 17:01:42");
INSERT INTO payments VALUES("422","spr-20231016-020252","2","","441","2","1","990","","0","Credit Card","","2023-10-16 17:02:52","2023-10-16 17:02:52");
INSERT INTO payments VALUES("423","spr-20231016-032402","2","","442","2","1","370","","0","Cash","","2023-10-16 18:24:02","2023-10-16 18:24:02");
INSERT INTO payments VALUES("424","spr-20231016-033416","2","","443","2","1","680","","0","Credit Card","","2023-10-16 18:34:16","2023-10-16 18:34:16");
INSERT INTO payments VALUES("425","spr-20231016-034820","2","","444","2","1","2175","","0","Credit Card","","2023-10-16 18:48:20","2023-10-16 18:48:20");
INSERT INTO payments VALUES("426","spr-20231016-042135","2","","445","2","1","1515","","0","Credit Card","","2023-10-16 19:21:35","2023-10-16 19:21:35");
INSERT INTO payments VALUES("427","spr-20231016-042851","2","","446","2","1","770","","0","Credit Card","","2023-10-16 19:28:51","2023-10-16 19:28:51");
INSERT INTO payments VALUES("428","spr-20231016-050110","2","","447","2","1","400","","0","Cash","","2023-10-16 20:01:10","2023-10-16 20:01:10");
INSERT INTO payments VALUES("429","spr-20231016-073002","2","","448","2","1","4200","","0","Credit Card","","2023-10-16 22:30:02","2023-10-16 22:30:02");
INSERT INTO payments VALUES("430","spr-20231017-094935","2","","449","2","1","680","","0","Credit Card","","2023-10-17 12:49:35","2023-10-17 12:49:35");
INSERT INTO payments VALUES("431","spr-20231017-112859","2","","450","2","1","300","","0","Credit Card","","2023-10-17 14:28:59","2023-10-17 14:28:59");
INSERT INTO payments VALUES("432","spr-20231017-120001","2","","451","2","1","200","","0","Credit Card","","2023-10-17 15:00:01","2023-10-17 15:00:01");
INSERT INTO payments VALUES("433","spr-20231017-120845","2","","452","2","1","680","","0","Credit Card","","2023-10-17 15:08:45","2023-10-17 15:08:45");
INSERT INTO payments VALUES("434","spr-20231017-124124","2","","453","2","1","4325","","0","Credit Card","","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO payments VALUES("435","spr-20231017-010231","2","","454","2","1","680","","0","Credit Card","","2023-10-17 16:02:31","2023-10-17 16:02:31");
INSERT INTO payments VALUES("436","spr-20231017-013538","2","","455","2","1","400","","100","Cash","","2023-10-17 16:35:38","2023-10-17 16:35:38");
INSERT INTO payments VALUES("437","spr-20231017-023149","2","","456","2","1","90","","0","Credit Card","","2023-10-17 17:31:49","2023-10-17 17:31:49");
INSERT INTO payments VALUES("438","spr-20231017-041357","2","","457","2","1","1080","","0","Cash","","2023-10-17 19:13:57","2023-10-17 19:13:57");
INSERT INTO payments VALUES("439","spr-20231017-050116","2","","458","2","1","1080","","0","Credit Card","","2023-10-17 20:01:16","2023-10-17 20:01:16");
INSERT INTO payments VALUES("440","spr-20231017-061800","2","","459","2","1","680","","0","Credit Card","","2023-10-17 21:18:00","2023-10-17 21:18:00");
INSERT INTO payments VALUES("441","spr-20231017-061924","2","","460","2","1","1980","","0","Credit Card","","2023-10-17 21:19:24","2023-10-17 21:19:24");
INSERT INTO payments VALUES("442","spr-20231017-062102","2","","461","2","1","400","","100","Cash","","2023-10-17 21:21:02","2023-10-17 21:21:02");
INSERT INTO payments VALUES("443","spr-20231017-062232","2","","462","2","1","680","","320","Cash","","2023-10-17 21:22:32","2023-10-17 21:22:32");
INSERT INTO payments VALUES("444","spr-20231017-062745","2","","463","2","1","880","","0","Credit Card","","2023-10-17 21:27:45","2023-10-17 21:27:45");
INSERT INTO payments VALUES("445","spr-20231017-063109","2","","464","2","1","680","","0","Credit Card","","2023-10-17 21:31:09","2023-10-17 21:31:09");
INSERT INTO payments VALUES("446","spr-20231018-093721","2","","465","2","1","680","","0","Credit Card","","2023-10-18 12:37:21","2023-10-18 12:37:21");
INSERT INTO payments VALUES("447","spr-20231018-094741","2","","466","2","1","1080","","0","Cash","","2023-10-18 12:47:41","2023-10-18 12:47:41");
INSERT INTO payments VALUES("448","spr-20231018-101451","2","","467","2","1","680","","0","Credit Card","","2023-10-18 13:14:51","2023-10-18 13:14:51");
INSERT INTO payments VALUES("449","spr-20231018-124717","2","","468","2","1","680","","0","Credit Card","","2023-10-18 15:47:17","2023-10-18 15:47:17");
INSERT INTO payments VALUES("450","spr-20231018-010741","2","","469","2","1","4440","","0","Cash","","2023-10-18 16:07:41","2023-10-18 16:07:41");
INSERT INTO payments VALUES("451","spr-20231018-045222","2","","470","2","1","310","","190","Cash","","2023-10-18 19:52:22","2023-10-18 19:52:22");
INSERT INTO payments VALUES("452","spr-20231018-061450","2","","471","2","1","680","","0","Credit Card","","2023-10-18 21:14:50","2023-10-18 21:14:50");
INSERT INTO payments VALUES("453","spr-20231019-084405","2","","472","2","1","275","","0","Cash","","2023-10-19 11:44:05","2023-10-19 11:44:05");
INSERT INTO payments VALUES("454","spr-20231019-092535","2","","473","2","1","680","","0","Credit Card","","2023-10-19 12:25:35","2023-10-19 12:25:35");
INSERT INTO payments VALUES("455","spr-20231019-104900","2","","474","2","1","510","","0","Cash","","2023-10-19 13:49:00","2023-10-19 13:49:00");
INSERT INTO payments VALUES("456","spr-20231019-110520","2","","475","2","1","1785","","0","Credit Card","","2023-10-19 14:05:20","2023-10-19 14:05:20");
INSERT INTO payments VALUES("457","spr-20231019-112942","2","","476","2","1","1710","","0","Credit Card","","2023-10-19 14:29:42","2023-10-19 14:29:42");
INSERT INTO payments VALUES("458","spr-20231019-120942","2","","477","2","1","680","","0","Credit Card","","2023-10-19 15:09:42","2023-10-19 15:09:42");
INSERT INTO payments VALUES("459","spr-20231019-021930","2","","478","2","1","130","","0","Credit Card","","2023-10-19 17:19:30","2023-10-19 17:19:30");
INSERT INTO payments VALUES("460","spr-20231019-043406","2","","479","2","1","680","","0","Credit Card","","2023-10-19 19:34:06","2023-10-19 19:34:06");
INSERT INTO payments VALUES("461","spr-20231019-043406","2","","480","2","1","680","","0","Credit Card","","2023-10-19 19:34:06","2023-10-19 19:34:06");
INSERT INTO payments VALUES("462","spr-20231019-051403","2","","481","2","1","20","","0","Cash","","2023-10-19 20:14:03","2023-10-19 20:14:03");
INSERT INTO payments VALUES("463","spr-20231019-071701","2","","482","2","1","680","","0","Credit Card","","2023-10-19 22:17:01","2023-10-19 22:17:01");
INSERT INTO payments VALUES("464","spr-20231020-085934","2","","483","2","1","200","","0","Credit Card","","2023-10-20 11:59:34","2023-10-20 11:59:34");
INSERT INTO payments VALUES("465","spr-20231020-092927","2","","484","2","1","105","","0","Credit Card","","2023-10-20 12:29:27","2023-10-20 12:29:27");
INSERT INTO payments VALUES("466","spr-20231020-102349","2","","485","2","1","310","","0","Credit Card","","2023-10-20 13:23:49","2023-10-20 13:23:49");
INSERT INTO payments VALUES("467","spr-20231020-102852","2","","486","2","1","680","","0","Credit Card","","2023-10-20 13:28:52","2023-10-20 13:28:52");
INSERT INTO payments VALUES("468","spr-20231020-110547","2","","487","2","1","1020","","0","Credit Card","","2023-10-20 14:05:47","2023-10-20 14:05:47");
INSERT INTO payments VALUES("469","spr-20231020-111457","2","","488","2","1","680","","0","Credit Card","","2023-10-20 14:14:57","2023-10-20 14:14:57");
INSERT INTO payments VALUES("470","spr-20231020-115924","2","","489","2","1","2225","","0","Cash","","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO payments VALUES("471","spr-20231020-121834","2","","490","2","1","1080","","0","Cash","","2023-10-20 15:18:34","2023-10-20 15:18:34");
INSERT INTO payments VALUES("472","spr-20231020-034410","2","","491","2","1","1080","","0","Cash","","2023-10-20 18:44:10","2023-10-20 18:44:10");
INSERT INTO payments VALUES("473","spr-20231020-034954","2","","492","2","1","400","","0","Credit Card","","2023-10-20 18:49:54","2023-10-20 18:49:54");
INSERT INTO payments VALUES("474","spr-20231020-035044","2","","493","2","1","680","","0","Cash","","2023-10-20 18:50:44","2023-10-20 18:50:44");
INSERT INTO payments VALUES("475","spr-20231020-035253","2","","494","2","1","370","","0","Credit Card","","2023-10-20 18:52:53","2023-10-20 18:52:53");
INSERT INTO payments VALUES("476","spr-20231020-035755","2","","495","2","1","680","","0","Cash","","2023-10-20 18:57:55","2023-10-20 18:57:55");
INSERT INTO payments VALUES("477","spr-20231020-035919","2","","496","2","1","680","","0","Cash","","2023-10-20 18:59:19","2023-10-20 18:59:19");
INSERT INTO payments VALUES("478","spr-20231020-040032","2","","497","2","1","310","","0","Cash","","2023-10-20 19:00:32","2023-10-20 19:00:32");
INSERT INTO payments VALUES("479","spr-20231020-040510","2","","498","2","1","15","","0","Cash","","2023-10-20 19:05:10","2023-10-20 19:05:10");
INSERT INTO payments VALUES("480","spr-20231020-054328","2","","499","2","1","655","","0","Cash","","2023-10-20 20:43:28","2023-10-20 20:43:28");
INSERT INTO payments VALUES("481","spr-20231020-054329","2","","500","2","1","655","","0","Cash","","2023-10-20 20:43:29","2023-10-20 20:43:29");
INSERT INTO payments VALUES("482","spr-20231020-054508","2","","501","2","1","680","","0","Credit Card","","2023-10-20 20:45:08","2023-10-20 20:45:08");
INSERT INTO payments VALUES("483","spr-20231020-064202","2","","502","2","1","2225","","0","Credit Card","","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO payments VALUES("484","spr-20231021-091259","2","","503","2","1","680","","0","Cash","","2023-10-21 12:12:59","2023-10-21 12:12:59");
INSERT INTO payments VALUES("485","spr-20231021-114034","2","","504","2","1","680","","0","Credit Card","","2023-10-21 14:40:34","2023-10-21 14:40:34");
INSERT INTO payments VALUES("486","spr-20231021-121355","2","","505","2","1","680","","0","Cash","","2023-10-21 15:13:55","2023-10-21 15:13:55");
INSERT INTO payments VALUES("487","spr-20231021-121430","2","","506","2","1","680","","0","Credit Card","","2023-10-21 15:14:30","2023-10-21 15:14:30");
INSERT INTO payments VALUES("488","spr-20231021-015616","2","","507","2","1","400","","0","Cash","","2023-10-21 16:56:16","2023-10-21 16:56:16");
INSERT INTO payments VALUES("489","spr-20231021-015802","2","","508","2","1","1950","","0","Cash","","2023-10-21 16:58:02","2023-10-21 16:58:02");
INSERT INTO payments VALUES("490","spr-20231021-015907","2","","509","2","1","555","","0","Cash","","2023-10-21 16:59:07","2023-10-21 16:59:07");
INSERT INTO payments VALUES("491","spr-20231021-020039","2","","510","2","1","2705","","0","Cash","","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO payments VALUES("492","spr-20231021-025837","2","","511","2","1","710","","0","Credit Card","","2023-10-21 17:58:37","2023-10-21 17:58:37");
INSERT INTO payments VALUES("493","spr-20231021-030738","2","","512","2","1","3020","","0","Credit Card","","2023-10-21 18:07:38","2023-10-21 18:07:38");
INSERT INTO payments VALUES("494","spr-20231021-034758","2","","513","2","1","4420","","0","Credit Card","","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO payments VALUES("495","spr-20231021-043648","2","","514","2","1","680","","0","Credit Card","","2023-10-21 19:36:48","2023-10-21 19:36:48");
INSERT INTO payments VALUES("496","spr-20231021-055718","2","","515","2","1","400","","0","Credit Card","","2023-10-21 20:57:18","2023-10-21 20:57:18");
INSERT INTO payments VALUES("497","spr-20231021-063219","2","","516","2","1","2965","","0","Cash","","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO payments VALUES("498","spr-20231021-063330","2","","517","2","1","75","","0","Cash","","2023-10-21 21:33:30","2023-10-21 21:33:30");
INSERT INTO payments VALUES("499","spr-20231021-063656","2","","518","2","1","490","","0","Cash","","2023-10-21 21:36:56","2023-10-21 21:36:56");
INSERT INTO payments VALUES("500","spr-20231022-105015","2","","519","2","1","680","","0","Credit Card","","2023-10-22 13:50:15","2023-10-22 13:50:15");
INSERT INTO payments VALUES("501","spr-20231022-114052","2","","520","2","1","7010","","0","Credit Card","","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO payments VALUES("502","spr-20231022-114653","2","","521","2","1","680","","0","Cash","","2023-10-22 14:46:53","2023-10-22 14:46:53");
INSERT INTO payments VALUES("503","spr-20231022-125705","2","","522","2","1","1250","","0","Credit Card","","2023-10-22 15:57:05","2023-10-22 15:57:05");
INSERT INTO payments VALUES("504","spr-20231022-010122","2","","523","2","1","1160","","0","Credit Card","","2023-10-22 16:01:22","2023-10-22 16:01:22");
INSERT INTO payments VALUES("505","spr-20231022-014008","2","","524","2","1","10180","","0","Credit Card","","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO payments VALUES("506","spr-20231022-023125","2","","525","2","1","680","","0","Credit Card","","2023-10-22 17:31:25","2023-10-22 17:31:25");
INSERT INTO payments VALUES("507","spr-20231022-033251","2","","526","2","1","2075","","0","Credit Card","","2023-10-22 18:32:51","2023-10-22 18:32:51");
INSERT INTO payments VALUES("508","spr-20231022-040705","2","","527","2","1","440","","0","Credit Card","","2023-10-22 19:07:05","2023-10-22 19:07:05");
INSERT INTO payments VALUES("509","spr-20231022-053948","2","","528","2","1","680","","0","Credit Card","","2023-10-22 20:39:48","2023-10-22 20:39:48");
INSERT INTO payments VALUES("510","spr-20231022-054108","2","","529","2","1","105","","0","Cash","","2023-10-22 20:41:08","2023-10-22 20:41:08");
INSERT INTO payments VALUES("511","spr-20231022-063048","2","","530","2","1","880","","120","Cash","","2023-10-22 21:30:48","2023-10-22 21:30:48");
INSERT INTO payments VALUES("512","spr-20231022-063559","2","","531","2","1","275","","0","Cash","","2023-10-22 21:35:59","2023-10-22 21:35:59");
INSERT INTO payments VALUES("513","spr-20231022-063716","2","","532","2","1","680","","0","Cash","","2023-10-22 21:37:16","2023-10-22 21:37:16");
INSERT INTO payments VALUES("514","spr-20231023-083553","2","","533","2","1","680","","0","Credit Card","","2023-10-23 11:35:53","2023-10-23 11:35:53");
INSERT INTO payments VALUES("515","spr-20231023-092044","2","","534","2","1","680","","0","Credit Card","","2023-10-23 12:20:44","2023-10-23 12:20:44");
INSERT INTO payments VALUES("516","spr-20231023-092642","2","","535","2","1","680","","0","Credit Card","","2023-10-23 12:26:42","2023-10-23 12:26:42");
INSERT INTO payments VALUES("517","spr-20231023-094019","2","","536","2","1","680","","0","Credit Card","","2023-10-23 12:40:19","2023-10-23 12:40:19");
INSERT INTO payments VALUES("518","spr-20231023-104517","2","","537","2","1","10","","0","Cash","","2023-10-23 13:45:17","2023-10-23 13:45:17");
INSERT INTO payments VALUES("519","spr-20231023-113016","2","","538","2","1","680","","0","Credit Card","","2023-10-23 14:30:16","2023-10-23 14:30:16");
INSERT INTO payments VALUES("520","spr-20231023-113136","2","","539","2","1","400","","0","Cash","","2023-10-23 14:31:36","2023-10-23 14:31:36");
INSERT INTO payments VALUES("521","spr-20231023-124815","2","","540","2","1","680","","0","Cash","","2023-10-23 15:48:15","2023-10-23 15:48:15");
INSERT INTO payments VALUES("522","spr-20231023-012300","2","","541","2","1","1250","","0","Credit Card","","2023-10-23 16:23:00","2023-10-23 16:23:00");
INSERT INTO payments VALUES("523","spr-20231023-014722","2","","542","2","1","680","","0","Credit Card","","2023-10-23 16:47:22","2023-10-23 16:47:22");
INSERT INTO payments VALUES("524","spr-20231023-015112","2","","543","2","1","90","","0","Cash","","2023-10-23 16:51:12","2023-10-23 16:51:12");
INSERT INTO payments VALUES("525","spr-20231023-033733","2","","544","2","1","90","","0","Credit Card","","2023-10-23 18:37:33","2023-10-23 18:37:33");
INSERT INTO payments VALUES("526","spr-20231023-034924","2","","545","2","1","200","","0","Cash","","2023-10-23 18:49:24","2023-10-23 18:49:24");
INSERT INTO payments VALUES("527","spr-20231023-054619","2","","546","2","1","680","","0","Credit Card","","2023-10-23 20:46:19","2023-10-23 20:46:19");
INSERT INTO payments VALUES("528","spr-20231023-062502","2","","547","2","1","955","","0","Credit Card","","2023-10-23 21:25:02","2023-10-23 21:25:02");
INSERT INTO payments VALUES("529","spr-20231023-063150","2","","548","2","1","420","","0","Cash","","2023-10-23 21:31:50","2023-10-23 21:31:50");
INSERT INTO payments VALUES("530","spr-20231024-094302","2","","549","2","1","20","","0","Credit Card","","2023-10-24 12:43:02","2023-10-24 12:43:02");
INSERT INTO payments VALUES("531","spr-20231024-103056","2","","550","2","1","310","","0","Cash","","2023-10-24 13:30:56","2023-10-24 13:30:56");
INSERT INTO payments VALUES("532","spr-20231024-114110","2","","551","2","1","1080","","0","Credit Card","","2023-10-24 14:41:10","2023-10-24 14:41:10");
INSERT INTO payments VALUES("533","spr-20231024-050931","2","","552","2","1","1545","","0","Cash","","2023-10-24 20:09:31","2023-10-24 20:09:31");
INSERT INTO payments VALUES("534","spr-20231024-051214","2","","553","2","1","1545","","0","Credit Card","","2023-10-24 20:12:14","2023-10-24 20:12:14");
INSERT INTO payments VALUES("535","spr-20231024-051343","2","","554","2","1","20","","0","Credit Card","","2023-10-24 20:13:43","2023-10-24 20:13:43");
INSERT INTO payments VALUES("536","spr-20231024-055353","2","","555","2","1","80","","20","Cash","","2023-10-24 20:53:53","2023-10-24 20:53:53");
INSERT INTO payments VALUES("537","spr-20231025-085459","2","","556","2","1","600","","0","Credit Card","","2023-10-25 11:54:59","2023-10-25 11:54:59");
INSERT INTO payments VALUES("538","spr-20231025-093211","2","","557","2","1","105","","0","Credit Card","","2023-10-25 12:32:11","2023-10-25 12:32:11");
INSERT INTO payments VALUES("539","spr-20231025-103356","2","","558","2","1","3925","","0","Credit Card","","2023-10-25 13:33:56","2023-10-25 13:33:56");
INSERT INTO payments VALUES("540","spr-20231025-011830","2","","559","2","1","520","","0","Credit Card","","2023-10-25 16:18:30","2023-10-25 16:18:30");
INSERT INTO payments VALUES("541","spr-20231025-031426","2","","560","2","1","1710","","0","Credit Card","","2023-10-25 18:14:26","2023-10-25 18:14:26");
INSERT INTO payments VALUES("542","spr-20231025-033025","2","","561","2","1","510","","0","Credit Card","","2023-10-25 18:30:25","2023-10-25 18:30:25");
INSERT INTO payments VALUES("543","spr-20231025-040436","2","","562","2","1","440","","0","Credit Card","","2023-10-25 19:04:36","2023-10-25 19:04:36");
INSERT INTO payments VALUES("544","spr-20231025-040605","2","","563","2","1","200","","0","Credit Card","","2023-10-25 19:06:05","2023-10-25 19:06:05");
INSERT INTO payments VALUES("545","spr-20231025-042120","2","","564","2","1","440","","0","Credit Card","","2023-10-25 19:21:20","2023-10-25 19:21:20");
INSERT INTO payments VALUES("546","spr-20231026-074033","2","","565","2","1","8840","","0","Cash","","2023-10-26 10:40:33","2023-10-26 10:40:33");
INSERT INTO payments VALUES("547","spr-20231026-074135","2","","566","2","1","300","","0","Cash","","2023-10-26 10:41:35","2023-10-26 10:41:35");
INSERT INTO payments VALUES("548","spr-20231026-074317","2","","567","2","1","80","","0","Cash","","2023-10-26 10:43:17","2023-10-26 10:43:17");
INSERT INTO payments VALUES("549","spr-20231026-075504","2","","568","2","1","800","","0","Cash","","2023-10-26 10:55:04","2023-10-26 10:55:04");
INSERT INTO payments VALUES("550","spr-20231026-093129","2","","569","2","1","680","","0","Credit Card","","2023-10-26 12:31:29","2023-10-26 12:31:29");
INSERT INTO payments VALUES("551","spr-20231026-093456","2","","570","2","1","680","","0","Credit Card","","2023-10-26 12:34:56","2023-10-26 12:34:56");
INSERT INTO payments VALUES("552","spr-20231026-094452","2","","571","2","1","310","","0","Credit Card","","2023-10-26 12:44:52","2023-10-26 12:44:52");
INSERT INTO payments VALUES("553","spr-20231026-100037","2","","572","2","1","990","","0","Cash","","2023-10-26 13:00:37","2023-10-26 13:00:37");
INSERT INTO payments VALUES("554","spr-20231026-101056","2","","573","2","1","680","","0","Credit Card","","2023-10-26 13:10:56","2023-10-26 13:10:56");
INSERT INTO payments VALUES("555","spr-20231026-030603","2","","574","2","1","1080","","0","Credit Card","","2023-10-26 18:06:03","2023-10-26 18:06:03");
INSERT INTO payments VALUES("556","spr-20231026-030829","2","","575","2","1","310","","0","Cash","","2023-10-26 18:08:29","2023-10-26 18:08:29");
INSERT INTO payments VALUES("557","spr-20231026-040906","2","","576","2","1","10","","0","Cash","","2023-10-26 19:09:06","2023-10-26 19:09:06");
INSERT INTO payments VALUES("558","spr-20231026-044127","2","","577","2","1","310","","0","Credit Card","","2023-10-26 19:41:27","2023-10-26 19:41:27");
INSERT INTO payments VALUES("559","spr-20231027-082724","2","","578","2","1","400","","0","Credit Card","","2023-10-27 11:27:24","2023-10-27 11:27:24");
INSERT INTO payments VALUES("560","spr-20231027-101426","2","","579","2","1","3320","","0","Credit Card","","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO payments VALUES("561","spr-20231027-111325","2","","580","2","1","680","","0","Credit Card","","2023-10-27 14:13:25","2023-10-27 14:13:25");
INSERT INTO payments VALUES("562","spr-20231027-113647","2","","581","2","1","275","","0","Credit Card","","2023-10-27 14:36:47","2023-10-27 14:36:47");
INSERT INTO payments VALUES("563","spr-20231027-115529","2","","582","2","1","1640","","0","Credit Card","","2023-10-27 14:55:29","2023-10-27 14:55:29");
INSERT INTO payments VALUES("564","spr-20231027-024210","2","","583","2","1","1160","","0","Credit Card","","2023-10-27 17:42:10","2023-10-27 17:42:10");
INSERT INTO payments VALUES("565","spr-20231027-041234","2","","584","2","1","680","","0","Cash","","2023-10-27 19:12:34","2023-10-27 19:12:34");
INSERT INTO payments VALUES("566","spr-20231027-041417","2","","585","2","1","680","","320","Cash","","2023-10-27 19:14:17","2023-10-27 19:14:17");
INSERT INTO payments VALUES("567","spr-20231027-045037","2","","586","2","1","680","","0","Credit Card","","2023-10-27 19:50:37","2023-10-27 19:50:37");
INSERT INTO payments VALUES("568","spr-20231027-050218","2","","587","2","1","275","","0","Cash","","2023-10-27 20:02:18","2023-10-27 20:02:18");
INSERT INTO payments VALUES("569","spr-20231027-051200","2","","588","2","1","320","","0","Cash","","2023-10-27 20:12:00","2023-10-27 20:12:00");
INSERT INTO payments VALUES("570","spr-20231027-063453","2","","589","2","1","2090","","0","Cash","","2023-10-27 21:34:53","2023-10-27 21:34:53");
INSERT INTO payments VALUES("571","spr-20231027-065115","2","","590","2","1","640","","0","Credit Card","","2023-10-27 21:51:15","2023-10-27 21:51:15");
INSERT INTO payments VALUES("572","spr-20231028-085059","2","","591","2","1","680","","0","Credit Card","","2023-10-28 11:50:59","2023-10-28 11:50:59");
INSERT INTO payments VALUES("573","spr-20231028-085059","2","","592","2","1","680","","0","Credit Card","","2023-10-28 11:50:59","2023-10-28 11:50:59");
INSERT INTO payments VALUES("574","spr-20231028-085226","2","","593","2","1","400","","0","Credit Card","","2023-10-28 11:52:26","2023-10-28 11:52:26");
INSERT INTO payments VALUES("575","spr-20231028-095512","2","","594","2","1","680","","0","Cash","","2023-10-28 12:55:12","2023-10-28 12:55:12");
INSERT INTO payments VALUES("576","spr-20231028-104311","2","","595","2","1","680","","0","Credit Card","","2023-10-28 13:43:11","2023-10-28 13:43:11");
INSERT INTO payments VALUES("577","spr-20231028-122625","2","","596","2","1","400","","600","Cash","","2023-10-28 15:26:25","2023-10-28 15:26:25");
INSERT INTO payments VALUES("578","spr-20231028-015033","2","","597","2","1","20","","0","Cash","","2023-10-28 16:50:33","2023-10-28 16:50:33");
INSERT INTO payments VALUES("579","spr-20231028-021253","2","","598","2","1","1545","","0","Credit Card","","2023-10-28 17:12:53","2023-10-28 17:12:53");
INSERT INTO payments VALUES("580","spr-20231028-022041","2","","599","2","1","400","","0","Credit Card","","2023-10-28 17:20:41","2023-10-28 17:20:41");
INSERT INTO payments VALUES("581","spr-20231028-022907","2","","600","2","1","400","","100","Cash","","2023-10-28 17:29:07","2023-10-28 17:29:07");
INSERT INTO payments VALUES("582","spr-20231028-030030","2","","601","2","1","680","","0","Credit Card","","2023-10-28 18:00:30","2023-10-28 18:00:30");
INSERT INTO payments VALUES("583","spr-20231028-031311","2","","602","2","1","1545","","0","Cash","","2023-10-28 18:13:11","2023-10-28 18:13:11");
INSERT INTO payments VALUES("584","spr-20231028-054532","2","","603","2","1","1655","","0","Credit Card","","2023-10-28 20:45:32","2023-10-28 20:45:32");
INSERT INTO payments VALUES("585","spr-20231028-055239","2","","604","2","1","10","","0","Cash","","2023-10-28 20:52:39","2023-10-28 20:52:39");
INSERT INTO payments VALUES("586","spr-20231029-025858","2","","605","2","1","75","","0","Cash","","2023-10-29 17:58:58","2023-10-29 17:58:58");
INSERT INTO payments VALUES("587","spr-20231029-030009","2","","606","2","1","1480","","0","Credit Card","","2023-10-29 18:00:09","2023-10-29 18:00:09");
INSERT INTO payments VALUES("588","spr-20231029-030106","2","","607","2","1","20","","0","Cash","","2023-10-29 18:01:06","2023-10-29 18:01:06");
INSERT INTO payments VALUES("589","spr-20231029-030208","2","","608","2","1","680","","0","Credit Card","","2023-10-29 18:02:08","2023-10-29 18:02:08");
INSERT INTO payments VALUES("590","spr-20231029-030327","2","","609","2","1","690","","0","Credit Card","","2023-10-29 18:03:27","2023-10-29 18:03:27");
INSERT INTO payments VALUES("591","spr-20231029-031236","2","","610","2","1","1120","","0","Credit Card","","2023-10-29 18:12:36","2023-10-29 18:12:36");
INSERT INTO payments VALUES("592","spr-20231029-032116","2","","611","2","1","1360","","0","Credit Card","","2023-10-29 18:21:16","2023-10-29 18:21:16");
INSERT INTO payments VALUES("593","spr-20231029-032342","2","","612","2","1","680","","0","Credit Card","","2023-10-29 18:23:42","2023-10-29 18:23:42");
INSERT INTO payments VALUES("594","spr-20231029-032424","2","","613","2","1","680","","0","Credit Card","","2023-10-29 18:24:24","2023-10-29 18:24:24");
INSERT INTO payments VALUES("595","spr-20231029-033624","2","","614","2","1","680","","0","Cash","","2023-10-29 18:36:24","2023-10-29 18:36:24");
INSERT INTO payments VALUES("596","spr-20231029-035529","2","","615","2","1","680","","0","Cash","","2023-10-29 18:55:29","2023-10-29 18:55:29");
INSERT INTO payments VALUES("597","spr-20231029-043104","2","","616","2","1","400","","0","Cash","","2023-10-29 19:31:04","2023-10-29 19:31:04");
INSERT INTO payments VALUES("598","spr-20231029-060438","2","","617","2","1","2720","","0","Credit Card","","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO payments VALUES("599","spr-20231029-060612","2","","618","2","1","680","","0","Credit Card","","2023-10-29 21:06:12","2023-10-29 21:06:12");
INSERT INTO payments VALUES("600","spr-20231029-061104","2","","619","2","1","405","","0","Credit Card","","2023-10-29 21:11:04","2023-10-29 21:11:04");
INSERT INTO payments VALUES("601","spr-20231030-084046","2","","620","2","1","275","","0","Cash","","2023-10-30 11:40:46","2023-10-30 11:40:46");
INSERT INTO payments VALUES("602","spr-20231030-094046","2","","621","2","1","35","","0","Credit Card","","2023-10-30 12:40:46","2023-10-30 12:40:46");
INSERT INTO payments VALUES("603","spr-20231030-094715","2","","622","2","1","680","","0","Credit Card","","2023-10-30 12:47:15","2023-10-30 12:47:15");
INSERT INTO payments VALUES("604","spr-20231030-105619","2","","623","2","1","680","","0","Cash","","2023-10-30 13:56:19","2023-10-30 13:56:19");
INSERT INTO payments VALUES("605","spr-20231030-112711","2","","624","2","1","680","","0","Cash","","2023-10-30 14:27:11","2023-10-30 14:27:11");
INSERT INTO payments VALUES("606","spr-20231030-112757","2","","625","2","1","75","","0","Cash","","2023-10-30 14:27:57","2023-10-30 14:27:57");
INSERT INTO payments VALUES("607","spr-20231030-120358","2","","626","2","1","680","","0","Credit Card","","2023-10-30 15:03:58","2023-10-30 15:03:58");
INSERT INTO payments VALUES("608","spr-20231030-020757","2","","627","2","1","270","","0","Cash","","2023-10-30 17:07:57","2023-10-30 17:07:57");
INSERT INTO payments VALUES("609","spr-20231030-024155","2","","628","2","1","680","","0","Credit Card","","2023-10-30 17:41:55","2023-10-30 17:41:55");
INSERT INTO payments VALUES("610","spr-20231030-053329","2","","629","2","1","600","","0","Credit Card","","2023-10-30 20:33:29","2023-10-30 20:33:29");
INSERT INTO payments VALUES("611","spr-20231030-055128","2","","630","2","1","975","","0","Credit Card","","2023-10-30 20:51:28","2023-10-30 20:51:28");
INSERT INTO payments VALUES("612","spr-20231030-055940","2","","631","2","1","400","","0","Credit Card","","2023-10-30 20:59:40","2023-10-30 20:59:40");
INSERT INTO payments VALUES("613","spr-20231030-061808","2","","632","2","1","400","","0","Credit Card","","2023-10-30 21:18:08","2023-10-30 21:18:08");
INSERT INTO payments VALUES("614","spr-20231030-063552","2","","633","2","1","275","","0","Credit Card","","2023-10-30 21:35:52","2023-10-30 21:35:52");
INSERT INTO payments VALUES("615","spr-20231030-064521","2","","634","2","1","195","","0","Credit Card","","2023-10-30 21:45:21","2023-10-30 21:45:21");
INSERT INTO payments VALUES("616","spr-20231030-065655","2","","635","2","1","310","","0","Credit Card","","2023-10-30 21:56:55","2023-10-30 21:56:55");
INSERT INTO payments VALUES("617","spr-20231031-100849","2","","636","2","1","400","","0","Credit Card","","2023-10-31 13:08:49","2023-10-31 13:08:49");
INSERT INTO payments VALUES("618","spr-20231031-102418","2","","637","2","1","400","","0","Cash","","2023-10-31 13:24:18","2023-10-31 13:24:18");
INSERT INTO payments VALUES("619","spr-20231031-120236","2","","638","2","1","35","","0","Cash","","2023-10-31 15:02:36","2023-10-31 15:02:36");
INSERT INTO payments VALUES("620","spr-20231031-122506","2","","639","2","1","10","","0","Credit Card","","2023-10-31 15:25:06","2023-10-31 15:25:06");
INSERT INTO payments VALUES("621","spr-20231031-010158","2","","640","2","1","200","","0","Cash","","2023-10-31 16:01:58","2023-10-31 16:01:58");
INSERT INTO payments VALUES("622","spr-20231031-031322","2","","641","2","1","3670","","0","Credit Card","","2023-10-31 18:13:22","2023-10-31 18:13:22");
INSERT INTO payments VALUES("623","spr-20231031-032453","2","","642","2","1","200","","0","Cash","","2023-10-31 18:24:53","2023-10-31 18:24:53");
INSERT INTO payments VALUES("624","spr-20231031-045807","2","","643","2","1","975","","0","Credit Card","","2023-10-31 19:58:07","2023-10-31 19:58:07");
INSERT INTO payments VALUES("625","spr-20231101-092314","2","","644","2","1","400","","0","Credit Card","","2023-11-01 12:23:14","2023-11-01 12:23:14");
INSERT INTO payments VALUES("626","spr-20231101-095458","2","","645","2","1","400","","0","Cash","","2023-11-01 12:54:58","2023-11-01 12:54:58");
INSERT INTO payments VALUES("627","spr-20231101-100326","2","","646","2","1","75","","0","Cash","","2023-11-01 13:03:26","2023-11-01 13:03:26");
INSERT INTO payments VALUES("628","spr-20231101-114518","2","","647","2","1","20","","0","Cash","","2023-11-01 14:45:18","2023-11-01 14:45:18");
INSERT INTO payments VALUES("629","spr-20231102-101349","2","","648","2","1","550","","0","Credit Card","","2023-11-02 13:13:49","2023-11-02 13:13:49");
INSERT INTO payments VALUES("630","spr-20231102-041313","2","","649","2","1","1545","","0","Cash","","2023-11-02 19:13:13","2023-11-02 19:13:13");
INSERT INTO payments VALUES("631","spr-20231102-042324","2","","650","2","1","270","","0","Credit Card","","2023-11-02 19:23:24","2023-11-02 19:23:24");
INSERT INTO payments VALUES("632","spr-20231102-042541","2","","651","2","1","800","","0","Credit Card","","2023-11-02 19:25:41","2023-11-02 19:25:41");
INSERT INTO payments VALUES("633","spr-20231102-042735","2","","652","2","1","400","","0","Credit Card","","2023-11-02 19:27:35","2023-11-02 19:27:35");
INSERT INTO payments VALUES("634","spr-20231102-042842","2","","653","2","1","100","","0","Cash","","2023-11-02 19:28:42","2023-11-02 19:28:42");
INSERT INTO payments VALUES("635","spr-20231102-044819","2","","654","2","1","150","","0","Credit Card","","2023-11-02 19:48:19","2023-11-02 19:48:19");
INSERT INTO payments VALUES("636","spr-20231103-081807","2","","655","2","1","275","","0","Cash","","2023-11-03 11:18:07","2023-11-03 11:18:07");
INSERT INTO payments VALUES("637","spr-20231103-102728","2","","656","2","1","100","","0","Cash","","2023-11-03 13:27:28","2023-11-03 13:27:28");
INSERT INTO payments VALUES("638","spr-20231103-110306","2","","657","2","1","400","","0","Cash","","2023-11-03 14:03:06","2023-11-03 14:03:06");
INSERT INTO payments VALUES("639","spr-20231103-044058","2","","658","2","1","930","","0","Cash","","2023-11-03 19:40:58","2023-11-03 19:40:58");
INSERT INTO payments VALUES("640","spr-20231103-045722","2","","659","2","1","310","","0","Cash","","2023-11-03 19:57:22","2023-11-03 19:57:22");
INSERT INTO payments VALUES("641","spr-20231103-064352","2","","660","2","1","1860","","0","Cash","","2023-11-03 21:43:52","2023-11-03 21:43:52");
INSERT INTO payments VALUES("642","spr-20231104-041226","2","","661","2","1","440","","0","Credit Card","","2023-11-04 19:12:26","2023-11-04 19:12:26");
INSERT INTO payments VALUES("643","spr-20231104-041317","2","","662","2","1","20","","0","Cash","","2023-11-04 19:13:17","2023-11-04 19:13:17");
INSERT INTO payments VALUES("644","spr-20231104-041824","2","","663","2","1","10","","0","Cash","","2023-11-04 19:18:24","2023-11-04 19:18:24");
INSERT INTO payments VALUES("645","spr-20231104-041854","2","","664","2","1","400","","0","Credit Card","","2023-11-04 19:18:54","2023-11-04 19:18:54");
INSERT INTO payments VALUES("646","spr-20231104-042005","2","","665","2","1","400","","0","Credit Card","","2023-11-04 19:20:05","2023-11-04 19:20:05");
INSERT INTO payments VALUES("647","spr-20231105-043756","2","","666","2","1","600","","0","Cash","","2023-11-05 19:37:56","2023-11-05 19:37:56");
INSERT INTO payments VALUES("648","spr-20231105-050048","2","","667","2","1","7295","","0","Credit Card","","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO payments VALUES("649","spr-20231105-050738","2","","668","2","1","4750","","0","Credit Card","","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO payments VALUES("650","spr-20231105-062645","2","","669","2","1","40","","0","Credit Card","","2023-11-05 21:26:45","2023-11-05 21:26:45");
INSERT INTO payments VALUES("651","spr-20231106-092530","2","","670","2","1","1755","","0","Credit Card","","2023-11-06 12:25:30","2023-11-06 12:25:30");
INSERT INTO payments VALUES("652","spr-20231106-112155","2","","671","2","1","375","","0","Credit Card","","2023-11-06 14:21:55","2023-11-06 14:21:55");
INSERT INTO payments VALUES("653","spr-20231107-094637","2","","672","2","1","800","","0","Credit Card","","2023-11-07 12:46:37","2023-11-07 12:46:37");
INSERT INTO payments VALUES("654","spr-20231107-094834","2","","673","2","1","880","","0","Credit Card","","2023-11-07 12:48:34","2023-11-07 12:48:34");
INSERT INTO payments VALUES("655","spr-20231107-095428","2","","674","2","1","30","","0","Credit Card","","2023-11-07 12:54:28","2023-11-07 12:54:28");
INSERT INTO payments VALUES("656","spr-20231107-114540","2","","675","2","1","1045","","0","Credit Card","","2023-11-07 14:45:40","2023-11-07 14:45:40");
INSERT INTO payments VALUES("657","spr-20231107-120045","2","","676","2","1","400","","0","Cash","","2023-11-07 15:00:45","2023-11-07 15:00:45");
INSERT INTO payments VALUES("658","spr-20231107-120444","2","","677","2","1","400","","0","Credit Card","","2023-11-07 15:04:44","2023-11-07 15:04:44");
INSERT INTO payments VALUES("659","spr-20231107-120659","2","","678","2","1","30","","0","Cash","","2023-11-07 15:06:59","2023-11-07 15:06:59");
INSERT INTO payments VALUES("660","spr-20231107-123531","2","","679","2","1","310","","0","Cash","","2023-11-07 15:35:31","2023-11-07 15:35:31");
INSERT INTO payments VALUES("661","spr-20231107-124441","2","","680","2","1","2945","","0","Cash","","2023-11-07 15:44:41","2023-11-07 15:44:41");
INSERT INTO payments VALUES("662","spr-20231107-013437","2","","681","2","1","320","","0","Cash","","2023-11-07 16:34:37","2023-11-07 16:34:37");
INSERT INTO payments VALUES("663","spr-20231107-043245","2","","682","2","1","400","","0","Credit Card","","2023-11-07 19:32:45","2023-11-07 19:32:45");
INSERT INTO payments VALUES("664","spr-20231108-095836","2","","683","2","1","865","","0","Credit Card","","2023-11-08 12:58:36","2023-11-08 12:58:36");
INSERT INTO payments VALUES("665","spr-20231108-100502","2","","684","2","1","2860","","0","Cash","","2023-11-08 13:05:02","2023-11-08 13:05:02");
INSERT INTO payments VALUES("666","spr-20231108-105134","2","","685","2","1","1980","","0","Cash","","2023-11-08 13:51:34","2023-11-08 13:51:34");
INSERT INTO payments VALUES("667","spr-20231108-122235","2","","686","2","1","2130","","0","Cash","","2023-11-08 15:22:35","2023-11-08 15:22:35");
INSERT INTO payments VALUES("668","spr-20231109-011657","2","","687","2","1","2715","","0","Credit Card","","2023-11-09 16:16:57","2023-11-09 16:16:57");
INSERT INTO payments VALUES("669","spr-20231109-011816","2","","688","2","1","2040","","0","Credit Card","","2023-11-09 16:18:16","2023-11-09 16:18:16");
INSERT INTO payments VALUES("670","spr-20231109-043552","2","","689","2","1","2000","","0","Cash","","2023-11-09 19:35:52","2023-11-09 19:35:52");
INSERT INTO payments VALUES("671","spr-20231109-044422","2","","690","2","1","2720","","0","Credit Card","","2023-11-09 19:44:22","2023-11-09 19:44:22");
INSERT INTO payments VALUES("672","spr-20231109-045503","2","","691","2","1","180","","0","Cash","","2023-11-09 19:55:03","2023-11-09 19:55:03");
INSERT INTO payments VALUES("673","spr-20231109-045742","2","","692","2","1","2735","","0","Credit Card","","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO payments VALUES("674","spr-20231109-050317","2","","693","2","1","760","","0","Credit Card","","2023-11-09 20:03:17","2023-11-09 20:03:17");
INSERT INTO payments VALUES("675","spr-20231109-050611","2","","694","2","1","2715","","0","Credit Card","","2023-11-09 20:06:11","2023-11-09 20:06:11");
INSERT INTO payments VALUES("676","spr-20231109-061848","2","","695","2","1","75","","25","Cash","","2023-11-09 21:18:48","2023-11-09 21:18:48");
INSERT INTO payments VALUES("677","spr-20231109-063616","2","","696","2","1","530","","0","Credit Card","","2023-11-09 21:36:16","2023-11-09 21:36:16");
INSERT INTO payments VALUES("678","spr-20231110-093335","2","","697","2","1","90","","0","Credit Card","","2023-11-10 12:33:35","2023-11-10 12:33:35");
INSERT INTO payments VALUES("679","spr-20231110-093431","2","","698","2","1","1545","","0","Cash","","2023-11-10 12:34:31","2023-11-10 12:34:31");
INSERT INTO payments VALUES("680","spr-20231110-052100","2","","699","2","1","75","","0","Cash","","2023-11-10 20:21:00","2023-11-10 20:21:00");
INSERT INTO payments VALUES("681","spr-20231111-095046","2","","700","2","1","1240","","0","Credit Card","","2023-11-11 12:50:46","2023-11-11 12:50:46");
INSERT INTO payments VALUES("682","spr-20231111-101623","2","","701","2","1","1240","","0","Credit Card","","2023-11-11 13:16:23","2023-11-11 13:16:23");
INSERT INTO payments VALUES("683","spr-20231111-121122","2","","702","2","1","1690","","0","Cash","","2023-11-11 15:11:22","2023-11-11 15:11:22");
INSERT INTO payments VALUES("684","spr-20231111-031304","2","","703","2","1","600","","0","Credit Card","","2023-11-11 18:13:04","2023-11-11 18:13:04");
INSERT INTO payments VALUES("685","spr-20231111-062202","2","","704","2","1","35","","0","Cash","","2023-11-11 21:22:02","2023-11-11 21:22:02");
INSERT INTO payments VALUES("686","spr-20231112-025701","2","","705","2","1","310","","0","Cash","","2023-11-12 17:57:01","2023-11-12 17:57:01");
INSERT INTO payments VALUES("687","spr-20231112-041850","2","","706","2","1","3855","","0","Credit Card","","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO payments VALUES("688","spr-20231112-062454","2","","707","2","1","2680","","0","Credit Card","","2023-11-12 21:24:54","2023-11-12 21:24:54");
INSERT INTO payments VALUES("689","spr-20231113-091913","2","","708","2","1","310","","0","Cash","","2023-11-13 12:19:13","2023-11-13 12:19:13");
INSERT INTO payments VALUES("690","spr-20231113-094552","2","","709","2","1","180","","0","Credit Card","","2023-11-13 12:45:52","2023-11-13 12:45:52");
INSERT INTO payments VALUES("691","spr-20231113-032413","2","","710","2","1","405","","0","Cash","","2023-11-13 18:24:13","2023-11-13 18:24:13");
INSERT INTO payments VALUES("692","spr-20231115-112846","2","","711","2","1","2640","","0","Cash","","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO payments VALUES("693","spr-20231117-114900","2","","712","2","1","960","","40","Cash","","2023-11-17 14:49:00","2023-11-17 14:49:00");
INSERT INTO payments VALUES("694","spr-20231117-115212","2","","713","2","1","370","","130","Cash","","2023-11-17 14:52:12","2023-11-17 14:52:12");
INSERT INTO payments VALUES("695","spr-20231120-122110","2","","714","2","1","3610","","0","Credit Card","","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO payments VALUES("696","spr-20231121-032442","2","","715","2","1","1120","","0","Cash","","2023-11-21 17:24:42","2023-11-21 17:24:42");
INSERT INTO payments VALUES("697","spr-20231122-102619","2","","716","2","1","35","","0","Cash","","2023-11-22 12:26:19","2023-11-22 12:26:19");
INSERT INTO payments VALUES("703","spr-20231125-035129","2","","722","2","1","570","","0","Cash","","2023-11-25 17:51:29","2023-11-25 17:51:29");
INSERT INTO payments VALUES("704","spr-20231127-040942","2","","723","2","1","590","","0","Cash","","2023-11-27 18:09:42","2023-11-27 18:09:42");
INSERT INTO payments VALUES("705","spr-20231127-062348","2","","724","2","1","2070","","0","Cash","","2023-11-27 20:23:48","2023-11-27 20:23:48");
INSERT INTO payments VALUES("706","spr-20231129-022935","2","","725","2","1","1200","","0","Cash","","2023-11-29 16:29:35","2023-11-29 16:29:35");
INSERT INTO payments VALUES("707","spr-20231201-030503","2","","726","2","1","280","","0","Cash","","2023-12-01 17:05:03","2023-12-01 17:05:03");
INSERT INTO payments VALUES("708","spr-20231201-030504","2","","727","2","1","280","","0","Cash","","2023-12-01 17:05:04","2023-12-01 17:05:04");
INSERT INTO payments VALUES("709","spr-20231214-043327","2","","728","2","1","310","","0","Cash","","2023-12-14 18:33:27","2023-12-14 18:33:27");
INSERT INTO payments VALUES("721","spr-20250118-104816","3","","736","5","1","440","","560","Cash","","2025-01-18 22:48:16","2025-01-18 22:48:16");
INSERT INTO payments VALUES("722","spr-20250118-104817","3","","737","5","1","440","","560","Cash","","2025-01-18 22:48:17","2025-01-18 22:48:17");
INSERT INTO payments VALUES("723","spr-20250118-104901","3","","738","5","1","440","","0","Cash","njsx","2025-01-18 22:49:01","2025-01-18 22:49:01");
INSERT INTO payments VALUES("727","spr-20250123-031036","1","","740","3","1","525","","0","Cash","","2025-01-23 15:10:36","2025-01-23 15:10:36");
INSERT INTO payments VALUES("728","ppr-20250225-023546","3","39","","","1","14480","","0","Cash","All paid","2025-02-25 14:35:46","2025-02-25 14:35:46");
INSERT INTO payments VALUES("729","ppr-20250228-080433","1","40","","","1","12242","","0","Cash","","2025-02-28 20:04:33","2025-02-28 20:04:33");
INSERT INTO payments VALUES("730","ppr-20250228-080448","1","41","","","1","15603","","0","Cash","","2025-02-28 20:04:48","2025-02-28 20:04:48");
INSERT INTO payments VALUES("731","ppr-20250228-080503","1","42","","","1","7520","","0","Cash","","2025-02-28 20:05:03","2025-02-28 20:05:03");
INSERT INTO payments VALUES("732","ppr-20250313-070848","1","45","","","1","11675","","0","Cash","Paid","2025-03-13 19:08:48","2025-03-13 19:08:48");
INSERT INTO payments VALUES("733","ppr-20250313-070944","1","43","","","4","10200","","0","Cash","Capital Injection (Nashon)","2025-03-13 19:09:44","2025-03-13 19:11:00");
INSERT INTO payments VALUES("734","ppr-20250313-071135","1","44","","","4","28150","","0","Cash","Capital Injection","2025-03-13 19:11:35","2025-04-01 12:59:51");
INSERT INTO payments VALUES("735","ppr-20250318-042010","1","47","","","0","150","","0","Cash","","2025-03-18 16:20:10","2025-03-18 16:20:10");
INSERT INTO payments VALUES("736","ppr-20250318-042648","1","48","","","0","100","","0","Cash","","2025-03-18 16:26:48","2025-03-18 16:26:48");
INSERT INTO payments VALUES("737","spr-20250318-053423","1","","742","3","1","1330","","0","Cash","","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO payments VALUES("738","spr-20250318-060446","1","","743","3","1","1490","","0","Cash","","2025-03-18 18:04:46","2025-03-18 18:04:46");
INSERT INTO payments VALUES("739","ppr-20250319-065035","1","50","","","0","2500","","0","Cash","","2025-03-19 18:50:35","2025-03-19 18:50:35");
INSERT INTO payments VALUES("740","ppr-20250319-065556","1","51","","","0","800","","0","Cash","","2025-03-19 18:55:56","2025-03-19 18:55:56");
INSERT INTO payments VALUES("741","spr-20250319-071906","1","","744","3","1","2100","","0","Cash","","2025-03-19 19:19:06","2025-03-19 19:19:06");
INSERT INTO payments VALUES("742","ppr-20250319-072138","1","52","","","0","300","","0","Cash","","2025-03-19 19:21:38","2025-03-19 19:21:38");
INSERT INTO payments VALUES("743","spr-20250319-080019","1","","745","3","1","680","","0","Cash","","2025-03-19 20:00:19","2025-03-19 20:00:19");
INSERT INTO payments VALUES("744","ppr-20250321-101830","1","53","","","0","4700","","0","Cash","","2025-03-21 10:18:30","2025-03-21 10:18:30");
INSERT INTO payments VALUES("745","ppr-20250321-102024","1","54","","","0","800","","0","Cash","","2025-03-21 10:20:24","2025-03-21 10:20:24");
INSERT INTO payments VALUES("746","ppr-20250321-102808","1","55","","","0","800","","0","Cash","","2025-03-21 10:28:08","2025-03-21 10:28:08");
INSERT INTO payments VALUES("747","ppr-20250321-112532","1","56","","","0","500","","0","Cash","","2025-03-21 11:25:32","2025-03-21 11:25:32");
INSERT INTO payments VALUES("748","spr-20250321-121055","1","","747","3","1","1920","","0","Cash","","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO payments VALUES("749","ppr-20250321-124214","1","57","","","0","360","","0","Cash","","2025-03-21 12:42:14","2025-03-21 12:42:14");
INSERT INTO payments VALUES("750","ppr-20250321-124559","1","58","","","0","850","","0","Cash","","2025-03-21 12:45:59","2025-03-21 12:45:59");
INSERT INTO payments VALUES("751","ppr-20250321-124824","1","59","","","0","400","","0","Cash","","2025-03-21 12:48:24","2025-03-21 12:48:24");
INSERT INTO payments VALUES("752","ppr-20250321-125332","1","60","","","0","2000","","0","Cash","","2025-03-21 12:53:32","2025-03-21 12:53:32");
INSERT INTO payments VALUES("753","spr-20250321-125419","1","","750","3","1","1810","","0","Cash","","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO payments VALUES("754","spr-20250321-010613","1","","752","3","1","980","","0","Cash","","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO payments VALUES("755","ppr-20250321-072715","1","62","","","0","400","","0","Cash","","2025-03-21 19:27:15","2025-03-21 19:27:15");
INSERT INTO payments VALUES("756","ppr-20250321-072911","1","63","","","0","600","","0","Cash","","2025-03-21 19:29:11","2025-03-21 19:29:11");
INSERT INTO payments VALUES("757","spr-20250321-083741","1","","756","3","1","3305","","0","Cash","","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO payments VALUES("758","spr-20250321-084902","1","","757","3","1","1030","","0","Cash","","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO payments VALUES("759","spr-20250321-093010","1","","758","3","1","2245","","0","Cash","","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO payments VALUES("760","spr-20250321-093825","1","","759","3","1","1890","","0","Cash","","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO payments VALUES("761","ppr-20250322-122304","1","61","","","1","1692","","0","Cash","","2025-03-22 12:23:04","2025-03-22 12:23:04");
INSERT INTO payments VALUES("762","ppr-20250322-122327","1","65","","","1","3550","","0","Cash","","2025-03-22 12:23:27","2025-03-22 12:23:27");
INSERT INTO payments VALUES("763","spr-20250322-123756","1","","762","3","1","1130","","0","Cash","","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO payments VALUES("764","ppr-20250322-124200","1","66","","","0","400","","0","Cash","","2025-03-22 12:42:00","2025-03-22 12:42:00");
INSERT INTO payments VALUES("765","spr-20250322-124650","1","","763","3","1","2300","","0","Cash","","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO payments VALUES("766","ppr-20250322-124939","1","67","","","0","0","","0","Cash","","2025-03-22 12:49:39","2025-03-22 12:49:39");
INSERT INTO payments VALUES("767","spr-20250322-010117","1","","765","3","1","1630","","0","Cash","","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO payments VALUES("768","ppr-20250322-020102","1","68","","","0","900","","0","Cash","","2025-03-22 14:01:02","2025-03-22 14:01:02");
INSERT INTO payments VALUES("769","ppr-20250322-021510","1","69","","","0","1000","","0","Cash","","2025-03-22 14:15:10","2025-03-22 14:15:10");
INSERT INTO payments VALUES("770","ppr-20250322-023548","1","70","","","0","2000","","0","Cash","","2025-03-22 14:35:48","2025-03-22 14:35:48");
INSERT INTO payments VALUES("771","spr-20250322-023718","1","","771","3","1","5276","","0","Cash","","2025-03-22 14:37:18","2025-03-22 14:37:18");
INSERT INTO payments VALUES("772","spr-20250322-043006","1","","772","3","1","1730","","0","Cash","","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO payments VALUES("773","ppr-20250322-043442","1","71","","","0","1200","","0","Cash","","2025-03-22 16:34:42","2025-03-22 16:34:42");
INSERT INTO payments VALUES("774","ppr-20250322-043719","1","72","","","0","1000","","0","Cash","","2025-03-22 16:37:19","2025-03-22 16:37:19");
INSERT INTO payments VALUES("775","spr-20250322-044930","1","","774","3","1","1955","","0","Cash","","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO payments VALUES("776","spr-20250322-045732","1","","775","3","1","1285","","0","Cash","","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO payments VALUES("777","spr-20250322-050150","1","","776","3","1","1510","","0","Cash","","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO payments VALUES("778","ppr-20250322-050340","1","73","","","0","1000","","0","Cash","","2025-03-22 17:03:40","2025-03-22 17:03:40");
INSERT INTO payments VALUES("779","spr-20250322-051014","1","","777","3","1","1302","","0","Cash","","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO payments VALUES("780","spr-20250322-052357","1","","778","3","1","2470","","0","Cash","","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO payments VALUES("781","ppr-20250322-052714","1","74","","","0","900","","0","Cash","","2025-03-22 17:27:14","2025-03-22 17:27:14");
INSERT INTO payments VALUES("782","spr-20250322-054549","1","","779","3","1","4320","","0","Cash","","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO payments VALUES("784","spr-20250322-062418","1","","782","3","1","3160","","0","Cash","","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO payments VALUES("785","spr-20250322-063518","1","","783","3","1","1142","","0","Cash","","2025-03-22 18:35:18","2025-03-22 18:35:18");
INSERT INTO payments VALUES("786","spr-20250322-064653","1","","784","3","1","1490","","0","Cash","","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO payments VALUES("787","spr-20250322-065027","1","","785","3","1","615","","0","Cash","","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO payments VALUES("788","spr-20250322-070520","1","","787","3","1","1710","","0","Cash","","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO payments VALUES("789","ppr-20250322-071432","1","76","","","0","2800","","0","Cash","","2025-03-22 19:14:32","2025-03-22 19:14:32");
INSERT INTO payments VALUES("790","spr-20250322-071940","1","","789","3","1","3210","","0","Cash","","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO payments VALUES("791","ppr-20250322-072605","1","77","","","0","1000","","0","Cash","","2025-03-22 19:26:05","2025-03-22 19:26:05");
INSERT INTO payments VALUES("792","spr-20250322-074015","1","","791","3","1","4157","","0","Cash","","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO payments VALUES("793","spr-20250322-074735","1","","792","3","1","620","","0","Cash","","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO payments VALUES("794","ppr-20250322-075300","1","78","","","0","3500","","0","Cash","","2025-03-22 19:53:00","2025-03-22 19:53:00");
INSERT INTO payments VALUES("795","spr-20250322-075940","1","","793","3","1","1210","","0","Cash","","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO payments VALUES("796","spr-20250322-080844","1","","794","3","1","1025","","0","Cash","","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO payments VALUES("797","ppr-20250322-083616","1","46","","","2","19476","","0","Cash","","2025-03-22 20:36:16","2025-03-22 20:36:16");
INSERT INTO payments VALUES("798","spr-20250324-061819","1","","795","3","1","2195","","0","Cash","","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO payments VALUES("799","ppr-20250324-062133","1","80","","","0","1500","","0","Cash","","2025-03-24 18:21:33","2025-03-24 18:21:33");
INSERT INTO payments VALUES("800","ppr-20250324-062510","1","81","","","0","1000","","0","Cash","","2025-03-24 18:25:10","2025-03-24 18:25:10");
INSERT INTO payments VALUES("801","spr-20250324-070505","1","","796","3","1","1980","","0","Cash","","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO payments VALUES("802","spr-20250324-071312","1","","797","3","1","1130","","0","Cash","","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO payments VALUES("803","spr-20250324-072936","1","","798","3","1","3640","","0","Cash","","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO payments VALUES("804","spr-20250324-073259","1","","799","3","1","1310","","0","Cash","","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO payments VALUES("805","spr-20250324-074316","1","","800","3","1","1845","","0","Cash","","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO payments VALUES("806","spr-20250324-074720","1","","801","3","1","1240","","0","Cash","","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO payments VALUES("807","spr-20250324-075436","1","","802","3","1","980","","0","Cash","","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO payments VALUES("808","ppr-20250324-075703","1","82","","","0","1000","","0","Cash","","2025-03-24 19:57:03","2025-03-24 19:57:03");
INSERT INTO payments VALUES("809","spr-20250324-080849","1","","803","3","1","920","","0","Cash","","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO payments VALUES("810","ppr-20250324-081406","1","83","","","0","800","","0","Cash","","2025-03-24 20:14:06","2025-03-24 20:14:06");
INSERT INTO payments VALUES("812","spr-20250324-082845","1","","804","3","1","1600","","0","Cash","","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO payments VALUES("813","spr-20250325-040913","1","","805","3","1","3638","","0","Cash","","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO payments VALUES("814","spr-20250325-041529","1","","806","3","1","2110","","0","Cash","","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO payments VALUES("815","spr-20250325-041853","1","","807","3","1","835","","0","Cash","","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO payments VALUES("816","spr-20250325-054126","1","","809","3","1","1825","","0","Cash","","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO payments VALUES("817","spr-20250325-055332","1","","810","3","1","2105","","0","Cash","","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO payments VALUES("818","spr-20250325-060231","1","","811","3","1","2270","","0","Cash","","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO payments VALUES("819","spr-20250325-062416","1","","812","3","1","3130","","0","Cash","","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO payments VALUES("820","spr-20250325-063943","1","","813","3","1","2585","","0","Cash","","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO payments VALUES("821","ppr-20250325-065620","1","85","","","0","2500","","0","Cash","","2025-03-25 18:56:20","2025-03-25 18:56:20");
INSERT INTO payments VALUES("822","spr-20250326-093211","1","","814","3","1","1865","","0","Cash","","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO payments VALUES("823","spr-20250326-070736","1","","815","3","1","1100","","0","Cash","","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO payments VALUES("824","spr-20250326-071307","1","","816","3","1","2480","","0","Cash","","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO payments VALUES("825","spr-20250326-072059","1","","817","3","1","1870","","0","Cash","","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO payments VALUES("826","ppr-20250326-072627","1","86","","","0","500","","0","Cash","","2025-03-26 19:26:27","2025-03-26 19:26:27");
INSERT INTO payments VALUES("827","spr-20250326-073328","1","","818","3","1","1680","","0","Cash","","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO payments VALUES("828","spr-20250326-074625","1","","819","3","1","3875","","0","Cash","","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO payments VALUES("829","spr-20250326-080040","1","","820","3","1","2555","","0","Cash","","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO payments VALUES("830","spr-20250326-080340","1","","821","3","1","650","","0","Cash","","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO payments VALUES("831","spr-20250326-080613","1","","822","3","1","500","","0","Cash","","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO payments VALUES("832","ppr-20250327-102636","1","79","","","1","24800","","0","Cash","TCR69UKOX0 Confirmed. Ksh24,800.00 paid to MAKAMITHI ENTERPRISES LIMITED 1. on 27/3/25 at 9:32 AM.New M-PESA balance is Ksh200.01. Transaction cost, Ksh0.00. Amount you can transact within the day is 475,200.00. Save frequent Tills for quick payment on M-PESA app https://bit.ly/mpesalnk","2025-03-27 10:26:36","2025-03-27 10:26:36");
INSERT INTO payments VALUES("833","ppr-20250327-070854","1","88","","","1","1810","","0","Cash","","2025-03-27 19:08:54","2025-03-27 19:08:54");
INSERT INTO payments VALUES("835","spr-20250328-083226","1","","824","3","1","4450","","0","Cash","","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO payments VALUES("836","spr-20250329-010041","1","","825","3","1","1200","","0","Cash","","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO payments VALUES("837","spr-20250329-010957","1","","826","3","1","1840","","0","Cash","","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO payments VALUES("838","spr-20250331-025930","1","","827","3","1","2150","","0","Cash","","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO payments VALUES("839","spr-20250331-030527","1","","828","3","1","2215","","0","Cash","","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO payments VALUES("840","ppr-20250331-030751","1","90","","","0","2400","","0","Cash","","2025-03-31 15:07:51","2025-03-31 15:07:51");
INSERT INTO payments VALUES("841","spr-20250331-032758","1","","829","3","1","5190","","0","Cash","","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO payments VALUES("842","spr-20250331-034315","1","","830","3","1","3755","","0","Cash","","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO payments VALUES("843","ppr-20250331-034743","1","91","","","0","360","","0","Cash","","2025-03-31 15:47:43","2025-03-31 15:47:43");
INSERT INTO payments VALUES("844","spr-20250331-035640","1","","831","3","1","2695","","0","Cash","","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO payments VALUES("845","spr-20250331-040009","1","","832","3","1","1700","","0","Cash","","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO payments VALUES("846","spr-20250331-040700","1","","833","3","1","1275","","0","Cash","","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO payments VALUES("847","spr-20250331-042510","1","","834","3","1","5071","","0","Cash","","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO payments VALUES("848","spr-20250331-045636","1","","835","3","1","5705","","0","Cash","","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO payments VALUES("849","spr-20250331-051053","1","","836","3","1","3855","","0","Cash","","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO payments VALUES("850","spr-20250331-051905","1","","837","3","1","1790","","0","Cash","","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO payments VALUES("851","spr-20250331-053657","1","","838","3","1","4870","","0","Cash","","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO payments VALUES("852","ppr-20250331-055128","1","92","","","0","1000","","0","Cash","","2025-03-31 17:51:28","2025-03-31 17:51:28");
INSERT INTO payments VALUES("853","spr-20250331-060223","1","","839","3","1","5295","","0","Cash","","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO payments VALUES("854","spr-20250331-060700","1","","840","3","1","850","","0","Cash","","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO payments VALUES("855","spr-20250331-061303","1","","841","3","1","1835","","0","Cash","","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO payments VALUES("856","spr-20250331-063731","1","","842","3","1","6380","","0","Cash","","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO payments VALUES("857","spr-20250331-070916","1","","844","3","1","8085","","0","Cash","","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO payments VALUES("858","spr-20250331-071958","1","","845","3","1","850","","0","Cash","","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO payments VALUES("859","spr-20250331-072228","1","","846","3","1","490","","0","Cash","","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO payments VALUES("860","spr-20250331-073018","1","","847","3","1","1340","","0","Cash","","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO payments VALUES("861","spr-20250331-073858","1","","848","3","1","2530","","0","Cash","","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO payments VALUES("862","ppr-20250331-075042","1","89","","","1","6550","","27450","Cash","Paid 31Mar 25","2025-03-31 19:50:42","2025-03-31 19:50:42");
INSERT INTO payments VALUES("863","spr-20250401-095505","1","","849","3","1","7005","","0","Cash","","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO payments VALUES("864","spr-20250401-031442","1","","850","3","1","2745","","0","Cash","","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO payments VALUES("865","spr-20250401-033748","1","","851","3","1","6270","","0","Cash","","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO payments VALUES("866","spr-20250401-034909","1","","852","3","1","1270","","0","Cash","","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO payments VALUES("867","spr-20250401-040316","1","","853","3","1","5035","","0","Cash","","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO payments VALUES("868","spr-20250401-040903","1","","854","3","1","900","","0","Cash","","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO payments VALUES("869","spr-20250401-054635","1","","855","3","1","2010","","0","Cash","","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO payments VALUES("870","spr-20250401-055831","1","","856","3","1","1255","","0","Cash","","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO payments VALUES("871","spr-20250401-060923","1","","857","3","1","1470","","0","Cash","","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO payments VALUES("872","spr-20250401-070710","1","","859","3","1","1770","","0","Cash","","2025-04-01 19:07:10","2025-04-01 19:07:10");



CREATE TABLE `payrolls` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `employee_id` int NOT NULL,
  `account_id` int NOT NULL,
  `user_id` int NOT NULL,
  `amount` double NOT NULL,
  `paying_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payrolls VALUES("1","payroll-20250322-091615","2","1","1","6000","0","","2025-03-22 21:16:15","2025-03-22 21:16:15");



CREATE TABLE `permissions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES("4","products-edit","web","2018-06-03 04:00:09","2018-06-03 04:00:09");
INSERT INTO permissions VALUES("5","products-delete","web","2018-06-04 01:54:22","2018-06-04 01:54:22");
INSERT INTO permissions VALUES("6","products-add","web","2018-06-04 03:34:14","2018-06-04 03:34:14");
INSERT INTO permissions VALUES("7","products-index","web","2018-06-04 06:34:27","2018-06-04 06:34:27");
INSERT INTO permissions VALUES("8","purchases-index","web","2018-06-04 11:03:19","2018-06-04 11:03:19");
INSERT INTO permissions VALUES("9","purchases-add","web","2018-06-04 11:12:25","2018-06-04 11:12:25");
INSERT INTO permissions VALUES("10","purchases-edit","web","2018-06-04 12:47:36","2018-06-04 12:47:36");
INSERT INTO permissions VALUES("11","purchases-delete","web","2018-06-04 12:47:36","2018-06-04 12:47:36");
INSERT INTO permissions VALUES("12","sales-index","web","2018-06-04 13:49:08","2018-06-04 13:49:08");
INSERT INTO permissions VALUES("13","sales-add","web","2018-06-04 13:49:52","2018-06-04 13:49:52");
INSERT INTO permissions VALUES("14","sales-edit","web","2018-06-04 13:49:52","2018-06-04 13:49:52");
INSERT INTO permissions VALUES("15","sales-delete","web","2018-06-04 13:49:53","2018-06-04 13:49:53");
INSERT INTO permissions VALUES("16","quotes-index","web","2018-06-05 01:05:10","2018-06-05 01:05:10");
INSERT INTO permissions VALUES("17","quotes-add","web","2018-06-05 01:05:10","2018-06-05 01:05:10");
INSERT INTO permissions VALUES("18","quotes-edit","web","2018-06-05 01:05:10","2018-06-05 01:05:10");
INSERT INTO permissions VALUES("19","quotes-delete","web","2018-06-05 01:05:10","2018-06-05 01:05:10");
INSERT INTO permissions VALUES("20","transfers-index","web","2018-06-05 01:30:03","2018-06-05 01:30:03");
INSERT INTO permissions VALUES("21","transfers-add","web","2018-06-05 01:30:03","2018-06-05 01:30:03");
INSERT INTO permissions VALUES("22","transfers-edit","web","2018-06-05 01:30:03","2018-06-05 01:30:03");
INSERT INTO permissions VALUES("23","transfers-delete","web","2018-06-05 01:30:03","2018-06-05 01:30:03");
INSERT INTO permissions VALUES("24","returns-index","web","2018-06-05 01:50:24","2018-06-05 01:50:24");
INSERT INTO permissions VALUES("25","returns-add","web","2018-06-05 01:50:24","2018-06-05 01:50:24");
INSERT INTO permissions VALUES("26","returns-edit","web","2018-06-05 01:50:25","2018-06-05 01:50:25");
INSERT INTO permissions VALUES("27","returns-delete","web","2018-06-05 01:50:25","2018-06-05 01:50:25");
INSERT INTO permissions VALUES("28","customers-index","web","2018-06-05 02:15:54","2018-06-05 02:15:54");
INSERT INTO permissions VALUES("29","customers-add","web","2018-06-05 02:15:55","2018-06-05 02:15:55");
INSERT INTO permissions VALUES("30","customers-edit","web","2018-06-05 02:15:55","2018-06-05 02:15:55");
INSERT INTO permissions VALUES("31","customers-delete","web","2018-06-05 02:15:55","2018-06-05 02:15:55");
INSERT INTO permissions VALUES("32","suppliers-index","web","2018-06-05 02:40:12","2018-06-05 02:40:12");
INSERT INTO permissions VALUES("33","suppliers-add","web","2018-06-05 02:40:12","2018-06-05 02:40:12");
INSERT INTO permissions VALUES("34","suppliers-edit","web","2018-06-05 02:40:12","2018-06-05 02:40:12");
INSERT INTO permissions VALUES("35","suppliers-delete","web","2018-06-05 02:40:12","2018-06-05 02:40:12");
INSERT INTO permissions VALUES("36","product-report","web","2018-06-25 02:05:33","2018-06-25 02:05:33");
INSERT INTO permissions VALUES("37","purchase-report","web","2018-06-25 02:24:56","2018-06-25 02:24:56");
INSERT INTO permissions VALUES("38","sale-report","web","2018-06-25 02:33:13","2018-06-25 02:33:13");
INSERT INTO permissions VALUES("39","customer-report","web","2018-06-25 02:36:51","2018-06-25 02:36:51");
INSERT INTO permissions VALUES("40","due-report","web","2018-06-25 02:39:52","2018-06-25 02:39:52");
INSERT INTO permissions VALUES("41","users-index","web","2018-06-25 03:00:10","2018-06-25 03:00:10");
INSERT INTO permissions VALUES("42","users-add","web","2018-06-25 03:00:10","2018-06-25 03:00:10");
INSERT INTO permissions VALUES("43","users-edit","web","2018-06-25 03:01:30","2018-06-25 03:01:30");
INSERT INTO permissions VALUES("44","users-delete","web","2018-06-25 03:01:30","2018-06-25 03:01:30");
INSERT INTO permissions VALUES("45","profit-loss","web","2018-07-15 00:50:05","2018-07-15 00:50:05");
INSERT INTO permissions VALUES("46","best-seller","web","2018-07-15 01:01:38","2018-07-15 01:01:38");
INSERT INTO permissions VALUES("47","daily-sale","web","2018-07-15 01:24:21","2018-07-15 01:24:21");
INSERT INTO permissions VALUES("48","monthly-sale","web","2018-07-15 01:30:41","2018-07-15 01:30:41");
INSERT INTO permissions VALUES("49","daily-purchase","web","2018-07-15 01:36:46","2018-07-15 01:36:46");
INSERT INTO permissions VALUES("50","monthly-purchase","web","2018-07-15 01:48:17","2018-07-15 01:48:17");
INSERT INTO permissions VALUES("51","payment-report","web","2018-07-15 02:10:41","2018-07-15 02:10:41");
INSERT INTO permissions VALUES("52","warehouse-stock-report","web","2018-07-15 02:16:55","2018-07-15 02:16:55");
INSERT INTO permissions VALUES("53","product-qty-alert","web","2018-07-15 02:33:21","2018-07-15 02:33:21");
INSERT INTO permissions VALUES("54","supplier-report","web","2018-07-30 06:00:01","2018-07-30 06:00:01");
INSERT INTO permissions VALUES("55","expenses-index","web","2018-09-05 04:07:10","2018-09-05 04:07:10");
INSERT INTO permissions VALUES("56","expenses-add","web","2018-09-05 04:07:10","2018-09-05 04:07:10");
INSERT INTO permissions VALUES("57","expenses-edit","web","2018-09-05 04:07:10","2018-09-05 04:07:10");
INSERT INTO permissions VALUES("58","expenses-delete","web","2018-09-05 04:07:11","2018-09-05 04:07:11");
INSERT INTO permissions VALUES("59","general_setting","web","2018-10-20 02:10:04","2018-10-20 02:10:04");
INSERT INTO permissions VALUES("60","mail_setting","web","2018-10-20 02:10:04","2018-10-20 02:10:04");
INSERT INTO permissions VALUES("61","pos_setting","web","2018-10-20 02:10:04","2018-10-20 02:10:04");
INSERT INTO permissions VALUES("62","hrm_setting","web","2019-01-02 13:30:23","2019-01-02 13:30:23");
INSERT INTO permissions VALUES("63","purchase-return-index","web","2019-01-03 00:45:14","2019-01-03 00:45:14");
INSERT INTO permissions VALUES("64","purchase-return-add","web","2019-01-03 00:45:14","2019-01-03 00:45:14");
INSERT INTO permissions VALUES("65","purchase-return-edit","web","2019-01-03 00:45:14","2019-01-03 00:45:14");
INSERT INTO permissions VALUES("66","purchase-return-delete","web","2019-01-03 00:45:14","2019-01-03 00:45:14");
INSERT INTO permissions VALUES("67","account-index","web","2019-01-03 01:06:13","2019-01-03 01:06:13");
INSERT INTO permissions VALUES("68","balance-sheet","web","2019-01-03 01:06:14","2019-01-03 01:06:14");
INSERT INTO permissions VALUES("69","account-statement","web","2019-01-03 01:06:14","2019-01-03 01:06:14");
INSERT INTO permissions VALUES("70","department","web","2019-01-03 01:30:01","2019-01-03 01:30:01");
INSERT INTO permissions VALUES("71","attendance","web","2019-01-03 01:30:01","2019-01-03 01:30:01");
INSERT INTO permissions VALUES("72","payroll","web","2019-01-03 01:30:01","2019-01-03 01:30:01");
INSERT INTO permissions VALUES("73","employees-index","web","2019-01-03 01:52:19","2019-01-03 01:52:19");
INSERT INTO permissions VALUES("74","employees-add","web","2019-01-03 01:52:19","2019-01-03 01:52:19");
INSERT INTO permissions VALUES("75","employees-edit","web","2019-01-03 01:52:19","2019-01-03 01:52:19");
INSERT INTO permissions VALUES("76","employees-delete","web","2019-01-03 01:52:19","2019-01-03 01:52:19");
INSERT INTO permissions VALUES("77","user-report","web","2019-01-16 09:48:18","2019-01-16 09:48:18");
INSERT INTO permissions VALUES("78","stock_count","web","2019-02-17 13:32:01","2019-02-17 13:32:01");
INSERT INTO permissions VALUES("79","adjustment","web","2019-02-17 13:32:02","2019-02-17 13:32:02");
INSERT INTO permissions VALUES("80","sms_setting","web","2019-02-22 08:18:03","2019-02-22 08:18:03");
INSERT INTO permissions VALUES("81","create_sms","web","2019-02-22 08:18:03","2019-02-22 08:18:03");
INSERT INTO permissions VALUES("82","print_barcode","web","2019-03-07 08:02:19","2019-03-07 08:02:19");
INSERT INTO permissions VALUES("83","empty_database","web","2019-03-07 08:02:19","2019-03-07 08:02:19");
INSERT INTO permissions VALUES("84","customer_group","web","2019-03-07 08:37:15","2019-03-07 08:37:15");
INSERT INTO permissions VALUES("85","unit","web","2019-03-07 08:37:15","2019-03-07 08:37:15");
INSERT INTO permissions VALUES("86","tax","web","2019-03-07 08:37:15","2019-03-07 08:37:15");
INSERT INTO permissions VALUES("87","gift_card","web","2019-03-07 09:29:38","2019-03-07 09:29:38");
INSERT INTO permissions VALUES("88","coupon","web","2019-03-07 09:29:38","2019-03-07 09:29:38");
INSERT INTO permissions VALUES("89","holiday","web","2019-10-19 11:57:15","2019-10-19 11:57:15");
INSERT INTO permissions VALUES("90","warehouse-report","web","2019-10-22 09:00:23","2019-10-22 09:00:23");
INSERT INTO permissions VALUES("91","warehouse","web","2020-02-26 09:47:32","2020-02-26 09:47:32");
INSERT INTO permissions VALUES("92","brand","web","2020-02-26 09:59:59","2020-02-26 09:59:59");
INSERT INTO permissions VALUES("93","billers-index","web","2020-02-26 10:11:15","2020-02-26 10:11:15");
INSERT INTO permissions VALUES("94","billers-add","web","2020-02-26 10:11:15","2020-02-26 10:11:15");
INSERT INTO permissions VALUES("95","billers-edit","web","2020-02-26 10:11:15","2020-02-26 10:11:15");
INSERT INTO permissions VALUES("96","billers-delete","web","2020-02-26 10:11:15","2020-02-26 10:11:15");
INSERT INTO permissions VALUES("97","money-transfer","web","2020-03-02 08:41:48","2020-03-02 08:41:48");
INSERT INTO permissions VALUES("98","category","web","2020-07-13 15:13:16","2020-07-13 15:13:16");
INSERT INTO permissions VALUES("99","delivery","web","2020-07-13 15:13:16","2020-07-13 15:13:16");
INSERT INTO permissions VALUES("100","send_notification","web","2020-10-31 09:21:31","2020-10-31 09:21:31");
INSERT INTO permissions VALUES("101","today_sale","web","2020-10-31 09:57:04","2020-10-31 09:57:04");
INSERT INTO permissions VALUES("102","today_profit","web","2020-10-31 09:57:04","2020-10-31 09:57:04");
INSERT INTO permissions VALUES("103","currency","web","2020-11-09 03:23:11","2020-11-09 03:23:11");
INSERT INTO permissions VALUES("104","backup_database","web","2020-11-15 03:16:55","2020-11-15 03:16:55");
INSERT INTO permissions VALUES("105","reward_point_setting","web","2021-06-27 07:34:42","2021-06-27 07:34:42");
INSERT INTO permissions VALUES("106","revenue_profit_summary","web","2022-02-08 16:57:21","2022-02-08 16:57:21");
INSERT INTO permissions VALUES("107","cash_flow","web","2022-02-08 16:57:22","2022-02-08 16:57:22");
INSERT INTO permissions VALUES("108","monthly_summary","web","2022-02-08 16:57:22","2022-02-08 16:57:22");
INSERT INTO permissions VALUES("109","yearly_report","web","2022-02-08 16:57:22","2022-02-08 16:57:22");
INSERT INTO permissions VALUES("110","discount_plan","web","2022-02-16 12:12:26","2022-02-16 12:12:26");
INSERT INTO permissions VALUES("111","discount","web","2022-02-16 12:12:38","2022-02-16 12:12:38");
INSERT INTO permissions VALUES("112","product-expiry-report","web","2022-03-30 08:39:20","2022-03-30 08:39:20");
INSERT INTO permissions VALUES("113","purchase-payment-index","web","2022-06-05 17:12:27","2022-06-05 17:12:27");
INSERT INTO permissions VALUES("114","purchase-payment-add","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("115","purchase-payment-edit","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("116","purchase-payment-delete","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("117","sale-payment-index","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("118","sale-payment-add","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("119","sale-payment-edit","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("120","sale-payment-delete","web","2022-06-05 17:12:28","2022-06-05 17:12:28");
INSERT INTO permissions VALUES("121","all_notification","web","2022-06-05 17:12:29","2022-06-05 17:12:29");
INSERT INTO permissions VALUES("122","sale-report-chart","web","2022-06-05 17:12:29","2022-06-05 17:12:29");
INSERT INTO permissions VALUES("123","dso-report","web","2022-06-05 17:12:29","2022-06-05 17:12:29");
INSERT INTO permissions VALUES("124","product_history","web","2022-08-25 17:04:05","2022-08-25 17:04:05");
INSERT INTO permissions VALUES("125","supplier-due-report","web","2022-08-31 12:46:33","2022-08-31 12:46:33");
INSERT INTO permissions VALUES("126","custom_field","web","2023-05-02 10:41:35","2023-05-02 10:41:35");



CREATE TABLE `pos_setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `product_number` int NOT NULL,
  `keybord_active` tinyint(1) NOT NULL,
  `is_table` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_public_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_secret_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_live_api_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_live_api_password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_live_api_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `invoice_option` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `pos_setting_id_unique` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pos_setting VALUES("1","1","2","1","50","0","0","","","admin","B@admin","","cash,mpesa","thermal","2023-06-21 17:20:02","2025-01-04 22:51:05");



CREATE TABLE `product_adjustments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `adjustment_id` int NOT NULL,
  `product_id` int NOT NULL,
  `variant_id` int DEFAULT NULL,
  `qty` double NOT NULL,
  `action` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_adjustments VALUES("148","49","1385","","10","+","2025-01-18 22:31:05","2025-01-18 22:31:05");
INSERT INTO product_adjustments VALUES("149","50","1443","","50","+","2025-03-16 20:05:05","2025-03-16 20:05:05");
INSERT INTO product_adjustments VALUES("150","51","1460","","5","+","2025-03-18 17:32:12","2025-03-18 17:32:12");
INSERT INTO product_adjustments VALUES("151","52","1461","","5","+","2025-03-18 17:53:36","2025-03-18 17:53:36");
INSERT INTO product_adjustments VALUES("152","53","1387","","20","+","2025-03-21 12:38:48","2025-03-21 12:38:48");
INSERT INTO product_adjustments VALUES("153","54","1444","","50","+","2025-03-22 12:56:30","2025-03-22 12:56:30");
INSERT INTO product_adjustments VALUES("154","55","1468","","5","+","2025-03-22 14:23:37","2025-03-22 14:23:37");
INSERT INTO product_adjustments VALUES("155","56","1443","","50","+","2025-03-22 16:44:13","2025-03-22 16:44:13");
INSERT INTO product_adjustments VALUES("156","57","1443","","50","+","2025-03-22 18:52:52","2025-03-22 18:52:52");
INSERT INTO product_adjustments VALUES("157","58","1443","","50","+","2025-03-24 20:05:13","2025-03-24 20:05:13");
INSERT INTO product_adjustments VALUES("158","59","1421","","10","+","2025-03-24 20:16:19","2025-03-24 20:16:19");
INSERT INTO product_adjustments VALUES("159","60","1406","","10","+","2025-03-24 20:18:39","2025-03-24 20:18:39");
INSERT INTO product_adjustments VALUES("160","61","1427","","5","+","2025-03-24 20:24:38","2025-03-24 20:24:38");
INSERT INTO product_adjustments VALUES("161","62","1465","","50","+","2025-03-25 15:52:28","2025-03-25 15:52:28");
INSERT INTO product_adjustments VALUES("162","63","1418","","10","+","2025-03-25 17:56:54","2025-03-25 17:56:54");
INSERT INTO product_adjustments VALUES("163","64","1444","","50","+","2025-03-26 19:16:40","2025-03-26 19:16:40");
INSERT INTO product_adjustments VALUES("164","65","1443","","20","+","2025-03-27 19:25:37","2025-03-27 19:25:37");
INSERT INTO product_adjustments VALUES("165","66","1415","","5","+","2025-03-27 19:26:45","2025-03-27 19:26:45");
INSERT INTO product_adjustments VALUES("166","67","1417","","10","+","2025-03-28 20:15:12","2025-03-28 20:15:12");
INSERT INTO product_adjustments VALUES("167","68","1487","","6","+","2025-03-31 15:34:24","2025-03-31 15:34:24");
INSERT INTO product_adjustments VALUES("168","69","1443","","20","+","2025-03-31 15:53:14","2025-03-31 15:53:14");
INSERT INTO product_adjustments VALUES("169","70","1417","","10","+","2025-03-31 17:16:44","2025-03-31 17:16:44");
INSERT INTO product_adjustments VALUES("170","71","1443","","30","+","2025-03-31 18:06:26","2025-03-31 18:06:26");
INSERT INTO product_adjustments VALUES("171","72","1498","","6","+","2025-03-31 18:54:16","2025-03-31 18:54:16");
INSERT INTO product_adjustments VALUES("172","73","1417","","10","+","2025-03-31 19:36:11","2025-03-31 19:36:11");
INSERT INTO product_adjustments VALUES("173","74","1409","","10","+","2025-04-01 15:44:02","2025-04-01 15:44:02");
INSERT INTO product_adjustments VALUES("174","75","1488","","3","+","2025-04-01 16:16:01","2025-04-01 16:16:01");
INSERT INTO product_adjustments VALUES("175","76","1470","","2","+","2025-04-01 16:16:48","2025-04-01 16:16:48");
INSERT INTO product_adjustments VALUES("176","77","1432","","5","+","2025-04-01 16:17:31","2025-04-01 16:17:31");
INSERT INTO product_adjustments VALUES("177","78","1436","","4","+","2025-04-01 16:18:18","2025-04-01 16:18:18");



CREATE TABLE `product_batches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `batch_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_date` date NOT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_purchases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `purchase_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `recieved` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_purchases VALUES("213","3","879","","","","0","0","1","346","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("214","3","880","","","","2","2","1","982","0","0","0","1964","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("215","3","881","","","","2","2","1","1115","0","0","0","2230","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("216","3","882","","","","3","3","1","175","0","0","0","525","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("217","3","883","","","","0","0","1","237","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("218","3","884","","","","8","8","1","212","0","0","0","1696","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("219","3","885","","","","5","5","1","321","0","0","0","1605","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("220","3","886","","","","12","12","1","72","0","0","0","864","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("221","3","887","","","","5","5","1","102","0","0","0","510","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("222","3","888","","","","4","4","1","1253","0","0","0","5012","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("223","3","889","","","","0","0","1","365","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("224","3","890","","","","1","1","1","2164","0","0","0","2164","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("225","3","891","","","","3","3","1","297","0","0","0","891","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("226","3","892","","","","3","3","1","635","0","0","0","1905","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("227","3","893","","","","0","0","1","386","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("228","3","894","","","","1","1","1","1420","0","0","0","1420","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("229","3","895","","","","0","0","1","9","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("230","3","896","","","","2","2","1","24","0","0","0","48","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("231","3","897","","","","49","49","1","7","0","0","0","343","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("232","3","898","","","","5","5","1","48","0","0","0","240","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("233","3","899","","","","8","8","1","49","0","0","0","392","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("234","3","900","","","","1","1","1","199","0","0","0","199","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("235","3","901","","","","9","9","1","10","0","0","0","90","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("236","3","902","","","","0","0","1","69","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("237","3","903","","","","3","3","1","343","0","0","0","1029","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("238","3","904","","","","4","4","1","28","0","0","0","112","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("239","3","905","","","","6","6","1","16","0","0","0","96","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("240","3","906","","","","5","5","1","200","0","0","0","1000","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("241","3","907","","","","1","1","1","277","0","0","0","277","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("242","3","908","","","","1","1","1","438","0","0","0","438","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("243","3","909","","","","16","16","1","223","0","0","0","3568","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("244","3","910","","","","0","0","1","486","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("245","3","911","","","","1","1","1","355","0","0","0","355","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("246","3","912","","","","2","2","1","188","0","0","0","376","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("247","3","913","","","","2","2","1","341","0","0","0","682","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("248","3","914","","","","90","90","1","127","0","0","0","11430","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("249","3","915","","","","0","0","1","142","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("250","3","916","","","","12","12","1","49","0","0","0","588","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("251","3","917","","","","2","2","1","244","0","0","0","488","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("252","3","918","","","","5","5","1","288","0","0","0","1440","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("253","3","919","","","","5","5","1","242","0","0","0","1210","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("254","3","920","","","","7","7","1","315","0","0","0","2205","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("255","3","921","","","","5","5","1","310","0","0","0","1550","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("256","3","922","","","","1","1","1","746","0","0","0","746","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("257","3","923","","","","0","0","1","874","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("258","3","924","","","","3","3","1","53","0","0","0","159","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("259","3","925","","","","2","2","1","108","0","0","0","216","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("260","3","926","","","","9","9","1","29","0","0","0","261","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("261","3","927","","","","3","3","1","597","0","0","0","1791","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("262","3","928","","","","0","0","1","2086","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("263","3","929","","","","0","0","1","1537","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("264","3","930","","","","2","2","1","234","0","0","0","468","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("265","3","931","","","","1","1","1","3385","0","0","0","3385","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("266","3","932","","","","5","5","1","492","0","0","0","2460","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("267","3","933","","","","4","4","1","3313","0","0","0","13252","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("268","3","934","","","","4","4","1","714","0","0","0","2856","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("269","3","935","","","","5","5","1","735","0","0","0","3675","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("270","3","936","","","","5","5","1","319","0","0","0","1595","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("271","3","937","","","","2","2","1","620","0","0","0","1240","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("272","3","938","","","","0","0","1","413","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("273","3","939","","","","0","0","1","773","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("274","3","940","","","","3","3","1","11","0","0","0","33","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("275","3","941","","","","0","0","1","2056","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("276","3","942","","","","0","0","1","22","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("277","3","943","","","","8","8","1","30","0","0","0","240","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("278","3","944","","","","8","8","1","19","0","0","0","152","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("279","3","945","","","","2","2","1","609","0","0","0","1218","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("280","3","946","","","","2","2","1","7061","0","0","0","14122","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("281","3","947","","","","5","5","1","143","0","0","0","715","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("282","3","948","","","","2","2","1","2137","0","0","0","4274","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("283","3","949","","","","4","4","1","312","0","0","0","1248","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("284","3","950","","","","5","5","1","354","0","0","0","1770","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("285","3","951","","","","20","20","1","351","0","0","0","7020","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("286","3","952","","","","6","6","1","1575","0","0","0","9450","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("287","3","953","","","","0","0","1","452","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("288","3","954","","","","2","2","1","718","0","0","0","1436","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("289","3","955","","","","2","2","1","1337","0","0","0","2674","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("290","3","956","","","","2","2","1","6067","0","0","0","12134","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("291","3","957","","","","1","1","1","6396","0","0","0","6396","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("292","3","958","","","","0","0","1","27","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("293","3","959","","","","4","4","1","69","0","0","0","276","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("294","3","960","","","","0","0","1","92","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("295","3","961","","","","1","1","1","258","0","0","0","258","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("296","3","962","","","","6","6","1","330","0","0","0","1980","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("297","3","963","","","","1","1","1","528","0","0","0","528","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("298","3","964","","","","0","0","1","174","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("299","3","965","","","","3","3","1","427","0","0","0","1281","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("300","3","966","","","","0","0","1","192","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("301","3","967","","","","0","0","1","16","0","0","0","0","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("302","3","968","","","","2","2","1","638","0","0","0","1276","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("303","3","969","","","","4","4","1","19","0","0","0","76","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("304","3","970","","","","3","3","1","821","0","0","0","2463","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("305","3","971","","","","1","1","1","1061","0","0","0","1061","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("306","3","972","","","","8","8","1","19","0","0","0","152","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("307","3","973","","","","1","1","1","54","0","0","0","54","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_purchases VALUES("308","3","974","","","","1","1","1","3115","0","0","0","3115","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("309","3","975","","","","3","3","1","291","0","0","0","873","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("310","3","976","","","","1","1","1","582","0","0","0","582","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("311","3","977","","","","11","11","1","145","0","0","0","1595","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("312","3","978","","","","5","5","1","142","0","0","0","710","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("313","3","979","","","","0","0","1","1411","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("314","3","980","","","","0","0","1","1637","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("315","3","981","","","","2","2","1","301","0","0","0","602","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("316","3","982","","","","4","4","1","381","0","0","0","1524","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("317","3","983","","","","2","2","1","301","0","0","0","602","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("318","3","984","","","","7","7","1","19","0","0","0","133","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("319","3","985","","","","2","2","1","188","0","0","0","376","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("320","3","986","","","","4","4","1","28","0","0","0","112","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("321","3","987","","","","3","3","1","14","0","0","0","42","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("322","3","988","","","","10","10","1","13","0","0","0","130","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("323","3","989","","","","1","1","1","30","0","0","0","30","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("324","3","990","","","","7","7","1","16","0","0","0","112","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("325","3","991","","","","9","9","1","8","0","0","0","72","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("326","3","992","","","","7","7","1","518","0","0","0","3626","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("327","3","993","","","","9","9","1","68","0","0","0","612","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("328","3","994","","","","4","4","1","207","0","0","0","828","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("329","3","995","","","","0","0","1","580","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("330","3","996","","","","0","0","1","3512","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("331","3","997","","","","1","1","1","1700","0","0","0","1700","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("332","3","998","","","","1","1","1","2424","0","0","0","2424","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("333","3","999","","","","5","5","1","664","0","0","0","3320","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("334","3","1000","","","","3","3","1","487","0","0","0","1461","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("335","3","1001","","","","3","3","1","55","0","0","0","165","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("336","3","1002","","","","3","3","1","119","0","0","0","357","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("337","3","1003","","","","3","3","1","2","0","0","0","6","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("338","3","1004","","","","2","2","1","694","0","0","0","1388","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("339","3","1005","","","","2","2","1","1427","0","0","0","2854","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("340","3","1006","","","","1","1","1","1294","0","0","0","1294","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("341","3","1007","","","","1","1","1","1294","0","0","0","1294","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("342","3","1008","","","","0","0","1","166","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("343","3","1009","","","","2","2","1","28","0","0","0","56","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("344","3","1010","","","","0","0","1","329","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("345","3","1011","","","","7","7","1","202","0","0","0","1414","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("346","3","1012","","","","0","0","1","256","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("347","3","1013","","","","4","4","1","159","0","0","0","636","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("348","3","1014","","","","6","6","1","160","0","0","0","960","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("349","3","1015","","","","0","0","1","159","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("350","3","1016","","","","1","1","1","157","0","0","0","157","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("351","3","1017","","","","2","2","1","1108","0","0","0","2216","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("352","3","1018","","","","3","3","1","321","0","0","0","963","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("353","3","1019","","","","6","6","1","71","0","0","0","426","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("354","3","1020","","","","5","5","1","71","0","0","0","355","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("355","3","1021","","","","1","1","1","730","0","0","0","730","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("356","3","1022","","","","5","5","1","679","0","0","0","3395","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("357","3","1023","","","","1","1","1","241","0","0","0","241","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("358","3","1024","","","","5","5","1","329","0","0","0","1645","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("359","3","1025","","","","2","2","1","237","0","0","0","475","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("360","3","1026","","","","2","2","1","158","0","0","0","316","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("361","3","1027","","","","4","4","1","14","0","0","0","56","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("362","3","1028","","","","1","1","1","144","0","0","0","144","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("363","3","1029","","","","8","8","1","69","0","0","0","552","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("364","3","1030","","","","2","2","1","128","0","0","0","256","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("365","3","1031","","","","10","10","1","22","0","0","0","220","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("366","3","1032","","","","5","5","1","52","0","0","0","260","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("367","3","1033","","","","5","5","1","16","0","0","0","80","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("368","3","1034","","","","6","6","1","313","0","0","0","1878","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("369","3","1035","","","","0","0","1","121","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("370","3","1036","","","","8","8","1","83","0","0","0","664","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("371","3","1037","","","","1","1","1","1359","0","0","0","1359","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("372","3","1038","","","","1","1","1","1333","0","0","0","1333","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("373","3","1039","","","","1","1","1","0","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("374","3","1040","","","","0","0","1","1333","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("375","3","1041","","","","1","1","1","2790","0","0","0","2790","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("376","3","1042","","","","7","7","1","403","0","0","0","2821","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("377","3","1043","","","","5","5","1","2008","0","0","0","10040","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("378","3","1044","","","","3","3","1","781","0","0","0","2343","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("379","3","1045","","","","6","6","1","345","0","0","0","2070","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("380","3","1046","","","","2","2","1","320","0","0","0","640","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("381","3","1047","","","","3","3","1","645","0","0","0","1935","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("382","3","1048","","","","0","0","1","93","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("383","3","1049","","","","3","3","1","318","0","0","0","954","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("384","3","1050","","","","1","1","1","602","0","0","0","602","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("385","3","1051","","","","0","0","1","2900","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("386","3","1052","","","","4","4","1","979","0","0","0","3916","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("387","3","1053","","","","7","7","1","8","0","0","0","56","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("388","3","1054","","","","11","11","1","209","0","0","0","2299","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("389","3","1055","","","","3","3","1","117","0","0","0","351","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("390","3","1056","","","","3","3","1","70","0","0","0","210","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("391","3","1057","","","","1","1","1","112","0","0","0","112","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("392","3","1058","","","","4","4","1","184","0","0","0","736","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("393","3","1059","","","","8","8","1","94","0","0","0","752","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("394","3","1060","","","","9","9","1","49","0","0","0","441","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("395","3","1061","","","","20","20","1","212","0","0","0","4240","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("396","3","1062","","","","0","0","1","779","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("397","3","1063","","","","3","3","1","1898","0","0","0","5694","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("398","3","1064","","","","0","0","1","230","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("399","3","1065","","","","3","3","1","1486","0","0","0","4458","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("400","3","1066","","","","3","3","1","173","0","0","0","519","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("401","3","1067","","","","0","0","1","945","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("402","3","1068","","","","1","1","1","1628","0","0","0","1628","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("403","3","1069","","","","2","2","1","912","0","0","0","1824","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("404","3","1070","","","","3","3","1","275","0","0","0","825","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("405","3","1071","","","","3","3","1","720","0","0","0","2160","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("406","3","1072","","","","0","0","1","930","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("407","3","1073","","","","0","0","1","242","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("408","3","1074","","","","1","1","1","192","0","0","0","192","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("409","3","1075","","","","3","3","1","5328","0","0","0","15984","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("410","3","1076","","","","3","3","1","2038","0","0","0","6114","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("411","3","1077","","","","0","0","1","1246","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("412","3","1078","","","","0","0","1","0","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("413","3","1079","","","","0","0","1","0","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("414","3","1080","","","","1","1","1","1664","0","0","0","1664","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("415","3","1081","","","","1","1","1","1286","0","0","0","1286","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("416","3","1082","","","","7","7","1","654","0","0","0","4578","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("417","3","1083","","","","8","8","1","416","0","0","0","3328","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("418","3","1084","","","","3","3","1","60","0","0","0","180","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("419","3","1085","","","","4","4","1","85","0","0","0","340","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("420","3","1086","","","","9","9","1","29","0","0","0","261","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("421","3","1087","","","","0","0","1","305","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("422","3","1088","","","","0","0","1","305","0","0","0","0","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("423","3","1089","","","","1","1","1","305","0","0","0","305","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("424","3","1090","","","","1","1","1","305","0","0","0","305","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_purchases VALUES("425","4","1046","","","","20","20","1","320","0","0","0","6400","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("426","4","1075","","","","1","1","1","5328","0","0","0","5328","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("427","4","927","","","","1","1","1","597","0","0","0","597","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("428","4","999","","","","2","2","1","664","0","0","0","1328","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("429","4","992","","","","48","48","1","518","0","0","0","24864","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("430","4","912","","","","10","10","1","188","0","0","0","1880","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("431","4","1035","","","","20","20","1","121","0","0","0","2420","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("432","4","1014","","","","5","5","1","160","0","0","0","800","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("433","4","1013","","","","5","5","1","159","0","0","0","795","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("434","4","973","","","","5","5","1","54","0","0","0","270","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("435","4","1010","","","","5","5","1","329","0","0","0","1645","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("436","4","1007","","","","4","4","1","1294","0","0","0","5176","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("437","4","1006","","","","2","2","1","1294","0","0","0","2588","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("438","4","1011","","","","10","10","1","202","0","0","0","2020","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("439","4","1025","","","","10","10","1","237","0","0","0","2370","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("440","4","1024","","","","5","5","1","329","0","0","0","1645","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("441","4","936","","","","3","3","1","319","0","0","0","957","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("442","4","1026","","","","10","10","1","158","0","0","0","1580","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO product_purchases VALUES("443","5","1091","","","","9","9","1","500","0","0","0","4500","2023-09-13 13:19:41","2023-09-13 13:19:41");
INSERT INTO product_purchases VALUES("444","6","1092","","","","10","10","1","28","0","0","0","280","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("445","6","1093","","","","5","5","1","28","0","0","0","140","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("446","6","1094","","","","2","2","1","333","0","0","0","666","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("447","6","1095","","","","4","4","1","26","0","0","0","104","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("448","6","1096","","","","2","2","1","931","0","0","0","1862","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("449","6","1097","","","","1","1","1","9843","0","0","0","9843","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("450","6","1098","","","","2","2","1","459","0","0","0","918","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("451","6","1099","","","","2","2","1","15","0","0","0","30","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("452","6","1100","","","","3","3","1","133","0","0","0","399","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("453","6","1101","","","","5","5","1","282","0","0","0","1410","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("454","6","1102","","","","3","3","1","80","0","0","0","240","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("455","6","1103","","","","5","5","1","177","0","0","0","885","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("456","6","1104","","","","8","8","1","64","0","0","0","512","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("457","6","1105","","","","2","2","1","298","0","0","0","596","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("458","6","1106","","","","5","5","1","98","0","0","0","490","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("459","6","1107","","","","9","9","1","18","0","0","0","162","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("460","6","1108","","","","2","2","1","469","0","0","0","938","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("461","6","1109","","","","3","3","1","2799","0","0","0","8397","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("462","6","1110","","","","5","5","1","95","0","0","0","475","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("463","6","1111","","","","4","4","1","70","0","0","0","280","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("464","6","1112","","","","2","2","1","1523","0","0","0","3046","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("465","6","1113","","","","5","5","1","521","0","0","0","2605","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("466","6","1114","","","","1","1","1","1024","0","0","0","1024","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("467","6","1115","","","","2","2","1","3914","0","0","0","7828","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("468","6","1116","","","","2","2","1","394","0","0","0","788","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("469","6","1117","","","","5","5","1","190","0","0","0","950","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("470","6","1118","","","","2","2","1","118","0","0","0","236","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("471","6","978","","","","2","2","1","128","0","0","0","256","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("472","6","977","","","","3","3","1","128","0","0","0","384","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("473","6","1119","","","","2","2","1","1046","0","0","0","2092","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("474","6","1120","","","","2","2","1","1880","0","0","0","3760","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("475","6","1121","","","","1","1","1","1026","0","0","0","1026","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("476","6","1122","","","","4","4","1","38","0","0","0","152","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("477","6","1123","","","","2","2","1","30","0","0","0","60","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("478","6","907","","","","1","1","1","407","0","0","0","407","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("479","6","1124","","","","2","2","1","23","0","0","0","46","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_purchases VALUES("480","7","1125","","","","11","11","1","145","0","0","0","1595","2023-09-13 14:33:30","2023-09-13 14:33:30");
INSERT INTO product_purchases VALUES("481","8","1127","","","","2","2","1","130","0","0","0","260","2023-09-13 14:57:10","2023-09-13 14:57:10");
INSERT INTO product_purchases VALUES("482","9","1128","","","","10","10","1","100","0","0","0","1000","2023-09-13 19:07:11","2023-09-13 19:07:11");
INSERT INTO product_purchases VALUES("483","10","1129","","","","9","9","1","40","0","0","0","360","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("484","10","1130","","","","5","5","1","40","0","0","0","200","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("485","10","1131","","","","4","4","1","399","0","0","0","1596","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("486","10","1132","","","","13","13","1","423","0","0","0","5499","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("487","10","1133","","","","10","10","1","96","0","0","0","960","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("488","10","1134","","","","0","0","1","580","0","0","0","0","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("489","10","1135","","","","8","8","1","518","0","0","0","4144","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("490","10","1136","","","","1","1","1","694","0","0","0","694","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("491","10","1137","","","","6","6","1","434","0","0","0","2604","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("492","10","1138","","","","0","0","1","122","0","0","0","0","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("493","10","1139","","","","18","18","1","162","0","0","0","2916","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("494","10","1140","","","","1","1","1","341","0","0","0","341","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("495","10","1141","","","","2","2","1","461","0","0","0","922","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("496","10","1142","","","","2","2","1","9275","0","0","0","18550","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("497","10","1143","","","","5","5","1","893","0","0","0","4465","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("498","10","1144","","","","0","0","1","960","0","0","0","0","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("499","10","1145","","","","3","3","1","1700","0","0","0","5100","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("500","10","1146","","","","3","3","1","1711","0","0","0","5133","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("501","10","1147","","","","2","2","1","159","0","0","0","318","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("502","10","1148","","","","2","2","1","16","0","0","0","32","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("503","10","1149","","","","5","5","1","2641","0","0","0","13205","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("504","10","1150","","","","3","3","1","2493","0","0","0","7479","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("505","10","1151","","","","0","0","1","544","0","0","0","0","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("506","10","1152","","","","5","5","1","566","0","0","0","2830","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("507","10","1153","","","","2","2","1","1465","0","0","0","2930","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("508","10","1154","","","","3","3","1","231","0","0","0","693","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("509","10","1155","","","","8","8","1","211","0","0","0","1688","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("510","10","1156","","","","0","0","1","30","0","0","0","0","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("511","10","1157","","","","2","2","1","37","0","0","0","74","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("512","10","1158","","","","1","1","1","207","0","0","0","207","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("513","10","1159","","","","4","4","1","26","0","0","0","104","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_purchases VALUES("514","10","1160","","","","8","8","1","315","0","0","0","2520","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("515","10","1161","","","","3","3","1","74","0","0","0","222","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("516","10","1162","","","","6","6","1","435","0","0","0","2610","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("517","10","1163","","","","7","7","1","550","0","0","0","3850","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("518","10","1164","","","","6","6","1","862","0","0","0","5172","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("519","10","1165","","","","0","0","1","229","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("520","10","1166","","","","2","2","1","1164","0","0","0","2328","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("521","10","1167","","","","1","1","1","13570","0","0","0","13570","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("522","10","1168","","","","7","7","1","21","0","0","0","147","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("523","10","1169","","","","2","2","1","645","0","0","0","1290","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("524","10","1170","","","","7","7","1","91","0","0","0","637","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("525","10","1171","","","","5","5","1","187","0","0","0","935","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("526","10","1172","","","","9","9","1","11","0","0","0","99","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("527","10","1173","","","","2","2","1","21","0","0","0","42","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("528","10","1174","","","","0","0","1","593","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("529","10","1175","","","","8","8","1","109","0","0","0","872","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("530","10","1176","","","","10","10","1","16","0","0","0","160","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("531","10","1177","","","","3","3","1","182","0","0","0","546","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("532","10","1178","","","","5","5","1","389","0","0","0","1945","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("533","10","1179","","","","8","8","1","25","0","0","0","200","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("534","10","1180","","","","4","4","1","784","0","0","0","3136","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("535","10","1181","","","","0","0","1","113","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("536","10","1182","","","","3","3","1","109","0","0","0","327","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("537","10","1183","","","","5","5","1","244","0","0","0","1220","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("538","10","1184","","","","8","8","1","88","0","0","0","704","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("539","10","1185","","","","1","1","1","1135","0","0","0","1135","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("540","10","1186","","","","0","0","1","1147","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("541","10","1187","","","","6","6","1","413","0","0","0","2478","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("542","10","1188","","","","0","0","1","4609","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("543","10","1189","","","","4","4","1","937","0","0","0","3748","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("544","10","1190","","","","4","4","1","965","0","0","0","3860","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("545","10","1191","","","","16","16","1","461","0","0","0","7376","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("546","10","1192","","","","5","5","1","465","0","0","0","2325","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("547","10","1193","","","","0","0","1","218","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("548","10","1194","","","","2","2","1","448","0","0","0","896","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("549","10","1195","","","","4","4","1","431","0","0","0","1724","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("550","10","1196","","","","1","1","1","764","0","0","0","764","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("551","10","1197","","","","2","2","1","377","0","0","0","754","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("552","10","1198","","","","3","3","1","1026","0","0","0","3078","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("553","10","1199","","","","2","2","1","799","0","0","0","1598","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("554","10","1200","","","","0","0","1","302","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("555","10","1201","","","","2","2","1","37","0","0","0","74","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("556","10","1202","","","","4","4","1","1285","0","0","0","5140","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("557","10","1203","","","","3","3","1","92","0","0","0","276","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("558","10","1204","","","","2","2","1","639","0","0","0","1278","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("559","10","1205","","","","1","1","1","147","0","0","0","147","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("560","10","1206","","","","2","2","1","1289","0","0","0","2578","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("561","10","1207","","","","0","0","1","0","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("562","10","1208","","","","0","0","1","0","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("563","10","1209","","","","1","1","1","2184","0","0","0","2184","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("564","10","1210","","","","0","0","1","1393","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("565","10","1211","","","","5","5","1","407","0","0","0","2035","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("566","10","1212","","","","0","0","1","3131","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("567","10","1213","","","","7","7","1","529","0","0","0","3703","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("568","10","1214","","","","1","1","1","2840","0","0","0","2840","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("569","10","1215","","","","2","2","1","1454","0","0","0","2908","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("570","10","1216","","","","13","13","1","265","0","0","0","3445","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("571","10","1217","","","","0","0","1","1550","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("572","10","1218","","","","0","0","1","2050","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("573","10","1219","","","","5","5","1","90","0","0","0","450","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("574","10","1220","","","","20","20","1","278","0","0","0","5560","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("575","10","1221","","","","1","1","1","1687","0","0","0","1687","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("576","10","1222","","","","1","1","1","790","0","0","0","790","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("577","10","1223","","","","3","3","1","847","0","0","0","2541","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("578","10","1224","","","","3","3","1","417","0","0","0","1251","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("579","10","1225","","","","2","2","1","447","0","0","0","894","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("580","10","1226","","","","1","1","1","400","0","0","0","400","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("581","10","1227","","","","5","5","1","68","0","0","0","340","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("582","10","1228","","","","5","5","1","21","0","0","0","105","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("583","10","1229","","","","0","0","1","400","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("584","10","1230","","","","5","5","1","135","0","0","0","675","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("585","10","1231","","","","0","0","1","400","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("586","10","1232","","","","9","9","1","25","0","0","0","225","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("587","10","1233","","","","0","0","1","400","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("588","10","1234","","","","3","3","1","382","0","0","0","1146","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("589","10","1235","","","","0","0","1","122","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("590","10","1236","","","","0","0","1","653","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("591","10","1237","","","","10","10","1","246","0","0","0","2460","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("592","10","1238","","","","0","0","1","186","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("593","10","1239","","","","89","89","1","167","0","0","0","14863","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("594","10","1240","","","","12","12","1","64","0","0","0","768","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("595","10","1241","","","","3","3","1","3935","0","0","0","11805","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("596","10","1242","","","","1","1","1","4088","0","0","0","4088","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("597","10","1243","","","","3","3","1","2675","0","0","0","8025","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("598","10","1244","","","","5","5","1","126","0","0","0","630","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("599","10","1245","","","","2","2","1","945","0","0","0","1890","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("600","10","1246","","","","2","2","1","1198","0","0","0","2396","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("601","10","1247","","","","0","0","1","1221","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("602","10","1248","","","","4","4","1","98","0","0","0","392","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("603","10","1249","","","","1","1","1","252","0","0","0","252","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("604","10","1250","","","","0","0","1","318","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("605","10","1251","","","","3","3","1","360","0","0","0","1080","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("606","10","1252","","","","9","9","1","64","0","0","0","576","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("607","10","1253","","","","0","0","1","1636","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("608","10","1254","","","","1","1","1","3662","0","0","0","3662","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("609","10","1255","","","","0","0","1","3806","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("610","10","1256","","","","2","2","1","2079","0","0","0","4158","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("611","10","1257","","","","5","5","1","749","0","0","0","3745","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("612","10","1258","","","","3","3","1","1078","0","0","0","3234","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("613","10","1259","","","","3","3","1","421","0","0","0","1263","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("614","10","1260","","","","0","0","1","2017","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("615","10","1261","","","","0","0","1","2738","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("616","10","1262","","","","2","2","1","700","0","0","0","1400","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("617","10","1263","","","","-1","-1","1","1015","0","0","0","-1015","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("618","10","1264","","","","5","5","1","71","0","0","0","355","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("619","10","1265","","","","0","0","1","454","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("620","10","1266","","","","3","3","1","80","0","0","0","240","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("621","10","1267","","","","1","1","1","142","0","0","0","142","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("622","10","1268","","","","4","4","1","2067","0","0","0","8268","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("623","10","1269","","","","0","0","1","1022","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("624","10","1270","","","","1","1","1","3182","0","0","0","3182","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("625","10","1271","","","","0","0","1","360","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("626","10","1272","","","","1","1","1","317","0","0","0","317","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("627","10","1273","","","","5","5","1","422","0","0","0","2110","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("628","10","1274","","","","2","2","1","560","0","0","0","1120","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("629","10","1275","","","","1","1","1","321","0","0","0","321","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("630","10","1276","","","","1","1","1","2231","0","0","0","2231","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("631","10","1277","","","","8","8","1","278","0","0","0","2224","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("632","10","1278","","","","4","4","1","347","0","0","0","1388","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("633","10","1279","","","","7","7","1","934","0","0","0","6538","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("634","10","1280","","","","2","2","1","154","0","0","0","308","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("635","10","1281","","","","7","7","1","209","0","0","0","1463","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("636","10","1282","","","","9","9","1","29","0","0","0","261","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("637","10","1283","","","","5","5","1","689","0","0","0","3445","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("638","10","1284","","","","5","5","1","134","0","0","0","670","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("639","10","1285","","","","1","1","1","1411","0","0","0","1411","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("640","10","1286","","","","3","3","1","1951","0","0","0","5853","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("641","10","1287","","","","11","11","1","274","0","0","0","3014","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("642","10","1288","","","","5","5","1","454","0","0","0","2270","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("643","10","1289","","","","0","0","1","480","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("644","10","1290","","","","8","8","1","123","0","0","0","984","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("645","10","1291","","","","3","3","1","1645","0","0","0","4935","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("646","10","1292","","","","0","0","1","189","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("647","10","1293","","","","1","1","1","2163","0","0","0","2163","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("648","10","1294","","","","1","1","1","8395","0","0","0","8395","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("649","10","1295","","","","2","2","1","5342","0","0","0","10684","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("650","10","1296","","","","3","3","1","78","0","0","0","234","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("651","10","1297","","","","4","4","1","241","0","0","0","964","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("652","10","1298","","","","2","2","1","837","0","0","0","1674","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("653","10","1299","","","","4","4","1","4348","0","0","0","17392","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("654","10","1300","","","","2","2","1","911","0","0","0","1822","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("655","10","1301","","","","1","1","1","411","0","0","0","411","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("656","10","1302","","","","2","2","1","7963","0","0","0","15926","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("657","10","1303","","","","1","1","1","4442","0","0","0","4442","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("658","10","1304","","","","2","2","1","560","0","0","0","1120","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("659","10","1305","","","","2","2","1","137","0","0","0","274","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("660","10","1306","","","","3","3","1","451","0","0","0","1353","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("661","10","1307","","","","4","4","1","6994","0","0","0","27976","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("662","10","1308","","","","2","2","1","3005","0","0","0","6010","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("663","10","1309","","","","5","5","1","251","0","0","0","1255","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("664","10","1310","","","","2","2","1","1873","0","0","0","3746","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("665","10","1311","","","","4","4","1","18","0","0","0","72","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("666","10","1312","","","","0","0","1","252","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("667","10","1313","","","","2","2","1","166","0","0","0","332","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("668","10","1314","","","","4","4","1","500","0","0","0","2000","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("669","10","1315","","","","0","0","1","638","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("670","10","1316","","","","-1","-1","1","186","0","0","0","-186","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("671","10","1317","","","","10","10","1","190","0","0","0","1900","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("672","10","1318","","","","3","3","1","181","0","0","0","543","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("673","10","1319","","","","2","2","1","1457","0","0","0","2914","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("674","10","1320","","","","0","0","1","209","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("675","10","1321","","","","10","10","1","210","0","0","0","2100","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("676","10","1322","","","","0","0","1","2136","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("677","10","1323","","","","2","2","1","2592","0","0","0","5184","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("678","10","1324","","","","9","9","1","500","0","0","0","4500","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("679","10","1325","","","","2","2","1","1755","0","0","0","3510","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("680","10","1326","","","","3","3","1","227","0","0","0","681","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("681","10","1327","","","","1","1","1","307","0","0","0","307","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("682","10","1328","","","","0","0","1","1240","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("683","10","1329","","","","6","6","1","21","0","0","0","126","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("684","10","1330","","","","4","4","1","37","0","0","0","148","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("685","10","1331","","","","8","8","1","46","0","0","0","368","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("686","10","1332","","","","2","2","1","963","0","0","0","1926","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("687","10","1333","","","","1","1","1","1456","0","0","0","1456","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("688","10","1334","","","","1","1","1","1784","0","0","0","1784","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("689","10","1335","","","","1","1","1","0","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("690","10","1336","","","","0","0","1","21","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("691","10","1337","","","","0","0","1","1750","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("692","10","1338","","","","1","1","1","1750","0","0","0","1750","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("693","10","1339","","","","1","1","1","541","0","0","0","541","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("694","10","1340","","","","4","4","1","53","0","0","0","212","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("695","10","1341","","","","1","1","1","395","0","0","0","395","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("696","10","1342","","","","1","1","1","395","0","0","0","395","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("697","10","1343","","","","2","2","1","168","0","0","0","336","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("698","10","1344","","","","10","10","1","29","0","0","0","290","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("699","10","1345","","","","0","0","1","90","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("700","10","1346","","","","2","2","1","42","0","0","0","84","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("701","10","1347","","","","1","1","1","199","0","0","0","199","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("702","10","1348","","","","4","4","1","36","0","0","0","144","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("703","10","1349","","","","7","7","1","25","0","0","0","175","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("704","10","1350","","","","2","2","1","247","0","0","0","494","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("705","10","1351","","","","9","9","1","39","0","0","0","351","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("706","10","1352","","","","4","4","1","112","0","0","0","448","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("707","10","1353","","","","2","2","1","94","0","0","0","188","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("708","10","1354","","","","3","3","1","833","0","0","0","2499","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("709","10","1355","","","","16","16","1","293","0","0","0","4688","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("710","10","1356","","","","5","5","1","263","0","0","0","1315","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("711","10","1357","","","","0","0","1","336","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("712","10","1358","","","","0","0","1","507","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("713","10","1359","","","","1","1","1","575","0","0","0","575","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("714","10","1360","","","","1","1","1","549","0","0","0","549","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("715","10","1361","","","","8","8","1","89","0","0","0","712","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("716","10","1362","","","","3","3","1","271","0","0","0","813","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("717","10","1363","","","","1","1","1","39","0","0","0","39","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("718","10","1364","","","","49","49","1","11","0","0","0","539","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("719","10","1365","","","","2","2","1","32","0","0","0","64","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("720","10","1366","","","","5","5","1","73","0","0","0","365","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("721","10","1367","","","","2","2","1","31","0","0","0","62","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("722","10","1368","","","","2","2","1","22","0","0","0","44","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("723","10","1369","","","","3","3","1","4","0","0","0","12","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("724","10","1370","","","","7","7","1","11","0","0","0","77","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("725","10","1371","","","","8","8","1","26","0","0","0","208","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("726","10","1372","","","","0","0","1","12","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("727","10","1373","","","","8","8","1","75","0","0","0","600","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("728","10","1374","","","","2","2","1","10","0","0","0","20","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("729","10","1375","","","","1","1","1","389","0","0","0","389","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("730","10","1376","","","","0","0","1","36","0","0","0","0","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("731","10","1377","","","","4","4","1","90","0","0","0","360","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_purchases VALUES("732","11","1378","","","","5","5","1","70","0","0","0","350","2023-09-19 16:39:37","2023-09-19 16:39:37");
INSERT INTO product_purchases VALUES("733","12","1379","","","","100","100","1","10","0","0","0","1000","2023-09-19 23:46:07","2023-09-19 23:46:07");
INSERT INTO product_purchases VALUES("734","13","1135","","","","48","48","1","518","0","0","0","24864","2023-09-23 15:03:41","2023-09-23 15:03:41");
INSERT INTO product_purchases VALUES("735","14","1342","","","","5","5","1","395","0","0","0","1975","2023-09-23 15:19:06","2023-09-23 15:19:06");
INSERT INTO product_purchases VALUES("736","15","1341","","","","5","5","1","395","0","0","0","1975","2023-09-23 15:21:33","2023-09-23 15:21:33");
INSERT INTO product_purchases VALUES("737","16","1216","","","","20","20","1","265","0","0","0","5300","2023-09-23 15:22:26","2023-09-23 15:22:26");
INSERT INTO product_purchases VALUES("738","17","1316","","","","10","10","1","186","0","0","0","1860","2023-09-23 15:24:01","2023-09-23 15:24:01");
INSERT INTO product_purchases VALUES("739","18","1140","","","","5","5","1","341","0","0","0","1705","2023-09-23 15:25:39","2023-09-23 15:25:39");
INSERT INTO product_purchases VALUES("740","19","1140","","","","5","5","1","341","0","0","0","1705","2023-09-23 15:25:39","2023-09-23 15:25:39");
INSERT INTO product_purchases VALUES("741","20","1174","","","","2","2","1","593","0","0","0","1186","2023-09-23 15:26:16","2023-09-23 15:26:16");
INSERT INTO product_purchases VALUES("742","21","1260","","","","1","1","1","2017","0","0","0","2017","2023-09-23 15:27:04","2023-09-23 15:27:04");
INSERT INTO product_purchases VALUES("743","22","1261","","","","1","1","1","2738","0","0","0","2738","2023-09-23 15:28:36","2023-09-23 15:28:36");
INSERT INTO product_purchases VALUES("744","22","1260","","","","2","2","1","2017","0","0","0","4034","2023-09-23 15:28:36","2023-09-23 15:28:36");
INSERT INTO product_purchases VALUES("745","23","1292","","","","5","5","1","189","0","0","0","945","2023-09-23 15:29:21","2023-09-23 15:29:21");
INSERT INTO product_purchases VALUES("746","24","1197","","","","10","10","1","377","0","0","0","3770","2023-09-23 15:30:16","2023-09-23 15:30:16");
INSERT INTO product_purchases VALUES("747","25","1218","","","","2","2","1","2050","0","0","0","4100","2023-09-23 15:31:41","2023-09-23 15:31:41");
INSERT INTO product_purchases VALUES("748","26","1255","","","","2","2","1","3806","0","0","0","7612","2023-09-23 15:32:22","2023-09-23 15:32:22");
INSERT INTO product_purchases VALUES("749","27","1246","","","","2","2","1","1198","0","0","0","2396","2023-09-23 15:33:34","2023-09-23 15:33:34");
INSERT INTO product_purchases VALUES("750","28","1155","","","","10","10","1","211","0","0","0","2110","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("751","28","1162","","","","10","10","1","435","0","0","0","4350","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("752","28","1160","","","","10","10","1","315","0","0","0","3150","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("753","28","1152","","","","10","10","1","566","0","0","0","5660","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("754","28","1301","","","","110","110","1","411","0","0","0","45210","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("755","28","1358","","","","10","10","1","507","0","0","0","5070","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO product_purchases VALUES("756","29","1381","","","","79","79","1","5","0","0","0","395","2023-10-03 17:03:03","2023-10-03 17:03:03");
INSERT INTO product_purchases VALUES("757","29","1382","","","","50","50","1","5","0","0","0","250","2023-10-03 17:03:03","2023-10-03 17:03:03");
INSERT INTO product_purchases VALUES("758","29","1380","","","","100","100","1","5","0","0","0","500","2023-10-03 17:03:03","2023-10-03 17:03:03");
INSERT INTO product_purchases VALUES("759","30","1383","","","","5","5","1","40","0","0","0","200","2023-10-03 17:04:28","2023-10-03 17:04:28");
INSERT INTO product_purchases VALUES("760","31","1384","","","","1","1","1","4685","0","0","0","4685","2023-10-09 20:38:39","2023-10-09 20:38:39");
INSERT INTO product_purchases VALUES("779","39","1398","","","","50","50","2","101","0","0","0","5050","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("780","39","1397","","","","50","50","2","76","0","0","0","3800","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("781","39","1395","","","","10","10","21","80","0","0","0","800","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("782","39","1401","","","","10","10","21","96","0","0","0","960","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("783","39","1396","","","","10","10","3","73","0","0","0","730","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("784","39","1393","","","","10","10","3","39","0","0","0","390","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("785","39","1392","","","","10","10","3","47","0","0","0","470","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("786","39","1389","","","","6","6","2","100","0","0","0","600","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("787","39","1390","","","","6","6","2","180","0","0","0","1080","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("788","39","1388","","2","","6","6","2","100","0","0","0","600","2025-02-25 14:33:31","2025-02-25 14:33:31");
INSERT INTO product_purchases VALUES("789","40","1405","","","","5","5","1","176","0","0","0","880","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("790","40","1404","","","","6","6","10","153","0","0","0","918","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("791","40","1403","","","","10","10","10","104","0","0","0","1040","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("792","40","1408","","","","1","1","2","104","0","0","0","104","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("793","40","1402","","","","10","10","5","80","0","0","0","800","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("794","40","1409","","","","50","50","2","84","0","0","0","4200","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("795","40","1411","","","","50","50","2","86","0","0","0","4300","2025-02-28 13:59:48","2025-02-28 13:59:48");
INSERT INTO product_purchases VALUES("796","41","1403","","","","6","6","10","104","0","0","0","624","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("797","41","1410","","","","50","50","2","56","0","0","0","2800","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("798","41","1408","","","","50","50","2","106","0","0","0","5300","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("799","41","1418","","","","10","10","5","157","0","0","0","1570","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("800","41","1402","","","","4","4","5","80","0","0","0","320","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("801","41","1424","","","","5","5","6","115","0","0","0","575","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("802","41","1416","","","","40","40","1","15","0","0","0","600","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("803","41","1417","","","","72","72","1","12","0","0","0","864","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("804","41","1406","","","","10","10","4","125","0","0","0","1250","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("805","41","1391","","","","10","10","2","170","0","0","0","1700","2025-02-28 14:15:36","2025-02-28 14:15:36");
INSERT INTO product_purchases VALUES("806","42","1389","","","","2","2","2","100","0","0","0","200","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("807","42","1404","","","","5","5","10","153","0","0","0","765","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("808","42","1426","","","","5","5","10","361","0","0","0","1805","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("809","42","1431","","","","5","5","5","114","0","0","0","570","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("810","42","1430","","","","18","18","9","61","0","0","0","1098","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("811","42","1429","","","","6","6","22","247","0","0","0","1482","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("812","42","1428","","","","10","10","9","90","0","0","0","900","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("813","42","1425","","","","10","10","17","70","0","0","0","700","2025-02-28 14:54:11","2025-02-28 14:54:11");
INSERT INTO product_purchases VALUES("814","43","1414","","","","12","12","1","850","0","0","0","10200","2025-03-13 18:10:35","2025-03-13 18:10:35");
INSERT INTO product_purchases VALUES("828","45","1455","","","","6","6","1","77","0","0","0","462","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("829","45","1410","","","","50","50","2","60","0","0","0","3000","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("830","45","1458","","","","5","5","1","129","0","0","0","645","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("831","45","1459","","","","4","4","1","171","0","0","0","684","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("832","45","1415","","","","10","10","4","45","0","0","0","450","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("833","45","1457","","","","6","6","1","209","0","0","0","1254","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("834","45","1456","","","","6","6","1","214","0","0","0","1284","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("835","45","1402","","","","10","10","5","80","0","0","0","800","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("836","45","1422","","","","10","10","1","70","0","0","0","700","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("837","45","1432","","","","12","12","23","83","0","0","0","996","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("838","45","1428","","","","10","10","9","90","0","0","0","900","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("839","45","1430","","","","10","10","9","50","0","0","0","500","2025-03-13 19:07:56","2025-03-13 19:07:56");
INSERT INTO product_purchases VALUES("840","46","1402","","","","10","10","5","80","0","0","0","800","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("841","46","1393","","","","6","6","3","39","0","0","0","234","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("842","46","1454","","","","10","10","7","65","0","0","0","650","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("843","46","1410","","","","50","50","2","61","0","0","0","3050","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("844","46","1395","","","","10","10","21","80","0","0","0","800","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("845","46","1390","","","","5","5","2","180","0","0","0","900","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("846","46","1441","","","","10","10","4","115","0","0","0","1150","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("847","46","1436","","","","12","12","23","116","0","0","0","1392","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("848","46","1443","","","","1","1","2","4200","0","0","0","4200","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("849","46","1442","","","","2","2","2","3150","0","0","0","6300","2025-03-14 13:01:13","2025-03-14 13:01:13");
INSERT INTO product_purchases VALUES("852","49","1446","","","","3","3","2","1200","0","0","0","3600","2025-03-18 16:57:44","2025-03-18 16:57:44");
INSERT INTO product_purchases VALUES("853","49","1440","","","","5","5","3","185","0","0","0","925","2025-03-18 16:57:44","2025-03-18 16:57:44");
INSERT INTO product_purchases VALUES("854","49","1444","","","","10","10","2","86","0","0","0","860","2025-03-18 16:57:44","2025-03-18 16:57:44");
INSERT INTO product_purchases VALUES("855","49","1421","","","","5","5","4","45","0","0","0","225","2025-03-18 16:57:44","2025-03-18 16:57:44");
INSERT INTO product_purchases VALUES("859","52","1464","","","","20","20","1","15","0","0","0","300","2025-03-19 20:21:58","2025-03-19 20:21:58");
INSERT INTO product_purchases VALUES("860","51","1463","","","","10","10","1","80","0","0","0","800","2025-03-19 20:22:33","2025-03-19 20:22:33");
INSERT INTO product_purchases VALUES("861","47","1460","","","","1","1","1","150","0","0","0","150","2025-03-19 20:23:19","2025-03-19 20:23:19");
INSERT INTO product_purchases VALUES("862","48","1461","","","","1","1","1","100","0","0","0","100","2025-03-19 20:24:28","2025-03-19 20:24:28");
INSERT INTO product_purchases VALUES("863","50","1462","","","","50","50","2","50","0","0","0","2500","2025-03-19 20:24:59","2025-03-19 20:24:59");
INSERT INTO product_purchases VALUES("868","53","1465","","","","50","50","2","94","0","0","0","4700","2025-03-21 12:12:22","2025-03-21 12:12:22");
INSERT INTO product_purchases VALUES("869","54","1466","","","","10","10","1","80","0","0","0","800","2025-03-21 12:12:58","2025-03-21 12:12:58");
INSERT INTO product_purchases VALUES("870","55","1467","","","","10","10","1","80","0","0","0","800","2025-03-21 12:13:34","2025-03-21 12:13:34");
INSERT INTO product_purchases VALUES("871","56","1468","","","","5","5","2","100","0","0","0","500","2025-03-21 12:14:12","2025-03-21 12:14:12");
INSERT INTO product_purchases VALUES("876","60","1472","","","","10","10","1","200","0","0","0","2000","2025-03-21 12:56:33","2025-03-21 12:56:33");
INSERT INTO product_purchases VALUES("877","57","1469","","","","20","20","1","18","0","0","0","360","2025-03-21 12:57:07","2025-03-21 12:57:07");
INSERT INTO product_purchases VALUES("878","58","1470","","","","10","10","1","85","0","0","0","850","2025-03-21 12:57:31","2025-03-21 12:57:31");
INSERT INTO product_purchases VALUES("879","59","1471","","","","20","20","1","20","0","0","0","400","2025-03-21 12:57:55","2025-03-21 12:57:55");
INSERT INTO product_purchases VALUES("880","61","1451","","","","3","3","2","368","0","0","0","1104","2025-03-21 19:22:19","2025-03-21 19:22:19");
INSERT INTO product_purchases VALUES("881","61","1450","","","","3","3","2","196","0","0","0","588","2025-03-21 19:22:19","2025-03-21 19:22:19");
INSERT INTO product_purchases VALUES("884","64","1453","","","","3","3","1","205","0","0","0","615","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("885","64","1447","","","","20","20","2","16","0","0","0","320","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("886","64","1439","","","","5","5","4","75","0","0","0","375","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("887","64","1434","","","","10","10","1","200","0","0","0","2000","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("888","64","1438","","","","5","5","5","140","0","0","0","700","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("889","64","1412","","","","3","3","1","750","0","0","0","2250","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("890","64","1413","","","","3","3","1","750","0","0","0","2250","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("891","64","1407","","","","50","50","2","46","0","0","0","2300","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("892","64","1435","","","","20","20","1","15","0","0","0","300","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("893","64","1423","","","","2","2","1","210","0","0","0","420","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("894","64","1400","","","","10","10","5","115","0","0","0","1150","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("895","64","1399","","","","10","10","4","85","0","0","0","850","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("896","64","1392","","","","10","10","3","47","0","0","0","470","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("897","64","1427","","","","2","2","10","266","0","0","0","532","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_purchases VALUES("898","62","1473","","","","20","20","1","20","0","0","0","400","2025-03-21 20:01:14","2025-03-21 20:01:14");
INSERT INTO product_purchases VALUES("899","63","1474","","","","3","3","1","200","0","0","0","600","2025-03-21 20:02:07","2025-03-21 20:02:07");
INSERT INTO product_purchases VALUES("900","65","1423","","","","5","5","1","210","0","0","0","1050","2025-03-22 12:22:23","2025-03-22 12:22:23");
INSERT INTO product_purchases VALUES("901","65","1385","","","","50","50","1","50","0","0","0","2500","2025-03-22 12:22:23","2025-03-22 12:22:23");
INSERT INTO product_purchases VALUES("907","70","1479","","","","10","10","1","200","0","0","0","2000","2025-03-22 14:39:13","2025-03-22 14:39:13");
INSERT INTO product_purchases VALUES("908","69","1478","","","","10","10","1","100","0","0","0","1000","2025-03-22 14:39:31","2025-03-22 14:39:31");
INSERT INTO product_purchases VALUES("909","68","1477","","","","5","5","1","180","0","0","0","900","2025-03-22 14:40:07","2025-03-22 14:40:07");
INSERT INTO product_purchases VALUES("910","67","1476","","","","30","30","1","0","0","0","0","0","2025-03-22 14:40:22","2025-03-22 14:40:22");
INSERT INTO product_purchases VALUES("911","66","1475","","","","5","5","1","80","0","0","0","400","2025-03-22 14:40:37","2025-03-22 14:40:37");
INSERT INTO product_purchases VALUES("916","74","1483","","","","5","5","1","180","0","0","0","900","2025-03-22 18:06:12","2025-03-22 18:06:12");
INSERT INTO product_purchases VALUES("917","73","1482","","","","10","10","1","100","0","0","0","1000","2025-03-22 18:06:33","2025-03-22 18:06:33");
INSERT INTO product_purchases VALUES("918","72","1481","","","","10","10","1","100","0","0","0","1000","2025-03-22 18:06:46","2025-03-22 18:06:46");
INSERT INTO product_purchases VALUES("919","71","1480","","","","10","10","1","120","0","0","0","1200","2025-03-22 18:07:03","2025-03-22 18:07:03");
INSERT INTO product_purchases VALUES("924","76","1485","","","","10","10","1","280","0","0","0","2800","2025-03-22 20:10:40","2025-03-22 20:10:40");
INSERT INTO product_purchases VALUES("925","77","1486","","","","10","10","1","100","0","0","0","1000","2025-03-22 20:11:03","2025-03-22 20:11:03");
INSERT INTO product_purchases VALUES("926","78","1487","","","","10","10","1","350","0","0","0","3500","2025-03-22 20:11:38","2025-03-22 20:11:38");
INSERT INTO product_purchases VALUES("927","79","1413","","","","10","10","1","780","0","0","0","7800","2025-03-22 20:33:37","2025-03-22 20:33:37");
INSERT INTO product_purchases VALUES("928","79","1410","","","","50","50","2","60","0","0","0","3000","2025-03-22 20:33:37","2025-03-22 20:33:37");
INSERT INTO product_purchases VALUES("929","79","1408","","","","50","50","2","104","0","0","0","5200","2025-03-22 20:33:37","2025-03-22 20:33:37");
INSERT INTO product_purchases VALUES("930","79","1411","","","","50","50","2","92","0","0","0","4600","2025-03-22 20:33:37","2025-03-22 20:33:37");
INSERT INTO product_purchases VALUES("931","79","1409","","","","50","50","2","84","0","0","0","4200","2025-03-22 20:33:37","2025-03-22 20:33:37");
INSERT INTO product_purchases VALUES("934","80","1488","","","","10","10","1","150","0","0","0","1500","2025-03-24 19:05:43","2025-03-24 19:05:43");
INSERT INTO product_purchases VALUES("935","81","1489","","","","10","10","1","100","0","0","0","1000","2025-03-24 19:06:02","2025-03-24 19:06:02");
INSERT INTO product_purchases VALUES("939","82","1490","","","","10","10","1","100","0","0","0","1000","2025-03-24 20:31:02","2025-03-24 20:31:02");
INSERT INTO product_purchases VALUES("940","83","1491","","","","10","10","1","80","0","0","0","800","2025-03-24 20:31:19","2025-03-24 20:31:19");
INSERT INTO product_purchases VALUES("942","85","1493","","","","10","10","1","250","0","0","0","2500","2025-03-25 18:57:10","2025-03-25 18:57:10");
INSERT INTO product_purchases VALUES("944","86","1494","","","","5","5","1","100","0","0","0","500","2025-03-26 20:25:12","2025-03-26 20:25:12");
INSERT INTO product_purchases VALUES("945","87","1391","","","","6","6","2","176","0","0","0","1056","2025-03-27 18:55:44","2025-03-27 18:55:44");
INSERT INTO product_purchases VALUES("946","87","1495","","","","6","6","1","126","0","0","0","756","2025-03-27 18:55:44","2025-03-27 18:55:44");
INSERT INTO product_purchases VALUES("947","87","1425","","","","6","6","17","70","0","0","0","420","2025-03-27 18:55:44","2025-03-27 18:55:44");
INSERT INTO product_purchases VALUES("948","87","1406","","","","10","10","4","125","0","0","0","1250","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("949","87","1424","","","","10","10","6","115","0","0","0","1150","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("950","87","1427","","","","6","6","10","266","0","0","0","1596","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("951","87","1426","","","","6","6","10","361","0","0","0","2166","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("952","87","1410","","","","100","100","2","56","0","0","0","5600","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("953","87","1411","","","","100","100","2","92","0","0","0","9200","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("954","87","1409","","","","50","50","2","84","0","0","0","4200","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("955","87","1408","","","","100","100","2","104","0","0","0","10400","2025-03-27 18:55:45","2025-03-27 18:55:45");
INSERT INTO product_purchases VALUES("957","88","1405","","","","10","10","1","181","0","0","0","1810","2025-03-27 19:08:29","2025-03-27 19:08:29");
INSERT INTO product_purchases VALUES("958","89","1497","","","","6","6","1","650","0","0","0","3900","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_purchases VALUES("959","89","1496","","","","6","6","1","650","0","0","0","3900","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_purchases VALUES("960","89","1412","","","","10","10","1","800","0","0","0","8000","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_purchases VALUES("961","89","1413","","","","10","10","1","800","0","0","0","8000","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_purchases VALUES("962","89","1414","","","","12","12","1","850","0","0","0","10200","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_purchases VALUES("965","90","1498","","","","6","6","1","400","0","0","0","2400","2025-03-31 16:28:09","2025-03-31 16:28:09");
INSERT INTO product_purchases VALUES("966","91","1499","","","","6","6","1","60","0","0","0","360","2025-03-31 16:28:38","2025-03-31 16:28:38");
INSERT INTO product_purchases VALUES("968","92","1500","","","","5","5","1","200","0","0","0","1000","2025-04-01 09:15:34","2025-04-01 09:15:34");
INSERT INTO product_purchases VALUES("975","44","1443","","","","100","100","2","60","0","0","0","6000","2025-04-01 13:00:46","2025-04-01 13:00:46");
INSERT INTO product_purchases VALUES("976","44","1444","","","","50","50","2","83","0","0","0","4150","2025-04-01 13:00:46","2025-04-01 13:00:46");
INSERT INTO product_purchases VALUES("977","44","1414","","","","12","12","1","850","0","0","0","10200","2025-04-01 13:00:46","2025-04-01 13:00:46");
INSERT INTO product_purchases VALUES("978","44","1413","","","","10","10","1","780","0","0","0","7800","2025-04-01 13:00:46","2025-04-01 13:00:46");



CREATE TABLE `product_quotation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_quotation VALUES("2","2","1408","","","1","2","120","0","0","0","120","2025-03-13 20:46:49","2025-03-13 21:05:28");
INSERT INTO product_quotation VALUES("3","2","1385","","","1","1","55","0","0","0","55","2025-03-13 20:46:49","2025-03-13 21:05:28");
INSERT INTO product_quotation VALUES("4","2","1424","","","1","6","150","0","0","0","150","2025-03-13 21:04:06","2025-03-13 21:05:28");



CREATE TABLE `product_returns` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_sales` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `sale_unit_id` int NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2325 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_sales VALUES("18","23","952","","","","1","1","1970","0","0","0","1970","2023-09-14 12:23:02","2023-09-14 12:23:02");
INSERT INTO product_sales VALUES("19","24","992","","","","1","1","680","0","0","0","680","2023-09-15 13:15:45","2023-09-15 13:15:45");
INSERT INTO product_sales VALUES("20","25","936","","","","1","1","500","0","0","0","500","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO product_sales VALUES("21","25","1025","","","","1","1","340","0","0","0","340","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO product_sales VALUES("22","25","1026","","","","1","1","230","0","0","0","230","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO product_sales VALUES("23","25","1024","","","","1","1","430","0","0","0","430","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO product_sales VALUES("24","25","992","","","","1","1","680","0","0","0","680","2023-09-15 15:22:59","2023-09-15 15:22:59");
INSERT INTO product_sales VALUES("25","26","992","","","","1","1","680","0","0","0","680","2023-09-15 16:25:27","2023-09-15 16:25:27");
INSERT INTO product_sales VALUES("26","27","992","","","","1","1","680","0","0","0","680","2023-09-15 16:35:32","2023-09-15 16:35:32");
INSERT INTO product_sales VALUES("27","28","983","","","","1","1","380","0","0","0","380","2023-09-15 16:41:13","2023-09-15 16:41:13");
INSERT INTO product_sales VALUES("28","28","1007","","","","1","1","1620","0","0","0","1620","2023-09-15 16:41:13","2023-09-15 16:41:13");
INSERT INTO product_sales VALUES("29","29","992","","","","1","1","680","0","0","0","680","2023-09-15 16:43:31","2023-09-15 16:43:31");
INSERT INTO product_sales VALUES("30","30","973","","","","1","1","68","0","0","0","68","2023-09-15 16:44:40","2023-09-15 16:44:40");
INSERT INTO product_sales VALUES("31","31","891","","","","1","1","375","0","0","0","375","2023-09-15 16:52:01","2023-09-15 16:52:01");
INSERT INTO product_sales VALUES("32","32","901","","","","7","1","30","0","0","0","210","2023-09-15 17:07:47","2023-09-15 17:07:47");
INSERT INTO product_sales VALUES("33","33","992","","","","1","1","680","0","0","0","680","2023-09-15 18:12:05","2023-09-15 18:12:05");
INSERT INTO product_sales VALUES("34","33","1068","","","","1","1","2035","0","0","0","2035","2023-09-15 18:12:05","2023-09-15 18:12:05");
INSERT INTO product_sales VALUES("35","34","992","","","","1","1","680","0","0","0","680","2023-09-15 18:36:55","2023-09-15 18:36:55");
INSERT INTO product_sales VALUES("36","35","992","","","","1","1","680","0","0","0","680","2023-09-15 19:16:51","2023-09-15 19:16:51");
INSERT INTO product_sales VALUES("37","36","1046","","","","1","1","400","0","0","0","400","2023-09-15 19:35:00","2023-09-15 19:35:00");
INSERT INTO product_sales VALUES("38","37","1095","","","","1","1","32","0","0","0","32","2023-09-15 20:09:28","2023-09-15 20:09:28");
INSERT INTO product_sales VALUES("39","38","1108","","","","1","1","587","0","0","0","587","2023-09-15 20:28:21","2023-09-15 20:28:21");
INSERT INTO product_sales VALUES("40","39","936","","","","1","1","500","0","0","0","500","2023-09-15 20:48:38","2023-09-15 20:48:38");
INSERT INTO product_sales VALUES("41","40","1089","","","","1","1","385","0","0","0","385","2023-09-15 21:10:54","2023-09-15 21:10:54");
INSERT INTO product_sales VALUES("42","40","992","","","","1","1","680","0","0","0","680","2023-09-15 21:10:54","2023-09-15 21:10:54");
INSERT INTO product_sales VALUES("43","41","992","","","","1","1","680","0","0","0","680","2023-09-15 21:11:55","2023-09-15 21:11:55");
INSERT INTO product_sales VALUES("44","42","992","","","","1","1","680","0","0","0","680","2023-09-15 21:26:07","2023-09-15 21:26:07");
INSERT INTO product_sales VALUES("45","43","952","","","","1","1","1970","0","0","0","1970","2023-09-16 12:56:36","2023-09-16 12:56:36");
INSERT INTO product_sales VALUES("46","44","1025","","","","1","1","340","0","0","0","340","2023-09-16 13:17:32","2023-09-16 13:17:32");
INSERT INTO product_sales VALUES("47","44","1026","","","","1","1","230","0","0","0","230","2023-09-16 13:17:32","2023-09-16 13:17:32");
INSERT INTO product_sales VALUES("48","44","1024","","","","1","1","430","0","0","0","430","2023-09-16 13:17:32","2023-09-16 13:17:32");
INSERT INTO product_sales VALUES("49","45","992","","","","1","1","680","0","0","0","680","2023-09-16 13:37:57","2023-09-16 13:37:57");
INSERT INTO product_sales VALUES("50","46","920","","","","1","1","395","0","0","0","395","2023-09-16 14:22:02","2023-09-16 14:22:02");
INSERT INTO product_sales VALUES("51","46","1071","","","","1","1","900","0","0","0","900","2023-09-16 14:22:02","2023-09-16 14:22:02");
INSERT INTO product_sales VALUES("52","47","992","","","","1","1","680","0","0","0","680","2023-09-16 14:25:15","2023-09-16 14:25:15");
INSERT INTO product_sales VALUES("53","48","992","","","","1","1","680","0","0","0","680","2023-09-16 15:35:04","2023-09-16 15:35:04");
INSERT INTO product_sales VALUES("54","49","1046","","","","1","1","400","0","0","0","400","2023-09-16 16:31:51","2023-09-16 16:31:51");
INSERT INTO product_sales VALUES("55","50","992","","","","1","1","680","0","0","0","680","2023-09-16 16:46:30","2023-09-16 16:46:30");
INSERT INTO product_sales VALUES("58","53","930","","","","1","1","295","0","0","0","295","2023-09-16 17:29:23","2023-09-16 17:29:23");
INSERT INTO product_sales VALUES("59","53","1034","","","","1","1","400","0","0","0","400","2023-09-16 17:29:23","2023-09-16 17:29:23");
INSERT INTO product_sales VALUES("60","53","1019","","","","1","1","90","0","0","0","90","2023-09-16 17:29:23","2023-09-16 17:29:23");
INSERT INTO product_sales VALUES("61","54","918","","","","1","1","360","0","0","0","360","2023-09-16 17:59:42","2023-09-16 17:59:42");
INSERT INTO product_sales VALUES("62","55","992","","","","1","1","680","0","0","0","680","2023-09-16 18:03:25","2023-09-16 18:03:25");
INSERT INTO product_sales VALUES("63","56","936","","","","1","1","500","0","0","0","500","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO product_sales VALUES("64","56","1025","","","","1","1","340","0","0","0","340","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO product_sales VALUES("65","56","1026","","","","1","1","230","0","0","0","230","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO product_sales VALUES("66","56","1024","","","","1","1","430","0","0","0","430","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO product_sales VALUES("67","56","992","","","","1","1","680","0","0","0","680","2023-09-16 19:56:00","2023-09-16 19:56:00");
INSERT INTO product_sales VALUES("68","57","912","","","","1","1","235","0","0","0","235","2023-09-16 21:25:14","2023-09-16 21:25:14");
INSERT INTO product_sales VALUES("69","58","992","","","","1","1","680","0","0","0","680","2023-09-16 21:40:17","2023-09-16 21:40:17");
INSERT INTO product_sales VALUES("70","59","1092","","","","1","1","35","0","0","0","35","2023-09-17 14:34:24","2023-09-17 14:34:24");
INSERT INTO product_sales VALUES("71","60","1011","","","","1","1","250","0","0","0","250","2023-09-17 14:54:07","2023-09-17 14:54:07");
INSERT INTO product_sales VALUES("72","61","1095","","","","1","1","32","0","0","0","32","2023-09-17 15:19:12","2023-09-17 15:19:12");
INSERT INTO product_sales VALUES("73","61","992","","","","1","1","680","0","0","0","680","2023-09-17 15:19:12","2023-09-17 15:19:12");
INSERT INTO product_sales VALUES("74","62","992","","","","1","1","680","0","0","0","680","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO product_sales VALUES("75","62","891","","","","1","1","375","0","0","0","375","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO product_sales VALUES("76","62","1046","","","","1","1","400","0","0","0","400","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO product_sales VALUES("77","62","994","","","","1","1","260","0","0","0","260","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO product_sales VALUES("78","62","993","","","","1","1","85","0","0","0","85","2023-09-17 15:45:23","2023-09-17 15:45:23");
INSERT INTO product_sales VALUES("79","63","992","","","","1","1","680","0","0","0","680","2023-09-17 15:57:58","2023-09-17 15:57:58");
INSERT INTO product_sales VALUES("80","64","992","","","","1","1","680","0","0","0","680","2023-09-17 15:59:18","2023-09-17 15:59:18");
INSERT INTO product_sales VALUES("81","65","925","","","","1","1","135","0","0","0","135","2023-09-17 16:21:01","2023-09-17 16:21:01");
INSERT INTO product_sales VALUES("82","66","992","","","","1","1","680","0","0","0","680","2023-09-17 16:21:51","2023-09-17 16:21:51");
INSERT INTO product_sales VALUES("83","67","992","","","","1","1","680","0","0","0","680","2023-09-17 17:32:53","2023-09-17 17:32:53");
INSERT INTO product_sales VALUES("84","68","992","","","","1","1","680","0","0","0","680","2023-09-17 17:49:39","2023-09-17 17:49:39");
INSERT INTO product_sales VALUES("85","69","1020","","","","1","1","105","0","0","0","105","2023-09-17 18:47:50","2023-09-17 18:47:50");
INSERT INTO product_sales VALUES("86","69","1034","","","","1","1","400","0","0","0","400","2023-09-17 18:47:50","2023-09-17 18:47:50");
INSERT INTO product_sales VALUES("87","70","992","","","","1","1","680","0","0","0","680","2023-09-17 19:08:09","2023-09-17 19:08:09");
INSERT INTO product_sales VALUES("88","70","951","","","","4","1","450","0","0","0","1800","2023-09-17 19:08:09","2023-09-17 19:08:09");
INSERT INTO product_sales VALUES("89","70","935","","","","1","1","920","0","0","0","920","2023-09-17 19:08:09","2023-09-17 19:08:09");
INSERT INTO product_sales VALUES("90","70","1010","","","","1","1","415","0","0","0","415","2023-09-17 19:08:09","2023-09-17 19:08:09");
INSERT INTO product_sales VALUES("91","71","992","","","","1","1","680","0","0","0","680","2023-09-17 20:15:29","2023-09-17 20:15:29");
INSERT INTO product_sales VALUES("92","72","1083","","","","1","1","520","0","0","0","520","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("93","72","1082","","","","1","1","820","0","0","0","820","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("94","72","1035","","","","2","1","155","0","0","0","310","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("95","72","1024","","","","1","1","430","0","0","0","430","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("96","72","1026","","","","1","1","230","0","0","0","230","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("97","72","1025","","","","1","1","340","0","0","0","340","2023-09-17 21:45:19","2023-09-17 21:45:19");
INSERT INTO product_sales VALUES("98","73","1046","","","","1","1","400","0","0","0","400","2023-09-18 12:47:34","2023-09-18 12:47:34");
INSERT INTO product_sales VALUES("99","74","1014","","","","1","1","200","0","0","0","200","2023-09-18 13:48:15","2023-09-18 13:48:15");
INSERT INTO product_sales VALUES("100","74","1013","","","","2","1","200","0","0","0","400","2023-09-18 13:48:15","2023-09-18 13:48:15");
INSERT INTO product_sales VALUES("101","74","886","","","","2","1","90","0","0","0","180","2023-09-18 13:48:15","2023-09-18 13:48:15");
INSERT INTO product_sales VALUES("102","75","1046","","","","1","1","400","0","0","0","400","2023-09-18 14:00:35","2023-09-18 14:00:35");
INSERT INTO product_sales VALUES("103","76","992","","","","1","1","680","0","0","0","680","2023-09-18 15:26:18","2023-09-18 15:26:18");
INSERT INTO product_sales VALUES("104","77","992","","","","1","1","680","0","0","0","680","2023-09-18 15:28:26","2023-09-18 15:28:26");
INSERT INTO product_sales VALUES("105","78","978","","","","1","1","161","0","0","0","161","2023-09-18 16:06:17","2023-09-18 16:06:17");
INSERT INTO product_sales VALUES("106","78","1045","","","","1","1","435","0","0","0","435","2023-09-18 16:06:17","2023-09-18 16:06:17");
INSERT INTO product_sales VALUES("107","79","978","","","","1","1","161","0","0","0","161","2023-09-18 16:22:12","2023-09-18 16:22:12");
INSERT INTO product_sales VALUES("108","80","978","","","","1","1","161","0","0","0","161","2023-09-18 18:15:48","2023-09-18 18:15:48");
INSERT INTO product_sales VALUES("109","81","1000","","","","1","1","610","0","0","0","610","2023-09-18 19:01:15","2023-09-18 19:01:15");
INSERT INTO product_sales VALUES("110","82","912","","","","1","1","235","0","0","0","235","2023-09-18 19:31:00","2023-09-18 19:31:00");
INSERT INTO product_sales VALUES("111","82","1055","","","","1","1","150","0","0","0","150","2023-09-18 19:31:00","2023-09-18 19:31:00");
INSERT INTO product_sales VALUES("112","82","1046","","","","1","1","400","0","0","0","400","2023-09-18 19:31:00","2023-09-18 19:31:00");
INSERT INTO product_sales VALUES("113","82","992","","","","1","1","680","0","0","0","680","2023-09-18 19:31:00","2023-09-18 19:31:00");
INSERT INTO product_sales VALUES("114","83","981","","","","1","1","380","0","0","0","380","2023-09-18 19:51:47","2023-09-18 19:51:47");
INSERT INTO product_sales VALUES("115","84","987","","","","1","1","25","0","0","0","25","2023-09-18 21:35:32","2023-09-18 21:35:32");
INSERT INTO product_sales VALUES("116","85","992","","","","1","1","680","0","0","0","680","2023-09-19 12:33:00","2023-09-19 12:33:00");
INSERT INTO product_sales VALUES("117","86","1035","","","","2","1","155","0","0","0","310","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("118","86","1024","","","","1","1","430","0","0","0","430","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("119","86","1025","","","","1","1","340","0","0","0","340","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("120","86","1026","","","","1","1","230","0","0","0","230","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("121","86","1083","","","","1","1","520","0","0","0","520","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("122","86","1082","","","","1","1","820","0","0","0","820","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("123","86","961","","","","1","1","325","0","0","0","325","2023-09-19 13:02:53","2023-09-19 13:02:53");
INSERT INTO product_sales VALUES("124","87","992","","","","1","1","680","0","0","0","680","2023-09-19 13:04:35","2023-09-19 13:04:35");
INSERT INTO product_sales VALUES("125","88","1135","","","","1","1","680","0","0","0","680","2023-09-19 17:07:41","2023-09-19 17:07:41");
INSERT INTO product_sales VALUES("126","89","1137","","","","1","1","505","0","0","0","505","2023-09-19 17:13:48","2023-09-19 17:13:48");
INSERT INTO product_sales VALUES("127","89","1211","","","","1","1","480","0","0","0","480","2023-09-19 17:13:48","2023-09-19 17:13:48");
INSERT INTO product_sales VALUES("128","89","1216","","","","1","1","310","0","0","0","310","2023-09-19 17:13:48","2023-09-19 17:13:48");
INSERT INTO product_sales VALUES("129","90","1135","","","","1","1","680","0","0","0","680","2023-09-19 17:28:10","2023-09-19 17:28:10");
INSERT INTO product_sales VALUES("130","90","1143","","","","1","1","1040","0","0","0","1040","2023-09-19 17:28:10","2023-09-19 17:28:10");
INSERT INTO product_sales VALUES("131","91","1135","","","","1","1","680","0","0","0","680","2023-09-19 17:30:44","2023-09-19 17:30:44");
INSERT INTO product_sales VALUES("132","92","1135","","","","1","1","680","0","0","0","680","2023-09-19 17:31:27","2023-09-19 17:31:27");
INSERT INTO product_sales VALUES("133","93","1135","","","","1","1","680","0","0","0","680","2023-09-19 17:49:40","2023-09-19 17:49:40");
INSERT INTO product_sales VALUES("134","93","1139","","","","2","1","190","0","0","0","380","2023-09-19 17:49:40","2023-09-19 17:49:40");
INSERT INTO product_sales VALUES("135","93","1193","","","","3","1","260","0","0","0","780","2023-09-19 17:49:40","2023-09-19 17:49:40");
INSERT INTO product_sales VALUES("136","94","1197","","","","1","1","440","0","0","0","440","2023-09-19 18:45:21","2023-09-19 18:45:21");
INSERT INTO product_sales VALUES("137","94","1246","","","","1","1","1390","0","0","0","1390","2023-09-19 18:45:21","2023-09-19 18:45:21");
INSERT INTO product_sales VALUES("138","95","1259","","","","1","1","490","0","0","0","490","2023-09-19 19:11:18","2023-09-19 19:11:18");
INSERT INTO product_sales VALUES("139","96","1237","","","","1","1","290","0","0","0","290","2023-09-19 19:24:38","2023-09-19 19:24:38");
INSERT INTO product_sales VALUES("140","97","1135","","","","1","1","680","0","0","0","680","2023-09-19 19:34:03","2023-09-19 19:34:03");
INSERT INTO product_sales VALUES("141","98","1135","","","","1","1","680","0","0","0","680","2023-09-19 19:35:04","2023-09-19 19:35:04");
INSERT INTO product_sales VALUES("142","99","1160","","","","1","1","370","0","0","0","370","2023-09-19 19:48:13","2023-09-19 19:48:13");
INSERT INTO product_sales VALUES("143","99","1162","","","","1","1","505","0","0","0","505","2023-09-19 19:48:13","2023-09-19 19:48:13");
INSERT INTO product_sales VALUES("144","99","1155","","","","1","1","245","0","0","0","245","2023-09-19 19:48:13","2023-09-19 19:48:13");
INSERT INTO product_sales VALUES("145","99","1152","","","","1","1","660","0","0","0","660","2023-09-19 19:48:13","2023-09-19 19:48:13");
INSERT INTO product_sales VALUES("146","100","1268","","","","1","1","2400","0","0","0","2400","2023-09-19 20:01:26","2023-09-19 20:01:26");
INSERT INTO product_sales VALUES("147","101","1135","","","","1","1","680","0","0","0","680","2023-09-19 21:10:38","2023-09-19 21:10:38");
INSERT INTO product_sales VALUES("149","103","1135","","","","1","1","680","0","0","0","680","2023-09-20 12:51:41","2023-09-20 12:51:41");
INSERT INTO product_sales VALUES("150","104","1135","","","","1","1","680","0","0","0","680","2023-09-20 12:55:59","2023-09-20 12:55:59");
INSERT INTO product_sales VALUES("151","105","1268","","","","1","1","2400","0","0","0","2400","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO product_sales VALUES("152","105","1162","","","","1","1","505","0","0","0","505","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO product_sales VALUES("153","105","1160","","","","1","1","370","0","0","0","370","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO product_sales VALUES("154","105","1155","","","","1","1","245","0","0","0","245","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO product_sales VALUES("155","105","1152","","","","1","1","660","0","0","0","660","2023-09-20 13:45:40","2023-09-20 13:45:40");
INSERT INTO product_sales VALUES("156","106","1135","","","","1","1","680","0","0","0","680","2023-09-20 13:50:00","2023-09-20 13:50:00");
INSERT INTO product_sales VALUES("157","107","1362","","","","1","1","315","0","0","0","315","2023-09-20 18:00:35","2023-09-20 18:00:35");
INSERT INTO product_sales VALUES("158","108","1149","","","","1","1","3070","0","0","0","3070","2023-09-20 19:51:25","2023-09-20 19:51:25");
INSERT INTO product_sales VALUES("159","109","1135","","","","1","1","680","0","0","0","680","2023-09-20 20:33:13","2023-09-20 20:33:13");
INSERT INTO product_sales VALUES("160","110","1135","","","","1","1","680","0","0","0","680","2023-09-20 20:37:48","2023-09-20 20:37:48");
INSERT INTO product_sales VALUES("161","111","1342","","","","1","1","460","0","0","0","460","2023-09-21 12:15:33","2023-09-21 12:15:33");
INSERT INTO product_sales VALUES("162","112","1135","","","","1","1","680","0","0","0","680","2023-09-21 12:17:06","2023-09-21 12:17:06");
INSERT INTO product_sales VALUES("163","113","1132","","","","1","1","495","0","0","0","495","2023-09-21 12:18:03","2023-09-21 12:18:03");
INSERT INTO product_sales VALUES("164","114","1170","","","","1","1","110","0","0","0","110","2023-09-21 13:47:57","2023-09-21 13:47:57");
INSERT INTO product_sales VALUES("165","115","1135","","","","1","1","680","0","0","0","680","2023-09-21 13:57:46","2023-09-21 13:57:46");
INSERT INTO product_sales VALUES("166","116","1216","","","","1","1","310","0","0","0","310","2023-09-21 14:16:35","2023-09-21 14:16:35");
INSERT INTO product_sales VALUES("167","116","1135","","","","1","1","680","0","0","0","680","2023-09-21 14:16:35","2023-09-21 14:16:35");
INSERT INTO product_sales VALUES("168","117","1135","","","","1","1","680","0","0","0","680","2023-09-21 14:18:36","2023-09-21 14:18:36");
INSERT INTO product_sales VALUES("169","118","1135","","","","1","1","680","0","0","0","680","2023-09-21 17:56:13","2023-09-21 17:56:13");
INSERT INTO product_sales VALUES("170","119","1135","","","","1","1","680","0","0","0","680","2023-09-21 21:14:05","2023-09-21 21:14:05");
INSERT INTO product_sales VALUES("171","120","1135","","","","1","1","680","0","0","0","680","2023-09-22 12:57:21","2023-09-22 12:57:21");
INSERT INTO product_sales VALUES("172","121","1245","","","","1","1","1100","0","0","0","1100","2023-09-22 13:55:15","2023-09-22 13:55:15");
INSERT INTO product_sales VALUES("173","122","1374","","","","2","1","30","0","0","0","60","2023-09-22 14:56:51","2023-09-22 14:56:51");
INSERT INTO product_sales VALUES("174","123","1135","","","","1","1","680","0","0","0","680","2023-09-22 16:56:18","2023-09-22 16:56:18");
INSERT INTO product_sales VALUES("175","123","1290","","","","1","1","145","0","0","0","145","2023-09-22 16:56:18","2023-09-22 16:56:18");
INSERT INTO product_sales VALUES("176","124","1216","","","","1","1","310","0","0","0","310","2023-09-22 17:04:03","2023-09-22 17:04:03");
INSERT INTO product_sales VALUES("177","124","1135","","","","1","1","680","0","0","0","680","2023-09-22 17:04:03","2023-09-22 17:04:03");
INSERT INTO product_sales VALUES("178","125","1135","","","","1","1","680","0","0","0","680","2023-09-22 20:51:54","2023-09-22 20:51:54");
INSERT INTO product_sales VALUES("179","125","1162","","","","1","1","505","0","0","0","505","2023-09-22 20:51:54","2023-09-22 20:51:54");
INSERT INTO product_sales VALUES("180","125","1155","","","","1","1","245","0","0","0","245","2023-09-22 20:51:54","2023-09-22 20:51:54");
INSERT INTO product_sales VALUES("181","125","1160","","","","1","1","370","0","0","0","370","2023-09-22 20:51:54","2023-09-22 20:51:54");
INSERT INTO product_sales VALUES("182","126","1135","","","","1","1","680","0","0","0","680","2023-09-22 20:55:42","2023-09-22 20:55:42");
INSERT INTO product_sales VALUES("183","127","1135","","","","1","1","680","0","0","0","680","2023-09-22 21:22:01","2023-09-22 21:22:01");
INSERT INTO product_sales VALUES("184","127","1132","","","","1","1","495","0","0","0","495","2023-09-22 21:22:01","2023-09-22 21:22:01");
INSERT INTO product_sales VALUES("185","128","1344","","","","1","1","35","0","0","0","35","2023-09-22 21:30:09","2023-09-22 21:30:09");
INSERT INTO product_sales VALUES("186","129","1135","","","","1","1","680","0","0","0","680","2023-09-23 11:52:40","2023-09-23 11:52:40");
INSERT INTO product_sales VALUES("187","130","1135","","","","1","1","680","0","0","0","680","2023-09-23 13:43:32","2023-09-23 13:43:32");
INSERT INTO product_sales VALUES("188","131","1135","","","","1","1","680","0","0","0","680","2023-09-23 14:54:53","2023-09-23 14:54:53");
INSERT INTO product_sales VALUES("189","132","1135","","","","1","1","680","0","0","0","680","2023-09-23 16:15:25","2023-09-23 16:15:25");
INSERT INTO product_sales VALUES("190","133","1237","","","","1","1","290","0","0","0","290","2023-09-23 16:25:37","2023-09-23 16:25:37");
INSERT INTO product_sales VALUES("191","134","1239","","","","1","1","195","0","0","0","195","2023-09-23 16:31:00","2023-09-23 16:31:00");
INSERT INTO product_sales VALUES("192","135","1245","","","","1","1","1100","0","0","0","1100","2023-09-23 16:51:32","2023-09-23 16:51:32");
INSERT INTO product_sales VALUES("193","136","1135","","","","1","1","680","0","0","0","680","2023-09-23 18:54:03","2023-09-23 18:54:03");
INSERT INTO product_sales VALUES("194","137","1135","","","","1","1","680","0","0","0","680","2023-09-23 19:48:13","2023-09-23 19:48:13");
INSERT INTO product_sales VALUES("195","138","1135","","","","1","1","680","0","0","0","680","2023-09-23 19:49:31","2023-09-23 19:49:31");
INSERT INTO product_sales VALUES("196","139","1135","","","","1","1","680","0","0","0","680","2023-09-23 21:42:39","2023-09-23 21:42:39");
INSERT INTO product_sales VALUES("197","140","1135","","","","1","1","680","0","0","0","680","2023-09-24 13:20:07","2023-09-24 13:20:07");
INSERT INTO product_sales VALUES("198","141","1135","","","","1","1","680","0","0","0","680","2023-09-24 14:10:10","2023-09-24 14:10:10");
INSERT INTO product_sales VALUES("199","142","1301","","","","1","1","480","0","0","0","480","2023-09-24 14:21:09","2023-09-24 14:21:09");
INSERT INTO product_sales VALUES("200","142","1358","","","","2","1","590","0","0","0","1180","2023-09-24 14:21:09","2023-09-24 14:21:09");
INSERT INTO product_sales VALUES("201","143","1135","","","","1","1","680","0","0","0","680","2023-09-24 16:14:57","2023-09-24 16:14:57");
INSERT INTO product_sales VALUES("202","144","1135","","","","1","1","680","0","0","0","680","2023-09-24 16:17:53","2023-09-24 16:17:53");
INSERT INTO product_sales VALUES("203","145","1135","","","","1","1","680","0","0","0","680","2023-09-24 16:17:53","2023-09-24 16:17:53");
INSERT INTO product_sales VALUES("204","146","1135","","","","1","1","680","0","0","0","680","2023-09-24 16:58:42","2023-09-24 16:58:42");
INSERT INTO product_sales VALUES("205","147","1377","","","","1","1","105","0","0","0","105","2023-09-24 18:53:06","2023-09-24 18:53:06");
INSERT INTO product_sales VALUES("206","148","1135","","","","1","1","680","0","0","0","680","2023-09-24 19:54:29","2023-09-24 19:54:29");
INSERT INTO product_sales VALUES("207","149","1135","","","","1","1","680","0","0","0","680","2023-09-24 20:21:17","2023-09-24 20:21:17");
INSERT INTO product_sales VALUES("208","150","1132","","","","1","1","495","0","0","0","495","2023-09-24 20:28:53","2023-09-24 20:28:53");
INSERT INTO product_sales VALUES("209","151","1157","","","","1","1","45","0","0","0","45","2023-09-25 11:01:30","2023-09-25 11:01:30");
INSERT INTO product_sales VALUES("210","152","1135","","","","1","1","680","0","0","0","680","2023-09-25 11:52:13","2023-09-25 11:52:13");
INSERT INTO product_sales VALUES("211","153","1132","","","","1","1","495","0","0","0","495","2023-09-25 12:27:42","2023-09-25 12:27:42");
INSERT INTO product_sales VALUES("212","154","1164","","","","1","1","1005","0","0","0","1005","2023-09-25 13:15:28","2023-09-25 13:15:28");
INSERT INTO product_sales VALUES("213","154","1144","","","","1","1","1120","0","0","0","1120","2023-09-25 13:15:28","2023-09-25 13:15:28");
INSERT INTO product_sales VALUES("214","154","1163","","","","1","1","640","0","0","0","640","2023-09-25 13:15:28","2023-09-25 13:15:28");
INSERT INTO product_sales VALUES("215","154","1139","","","","2","1","190","0","0","0","380","2023-09-25 13:15:28","2023-09-25 13:15:28");
INSERT INTO product_sales VALUES("216","155","1237","","","","1","1","290","0","0","0","290","2023-09-25 14:20:59","2023-09-25 14:20:59");
INSERT INTO product_sales VALUES("217","156","1132","","","","1","1","495","0","0","0","495","2023-09-25 14:21:49","2023-09-25 14:21:49");
INSERT INTO product_sales VALUES("218","157","1278","","","","1","1","405","0","0","0","405","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("219","157","1135","","","","1","1","680","0","0","0","680","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("220","157","1146","","","","1","1","1985","0","0","0","1985","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("221","157","1144","","","","1","1","1120","0","0","0","1120","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("222","157","1316","","","","1","1","216","0","0","0","216","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("223","157","1152","","","","1","1","660","0","0","0","660","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("224","157","1163","","","","1","1","640","0","0","0","640","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("225","157","1164","","","","1","1","1005","0","0","0","1005","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("226","157","1162","","","","1","1","505","0","0","0","505","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("227","157","1160","","","","1","1","370","0","0","0","370","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("228","157","1155","","","","1","1","245","0","0","0","245","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("229","157","1301","","","","2","1","480","0","0","0","960","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("230","157","1139","","","","2","1","190","0","0","0","380","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("231","157","1132","","","","2","1","495","0","0","0","990","2023-09-25 15:07:32","2023-09-25 15:07:32");
INSERT INTO product_sales VALUES("232","158","1264","","","","1","1","90","0","0","0","90","2023-09-25 15:25:36","2023-09-25 15:25:36");
INSERT INTO product_sales VALUES("233","159","1135","","","","1","1","680","0","0","0","680","2023-09-25 16:33:38","2023-09-25 16:33:38");
INSERT INTO product_sales VALUES("234","160","1377","","","","1","1","105","0","0","0","105","2023-09-25 17:31:15","2023-09-25 17:31:15");
INSERT INTO product_sales VALUES("235","161","1135","","","","1","1","680","0","0","0","680","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("236","161","1139","","","","2","1","190","0","0","0","380","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("237","161","1144","","","","1","1","1120","0","0","0","1120","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("238","161","1163","","","","1","1","640","0","0","0","640","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("239","161","1164","","","","1","1","1005","0","0","0","1005","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("240","161","1216","","","","1","1","310","0","0","0","310","2023-09-25 18:14:48","2023-09-25 18:14:48");
INSERT INTO product_sales VALUES("241","162","1252","","","","1","1","75","0","0","0","75","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO product_sales VALUES("242","162","1370","","","","1","1","15","0","0","0","15","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO product_sales VALUES("243","162","1239","","","","1","1","195","0","0","0","195","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO product_sales VALUES("244","162","1148","","","","1","1","20","0","0","0","20","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO product_sales VALUES("245","162","1137","","","","1","1","505","0","0","0","505","2023-09-25 18:18:18","2023-09-25 18:18:18");
INSERT INTO product_sales VALUES("246","163","1162","","","","1","1","505","0","0","0","505","2023-09-25 18:21:38","2023-09-25 18:21:38");
INSERT INTO product_sales VALUES("247","163","1160","","","","1","1","370","0","0","0","370","2023-09-25 18:21:38","2023-09-25 18:21:38");
INSERT INTO product_sales VALUES("248","163","1155","","","","1","1","245","0","0","0","245","2023-09-25 18:21:38","2023-09-25 18:21:38");
INSERT INTO product_sales VALUES("249","164","1135","","","","1","1","680","0","0","0","680","2023-09-25 18:28:32","2023-09-25 18:28:32");
INSERT INTO product_sales VALUES("250","165","1135","","","","1","1","680","0","0","0","680","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO product_sales VALUES("251","165","1152","","","","1","1","660","0","0","0","660","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO product_sales VALUES("252","165","1162","","","","1","1","505","0","0","0","505","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO product_sales VALUES("253","165","1160","","","","1","1","370","0","0","0","370","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO product_sales VALUES("254","165","1155","","","","1","1","245","0","0","0","245","2023-09-25 19:20:17","2023-09-25 19:20:17");
INSERT INTO product_sales VALUES("255","166","1135","","","","1","1","680","0","0","0","680","2023-09-25 19:42:42","2023-09-25 19:42:42");
INSERT INTO product_sales VALUES("256","167","1137","","","","1","1","505","0","0","0","505","2023-09-25 19:59:13","2023-09-25 19:59:13");
INSERT INTO product_sales VALUES("257","168","1216","","","","1","1","310","0","0","0","310","2023-09-25 20:06:53","2023-09-25 20:06:53");
INSERT INTO product_sales VALUES("258","169","1132","","","","1","1","495","0","0","0","495","2023-09-25 21:00:27","2023-09-25 21:00:27");
INSERT INTO product_sales VALUES("259","170","1135","","","","1","1","680","0","0","0","680","2023-09-26 11:49:08","2023-09-26 11:49:08");
INSERT INTO product_sales VALUES("260","171","1135","","","","1","1","680","0","0","0","680","2023-09-26 12:23:50","2023-09-26 12:23:50");
INSERT INTO product_sales VALUES("261","172","1316","","","","1","1","216","0","0","0","216","2023-09-26 13:13:26","2023-09-26 13:13:26");
INSERT INTO product_sales VALUES("262","172","1135","","","","1","1","680","0","0","0","680","2023-09-26 13:13:26","2023-09-26 13:13:26");
INSERT INTO product_sales VALUES("263","173","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:41:30","2023-09-26 19:41:30");
INSERT INTO product_sales VALUES("264","173","1193","","","","3","1","260","0","0","0","780","2023-09-26 19:41:30","2023-09-26 19:41:30");
INSERT INTO product_sales VALUES("265","173","1191","","","","4","1","540","0","0","0","2160","2023-09-26 19:41:30","2023-09-26 19:41:30");
INSERT INTO product_sales VALUES("266","174","1240","","","","3","1","75","0","0","0","225","2023-09-26 19:43:33","2023-09-26 19:43:33");
INSERT INTO product_sales VALUES("267","175","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:47:20","2023-09-26 19:47:20");
INSERT INTO product_sales VALUES("268","175","1243","","","","1","1","3105","0","0","0","3105","2023-09-26 19:47:20","2023-09-26 19:47:20");
INSERT INTO product_sales VALUES("269","175","1301","","","","2","1","480","0","0","0","960","2023-09-26 19:47:20","2023-09-26 19:47:20");
INSERT INTO product_sales VALUES("270","175","1132","","","","1","1","495","0","0","0","495","2023-09-26 19:47:20","2023-09-26 19:47:20");
INSERT INTO product_sales VALUES("271","176","1326","","","","1","1","265","0","0","0","265","2023-09-26 19:49:43","2023-09-26 19:49:43");
INSERT INTO product_sales VALUES("272","177","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:51:07","2023-09-26 19:51:07");
INSERT INTO product_sales VALUES("273","178","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:52:26","2023-09-26 19:52:26");
INSERT INTO product_sales VALUES("274","179","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:53:46","2023-09-26 19:53:46");
INSERT INTO product_sales VALUES("275","180","1135","","","","1","1","680","0","0","0","680","2023-09-26 19:54:58","2023-09-26 19:54:58");
INSERT INTO product_sales VALUES("276","181","1135","","","","1","1","680","0","0","0","680","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO product_sales VALUES("277","181","1162","","","","1","1","505","0","0","0","505","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO product_sales VALUES("278","181","1160","","","","1","1","370","0","0","0","370","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO product_sales VALUES("279","181","1155","","","","1","1","245","0","0","0","245","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO product_sales VALUES("280","181","1152","","","","1","1","660","0","0","0","660","2023-09-26 20:38:56","2023-09-26 20:38:56");
INSERT INTO product_sales VALUES("281","182","1135","","","","1","1","680","0","0","0","680","2023-09-26 21:20:31","2023-09-26 21:20:31");
INSERT INTO product_sales VALUES("282","183","1152","","","","1","1","660","0","0","0","660","2023-09-27 14:30:31","2023-09-27 14:30:31");
INSERT INTO product_sales VALUES("283","183","1162","","","","1","1","505","0","0","0","505","2023-09-27 14:30:31","2023-09-27 14:30:31");
INSERT INTO product_sales VALUES("284","183","1155","","","","1","1","245","0","0","0","245","2023-09-27 14:30:31","2023-09-27 14:30:31");
INSERT INTO product_sales VALUES("285","183","1160","","","","1","1","370","0","0","0","370","2023-09-27 14:30:31","2023-09-27 14:30:31");
INSERT INTO product_sales VALUES("286","184","1135","","","","1","1","680","0","0","0","680","2023-09-27 16:07:55","2023-09-27 16:07:55");
INSERT INTO product_sales VALUES("287","184","1162","","","","1","1","505","0","0","0","505","2023-09-27 16:07:55","2023-09-27 16:07:55");
INSERT INTO product_sales VALUES("288","184","1155","","","","1","1","245","0","0","0","245","2023-09-27 16:07:55","2023-09-27 16:07:55");
INSERT INTO product_sales VALUES("289","184","1160","","","","1","1","370","0","0","0","370","2023-09-27 16:07:55","2023-09-27 16:07:55");
INSERT INTO product_sales VALUES("290","185","1135","","","","1","1","680","0","0","0","680","2023-09-27 16:41:47","2023-09-27 16:41:47");
INSERT INTO product_sales VALUES("291","186","1135","","","","1","1","680","0","0","0","680","2023-09-27 17:32:10","2023-09-27 17:32:10");
INSERT INTO product_sales VALUES("292","187","1135","","","","1","1","680","0","0","0","680","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO product_sales VALUES("293","187","1152","","","","1","1","660","0","0","0","660","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO product_sales VALUES("294","187","1162","","","","1","1","505","0","0","0","505","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO product_sales VALUES("295","187","1160","","","","1","1","370","0","0","0","370","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO product_sales VALUES("296","187","1155","","","","1","1","245","0","0","0","245","2023-09-27 18:13:45","2023-09-27 18:13:45");
INSERT INTO product_sales VALUES("297","188","1154","","","","1","1","270","0","0","0","270","2023-09-27 18:29:56","2023-09-27 18:29:56");
INSERT INTO product_sales VALUES("298","189","1197","","","","1","1","440","0","0","0","440","2023-09-27 19:17:04","2023-09-27 19:17:04");
INSERT INTO product_sales VALUES("299","189","1132","","","","1","1","495","0","0","0","495","2023-09-27 19:17:04","2023-09-27 19:17:04");
INSERT INTO product_sales VALUES("300","189","1237","","","","1","1","290","0","0","0","290","2023-09-27 19:17:04","2023-09-27 19:17:04");
INSERT INTO product_sales VALUES("301","190","1135","","","","1","1","680","0","0","0","680","2023-09-27 19:21:18","2023-09-27 19:21:18");
INSERT INTO product_sales VALUES("302","191","1135","","","","1","1","680","0","0","0","680","2023-09-27 19:25:24","2023-09-27 19:25:24");
INSERT INTO product_sales VALUES("303","192","1197","","","","1","1","440","0","0","0","440","2023-09-27 19:37:03","2023-09-27 19:37:03");
INSERT INTO product_sales VALUES("304","192","1317","","","","1","1","225","0","0","0","225","2023-09-27 19:37:03","2023-09-27 19:37:03");
INSERT INTO product_sales VALUES("305","192","1204","","","","1","1","745","0","0","0","745","2023-09-27 19:37:03","2023-09-27 19:37:03");
INSERT INTO product_sales VALUES("306","192","1202","","","","1","1","1500","0","0","0","1500","2023-09-27 19:37:03","2023-09-27 19:37:03");
INSERT INTO product_sales VALUES("307","193","1237","","","","1","1","290","0","0","0","290","2023-09-27 20:09:36","2023-09-27 20:09:36");
INSERT INTO product_sales VALUES("308","194","1135","","","","1","1","680","0","0","0","680","2023-09-27 21:23:57","2023-09-27 21:23:57");
INSERT INTO product_sales VALUES("309","195","1239","","","","1","1","195","0","0","0","195","2023-09-27 21:34:52","2023-09-27 21:34:52");
INSERT INTO product_sales VALUES("310","196","1240","","","","1","1","75","0","0","0","75","2023-09-28 14:33:27","2023-09-28 14:33:27");
INSERT INTO product_sales VALUES("311","197","1135","","","","1","1","680","0","0","0","680","2023-09-28 15:49:58","2023-09-28 15:49:58");
INSERT INTO product_sales VALUES("312","198","1135","","","","1","1","680","0","0","0","680","2023-09-28 17:34:34","2023-09-28 17:34:34");
INSERT INTO product_sales VALUES("313","199","1132","","","","1","1","495","0","0","0","495","2023-09-28 18:22:17","2023-09-28 18:22:17");
INSERT INTO product_sales VALUES("314","199","1278","","","","1","1","405","0","0","0","405","2023-09-28 18:22:17","2023-09-28 18:22:17");
INSERT INTO product_sales VALUES("315","199","1274","","","","1","1","655","0","0","0","655","2023-09-28 18:22:17","2023-09-28 18:22:17");
INSERT INTO product_sales VALUES("316","200","1135","","","","1","1","680","0","0","0","680","2023-09-29 11:42:39","2023-09-29 11:42:39");
INSERT INTO product_sales VALUES("317","201","1135","","","","1","1","680","0","0","0","680","2023-09-29 12:12:46","2023-09-29 12:12:46");
INSERT INTO product_sales VALUES("318","202","1135","","","","1","1","680","0","0","0","680","2023-09-29 13:18:05","2023-09-29 13:18:05");
INSERT INTO product_sales VALUES("319","203","1135","","","","1","1","680","0","0","0","680","2023-09-29 14:46:36","2023-09-29 14:46:36");
INSERT INTO product_sales VALUES("320","203","1132","","","","1","1","430","0","0","0","430","2023-09-29 14:46:36","2023-09-29 14:46:36");
INSERT INTO product_sales VALUES("321","204","1135","","","","1","1","680","0","0","0","680","2023-09-29 16:29:19","2023-09-29 16:29:19");
INSERT INTO product_sales VALUES("322","205","1135","","","","1","1","680","0","0","0","680","2023-09-29 16:30:20","2023-09-29 16:30:20");
INSERT INTO product_sales VALUES("323","206","1135","","","","1","1","680","0","0","0","680","2023-09-29 17:19:01","2023-09-29 17:19:01");
INSERT INTO product_sales VALUES("324","207","1135","","","","1","1","680","0","0","0","680","2023-09-29 19:53:30","2023-09-29 19:53:30");
INSERT INTO product_sales VALUES("325","208","1132","","","","1","1","430","0","0","0","430","2023-09-29 20:58:53","2023-09-29 20:58:53");
INSERT INTO product_sales VALUES("326","209","1135","","","","1","1","680","0","0","0","680","2023-09-30 11:36:39","2023-09-30 11:36:39");
INSERT INTO product_sales VALUES("327","210","1135","","","","1","1","680","0","0","0","680","2023-09-30 11:38:51","2023-09-30 11:38:51");
INSERT INTO product_sales VALUES("328","211","1135","","","","1","1","680","0","0","0","680","2023-09-30 12:29:40","2023-09-30 12:29:40");
INSERT INTO product_sales VALUES("329","212","1135","","","","1","1","680","0","0","0","680","2023-09-30 12:46:29","2023-09-30 12:46:29");
INSERT INTO product_sales VALUES("330","213","1191","","","","4","1","465","0","0","0","1860","2023-09-30 15:00:42","2023-09-30 15:00:42");
INSERT INTO product_sales VALUES("331","213","1190","","","","1","1","970","0","0","0","970","2023-09-30 15:00:42","2023-09-30 15:00:42");
INSERT INTO product_sales VALUES("332","213","1195","","","","1","1","435","0","0","0","435","2023-09-30 15:00:42","2023-09-30 15:00:42");
INSERT INTO product_sales VALUES("333","213","1193","","","","3","1","220","0","0","0","660","2023-09-30 15:00:42","2023-09-30 15:00:42");
INSERT INTO product_sales VALUES("334","214","1301","","","","2","1","480","0","0","0","960","2023-09-30 15:04:58","2023-09-30 15:04:58");
INSERT INTO product_sales VALUES("335","215","1135","","","","1","1","680","0","0","0","680","2023-09-30 15:06:50","2023-09-30 15:06:50");
INSERT INTO product_sales VALUES("336","216","1268","","","","1","1","2070","0","0","0","2070","2023-09-30 15:07:40","2023-09-30 15:07:40");
INSERT INTO product_sales VALUES("337","217","1139","","","","2","1","170","0","0","0","340","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("338","217","1164","","","","1","1","865","0","0","0","865","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("339","217","1163","","","","1","1","550","0","0","0","550","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("340","217","1147","","","","2","1","185","0","0","0","370","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("341","217","1144","","","","1","1","960","0","0","0","960","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("342","217","1146","","","","1","1","1720","0","0","0","1720","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("343","217","1162","","","","1","1","435","0","0","0","435","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("344","217","1160","","","","1","1","320","0","0","0","320","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("345","217","1155","","","","1","1","220","0","0","0","220","2023-09-30 15:11:33","2023-09-30 15:11:33");
INSERT INTO product_sales VALUES("346","218","1135","","","","1","1","680","0","0","0","680","2023-09-30 15:34:50","2023-09-30 15:34:50");
INSERT INTO product_sales VALUES("347","219","1344","","","","1","1","35","0","0","0","35","2023-09-30 16:01:23","2023-09-30 16:01:23");
INSERT INTO product_sales VALUES("348","220","1301","","","","2","1","480","0","0","0","960","2023-09-30 18:30:31","2023-09-30 18:30:31");
INSERT INTO product_sales VALUES("349","221","1135","","","","1","1","680","0","0","0","680","2023-09-30 18:35:57","2023-09-30 18:35:57");
INSERT INTO product_sales VALUES("350","222","1135","","","","1","1","680","0","0","0","680","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("351","222","1144","","","","1","1","960","0","0","0","960","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("352","222","1162","","","","1","1","435","0","0","0","435","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("353","222","1160","","","","1","1","320","0","0","0","320","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("354","222","1155","","","","1","1","220","0","0","0","220","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("355","222","1152","","","","1","1","570","0","0","0","570","2023-09-30 18:51:34","2023-09-30 18:51:34");
INSERT INTO product_sales VALUES("356","223","1135","","","","1","1","680","0","0","0","680","2023-09-30 19:35:15","2023-09-30 19:35:15");
INSERT INTO product_sales VALUES("357","224","1135","","","","1","1","680","0","0","0","680","2023-09-30 19:43:53","2023-09-30 19:43:53");
INSERT INTO product_sales VALUES("358","225","1135","","","","1","1","680","0","0","0","680","2023-09-30 19:50:00","2023-09-30 19:50:00");
INSERT INTO product_sales VALUES("359","225","1162","","","","1","1","435","0","0","0","435","2023-09-30 19:50:00","2023-09-30 19:50:00");
INSERT INTO product_sales VALUES("360","225","1160","","","","1","1","320","0","0","0","320","2023-09-30 19:50:00","2023-09-30 19:50:00");
INSERT INTO product_sales VALUES("361","225","1155","","","","1","1","220","0","0","0","220","2023-09-30 19:50:00","2023-09-30 19:50:00");
INSERT INTO product_sales VALUES("362","226","1135","","","","1","1","680","0","0","0","680","2023-09-30 20:59:37","2023-09-30 20:59:37");
INSERT INTO product_sales VALUES("363","227","1135","","","","1","1","680","0","0","0","680","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("364","227","1162","","","","1","1","435","0","0","0","435","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("365","227","1160","","","","1","1","320","0","0","0","320","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("366","227","1155","","","","1","1","220","0","0","0","220","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("367","227","1144","","","","1","1","960","0","0","0","960","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("368","227","1146","","","","1","1","1720","0","0","0","1720","2023-10-01 13:31:56","2023-10-01 13:31:56");
INSERT INTO product_sales VALUES("369","228","1152","","","","1","1","570","0","0","0","570","2023-10-01 13:38:48","2023-10-01 13:38:48");
INSERT INTO product_sales VALUES("370","229","1317","","","","1","1","225","0","0","0","225","2023-10-01 13:43:24","2023-10-01 13:43:24");
INSERT INTO product_sales VALUES("371","230","1135","","","","1","1","680","0","0","0","680","2023-10-01 14:05:50","2023-10-01 14:05:50");
INSERT INTO product_sales VALUES("372","231","1317","","","","1","1","225","0","0","0","225","2023-10-01 15:18:59","2023-10-01 15:18:59");
INSERT INTO product_sales VALUES("373","232","1137","","","","1","1","505","0","0","0","505","2023-10-01 15:28:50","2023-10-01 15:28:50");
INSERT INTO product_sales VALUES("374","233","1160","","","","1","1","320","0","0","0","320","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO product_sales VALUES("375","233","1155","","","","1","1","220","0","0","0","220","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO product_sales VALUES("376","233","1152","","","","1","1","570","0","0","0","570","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO product_sales VALUES("377","233","1358","","","","2","1","590","0","0","0","1180","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO product_sales VALUES("378","233","1135","","","","1","1","680","0","0","0","680","2023-10-01 15:38:58","2023-10-01 15:38:58");
INSERT INTO product_sales VALUES("379","234","1316","","","","1","1","216","0","0","0","216","2023-10-01 15:49:22","2023-10-01 15:49:22");
INSERT INTO product_sales VALUES("380","235","1239","","","","1","1","195","0","0","0","195","2023-10-01 17:14:28","2023-10-01 17:14:28");
INSERT INTO product_sales VALUES("381","235","1135","","","","1","1","680","0","0","0","680","2023-10-01 17:14:28","2023-10-01 17:14:28");
INSERT INTO product_sales VALUES("382","236","1135","","","","1","1","680","0","0","0","680","2023-10-01 17:49:17","2023-10-01 17:49:17");
INSERT INTO product_sales VALUES("383","237","1135","","","","1","1","680","0","0","0","680","2023-10-01 18:15:06","2023-10-01 18:15:06");
INSERT INTO product_sales VALUES("384","238","1135","","","","1","1","680","0","0","0","680","2023-10-01 18:46:07","2023-10-01 18:46:07");
INSERT INTO product_sales VALUES("385","239","1197","","","","1","1","440","0","0","0","440","2023-10-01 20:23:37","2023-10-01 20:23:37");
INSERT INTO product_sales VALUES("386","240","1135","","","","1","1","680","0","0","0","680","2023-10-01 21:01:04","2023-10-01 21:01:04");
INSERT INTO product_sales VALUES("387","241","1135","","","","1","1","680","0","0","0","680","2023-10-01 21:01:59","2023-10-01 21:01:59");
INSERT INTO product_sales VALUES("388","242","1148","","","","1","1","20","0","0","0","20","2023-10-01 21:13:19","2023-10-01 21:13:19");
INSERT INTO product_sales VALUES("389","243","1148","","","","1","1","20","0","0","0","20","2023-10-01 21:14:34","2023-10-01 21:14:34");
INSERT INTO product_sales VALUES("390","244","1237","","","","1","1","290","0","0","0","290","2023-10-01 21:23:05","2023-10-01 21:23:05");
INSERT INTO product_sales VALUES("391","245","1135","","","","1","1","680","0","0","0","680","2023-10-01 21:47:24","2023-10-01 21:47:24");
INSERT INTO product_sales VALUES("392","245","1301","","","","1","1","480","0","0","0","480","2023-10-01 21:47:24","2023-10-01 21:47:24");
INSERT INTO product_sales VALUES("393","246","1135","","","","1","1","680","0","0","0","680","2023-10-02 11:51:28","2023-10-02 11:51:28");
INSERT INTO product_sales VALUES("394","247","1135","","","","1","1","680","0","0","0","680","2023-10-02 12:08:26","2023-10-02 12:08:26");
INSERT INTO product_sales VALUES("395","248","1327","","","","1","1","360","0","0","0","360","2023-10-02 12:18:37","2023-10-02 12:18:37");
INSERT INTO product_sales VALUES("396","248","1218","","","","1","1","1640","0","0","0","1640","2023-10-02 12:18:37","2023-10-02 12:18:37");
INSERT INTO product_sales VALUES("397","249","1135","","","","1","1","680","0","0","0","680","2023-10-02 12:32:53","2023-10-02 12:32:53");
INSERT INTO product_sales VALUES("398","250","1240","","","","1","1","75","0","0","0","75","2023-10-02 13:22:13","2023-10-02 13:22:13");
INSERT INTO product_sales VALUES("399","251","1378","","","","1","1","100","0","0","0","100","2023-10-02 13:49:33","2023-10-02 13:49:33");
INSERT INTO product_sales VALUES("400","252","1197","","","","1","1","440","0","0","0","440","2023-10-02 14:10:53","2023-10-02 14:10:53");
INSERT INTO product_sales VALUES("401","253","1135","","","","1","1","680","0","0","0","680","2023-10-02 14:11:44","2023-10-02 14:11:44");
INSERT INTO product_sales VALUES("402","254","1135","","","","1","1","680","0","0","0","680","2023-10-02 17:51:53","2023-10-02 17:51:53");
INSERT INTO product_sales VALUES("403","254","1316","","","","1","1","216","0","0","0","216","2023-10-02 17:51:53","2023-10-02 17:51:53");
INSERT INTO product_sales VALUES("404","255","1135","","","","1","1","680","0","0","0","680","2023-10-02 19:14:15","2023-10-02 19:14:15");
INSERT INTO product_sales VALUES("405","256","1135","","","","1","1","680","0","0","0","680","2023-10-02 19:20:16","2023-10-02 19:20:16");
INSERT INTO product_sales VALUES("406","257","1264","","","","1","1","90","0","0","0","90","2023-10-02 19:57:50","2023-10-02 19:57:50");
INSERT INTO product_sales VALUES("407","258","1135","","","","1","1","680","0","0","0","680","2023-10-02 20:03:42","2023-10-02 20:03:42");
INSERT INTO product_sales VALUES("408","259","1366","","","","1","1","85","0","0","0","85","2023-10-02 20:51:30","2023-10-02 20:51:30");
INSERT INTO product_sales VALUES("409","260","1135","","","","1","1","680","0","0","0","680","2023-10-03 11:19:11","2023-10-03 11:19:11");
INSERT INTO product_sales VALUES("410","261","1135","","","","1","1","680","0","0","0","680","2023-10-03 11:19:39","2023-10-03 11:19:39");
INSERT INTO product_sales VALUES("411","262","1131","","","","1","1","470","0","0","0","470","2023-10-03 12:08:43","2023-10-03 12:08:43");
INSERT INTO product_sales VALUES("412","263","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:04:13","2023-10-03 13:04:13");
INSERT INTO product_sales VALUES("413","264","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:10:52","2023-10-03 13:10:52");
INSERT INTO product_sales VALUES("414","265","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:17:24","2023-10-03 13:17:24");
INSERT INTO product_sales VALUES("415","266","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:32:50","2023-10-03 13:32:50");
INSERT INTO product_sales VALUES("416","267","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:33:11","2023-10-03 13:33:11");
INSERT INTO product_sales VALUES("417","268","1135","","","","1","1","680","0","0","0","680","2023-10-03 13:50:57","2023-10-03 13:50:57");
INSERT INTO product_sales VALUES("418","269","1152","","","","1","1","570","0","0","0","570","2023-10-03 15:58:49","2023-10-03 15:58:49");
INSERT INTO product_sales VALUES("419","270","1358","","","","2","1","590","0","0","0","1180","2023-10-03 16:20:21","2023-10-03 16:20:21");
INSERT INTO product_sales VALUES("420","271","1320","","","","1","1","230","0","0","0","230","2023-10-03 18:55:04","2023-10-03 18:55:04");
INSERT INTO product_sales VALUES("421","271","1321","","","","1","1","220","0","0","0","220","2023-10-03 18:55:05","2023-10-03 18:55:05");
INSERT INTO product_sales VALUES("422","271","1133","","","","2","1","100","0","0","0","200","2023-10-03 18:55:05","2023-10-03 18:55:05");
INSERT INTO product_sales VALUES("423","271","1281","","","","2","1","215","0","0","0","430","2023-10-03 18:55:05","2023-10-03 18:55:05");
INSERT INTO product_sales VALUES("424","272","1135","","","","1","1","680","0","0","0","680","2023-10-03 19:57:07","2023-10-03 19:57:07");
INSERT INTO product_sales VALUES("425","273","1135","","","","1","1","680","0","0","0","680","2023-10-03 21:05:44","2023-10-03 21:05:44");
INSERT INTO product_sales VALUES("426","274","1135","","","","1","1","680","0","0","0","680","2023-10-03 21:38:17","2023-10-03 21:38:17");
INSERT INTO product_sales VALUES("427","275","1143","","","","1","1","1040","0","0","0","1040","2023-10-04 11:33:21","2023-10-04 11:33:21");
INSERT INTO product_sales VALUES("428","276","1135","","","","1","1","680","0","0","0","680","2023-10-04 12:04:48","2023-10-04 12:04:48");
INSERT INTO product_sales VALUES("429","277","1358","","","","1","1","590","0","0","0","590","2023-10-04 12:30:17","2023-10-04 12:30:17");
INSERT INTO product_sales VALUES("430","277","1135","","","","1","1","680","0","0","0","680","2023-10-04 12:30:17","2023-10-04 12:30:17");
INSERT INTO product_sales VALUES("431","278","1316","","","","1","1","216","0","0","0","216","2023-10-04 12:32:08","2023-10-04 12:32:08");
INSERT INTO product_sales VALUES("432","279","1135","","","","1","1","680","0","0","0","680","2023-10-04 12:49:56","2023-10-04 12:49:56");
INSERT INTO product_sales VALUES("433","280","1135","","","","1","1","680","0","0","0","680","2023-10-04 13:40:44","2023-10-04 13:40:44");
INSERT INTO product_sales VALUES("434","281","1240","","","","1","1","75","0","0","0","75","2023-10-04 13:58:25","2023-10-04 13:58:25");
INSERT INTO product_sales VALUES("435","282","1135","","","","1","1","680","0","0","0","680","2023-10-04 15:13:08","2023-10-04 15:13:08");
INSERT INTO product_sales VALUES("436","283","1135","","","","1","1","680","0","0","0","680","2023-10-04 16:44:17","2023-10-04 16:44:17");
INSERT INTO product_sales VALUES("437","284","1135","","","","1","1","680","0","0","0","680","2023-10-04 16:59:19","2023-10-04 16:59:19");
INSERT INTO product_sales VALUES("438","285","1187","","","","1","1","480","0","0","0","480","2023-10-04 17:36:17","2023-10-04 17:36:17");
INSERT INTO product_sales VALUES("439","285","1342","","","","1","1","400","0","0","0","400","2023-10-04 17:36:17","2023-10-04 17:36:17");
INSERT INTO product_sales VALUES("440","286","1135","","","","1","1","680","0","0","0","680","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO product_sales VALUES("441","286","1193","","","","3","1","220","0","0","0","660","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO product_sales VALUES("442","286","1191","","","","4","1","465","0","0","0","1860","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO product_sales VALUES("443","286","1190","","","","1","1","970","0","0","0","970","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO product_sales VALUES("444","286","1195","","","","1","1","435","0","0","0","435","2023-10-04 18:03:07","2023-10-04 18:03:07");
INSERT INTO product_sales VALUES("445","287","1214","","","","1","1","3295","0","0","0","3295","2023-10-04 18:08:44","2023-10-04 18:08:44");
INSERT INTO product_sales VALUES("446","288","1211","","","","1","1","480","0","0","0","480","2023-10-04 18:38:29","2023-10-04 18:38:29");
INSERT INTO product_sales VALUES("447","288","1161","","","","1","1","85","0","0","0","85","2023-10-04 18:38:29","2023-10-04 18:38:29");
INSERT INTO product_sales VALUES("448","289","1249","","","","1","1","295","0","0","0","295","2023-10-04 18:44:21","2023-10-04 18:44:21");
INSERT INTO product_sales VALUES("449","290","1135","","","","1","1","680","0","0","0","680","2023-10-04 19:04:01","2023-10-04 19:04:01");
INSERT INTO product_sales VALUES("450","291","1266","","","","1","1","100","0","0","0","100","2023-10-04 20:58:11","2023-10-04 20:58:11");
INSERT INTO product_sales VALUES("451","292","1152","","","","1","1","570","0","0","0","570","2023-10-04 21:04:56","2023-10-04 21:04:56");
INSERT INTO product_sales VALUES("452","293","1237","","","","1","1","290","0","0","0","290","2023-10-04 21:11:15","2023-10-04 21:11:15");
INSERT INTO product_sales VALUES("453","294","1216","","","","1","1","310","0","0","0","310","2023-10-04 21:13:14","2023-10-04 21:13:14");
INSERT INTO product_sales VALUES("454","295","1135","","","","1","1","680","0","0","0","680","2023-10-04 21:15:45","2023-10-04 21:15:45");
INSERT INTO product_sales VALUES("455","296","1197","","","","1","1","440","0","0","0","440","2023-10-05 12:57:28","2023-10-05 12:57:28");
INSERT INTO product_sales VALUES("456","297","1135","","","","1","1","680","0","0","0","680","2023-10-05 19:44:56","2023-10-05 19:44:56");
INSERT INTO product_sales VALUES("457","298","1373","","","","1","1","90","0","0","0","90","2023-10-05 19:46:33","2023-10-05 19:46:33");
INSERT INTO product_sales VALUES("458","299","1135","","","","1","1","680","0","0","0","680","2023-10-05 20:47:43","2023-10-05 20:47:43");
INSERT INTO product_sales VALUES("459","300","1135","","","","1","1","680","0","0","0","680","2023-10-05 20:49:54","2023-10-05 20:49:54");
INSERT INTO product_sales VALUES("460","301","1135","","","","1","1","680","0","0","0","680","2023-10-05 20:50:39","2023-10-05 20:50:39");
INSERT INTO product_sales VALUES("461","302","1135","","","","1","1","680","0","0","0","680","2023-10-06 12:10:26","2023-10-06 12:10:26");
INSERT INTO product_sales VALUES("462","303","1316","","","","1","1","216","0","0","0","216","2023-10-06 12:47:32","2023-10-06 12:47:32");
INSERT INTO product_sales VALUES("463","304","1240","","","","2","1","75","0","0","0","150","2023-10-06 12:52:40","2023-10-06 12:52:40");
INSERT INTO product_sales VALUES("464","305","1135","","","","1","1","680","0","0","0","680","2023-10-06 14:35:52","2023-10-06 14:35:52");
INSERT INTO product_sales VALUES("465","306","1135","","","","1","1","680","0","0","0","680","2023-10-06 18:11:12","2023-10-06 18:11:12");
INSERT INTO product_sales VALUES("466","307","1152","","","","1","1","570","0","0","0","570","2023-10-06 18:16:29","2023-10-06 18:16:29");
INSERT INTO product_sales VALUES("467","308","1216","","","","1","1","310","0","0","0","310","2023-10-06 19:19:11","2023-10-06 19:19:11");
INSERT INTO product_sales VALUES("468","309","1155","","","","1","1","220","0","0","0","220","2023-10-06 19:24:38","2023-10-06 19:24:38");
INSERT INTO product_sales VALUES("469","309","1162","","","","1","1","435","0","0","0","435","2023-10-06 19:24:38","2023-10-06 19:24:38");
INSERT INTO product_sales VALUES("470","309","1160","","","","1","1","320","0","0","0","320","2023-10-06 19:24:38","2023-10-06 19:24:38");
INSERT INTO product_sales VALUES("471","310","1135","","","","1","1","680","0","0","0","680","2023-10-06 19:50:15","2023-10-06 19:50:15");
INSERT INTO product_sales VALUES("472","311","1344","","","","1","1","35","0","0","0","35","2023-10-06 20:04:41","2023-10-06 20:04:41");
INSERT INTO product_sales VALUES("473","312","1132","","","","2","1","430","0","0","0","860","2023-10-06 20:56:18","2023-10-06 20:56:18");
INSERT INTO product_sales VALUES("474","313","1135","","","","1","1","680","0","0","0","680","2023-10-06 21:01:45","2023-10-06 21:01:45");
INSERT INTO product_sales VALUES("475","314","1287","","","","1","1","320","0","0","0","320","2023-10-06 21:37:25","2023-10-06 21:37:25");
INSERT INTO product_sales VALUES("476","314","1286","","","","1","1","2270","0","0","0","2270","2023-10-06 21:37:25","2023-10-06 21:37:25");
INSERT INTO product_sales VALUES("477","315","1288","","","","1","1","530","0","0","0","530","2023-10-06 21:48:58","2023-10-06 21:48:58");
INSERT INTO product_sales VALUES("478","316","1237","","","","1","1","290","0","0","0","290","2023-10-07 14:06:07","2023-10-07 14:06:07");
INSERT INTO product_sales VALUES("479","317","1358","","","","2","1","510","0","0","0","1020","2023-10-07 14:26:59","2023-10-07 14:26:59");
INSERT INTO product_sales VALUES("480","318","1376","","","","1","1","45","0","0","0","45","2023-10-07 14:38:37","2023-10-07 14:38:37");
INSERT INTO product_sales VALUES("481","319","1266","","","","2","1","100","0","0","0","200","2023-10-07 14:39:27","2023-10-07 14:39:27");
INSERT INTO product_sales VALUES("482","320","1132","","","","1","1","430","0","0","0","430","2023-10-07 14:43:44","2023-10-07 14:43:44");
INSERT INTO product_sales VALUES("483","321","1314","","","","1","1","0","0","0","0","0","2023-10-07 14:49:46","2023-10-07 14:49:46");
INSERT INTO product_sales VALUES("484","322","1135","","","","1","1","680","0","0","0","680","2023-10-07 16:58:41","2023-10-07 16:58:41");
INSERT INTO product_sales VALUES("485","323","1373","","","","2","1","90","0","0","0","180","2023-10-07 17:25:39","2023-10-07 17:25:39");
INSERT INTO product_sales VALUES("486","324","1216","","","","1","1","310","0","0","0","310","2023-10-07 17:42:19","2023-10-07 17:42:19");
INSERT INTO product_sales VALUES("487","325","1135","","","","1","1","680","0","0","0","680","2023-10-07 17:44:16","2023-10-07 17:44:16");
INSERT INTO product_sales VALUES("488","326","1135","","","","1","1","680","0","0","0","680","2023-10-07 18:01:44","2023-10-07 18:01:44");
INSERT INTO product_sales VALUES("489","327","1135","","","","1","1","680","0","0","0","680","2023-10-07 20:13:26","2023-10-07 20:13:26");
INSERT INTO product_sales VALUES("490","328","1135","","","","1","1","680","0","0","0","680","2023-10-07 20:47:39","2023-10-07 20:47:39");
INSERT INTO product_sales VALUES("491","329","1321","","","","1","1","220","0","0","0","220","2023-10-08 15:23:18","2023-10-08 15:23:18");
INSERT INTO product_sales VALUES("492","329","1320","","","","1","1","230","0","0","0","230","2023-10-08 15:23:18","2023-10-08 15:23:18");
INSERT INTO product_sales VALUES("493","329","1281","","","","2","1","215","0","0","0","430","2023-10-08 15:23:18","2023-10-08 15:23:18");
INSERT INTO product_sales VALUES("494","329","1133","","","","2","1","100","0","0","0","200","2023-10-08 15:23:18","2023-10-08 15:23:18");
INSERT INTO product_sales VALUES("495","330","1135","","","","1","1","680","0","0","0","680","2023-10-08 15:24:53","2023-10-08 15:24:53");
INSERT INTO product_sales VALUES("496","331","1162","","","","1","1","435","0","0","0","435","2023-10-08 15:27:23","2023-10-08 15:27:23");
INSERT INTO product_sales VALUES("497","331","1160","","","","1","1","320","0","0","0","320","2023-10-08 15:27:23","2023-10-08 15:27:23");
INSERT INTO product_sales VALUES("498","331","1155","","","","1","1","220","0","0","0","220","2023-10-08 15:27:23","2023-10-08 15:27:23");
INSERT INTO product_sales VALUES("499","332","1304","","","","2","1","565","0","0","0","1130","2023-10-08 15:34:05","2023-10-08 15:34:05");
INSERT INTO product_sales VALUES("500","333","1278","","","","1","1","405","0","0","0","405","2023-10-08 15:51:58","2023-10-08 15:51:58");
INSERT INTO product_sales VALUES("501","333","1132","","","","1","1","430","0","0","0","430","2023-10-08 15:51:58","2023-10-08 15:51:58");
INSERT INTO product_sales VALUES("502","334","1316","","","","1","1","216","0","0","0","216","2023-10-08 16:34:31","2023-10-08 16:34:31");
INSERT INTO product_sales VALUES("503","335","1135","","","","1","1","680","0","0","0","680","2023-10-08 16:35:34","2023-10-08 16:35:34");
INSERT INTO product_sales VALUES("504","336","1135","","","","1","1","680","0","0","0","680","2023-10-08 16:56:29","2023-10-08 16:56:29");
INSERT INTO product_sales VALUES("505","337","1135","","","","1","1","680","0","0","0","680","2023-10-08 18:18:11","2023-10-08 18:18:11");
INSERT INTO product_sales VALUES("506","337","1274","","","","1","1","655","0","0","0","655","2023-10-08 18:18:11","2023-10-08 18:18:11");
INSERT INTO product_sales VALUES("507","338","1239","","","","1","1","195","0","0","0","195","2023-10-08 19:03:11","2023-10-08 19:03:11");
INSERT INTO product_sales VALUES("508","339","1275","","","","1","1","375","0","0","0","375","2023-10-08 19:09:29","2023-10-08 19:09:29");
INSERT INTO product_sales VALUES("509","340","1135","","","","1","1","680","0","0","0","680","2023-10-09 12:35:03","2023-10-09 12:35:03");
INSERT INTO product_sales VALUES("510","341","1135","","","","1","1","680","0","0","0","680","2023-10-09 12:36:21","2023-10-09 12:36:21");
INSERT INTO product_sales VALUES("511","342","1135","","","","1","1","680","0","0","0","680","2023-10-09 13:28:44","2023-10-09 13:28:44");
INSERT INTO product_sales VALUES("512","343","1135","","","","1","1","680","0","0","0","680","2023-10-09 14:24:35","2023-10-09 14:24:35");
INSERT INTO product_sales VALUES("513","344","1358","","","","1","1","510","0","0","0","510","2023-10-09 14:52:36","2023-10-09 14:52:36");
INSERT INTO product_sales VALUES("514","345","1135","","","","1","1","680","0","0","0","680","2023-10-09 14:56:27","2023-10-09 14:56:27");
INSERT INTO product_sales VALUES("515","346","1381","","","","2","1","10","0","0","0","20","2023-10-09 15:11:21","2023-10-09 15:11:21");
INSERT INTO product_sales VALUES("516","347","1381","","","","2","1","10","0","0","0","20","2023-10-09 15:11:22","2023-10-09 15:11:22");
INSERT INTO product_sales VALUES("517","348","1381","","","","3","1","10","0","0","0","30","2023-10-09 15:16:26","2023-10-09 15:16:26");
INSERT INTO product_sales VALUES("518","349","1380","","","","2","1","20","0","0","0","40","2023-10-09 15:33:03","2023-10-09 15:33:03");
INSERT INTO product_sales VALUES("519","350","1135","","","","1","1","680","0","0","0","680","2023-10-09 17:21:02","2023-10-09 17:21:02");
INSERT INTO product_sales VALUES("520","351","1135","","","","1","1","680","0","0","0","680","2023-10-09 17:49:59","2023-10-09 17:49:59");
INSERT INTO product_sales VALUES("521","352","1135","","","","1","1","680","0","0","0","680","2023-10-09 17:49:59","2023-10-09 17:49:59");
INSERT INTO product_sales VALUES("522","353","1135","","","","1","1","680","0","0","0","680","2023-10-09 18:04:54","2023-10-09 18:04:54");
INSERT INTO product_sales VALUES("523","354","1162","","","","1","1","435","0","0","0","435","2023-10-09 19:00:13","2023-10-09 19:00:13");
INSERT INTO product_sales VALUES("524","354","1160","","","","1","1","320","0","0","0","320","2023-10-09 19:00:14","2023-10-09 19:00:14");
INSERT INTO product_sales VALUES("525","354","1155","","","","1","1","220","0","0","0","220","2023-10-09 19:00:14","2023-10-09 19:00:14");
INSERT INTO product_sales VALUES("526","355","1135","","","","1","1","680","0","0","0","680","2023-10-09 19:41:05","2023-10-09 19:41:05");
INSERT INTO product_sales VALUES("527","355","1155","","","","1","1","220","0","0","0","220","2023-10-09 19:41:05","2023-10-09 19:41:05");
INSERT INTO product_sales VALUES("528","355","1162","","","","1","1","435","0","0","0","435","2023-10-09 19:41:05","2023-10-09 19:41:05");
INSERT INTO product_sales VALUES("529","355","1160","","","","1","1","320","0","0","0","320","2023-10-09 19:41:05","2023-10-09 19:41:05");
INSERT INTO product_sales VALUES("530","356","1135","","","","1","1","680","0","0","0","680","2023-10-09 20:34:46","2023-10-09 20:34:46");
INSERT INTO product_sales VALUES("531","357","1201","","","","1","1","50","0","0","0","50","2023-10-09 20:36:41","2023-10-09 20:36:41");
INSERT INTO product_sales VALUES("532","358","1132","","","","1","1","430","0","0","0","430","2023-10-09 20:59:39","2023-10-09 20:59:39");
INSERT INTO product_sales VALUES("533","359","1135","","","","1","1","680","0","0","0","680","2023-10-09 21:09:54","2023-10-09 21:09:54");
INSERT INTO product_sales VALUES("534","360","1135","","","","1","1","680","0","0","0","680","2023-10-09 21:09:55","2023-10-09 21:09:55");
INSERT INTO product_sales VALUES("535","361","1162","","","","1","1","435","0","0","0","435","2023-10-10 11:50:09","2023-10-10 11:50:09");
INSERT INTO product_sales VALUES("536","361","1155","","","","1","1","220","0","0","0","220","2023-10-10 11:50:09","2023-10-10 11:50:09");
INSERT INTO product_sales VALUES("537","361","1160","","","","1","1","320","0","0","0","320","2023-10-10 11:50:09","2023-10-10 11:50:09");
INSERT INTO product_sales VALUES("538","362","1135","","","","1","1","680","0","0","0","680","2023-10-10 12:16:35","2023-10-10 12:16:35");
INSERT INTO product_sales VALUES("539","363","1204","","","","1","1","745","0","0","0","745","2023-10-10 12:44:27","2023-10-10 12:44:27");
INSERT INTO product_sales VALUES("540","364","1135","","","","1","1","680","0","0","0","680","2023-10-10 14:58:00","2023-10-10 14:58:00");
INSERT INTO product_sales VALUES("541","365","1234","","","","1","1","445","0","0","0","445","2023-10-10 14:58:20","2023-10-10 14:58:20");
INSERT INTO product_sales VALUES("542","366","1301","","","","2","1","480","0","0","0","960","2023-10-10 15:26:25","2023-10-10 15:26:25");
INSERT INTO product_sales VALUES("543","367","1216","","","","1","1","310","0","0","0","310","2023-10-10 15:55:35","2023-10-10 15:55:35");
INSERT INTO product_sales VALUES("544","368","1144","","","","1","1","960","0","0","0","960","2023-10-10 17:34:14","2023-10-10 17:34:14");
INSERT INTO product_sales VALUES("545","369","1135","","","","1","1","680","0","0","0","680","2023-10-10 17:42:48","2023-10-10 17:42:48");
INSERT INTO product_sales VALUES("546","370","1135","","","","1","1","680","0","0","0","680","2023-10-10 17:45:57","2023-10-10 17:45:57");
INSERT INTO product_sales VALUES("547","371","1135","","","","1","1","680","0","0","0","680","2023-10-10 19:18:44","2023-10-10 19:18:44");
INSERT INTO product_sales VALUES("548","372","1135","","","","1","1","680","0","0","0","680","2023-10-10 20:19:33","2023-10-10 20:19:33");
INSERT INTO product_sales VALUES("549","373","1135","","","","1","1","680","0","0","0","680","2023-10-10 20:24:23","2023-10-10 20:24:23");
INSERT INTO product_sales VALUES("550","374","1135","","","","1","1","680","0","0","0","680","2023-10-10 20:36:13","2023-10-10 20:36:13");
INSERT INTO product_sales VALUES("551","375","1135","","","","1","1","680","0","0","0","680","2023-10-11 12:13:25","2023-10-11 12:13:25");
INSERT INTO product_sales VALUES("552","376","1301","","","","1","1","480","0","0","0","480","2023-10-11 14:05:15","2023-10-11 14:05:15");
INSERT INTO product_sales VALUES("553","377","1135","","","","1","1","680","0","0","0","680","2023-10-11 14:05:46","2023-10-11 14:05:46");
INSERT INTO product_sales VALUES("554","378","1214","","","","1","1","2860","0","0","0","2860","2023-10-11 15:43:08","2023-10-11 15:43:08");
INSERT INTO product_sales VALUES("555","378","1382","","","","2","1","10","0","0","0","20","2023-10-11 15:43:08","2023-10-11 15:43:08");
INSERT INTO product_sales VALUES("556","378","1237","","","","1","1","275","0","0","0","275","2023-10-11 15:43:08","2023-10-11 15:43:08");
INSERT INTO product_sales VALUES("557","378","1135","","","","8","1","680","0","0","0","5440","2023-10-11 15:43:08","2023-10-11 15:43:08");
INSERT INTO product_sales VALUES("558","379","1135","","","","1","1","680","0","0","0","680","2023-10-11 17:16:51","2023-10-11 17:16:51");
INSERT INTO product_sales VALUES("559","380","1197","","","","1","1","440","0","0","0","440","2023-10-11 17:59:15","2023-10-11 17:59:15");
INSERT INTO product_sales VALUES("560","381","1341","","","","1","1","400","0","0","0","400","2023-10-11 18:52:36","2023-10-11 18:52:36");
INSERT INTO product_sales VALUES("561","382","1135","","","","1","1","680","0","0","0","680","2023-10-11 20:03:48","2023-10-11 20:03:48");
INSERT INTO product_sales VALUES("562","383","1135","","","","1","1","680","0","0","0","680","2023-10-12 13:09:24","2023-10-12 13:09:24");
INSERT INTO product_sales VALUES("563","384","1264","","","","1","1","90","0","0","0","90","2023-10-12 13:45:56","2023-10-12 13:45:56");
INSERT INTO product_sales VALUES("564","385","1164","","","","1","1","865","0","0","0","865","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO product_sales VALUES("565","385","1163","","","","1","1","550","0","0","0","550","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO product_sales VALUES("566","385","1139","","","","2","1","170","0","0","0","340","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO product_sales VALUES("567","385","1146","","","","1","1","1720","0","0","0","1720","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO product_sales VALUES("568","385","1144","","","","1","1","960","0","0","0","960","2023-10-12 16:54:33","2023-10-12 16:54:33");
INSERT INTO product_sales VALUES("569","386","1327","","","","1","1","360","0","0","0","360","2023-10-12 17:47:40","2023-10-12 17:47:40");
INSERT INTO product_sales VALUES("570","387","1187","","","","1","1","480","0","0","0","480","2023-10-12 18:40:27","2023-10-12 18:40:27");
INSERT INTO product_sales VALUES("571","387","1135","","","","1","1","680","0","0","0","680","2023-10-12 18:40:27","2023-10-12 18:40:27");
INSERT INTO product_sales VALUES("572","387","1157","","","","1","1","45","0","0","0","45","2023-10-12 18:40:27","2023-10-12 18:40:27");
INSERT INTO product_sales VALUES("573","388","1191","","","","2","1","465","0","0","0","930","2023-10-12 19:55:06","2023-10-12 19:55:06");
INSERT INTO product_sales VALUES("574","389","1139","","","","2","1","170","0","0","0","340","2023-10-12 19:57:22","2023-10-12 19:57:22");
INSERT INTO product_sales VALUES("575","389","1164","","","","1","1","865","0","0","0","865","2023-10-12 19:57:22","2023-10-12 19:57:22");
INSERT INTO product_sales VALUES("576","389","1163","","","","1","1","550","0","0","0","550","2023-10-12 19:57:22","2023-10-12 19:57:22");
INSERT INTO product_sales VALUES("577","390","1135","","","","1","1","680","0","0","0","680","2023-10-12 20:02:43","2023-10-12 20:02:43");
INSERT INTO product_sales VALUES("578","391","1135","","","","1","1","680","0","0","0","680","2023-10-12 20:32:04","2023-10-12 20:32:04");
INSERT INTO product_sales VALUES("579","392","1135","","","","1","1","680","0","0","0","680","2023-10-12 20:56:32","2023-10-12 20:56:32");
INSERT INTO product_sales VALUES("580","393","1317","","","","2","1","225","0","0","0","450","2023-10-12 22:03:44","2023-10-12 22:03:44");
INSERT INTO product_sales VALUES("581","393","1316","","","","2","1","200","0","0","0","400","2023-10-12 22:03:44","2023-10-12 22:03:44");
INSERT INTO product_sales VALUES("582","394","1135","","","","1","1","680","0","0","0","680","2023-10-13 11:18:16","2023-10-13 11:18:16");
INSERT INTO product_sales VALUES("583","395","1135","","","","1","1","680","0","0","0","680","2023-10-13 12:27:35","2023-10-13 12:27:35");
INSERT INTO product_sales VALUES("584","396","1135","","","","1","1","680","0","0","0","680","2023-10-13 13:37:09","2023-10-13 13:37:09");
INSERT INTO product_sales VALUES("585","397","1135","","","","1","1","680","0","0","0","680","2023-10-13 13:37:09","2023-10-13 13:37:09");
INSERT INTO product_sales VALUES("586","398","1382","","","","1","1","10","0","0","0","10","2023-10-13 13:42:44","2023-10-13 13:42:44");
INSERT INTO product_sales VALUES("587","399","1135","","","","1","1","680","0","0","0","680","2023-10-13 14:14:01","2023-10-13 14:14:01");
INSERT INTO product_sales VALUES("588","400","1382","","","","2","1","10","0","0","0","20","2023-10-13 14:20:39","2023-10-13 14:20:39");
INSERT INTO product_sales VALUES("589","401","1135","","","","1","1","680","0","0","0","680","2023-10-13 16:16:52","2023-10-13 16:16:52");
INSERT INTO product_sales VALUES("590","402","1132","","","","2","1","400","0","0","0","800","2023-10-13 17:00:54","2023-10-13 17:00:54");
INSERT INTO product_sales VALUES("591","402","1135","","","","1","1","680","0","0","0","680","2023-10-13 17:00:54","2023-10-13 17:00:54");
INSERT INTO product_sales VALUES("592","403","1135","","","","1","1","680","0","0","0","680","2023-10-13 17:30:48","2023-10-13 17:30:48");
INSERT INTO product_sales VALUES("593","404","1164","","","","1","1","865","0","0","0","865","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO product_sales VALUES("594","404","1163","","","","1","1","550","0","0","0","550","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO product_sales VALUES("595","404","1139","","","","2","1","170","0","0","0","340","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO product_sales VALUES("596","404","1146","","","","1","1","1720","0","0","0","1720","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO product_sales VALUES("597","404","1144","","","","1","1","960","0","0","0","960","2023-10-13 18:34:57","2023-10-13 18:34:57");
INSERT INTO product_sales VALUES("598","405","1301","","","","1","1","480","0","0","0","480","2023-10-13 19:09:18","2023-10-13 19:09:18");
INSERT INTO product_sales VALUES("599","406","1135","","","","1","1","680","0","0","0","680","2023-10-13 20:08:00","2023-10-13 20:08:00");
INSERT INTO product_sales VALUES("600","407","1135","","","","1","1","680","0","0","0","680","2023-10-13 20:09:42","2023-10-13 20:09:42");
INSERT INTO product_sales VALUES("601","408","1132","","","","1","1","400","0","0","0","400","2023-10-13 20:11:09","2023-10-13 20:11:09");
INSERT INTO product_sales VALUES("602","408","1135","","","","1","1","680","0","0","0","680","2023-10-13 20:11:09","2023-10-13 20:11:09");
INSERT INTO product_sales VALUES("603","409","1148","","","","2","1","20","0","0","0","40","2023-10-13 20:15:39","2023-10-13 20:15:39");
INSERT INTO product_sales VALUES("604","409","1147","","","","1","1","185","0","0","0","185","2023-10-13 20:15:39","2023-10-13 20:15:39");
INSERT INTO product_sales VALUES("605","410","1152","","","","1","1","570","0","0","0","570","2023-10-13 20:22:56","2023-10-13 20:22:56");
INSERT INTO product_sales VALUES("606","410","1160","","","","1","1","320","0","0","0","320","2023-10-13 20:22:56","2023-10-13 20:22:56");
INSERT INTO product_sales VALUES("607","410","1162","","","","1","1","435","0","0","0","435","2023-10-13 20:22:56","2023-10-13 20:22:56");
INSERT INTO product_sales VALUES("608","410","1155","","","","1","1","220","0","0","0","220","2023-10-13 20:22:56","2023-10-13 20:22:56");
INSERT INTO product_sales VALUES("609","411","1212","","","","1","1","3635","0","0","0","3635","2023-10-14 13:17:26","2023-10-14 13:17:26");
INSERT INTO product_sales VALUES("610","412","1177","","","","1","1","215","0","0","0","215","2023-10-14 13:46:24","2023-10-14 13:46:24");
INSERT INTO product_sales VALUES("611","413","1216","","","","1","1","310","0","0","0","310","2023-10-14 13:47:49","2023-10-14 13:47:49");
INSERT INTO product_sales VALUES("612","414","1216","","","","1","1","310","0","0","0","310","2023-10-14 13:48:53","2023-10-14 13:48:53");
INSERT INTO product_sales VALUES("613","415","1380","","","","1","1","20","0","0","0","20","2023-10-14 19:26:29","2023-10-14 19:26:29");
INSERT INTO product_sales VALUES("614","416","1381","","","","1","1","10","0","0","0","10","2023-10-14 19:28:38","2023-10-14 19:28:38");
INSERT INTO product_sales VALUES("615","416","1382","","","","2","1","10","0","0","0","20","2023-10-14 19:28:38","2023-10-14 19:28:38");
INSERT INTO product_sales VALUES("616","416","1267","","","","1","1","165","0","0","0","165","2023-10-14 19:28:38","2023-10-14 19:28:38");
INSERT INTO product_sales VALUES("617","417","1316","","","","1","1","200","0","0","0","200","2023-10-14 20:21:45","2023-10-14 20:21:45");
INSERT INTO product_sales VALUES("618","418","1382","","","","1","1","10","0","0","0","10","2023-10-14 20:28:26","2023-10-14 20:28:26");
INSERT INTO product_sales VALUES("619","419","1381","","","","3","1","10","0","0","0","30","2023-10-14 20:41:02","2023-10-14 20:41:02");
INSERT INTO product_sales VALUES("620","420","1216","","","","1","1","310","0","0","0","310","2023-10-15 13:05:10","2023-10-15 13:05:10");
INSERT INTO product_sales VALUES("621","421","1287","","","","1","1","320","0","0","0","320","2023-10-15 13:42:12","2023-10-15 13:42:12");
INSERT INTO product_sales VALUES("622","422","1361","","","","1","1","105","0","0","0","105","2023-10-15 14:23:50","2023-10-15 14:23:50");
INSERT INTO product_sales VALUES("623","423","1135","","","","1","1","680","0","0","0","680","2023-10-15 14:24:29","2023-10-15 14:24:29");
INSERT INTO product_sales VALUES("624","424","1135","","","","3","1","680","0","0","0","2040","2023-10-15 14:26:25","2023-10-15 14:26:25");
INSERT INTO product_sales VALUES("625","425","1251","","","","1","1","420","0","0","0","420","2023-10-15 15:17:48","2023-10-15 15:17:48");
INSERT INTO product_sales VALUES("626","426","1239","","","","1","1","195","0","0","0","195","2023-10-15 15:25:25","2023-10-15 15:25:25");
INSERT INTO product_sales VALUES("627","427","1135","","","","1","1","680","0","0","0","680","2023-10-15 17:13:42","2023-10-15 17:13:42");
INSERT INTO product_sales VALUES("628","428","1197","","","","1","1","440","0","0","0","440","2023-10-15 18:24:27","2023-10-15 18:24:27");
INSERT INTO product_sales VALUES("629","428","1203","","","","1","1","110","0","0","0","110","2023-10-15 18:24:27","2023-10-15 18:24:27");
INSERT INTO product_sales VALUES("630","428","1135","","","","1","1","680","0","0","0","680","2023-10-15 18:24:27","2023-10-15 18:24:27");
INSERT INTO product_sales VALUES("631","429","1152","","","","1","1","570","0","0","0","570","2023-10-15 18:51:30","2023-10-15 18:51:30");
INSERT INTO product_sales VALUES("632","429","1162","","","","1","1","435","0","0","0","435","2023-10-15 18:51:30","2023-10-15 18:51:30");
INSERT INTO product_sales VALUES("633","429","1155","","","","1","1","220","0","0","0","220","2023-10-15 18:51:30","2023-10-15 18:51:30");
INSERT INTO product_sales VALUES("634","429","1160","","","","1","1","320","0","0","0","320","2023-10-15 18:51:31","2023-10-15 18:51:31");
INSERT INTO product_sales VALUES("635","430","1381","","","","1","1","10","0","0","0","10","2023-10-15 19:52:34","2023-10-15 19:52:34");
INSERT INTO product_sales VALUES("636","431","1341","","","","1","1","400","0","0","0","400","2023-10-15 20:32:37","2023-10-15 20:32:37");
INSERT INTO product_sales VALUES("637","432","1216","","","","1","1","310","0","0","0","310","2023-10-15 20:34:15","2023-10-15 20:34:15");
INSERT INTO product_sales VALUES("638","433","1135","","","","1","1","680","0","0","0","680","2023-10-15 21:18:12","2023-10-15 21:18:12");
INSERT INTO product_sales VALUES("639","434","1135","","","","1","1","680","0","0","0","680","2023-10-16 12:43:45","2023-10-16 12:43:45");
INSERT INTO product_sales VALUES("640","435","1135","","","","1","1","680","0","0","0","680","2023-10-16 12:44:36","2023-10-16 12:44:36");
INSERT INTO product_sales VALUES("641","436","1135","","","","1","1","680","0","0","0","680","2023-10-16 12:45:35","2023-10-16 12:45:35");
INSERT INTO product_sales VALUES("642","437","1216","","","","1","1","310","0","0","0","310","2023-10-16 12:49:59","2023-10-16 12:49:59");
INSERT INTO product_sales VALUES("643","438","1135","","","","1","1","680","0","0","0","680","2023-10-16 15:59:40","2023-10-16 15:59:40");
INSERT INTO product_sales VALUES("644","439","1197","","","","1","1","440","0","0","0","440","2023-10-16 17:00:28","2023-10-16 17:00:28");
INSERT INTO product_sales VALUES("645","440","1135","","","","1","1","680","0","0","0","680","2023-10-16 17:01:42","2023-10-16 17:01:42");
INSERT INTO product_sales VALUES("646","441","1216","","","","1","1","310","0","0","0","310","2023-10-16 17:02:52","2023-10-16 17:02:52");
INSERT INTO product_sales VALUES("647","441","1135","","","","1","1","680","0","0","0","680","2023-10-16 17:02:52","2023-10-16 17:02:52");
INSERT INTO product_sales VALUES("648","442","1272","","","","1","1","370","0","0","0","370","2023-10-16 18:24:02","2023-10-16 18:24:02");
INSERT INTO product_sales VALUES("649","443","1135","","","","1","1","680","0","0","0","680","2023-10-16 18:34:16","2023-10-16 18:34:16");
INSERT INTO product_sales VALUES("650","444","1310","","","","1","1","2175","0","0","0","2175","2023-10-16 18:48:20","2023-10-16 18:48:20");
INSERT INTO product_sales VALUES("651","445","1216","","","","1","1","310","0","0","0","310","2023-10-16 19:21:35","2023-10-16 19:21:35");
INSERT INTO product_sales VALUES("652","445","1139","","","","2","1","170","0","0","0","340","2023-10-16 19:21:35","2023-10-16 19:21:35");
INSERT INTO product_sales VALUES("653","445","1164","","","","1","1","865","0","0","0","865","2023-10-16 19:21:35","2023-10-16 19:21:35");
INSERT INTO product_sales VALUES("654","446","1132","","","","1","1","400","0","0","0","400","2023-10-16 19:28:51","2023-10-16 19:28:51");
INSERT INTO product_sales VALUES("655","446","1272","","","","1","1","370","0","0","0","370","2023-10-16 19:28:51","2023-10-16 19:28:51");
INSERT INTO product_sales VALUES("656","447","1132","","","","1","1","400","0","0","0","400","2023-10-16 20:01:10","2023-10-16 20:01:10");
INSERT INTO product_sales VALUES("657","448","1188","","","","1","1","4200","0","0","0","4200","2023-10-16 22:30:02","2023-10-16 22:30:02");
INSERT INTO product_sales VALUES("658","449","1135","","","","1","1","680","0","0","0","680","2023-10-17 12:49:35","2023-10-17 12:49:35");
INSERT INTO product_sales VALUES("659","450","1312","","","","1","1","300","0","0","0","300","2023-10-17 14:28:59","2023-10-17 14:28:59");
INSERT INTO product_sales VALUES("660","451","1317","","","","1","1","200","0","0","0","200","2023-10-17 15:00:01","2023-10-17 15:00:01");
INSERT INTO product_sales VALUES("661","452","1135","","","","1","1","680","0","0","0","680","2023-10-17 15:08:45","2023-10-17 15:08:45");
INSERT INTO product_sales VALUES("662","453","1162","","","","1","1","435","0","0","0","435","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("663","453","1160","","","","1","1","320","0","0","0","320","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("664","453","1155","","","","1","1","220","0","0","0","220","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("665","453","1139","","","","2","1","170","0","0","0","340","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("666","453","1163","","","","1","1","550","0","0","0","550","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("667","453","1164","","","","1","1","865","0","0","0","865","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("668","453","1143","","","","1","1","1040","0","0","0","1040","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("669","453","1384","","","","1","1","555","0","0","0","555","2023-10-17 15:41:24","2023-10-17 15:41:24");
INSERT INTO product_sales VALUES("670","454","1135","","","","1","1","680","0","0","0","680","2023-10-17 16:02:31","2023-10-17 16:02:31");
INSERT INTO product_sales VALUES("671","455","1132","","","","1","1","400","0","0","0","400","2023-10-17 16:35:38","2023-10-17 16:35:38");
INSERT INTO product_sales VALUES("672","456","1373","","","","1","1","90","0","0","0","90","2023-10-17 17:31:49","2023-10-17 17:31:49");
INSERT INTO product_sales VALUES("673","457","1135","","","","1","1","680","0","0","0","680","2023-10-17 19:13:57","2023-10-17 19:13:57");
INSERT INTO product_sales VALUES("674","457","1132","","","","1","1","400","0","0","0","400","2023-10-17 19:13:57","2023-10-17 19:13:57");
INSERT INTO product_sales VALUES("675","458","1133","","","","2","1","100","0","0","0","200","2023-10-17 20:01:16","2023-10-17 20:01:16");
INSERT INTO product_sales VALUES("676","458","1320","","","","1","1","230","0","0","0","230","2023-10-17 20:01:16","2023-10-17 20:01:16");
INSERT INTO product_sales VALUES("677","458","1321","","","","1","1","220","0","0","0","220","2023-10-17 20:01:16","2023-10-17 20:01:16");
INSERT INTO product_sales VALUES("678","458","1281","","","","2","1","215","0","0","0","430","2023-10-17 20:01:16","2023-10-17 20:01:16");
INSERT INTO product_sales VALUES("679","459","1135","","","","1","1","680","0","0","0","680","2023-10-17 21:18:00","2023-10-17 21:18:00");
INSERT INTO product_sales VALUES("680","460","1145","","","","1","1","1980","0","0","0","1980","2023-10-17 21:19:24","2023-10-17 21:19:24");
INSERT INTO product_sales VALUES("681","461","1132","","","","1","1","400","0","0","0","400","2023-10-17 21:21:02","2023-10-17 21:21:02");
INSERT INTO product_sales VALUES("682","462","1135","","","","1","1","680","0","0","0","680","2023-10-17 21:22:32","2023-10-17 21:22:32");
INSERT INTO product_sales VALUES("683","463","1317","","","","1","1","200","0","0","0","200","2023-10-17 21:27:45","2023-10-17 21:27:45");
INSERT INTO product_sales VALUES("684","463","1135","","","","1","1","680","0","0","0","680","2023-10-17 21:27:45","2023-10-17 21:27:45");
INSERT INTO product_sales VALUES("685","464","1135","","","","1","1","680","0","0","0","680","2023-10-17 21:31:09","2023-10-17 21:31:09");
INSERT INTO product_sales VALUES("686","465","1135","","","","1","1","680","0","0","0","680","2023-10-18 12:37:21","2023-10-18 12:37:21");
INSERT INTO product_sales VALUES("687","466","1132","","","","1","1","400","0","0","0","400","2023-10-18 12:47:41","2023-10-18 12:47:41");
INSERT INTO product_sales VALUES("688","466","1135","","","","1","1","680","0","0","0","680","2023-10-18 12:47:41","2023-10-18 12:47:41");
INSERT INTO product_sales VALUES("689","467","1135","","","","1","1","680","0","0","0","680","2023-10-18 13:14:51","2023-10-18 13:14:51");
INSERT INTO product_sales VALUES("690","468","1135","","","","1","1","680","0","0","0","680","2023-10-18 15:47:17","2023-10-18 15:47:17");
INSERT INTO product_sales VALUES("691","469","1380","","","","1","1","20","0","0","0","20","2023-10-18 16:07:41","2023-10-18 16:07:41");
INSERT INTO product_sales VALUES("692","469","1255","","","","1","1","4420","0","0","0","4420","2023-10-18 16:07:41","2023-10-18 16:07:41");
INSERT INTO product_sales VALUES("693","470","1216","","","","1","1","310","0","0","0","310","2023-10-18 19:52:22","2023-10-18 19:52:22");
INSERT INTO product_sales VALUES("694","471","1135","","","","1","1","680","0","0","0","680","2023-10-18 21:14:50","2023-10-18 21:14:50");
INSERT INTO product_sales VALUES("695","472","1237","","","","1","1","275","0","0","0","275","2023-10-19 11:44:05","2023-10-19 11:44:05");
INSERT INTO product_sales VALUES("696","473","1135","","","","1","1","680","0","0","0","680","2023-10-19 12:25:35","2023-10-19 12:25:35");
INSERT INTO product_sales VALUES("697","474","1358","","","","1","1","510","0","0","0","510","2023-10-19 13:49:00","2023-10-19 13:49:00");
INSERT INTO product_sales VALUES("698","475","1274","","","","1","1","655","0","0","0","655","2023-10-19 14:05:20","2023-10-19 14:05:20");
INSERT INTO product_sales VALUES("699","475","1304","","","","2","1","565","0","0","0","1130","2023-10-19 14:05:20","2023-10-19 14:05:20");
INSERT INTO product_sales VALUES("700","476","1274","","","","1","1","655","0","0","0","655","2023-10-19 14:29:42","2023-10-19 14:29:42");
INSERT INTO product_sales VALUES("701","476","1135","","","","1","1","680","0","0","0","680","2023-10-19 14:29:42","2023-10-19 14:29:42");
INSERT INTO product_sales VALUES("702","476","1275","","","","1","1","375","0","0","0","375","2023-10-19 14:29:42","2023-10-19 14:29:42");
INSERT INTO product_sales VALUES("703","477","1135","","","","1","1","680","0","0","0","680","2023-10-19 15:09:42","2023-10-19 15:09:42");
INSERT INTO product_sales VALUES("704","478","1352","","","","1","1","130","0","0","0","130","2023-10-19 17:19:30","2023-10-19 17:19:30");
INSERT INTO product_sales VALUES("705","479","1135","","","","1","1","680","0","0","0","680","2023-10-19 19:34:06","2023-10-19 19:34:06");
INSERT INTO product_sales VALUES("706","480","1135","","","","1","1","680","0","0","0","680","2023-10-19 19:34:06","2023-10-19 19:34:06");
INSERT INTO product_sales VALUES("707","481","1380","","","","1","1","20","0","0","0","20","2023-10-19 20:14:03","2023-10-19 20:14:03");
INSERT INTO product_sales VALUES("708","482","1135","","","","1","1","680","0","0","0","680","2023-10-19 22:17:01","2023-10-19 22:17:01");
INSERT INTO product_sales VALUES("709","483","1316","","","","1","1","200","0","0","0","200","2023-10-20 11:59:34","2023-10-20 11:59:34");
INSERT INTO product_sales VALUES("710","484","1361","","","","1","1","105","0","0","0","105","2023-10-20 12:29:27","2023-10-20 12:29:27");
INSERT INTO product_sales VALUES("711","485","1216","","","","1","1","310","0","0","0","310","2023-10-20 13:23:49","2023-10-20 13:23:49");
INSERT INTO product_sales VALUES("712","486","1135","","","","1","1","680","0","0","0","680","2023-10-20 13:28:52","2023-10-20 13:28:52");
INSERT INTO product_sales VALUES("713","487","1358","","","","2","1","510","0","0","0","1020","2023-10-20 14:05:47","2023-10-20 14:05:47");
INSERT INTO product_sales VALUES("714","488","1135","","","","1","1","680","0","0","0","680","2023-10-20 14:14:57","2023-10-20 14:14:57");
INSERT INTO product_sales VALUES("715","489","1162","","","","1","1","435","0","0","0","435","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO product_sales VALUES("716","489","1155","","","","1","1","220","0","0","0","220","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO product_sales VALUES("717","489","1160","","","","1","1","320","0","0","0","320","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO product_sales VALUES("718","489","1135","","","","1","1","680","0","0","0","680","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO product_sales VALUES("719","489","1152","","","","1","1","570","0","0","0","570","2023-10-20 14:59:24","2023-10-20 14:59:24");
INSERT INTO product_sales VALUES("720","490","1132","","","","1","1","400","0","0","0","400","2023-10-20 15:18:34","2023-10-20 15:18:34");
INSERT INTO product_sales VALUES("721","490","1135","","","","1","1","680","0","0","0","680","2023-10-20 15:18:34","2023-10-20 15:18:34");
INSERT INTO product_sales VALUES("722","491","1133","","","","2","1","100","0","0","0","200","2023-10-20 18:44:10","2023-10-20 18:44:10");
INSERT INTO product_sales VALUES("723","491","1320","","","","1","1","230","0","0","0","230","2023-10-20 18:44:10","2023-10-20 18:44:10");
INSERT INTO product_sales VALUES("724","491","1321","","","","1","1","220","0","0","0","220","2023-10-20 18:44:10","2023-10-20 18:44:10");
INSERT INTO product_sales VALUES("725","491","1281","","","","2","1","215","0","0","0","430","2023-10-20 18:44:10","2023-10-20 18:44:10");
INSERT INTO product_sales VALUES("726","492","1132","","","","1","1","400","0","0","0","400","2023-10-20 18:49:54","2023-10-20 18:49:54");
INSERT INTO product_sales VALUES("727","493","1135","","","","1","1","680","0","0","0","680","2023-10-20 18:50:44","2023-10-20 18:50:44");
INSERT INTO product_sales VALUES("728","494","1271","","","","1","1","370","0","0","0","370","2023-10-20 18:52:53","2023-10-20 18:52:53");
INSERT INTO product_sales VALUES("729","495","1135","","","","1","1","680","0","0","0","680","2023-10-20 18:57:55","2023-10-20 18:57:55");
INSERT INTO product_sales VALUES("730","496","1135","","","","1","1","680","0","0","0","680","2023-10-20 18:59:19","2023-10-20 18:59:19");
INSERT INTO product_sales VALUES("731","497","1216","","","","1","1","310","0","0","0","310","2023-10-20 19:00:32","2023-10-20 19:00:32");
INSERT INTO product_sales VALUES("732","498","1370","","","","1","1","15","0","0","0","15","2023-10-20 19:05:10","2023-10-20 19:05:10");
INSERT INTO product_sales VALUES("733","499","1274","","","","1","1","655","0","0","0","655","2023-10-20 20:43:28","2023-10-20 20:43:28");
INSERT INTO product_sales VALUES("734","500","1274","","","","1","1","655","0","0","0","655","2023-10-20 20:43:29","2023-10-20 20:43:29");
INSERT INTO product_sales VALUES("735","501","1135","","","","1","1","680","0","0","0","680","2023-10-20 20:45:08","2023-10-20 20:45:08");
INSERT INTO product_sales VALUES("736","502","1135","","","","1","1","680","0","0","0","680","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO product_sales VALUES("737","502","1152","","","","1","1","570","0","0","0","570","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO product_sales VALUES("738","502","1162","","","","1","1","435","0","0","0","435","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO product_sales VALUES("739","502","1160","","","","1","1","320","0","0","0","320","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO product_sales VALUES("740","502","1155","","","","1","1","220","0","0","0","220","2023-10-20 21:42:02","2023-10-20 21:42:02");
INSERT INTO product_sales VALUES("741","503","1135","","","","1","1","680","0","0","0","680","2023-10-21 12:12:59","2023-10-21 12:12:59");
INSERT INTO product_sales VALUES("742","504","1135","","","","1","1","680","0","0","0","680","2023-10-21 14:40:34","2023-10-21 14:40:34");
INSERT INTO product_sales VALUES("743","505","1135","","","","1","1","680","0","0","0","680","2023-10-21 15:13:55","2023-10-21 15:13:55");
INSERT INTO product_sales VALUES("744","506","1135","","","","1","1","680","0","0","0","680","2023-10-21 15:14:30","2023-10-21 15:14:30");
INSERT INTO product_sales VALUES("745","507","1132","","","","1","1","400","0","0","0","400","2023-10-21 16:56:16","2023-10-21 16:56:16");
INSERT INTO product_sales VALUES("746","508","1162","","","","2","1","435","0","0","0","870","2023-10-21 16:58:02","2023-10-21 16:58:02");
INSERT INTO product_sales VALUES("747","508","1160","","","","2","1","320","0","0","0","640","2023-10-21 16:58:02","2023-10-21 16:58:02");
INSERT INTO product_sales VALUES("748","508","1155","","","","2","1","220","0","0","0","440","2023-10-21 16:58:02","2023-10-21 16:58:02");
INSERT INTO product_sales VALUES("749","509","1384","","","","1","1","555","0","0","0","555","2023-10-21 16:59:07","2023-10-21 16:59:07");
INSERT INTO product_sales VALUES("750","510","1246","","","","1","1","1390","0","0","0","1390","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO product_sales VALUES("751","510","1344","","","","1","1","35","0","0","0","35","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO product_sales VALUES("752","510","1342","","","","1","1","400","0","0","0","400","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO product_sales VALUES("753","510","1316","","","","1","1","200","0","0","0","200","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO product_sales VALUES("754","510","1135","","","","1","1","680","0","0","0","680","2023-10-21 17:00:39","2023-10-21 17:00:39");
INSERT INTO product_sales VALUES("755","511","1216","","","","1","1","310","0","0","0","310","2023-10-21 17:58:37","2023-10-21 17:58:37");
INSERT INTO product_sales VALUES("756","511","1132","","","","1","1","400","0","0","0","400","2023-10-21 17:58:37","2023-10-21 17:58:37");
INSERT INTO product_sales VALUES("757","512","1143","","","","1","1","1040","0","0","0","1040","2023-10-21 18:07:38","2023-10-21 18:07:38");
INSERT INTO product_sales VALUES("758","512","1145","","","","1","1","1980","0","0","0","1980","2023-10-21 18:07:38","2023-10-21 18:07:38");
INSERT INTO product_sales VALUES("759","513","1164","","","","1","1","865","0","0","0","865","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("760","513","1139","","","","2","1","170","0","0","0","340","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("761","513","1144","","","","1","1","960","0","0","0","960","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("762","513","1132","","","","1","1","400","0","0","0","400","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("763","513","1317","","","","1","1","200","0","0","0","200","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("764","513","1135","","","","1","1","680","0","0","0","680","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("765","513","1162","","","","1","1","435","0","0","0","435","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("766","513","1160","","","","1","1","320","0","0","0","320","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("767","513","1155","","","","1","1","220","0","0","0","220","2023-10-21 18:47:58","2023-10-21 18:47:58");
INSERT INTO product_sales VALUES("768","514","1135","","","","1","1","680","0","0","0","680","2023-10-21 19:36:48","2023-10-21 19:36:48");
INSERT INTO product_sales VALUES("769","515","1341","","","","1","1","400","0","0","0","400","2023-10-21 20:57:18","2023-10-21 20:57:18");
INSERT INTO product_sales VALUES("770","516","1381","","","","1","1","10","0","0","0","10","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("771","516","1239","","","","1","1","195","0","0","0","195","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("772","516","1317","","","","1","1","200","0","0","0","200","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("773","516","1132","","","","1","1","400","0","0","0","400","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("774","516","1341","","","","1","1","400","0","0","0","400","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("775","516","1342","","","","1","1","400","0","0","0","400","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("776","516","1135","","","","2","1","680","0","0","0","1360","2023-10-21 21:32:19","2023-10-21 21:32:19");
INSERT INTO product_sales VALUES("777","517","1240","","","","1","1","75","0","0","0","75","2023-10-21 21:33:30","2023-10-21 21:33:30");
INSERT INTO product_sales VALUES("778","518","1259","","","","1","1","490","0","0","0","490","2023-10-21 21:36:56","2023-10-21 21:36:56");
INSERT INTO product_sales VALUES("779","519","1135","","","","1","1","680","0","0","0","680","2023-10-22 13:50:15","2023-10-22 13:50:15");
INSERT INTO product_sales VALUES("780","520","1216","","","","1","1","310","0","0","0","310","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("781","520","1148","","","","2","1","20","0","0","0","40","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("782","520","1139","","","","2","1","170","0","0","0","340","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("783","520","1146","","","","1","1","1720","0","0","0","1720","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("784","520","1135","","","","1","1","680","0","0","0","680","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("785","520","1163","","","","1","1","550","0","0","0","550","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("786","520","1164","","","","1","1","865","0","0","0","865","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("787","520","1144","","","","1","1","960","0","0","0","960","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("788","520","1152","","","","1","1","570","0","0","0","570","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("789","520","1162","","","","1","1","435","0","0","0","435","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("790","520","1160","","","","1","1","320","0","0","0","320","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("791","520","1155","","","","1","1","220","0","0","0","220","2023-10-22 14:40:52","2023-10-22 14:40:52");
INSERT INTO product_sales VALUES("792","521","1135","","","","1","1","680","0","0","0","680","2023-10-22 14:46:53","2023-10-22 14:46:53");
INSERT INTO product_sales VALUES("793","522","1152","","","","1","1","570","0","0","0","570","2023-10-22 15:57:05","2023-10-22 15:57:05");
INSERT INTO product_sales VALUES("794","522","1135","","","","1","1","680","0","0","0","680","2023-10-22 15:57:05","2023-10-22 15:57:05");
INSERT INTO product_sales VALUES("795","523","1301","","","","1","1","480","0","0","0","480","2023-10-22 16:01:22","2023-10-22 16:01:22");
INSERT INTO product_sales VALUES("796","523","1135","","","","1","1","680","0","0","0","680","2023-10-22 16:01:22","2023-10-22 16:01:22");
INSERT INTO product_sales VALUES("797","524","1189","","","","1","1","1090","0","0","0","1090","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("798","524","1194","","","","1","1","520","0","0","0","520","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("799","524","1193","","","","3","1","220","0","0","0","660","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("800","524","1192","","","","4","1","540","0","0","0","2160","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("801","524","1135","","","","1","1","680","0","0","0","680","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("802","524","1164","","","","1","1","865","0","0","0","865","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("803","524","1163","","","","1","1","550","0","0","0","550","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("804","524","1144","","","","1","1","960","0","0","0","960","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("805","524","1146","","","","1","1","1720","0","0","0","1720","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("806","524","1162","","","","1","1","435","0","0","0","435","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("807","524","1160","","","","1","1","320","0","0","0","320","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("808","524","1155","","","","1","1","220","0","0","0","220","2023-10-22 16:40:08","2023-10-22 16:40:08");
INSERT INTO product_sales VALUES("809","525","1135","","","","1","1","680","0","0","0","680","2023-10-22 17:31:25","2023-10-22 17:31:25");
INSERT INTO product_sales VALUES("810","526","1135","","","","1","1","680","0","0","0","680","2023-10-22 18:32:51","2023-10-22 18:32:51");
INSERT INTO product_sales VALUES("811","526","1342","","","","1","1","400","0","0","0","400","2023-10-22 18:32:51","2023-10-22 18:32:51");
INSERT INTO product_sales VALUES("812","526","1384","","","","1","1","555","0","0","0","555","2023-10-22 18:32:51","2023-10-22 18:32:51");
INSERT INTO product_sales VALUES("813","526","1197","","","","1","1","440","0","0","0","440","2023-10-22 18:32:51","2023-10-22 18:32:51");
INSERT INTO product_sales VALUES("814","527","1197","","","","1","1","440","0","0","0","440","2023-10-22 19:07:05","2023-10-22 19:07:05");
INSERT INTO product_sales VALUES("815","528","1135","","","","1","1","680","0","0","0","680","2023-10-22 20:39:48","2023-10-22 20:39:48");
INSERT INTO product_sales VALUES("816","529","1361","","","","1","1","105","0","0","0","105","2023-10-22 20:41:08","2023-10-22 20:41:08");
INSERT INTO product_sales VALUES("817","530","1316","","","","1","1","200","0","0","0","200","2023-10-22 21:30:48","2023-10-22 21:30:48");
INSERT INTO product_sales VALUES("818","530","1135","","","","1","1","680","0","0","0","680","2023-10-22 21:30:48","2023-10-22 21:30:48");
INSERT INTO product_sales VALUES("819","531","1237","","","","1","1","275","0","0","0","275","2023-10-22 21:35:59","2023-10-22 21:35:59");
INSERT INTO product_sales VALUES("820","532","1135","","","","1","1","680","0","0","0","680","2023-10-22 21:37:16","2023-10-22 21:37:16");
INSERT INTO product_sales VALUES("821","533","1135","","","","1","1","680","0","0","0","680","2023-10-23 11:35:53","2023-10-23 11:35:53");
INSERT INTO product_sales VALUES("822","534","1135","","","","1","1","680","0","0","0","680","2023-10-23 12:20:44","2023-10-23 12:20:44");
INSERT INTO product_sales VALUES("823","535","1135","","","","1","1","680","0","0","0","680","2023-10-23 12:26:42","2023-10-23 12:26:42");
INSERT INTO product_sales VALUES("824","536","1135","","","","1","1","680","0","0","0","680","2023-10-23 12:40:19","2023-10-23 12:40:19");
INSERT INTO product_sales VALUES("825","537","1382","","","","1","1","10","0","0","0","10","2023-10-23 13:45:17","2023-10-23 13:45:17");
INSERT INTO product_sales VALUES("826","538","1135","","","","1","1","680","0","0","0","680","2023-10-23 14:30:16","2023-10-23 14:30:16");
INSERT INTO product_sales VALUES("827","539","1317","","","","1","1","200","0","0","0","200","2023-10-23 14:31:36","2023-10-23 14:31:36");
INSERT INTO product_sales VALUES("828","539","1316","","","","1","1","200","0","0","0","200","2023-10-23 14:31:36","2023-10-23 14:31:36");
INSERT INTO product_sales VALUES("829","540","1135","","","","1","1","680","0","0","0","680","2023-10-23 15:48:15","2023-10-23 15:48:15");
INSERT INTO product_sales VALUES("830","541","1205","","","","1","1","175","0","0","0","175","2023-10-23 16:23:00","2023-10-23 16:23:00");
INSERT INTO product_sales VALUES("831","541","1357","","","","1","1","395","0","0","0","395","2023-10-23 16:23:00","2023-10-23 16:23:00");
INSERT INTO product_sales VALUES("832","541","1135","","","","1","1","680","0","0","0","680","2023-10-23 16:23:00","2023-10-23 16:23:00");
INSERT INTO product_sales VALUES("833","542","1135","","","","1","1","680","0","0","0","680","2023-10-23 16:47:22","2023-10-23 16:47:22");
INSERT INTO product_sales VALUES("834","543","1373","","","","1","1","90","0","0","0","90","2023-10-23 16:51:12","2023-10-23 16:51:12");
INSERT INTO product_sales VALUES("835","544","1264","","","","1","1","90","0","0","0","90","2023-10-23 18:37:33","2023-10-23 18:37:33");
INSERT INTO product_sales VALUES("836","545","1316","","","","1","1","200","0","0","0","200","2023-10-23 18:49:24","2023-10-23 18:49:24");
INSERT INTO product_sales VALUES("837","546","1135","","","","1","1","680","0","0","0","680","2023-10-23 20:46:19","2023-10-23 20:46:19");
INSERT INTO product_sales VALUES("838","547","1237","","","","1","1","275","0","0","0","275","2023-10-23 21:25:02","2023-10-23 21:25:02");
INSERT INTO product_sales VALUES("839","547","1135","","","","1","1","680","0","0","0","680","2023-10-23 21:25:02","2023-10-23 21:25:02");
INSERT INTO product_sales VALUES("840","548","1251","","","","1","1","420","0","0","0","420","2023-10-23 21:31:50","2023-10-23 21:31:50");
INSERT INTO product_sales VALUES("841","549","1381","","","","2","1","10","0","0","0","20","2023-10-24 12:43:02","2023-10-24 12:43:02");
INSERT INTO product_sales VALUES("842","550","1216","","","","1","1","310","0","0","0","310","2023-10-24 13:30:56","2023-10-24 13:30:56");
INSERT INTO product_sales VALUES("843","551","1133","","","","2","1","100","0","0","0","200","2023-10-24 14:41:10","2023-10-24 14:41:10");
INSERT INTO product_sales VALUES("844","551","1320","","","","1","1","230","0","0","0","230","2023-10-24 14:41:10","2023-10-24 14:41:10");
INSERT INTO product_sales VALUES("845","551","1321","","","","1","1","220","0","0","0","220","2023-10-24 14:41:10","2023-10-24 14:41:10");
INSERT INTO product_sales VALUES("846","551","1281","","","","2","1","215","0","0","0","430","2023-10-24 14:41:10","2023-10-24 14:41:10");
INSERT INTO product_sales VALUES("847","552","1162","","","","1","1","435","0","0","0","435","2023-10-24 20:09:31","2023-10-24 20:09:31");
INSERT INTO product_sales VALUES("848","552","1160","","","","1","1","320","0","0","0","320","2023-10-24 20:09:31","2023-10-24 20:09:31");
INSERT INTO product_sales VALUES("849","552","1155","","","","1","1","220","0","0","0","220","2023-10-24 20:09:31","2023-10-24 20:09:31");
INSERT INTO product_sales VALUES("850","552","1152","","","","1","1","570","0","0","0","570","2023-10-24 20:09:31","2023-10-24 20:09:31");
INSERT INTO product_sales VALUES("851","553","1162","","","","1","1","435","0","0","0","435","2023-10-24 20:12:14","2023-10-24 20:12:14");
INSERT INTO product_sales VALUES("852","553","1160","","","","1","1","320","0","0","0","320","2023-10-24 20:12:14","2023-10-24 20:12:14");
INSERT INTO product_sales VALUES("853","553","1155","","","","1","1","220","0","0","0","220","2023-10-24 20:12:14","2023-10-24 20:12:14");
INSERT INTO product_sales VALUES("854","553","1152","","","","1","1","570","0","0","0","570","2023-10-24 20:12:14","2023-10-24 20:12:14");
INSERT INTO product_sales VALUES("855","554","1381","","","","2","1","10","0","0","0","20","2023-10-24 20:13:43","2023-10-24 20:13:43");
INSERT INTO product_sales VALUES("856","555","1201","","","","1","1","50","0","0","0","50","2023-10-24 20:53:53","2023-10-24 20:53:53");
INSERT INTO product_sales VALUES("857","555","1364","","","","2","1","15","0","0","0","30","2023-10-24 20:53:53","2023-10-24 20:53:53");
INSERT INTO product_sales VALUES("858","556","1316","","","","1","1","200","0","0","0","200","2023-10-25 11:54:59","2023-10-25 11:54:59");
INSERT INTO product_sales VALUES("859","556","1341","","","","1","1","400","0","0","0","400","2023-10-25 11:54:59","2023-10-25 11:54:59");
INSERT INTO product_sales VALUES("860","557","1361","","","","1","1","105","0","0","0","105","2023-10-25 12:32:11","2023-10-25 12:32:11");
INSERT INTO product_sales VALUES("861","558","1193","","","","3","1","220","0","0","0","660","2023-10-25 13:33:56","2023-10-25 13:33:56");
INSERT INTO product_sales VALUES("862","558","1191","","","","4","1","465","0","0","0","1860","2023-10-25 13:33:56","2023-10-25 13:33:56");
INSERT INTO product_sales VALUES("863","558","1190","","","","1","1","970","0","0","0","970","2023-10-25 13:33:56","2023-10-25 13:33:56");
INSERT INTO product_sales VALUES("864","558","1195","","","","1","1","435","0","0","0","435","2023-10-25 13:33:56","2023-10-25 13:33:56");
INSERT INTO product_sales VALUES("865","559","1194","","","","1","1","520","0","0","0","520","2023-10-25 16:18:30","2023-10-25 16:18:30");
INSERT INTO product_sales VALUES("866","560","1381","","","","2","1","10","0","0","0","20","2023-10-25 18:14:26","2023-10-25 18:14:26");
INSERT INTO product_sales VALUES("867","560","1215","","","","1","1","1690","0","0","0","1690","2023-10-25 18:14:26","2023-10-25 18:14:26");
INSERT INTO product_sales VALUES("868","561","1358","","","","1","1","510","0","0","0","510","2023-10-25 18:30:25","2023-10-25 18:30:25");
INSERT INTO product_sales VALUES("869","562","1197","","","","1","1","440","0","0","0","440","2023-10-25 19:04:36","2023-10-25 19:04:36");
INSERT INTO product_sales VALUES("870","563","1317","","","","1","1","200","0","0","0","200","2023-10-25 19:06:05","2023-10-25 19:06:05");
INSERT INTO product_sales VALUES("871","564","1197","","","","1","1","440","0","0","0","440","2023-10-25 19:21:20","2023-10-25 19:21:20");
INSERT INTO product_sales VALUES("872","565","1135","","","","13","1","680","0","0","0","8840","2023-10-26 10:40:33","2023-10-26 10:40:33");
INSERT INTO product_sales VALUES("873","566","1266","","","","3","1","100","0","0","0","300","2023-10-26 10:41:35","2023-10-26 10:41:35");
INSERT INTO product_sales VALUES("874","567","1148","","","","4","1","20","0","0","0","80","2023-10-26 10:43:17","2023-10-26 10:43:17");
INSERT INTO product_sales VALUES("875","568","1132","","","","2","1","400","0","0","0","800","2023-10-26 10:55:04","2023-10-26 10:55:04");
INSERT INTO product_sales VALUES("876","569","1135","","","","1","1","680","0","0","0","680","2023-10-26 12:31:29","2023-10-26 12:31:29");
INSERT INTO product_sales VALUES("877","570","1135","","","","1","1","680","0","0","0","680","2023-10-26 12:34:56","2023-10-26 12:34:56");
INSERT INTO product_sales VALUES("878","571","1216","","","","1","1","310","0","0","0","310","2023-10-26 12:44:52","2023-10-26 12:44:52");
INSERT INTO product_sales VALUES("879","572","1216","","","","1","1","310","0","0","0","310","2023-10-26 13:00:37","2023-10-26 13:00:37");
INSERT INTO product_sales VALUES("880","572","1135","","","","1","1","680","0","0","0","680","2023-10-26 13:00:37","2023-10-26 13:00:37");
INSERT INTO product_sales VALUES("881","573","1135","","","","1","1","680","0","0","0","680","2023-10-26 13:10:56","2023-10-26 13:10:56");
INSERT INTO product_sales VALUES("882","574","1132","","","","1","1","400","0","0","0","400","2023-10-26 18:06:03","2023-10-26 18:06:03");
INSERT INTO product_sales VALUES("883","574","1135","","","","1","1","680","0","0","0","680","2023-10-26 18:06:03","2023-10-26 18:06:03");
INSERT INTO product_sales VALUES("884","575","1216","","","","1","1","310","0","0","0","310","2023-10-26 18:08:29","2023-10-26 18:08:29");
INSERT INTO product_sales VALUES("885","576","1382","","","","1","1","10","0","0","0","10","2023-10-26 19:09:06","2023-10-26 19:09:06");
INSERT INTO product_sales VALUES("886","577","1216","","","","1","1","310","0","0","0","310","2023-10-26 19:41:27","2023-10-26 19:41:27");
INSERT INTO product_sales VALUES("887","578","1132","","","","1","1","400","0","0","0","400","2023-10-27 11:27:24","2023-10-27 11:27:24");
INSERT INTO product_sales VALUES("888","579","1155","","","","1","1","220","0","0","0","220","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("889","579","1162","","","","1","1","435","0","0","0","435","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("890","579","1160","","","","1","1","320","0","0","0","320","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("891","579","1152","","","","1","1","570","0","0","0","570","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("892","579","1240","","","","1","1","75","0","0","0","75","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("893","579","1135","","","","1","1","680","0","0","0","680","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("894","579","1358","","","","2","1","510","0","0","0","1020","2023-10-27 13:14:26","2023-10-27 13:14:26");
INSERT INTO product_sales VALUES("895","580","1135","","","","1","1","680","0","0","0","680","2023-10-27 14:13:25","2023-10-27 14:13:25");
INSERT INTO product_sales VALUES("896","581","1237","","","","1","1","275","0","0","0","275","2023-10-27 14:36:47","2023-10-27 14:36:47");
INSERT INTO product_sales VALUES("897","582","1135","","","","1","1","680","0","0","0","680","2023-10-27 14:55:29","2023-10-27 14:55:29");
INSERT INTO product_sales VALUES("898","582","1301","","","","2","1","480","0","0","0","960","2023-10-27 14:55:29","2023-10-27 14:55:29");
INSERT INTO product_sales VALUES("899","583","1301","","","","1","1","480","0","0","0","480","2023-10-27 17:42:10","2023-10-27 17:42:10");
INSERT INTO product_sales VALUES("900","583","1135","","","","1","1","680","0","0","0","680","2023-10-27 17:42:10","2023-10-27 17:42:10");
INSERT INTO product_sales VALUES("901","584","1135","","","","1","1","680","0","0","0","680","2023-10-27 19:12:34","2023-10-27 19:12:34");
INSERT INTO product_sales VALUES("902","585","1135","","","","1","1","680","0","0","0","680","2023-10-27 19:14:17","2023-10-27 19:14:17");
INSERT INTO product_sales VALUES("903","586","1135","","","","1","1","680","0","0","0","680","2023-10-27 19:50:37","2023-10-27 19:50:37");
INSERT INTO product_sales VALUES("904","587","1237","","","","1","1","275","0","0","0","275","2023-10-27 20:02:18","2023-10-27 20:02:18");
INSERT INTO product_sales VALUES("905","588","1287","","","","1","1","320","0","0","0","320","2023-10-27 20:12:00","2023-10-27 20:12:00");
INSERT INTO product_sales VALUES("906","589","1301","","","","2","1","480","0","0","0","960","2023-10-27 21:34:53","2023-10-27 21:34:53");
INSERT INTO product_sales VALUES("907","589","1304","","","","2","1","565","0","0","0","1130","2023-10-27 21:34:53","2023-10-27 21:34:53");
INSERT INTO product_sales VALUES("908","590","1240","","","","2","1","75","0","0","0","150","2023-10-27 21:51:15","2023-10-27 21:51:15");
INSERT INTO product_sales VALUES("909","590","1259","","","","1","1","490","0","0","0","490","2023-10-27 21:51:15","2023-10-27 21:51:15");
INSERT INTO product_sales VALUES("910","591","1135","","","","1","1","680","0","0","0","680","2023-10-28 11:50:59","2023-10-28 11:50:59");
INSERT INTO product_sales VALUES("911","592","1135","","","","1","1","680","0","0","0","680","2023-10-28 11:50:59","2023-10-28 11:50:59");
INSERT INTO product_sales VALUES("912","593","1341","","","","1","1","400","0","0","0","400","2023-10-28 11:52:26","2023-10-28 11:52:26");
INSERT INTO product_sales VALUES("913","594","1135","","","","1","1","680","0","0","0","680","2023-10-28 12:55:12","2023-10-28 12:55:12");
INSERT INTO product_sales VALUES("914","595","1135","","","","1","1","680","0","0","0","680","2023-10-28 13:43:11","2023-10-28 13:43:11");
INSERT INTO product_sales VALUES("915","596","1342","","","","1","1","400","0","0","0","400","2023-10-28 15:26:25","2023-10-28 15:26:25");
INSERT INTO product_sales VALUES("916","597","1380","","","","1","1","20","0","0","0","20","2023-10-28 16:50:33","2023-10-28 16:50:33");
INSERT INTO product_sales VALUES("917","598","1162","","","","1","1","435","0","0","0","435","2023-10-28 17:12:53","2023-10-28 17:12:53");
INSERT INTO product_sales VALUES("918","598","1160","","","","1","1","320","0","0","0","320","2023-10-28 17:12:53","2023-10-28 17:12:53");
INSERT INTO product_sales VALUES("919","598","1155","","","","1","1","220","0","0","0","220","2023-10-28 17:12:53","2023-10-28 17:12:53");
INSERT INTO product_sales VALUES("920","598","1152","","","","1","1","570","0","0","0","570","2023-10-28 17:12:53","2023-10-28 17:12:53");
INSERT INTO product_sales VALUES("921","599","1132","","","","1","1","400","0","0","0","400","2023-10-28 17:20:41","2023-10-28 17:20:41");
INSERT INTO product_sales VALUES("922","600","1342","","","","1","1","400","0","0","0","400","2023-10-28 17:29:07","2023-10-28 17:29:07");
INSERT INTO product_sales VALUES("923","601","1135","","","","1","1","680","0","0","0","680","2023-10-28 18:00:30","2023-10-28 18:00:30");
INSERT INTO product_sales VALUES("924","602","1162","","","","1","1","435","0","0","0","435","2023-10-28 18:13:10","2023-10-28 18:13:10");
INSERT INTO product_sales VALUES("925","602","1160","","","","1","1","320","0","0","0","320","2023-10-28 18:13:10","2023-10-28 18:13:10");
INSERT INTO product_sales VALUES("926","602","1155","","","","1","1","220","0","0","0","220","2023-10-28 18:13:10","2023-10-28 18:13:10");
INSERT INTO product_sales VALUES("927","602","1152","","","","1","1","570","0","0","0","570","2023-10-28 18:13:10","2023-10-28 18:13:10");
INSERT INTO product_sales VALUES("928","603","1135","","","","1","1","680","0","0","0","680","2023-10-28 20:45:32","2023-10-28 20:45:32");
INSERT INTO product_sales VALUES("929","603","1162","","","","1","1","435","0","0","0","435","2023-10-28 20:45:32","2023-10-28 20:45:32");
INSERT INTO product_sales VALUES("930","603","1160","","","","1","1","320","0","0","0","320","2023-10-28 20:45:32","2023-10-28 20:45:32");
INSERT INTO product_sales VALUES("931","603","1155","","","","1","1","220","0","0","0","220","2023-10-28 20:45:32","2023-10-28 20:45:32");
INSERT INTO product_sales VALUES("932","604","1381","","","","1","1","10","0","0","0","10","2023-10-28 20:52:39","2023-10-28 20:52:39");
INSERT INTO product_sales VALUES("933","605","1240","","","","1","1","75","0","0","0","75","2023-10-29 17:58:58","2023-10-29 17:58:58");
INSERT INTO product_sales VALUES("934","606","1341","","","","1","1","400","0","0","0","400","2023-10-29 18:00:09","2023-10-29 18:00:09");
INSERT INTO product_sales VALUES("935","606","1342","","","","1","1","400","0","0","0","400","2023-10-29 18:00:09","2023-10-29 18:00:09");
INSERT INTO product_sales VALUES("936","606","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:00:09","2023-10-29 18:00:09");
INSERT INTO product_sales VALUES("937","607","1380","","","","1","1","20","0","0","0","20","2023-10-29 18:01:06","2023-10-29 18:01:06");
INSERT INTO product_sales VALUES("938","608","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:02:08","2023-10-29 18:02:08");
INSERT INTO product_sales VALUES("939","609","1381","","","","1","1","10","0","0","0","10","2023-10-29 18:03:27","2023-10-29 18:03:27");
INSERT INTO product_sales VALUES("940","609","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:03:27","2023-10-29 18:03:27");
INSERT INTO product_sales VALUES("941","610","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:12:36","2023-10-29 18:12:36");
INSERT INTO product_sales VALUES("942","610","1197","","","","1","1","440","0","0","0","440","2023-10-29 18:12:36","2023-10-29 18:12:36");
INSERT INTO product_sales VALUES("943","611","1135","","","","2","1","680","0","0","0","1360","2023-10-29 18:21:16","2023-10-29 18:21:16");
INSERT INTO product_sales VALUES("944","612","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:23:42","2023-10-29 18:23:42");
INSERT INTO product_sales VALUES("945","613","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:24:24","2023-10-29 18:24:24");
INSERT INTO product_sales VALUES("946","614","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:36:24","2023-10-29 18:36:24");
INSERT INTO product_sales VALUES("947","615","1135","","","","1","1","680","0","0","0","680","2023-10-29 18:55:29","2023-10-29 18:55:29");
INSERT INTO product_sales VALUES("948","616","1317","","","","1","1","200","0","0","0","200","2023-10-29 19:31:04","2023-10-29 19:31:04");
INSERT INTO product_sales VALUES("949","616","1316","","","","1","1","200","0","0","0","200","2023-10-29 19:31:04","2023-10-29 19:31:04");
INSERT INTO product_sales VALUES("950","617","1135","","","","1","1","680","0","0","0","680","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("951","617","1144","","","","1","1","960","0","0","0","960","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("952","617","1133","","","","2","1","100","0","0","0","200","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("953","617","1281","","","","2","1","215","0","0","0","430","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("954","617","1321","","","","1","1","220","0","0","0","220","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("955","617","1320","","","","1","1","230","0","0","0","230","2023-10-29 21:04:38","2023-10-29 21:04:38");
INSERT INTO product_sales VALUES("956","618","1135","","","","1","1","680","0","0","0","680","2023-10-29 21:06:12","2023-10-29 21:06:12");
INSERT INTO product_sales VALUES("957","619","1278","","","","1","1","405","0","0","0","405","2023-10-29 21:11:04","2023-10-29 21:11:04");
INSERT INTO product_sales VALUES("958","620","1237","","","","1","1","275","0","0","0","275","2023-10-30 11:40:46","2023-10-30 11:40:46");
INSERT INTO product_sales VALUES("959","621","1344","","","","1","1","35","0","0","0","35","2023-10-30 12:40:46","2023-10-30 12:40:46");
INSERT INTO product_sales VALUES("960","622","1135","","","","1","1","680","0","0","0","680","2023-10-30 12:47:15","2023-10-30 12:47:15");
INSERT INTO product_sales VALUES("961","623","1135","","","","1","1","680","0","0","0","680","2023-10-30 13:56:19","2023-10-30 13:56:19");
INSERT INTO product_sales VALUES("962","624","1135","","","","1","1","680","0","0","0","680","2023-10-30 14:27:11","2023-10-30 14:27:11");
INSERT INTO product_sales VALUES("963","625","1240","","","","1","1","75","0","0","0","75","2023-10-30 14:27:57","2023-10-30 14:27:57");
INSERT INTO product_sales VALUES("964","626","1135","","","","1","1","680","0","0","0","680","2023-10-30 15:03:58","2023-10-30 15:03:58");
INSERT INTO product_sales VALUES("965","627","1154","","","","1","1","270","0","0","0","270","2023-10-30 17:07:57","2023-10-30 17:07:57");
INSERT INTO product_sales VALUES("966","628","1135","","","","1","1","680","0","0","0","680","2023-10-30 17:41:55","2023-10-30 17:41:55");
INSERT INTO product_sales VALUES("967","629","1132","","","","1","1","400","0","0","0","400","2023-10-30 20:33:29","2023-10-30 20:33:29");
INSERT INTO product_sales VALUES("968","629","1316","","","","1","1","200","0","0","0","200","2023-10-30 20:33:29","2023-10-30 20:33:29");
INSERT INTO product_sales VALUES("969","630","1160","","","","1","1","320","0","0","0","320","2023-10-30 20:51:28","2023-10-30 20:51:28");
INSERT INTO product_sales VALUES("970","630","1162","","","","1","1","435","0","0","0","435","2023-10-30 20:51:28","2023-10-30 20:51:28");
INSERT INTO product_sales VALUES("971","630","1155","","","","1","1","220","0","0","0","220","2023-10-30 20:51:28","2023-10-30 20:51:28");
INSERT INTO product_sales VALUES("972","631","1132","","","","1","1","400","0","0","0","400","2023-10-30 20:59:40","2023-10-30 20:59:40");
INSERT INTO product_sales VALUES("973","632","1132","","","","1","1","400","0","0","0","400","2023-10-30 21:18:08","2023-10-30 21:18:08");
INSERT INTO product_sales VALUES("974","633","1237","","","","1","1","275","0","0","0","275","2023-10-30 21:35:52","2023-10-30 21:35:52");
INSERT INTO product_sales VALUES("975","634","1239","","","","1","1","195","0","0","0","195","2023-10-30 21:45:21","2023-10-30 21:45:21");
INSERT INTO product_sales VALUES("976","635","1216","","","","1","1","310","0","0","0","310","2023-10-30 21:56:55","2023-10-30 21:56:55");
INSERT INTO product_sales VALUES("977","636","1132","","","","1","1","400","0","0","0","400","2023-10-31 13:08:49","2023-10-31 13:08:49");
INSERT INTO product_sales VALUES("978","637","1132","","","","1","1","400","0","0","0","400","2023-10-31 13:24:18","2023-10-31 13:24:18");
INSERT INTO product_sales VALUES("979","638","1344","","","","1","1","35","0","0","0","35","2023-10-31 15:02:35","2023-10-31 15:02:35");
INSERT INTO product_sales VALUES("980","639","1381","","","","1","1","10","0","0","0","10","2023-10-31 15:25:06","2023-10-31 15:25:06");
INSERT INTO product_sales VALUES("981","640","1316","","","","1","1","200","0","0","0","200","2023-10-31 16:01:58","2023-10-31 16:01:58");
INSERT INTO product_sales VALUES("982","641","1193","","","","2","1","220","0","0","0","440","2023-10-31 18:13:22","2023-10-31 18:13:22");
INSERT INTO product_sales VALUES("983","641","1199","","","","1","1","930","0","0","0","930","2023-10-31 18:13:22","2023-10-31 18:13:22");
INSERT INTO product_sales VALUES("984","641","1191","","","","4","1","465","0","0","0","1860","2023-10-31 18:13:22","2023-10-31 18:13:22");
INSERT INTO product_sales VALUES("985","641","1197","","","","1","1","440","0","0","0","440","2023-10-31 18:13:22","2023-10-31 18:13:22");
INSERT INTO product_sales VALUES("986","642","1317","","","","1","1","200","0","0","0","200","2023-10-31 18:24:53","2023-10-31 18:24:53");
INSERT INTO product_sales VALUES("987","643","1162","","","","1","1","435","0","0","0","435","2023-10-31 19:58:07","2023-10-31 19:58:07");
INSERT INTO product_sales VALUES("988","643","1160","","","","1","1","320","0","0","0","320","2023-10-31 19:58:07","2023-10-31 19:58:07");
INSERT INTO product_sales VALUES("989","643","1155","","","","1","1","220","0","0","0","220","2023-10-31 19:58:07","2023-10-31 19:58:07");
INSERT INTO product_sales VALUES("990","644","1132","","","","1","1","400","0","0","0","400","2023-11-01 12:23:14","2023-11-01 12:23:14");
INSERT INTO product_sales VALUES("991","645","1132","","","","1","1","400","0","0","0","400","2023-11-01 12:54:58","2023-11-01 12:54:58");
INSERT INTO product_sales VALUES("992","646","1240","","","","1","1","75","0","0","0","75","2023-11-01 13:03:26","2023-11-01 13:03:26");
INSERT INTO product_sales VALUES("993","647","1380","","","","1","1","20","0","0","0","20","2023-11-01 14:45:18","2023-11-01 14:45:18");
INSERT INTO product_sales VALUES("994","648","1237","","","","2","1","275","0","0","0","550","2023-11-02 13:13:49","2023-11-02 13:13:49");
INSERT INTO product_sales VALUES("995","649","1162","","","","1","1","435","0","0","0","435","2023-11-02 19:13:13","2023-11-02 19:13:13");
INSERT INTO product_sales VALUES("996","649","1160","","","","1","1","320","0","0","0","320","2023-11-02 19:13:13","2023-11-02 19:13:13");
INSERT INTO product_sales VALUES("997","649","1155","","","","1","1","220","0","0","0","220","2023-11-02 19:13:13","2023-11-02 19:13:13");
INSERT INTO product_sales VALUES("998","649","1152","","","","1","1","570","0","0","0","570","2023-11-02 19:13:13","2023-11-02 19:13:13");
INSERT INTO product_sales VALUES("999","650","1154","","","","1","1","270","0","0","0","270","2023-11-02 19:23:24","2023-11-02 19:23:24");
INSERT INTO product_sales VALUES("1000","651","1132","","","","2","1","400","0","0","0","800","2023-11-02 19:25:41","2023-11-02 19:25:41");
INSERT INTO product_sales VALUES("1001","652","1140","","","","1","1","400","0","0","0","400","2023-11-02 19:27:35","2023-11-02 19:27:35");
INSERT INTO product_sales VALUES("1002","653","1266","","","","1","1","100","0","0","0","100","2023-11-02 19:28:42","2023-11-02 19:28:42");
INSERT INTO product_sales VALUES("1003","654","1240","","","","2","1","75","0","0","0","150","2023-11-02 19:48:19","2023-11-02 19:48:19");
INSERT INTO product_sales VALUES("1004","655","1237","","","","1","1","275","0","0","0","275","2023-11-03 11:18:07","2023-11-03 11:18:07");
INSERT INTO product_sales VALUES("1005","656","1266","","","","1","1","100","0","0","0","100","2023-11-03 13:27:28","2023-11-03 13:27:28");
INSERT INTO product_sales VALUES("1006","657","1342","","","","1","1","400","0","0","0","400","2023-11-03 14:03:06","2023-11-03 14:03:06");
INSERT INTO product_sales VALUES("1007","658","1199","","","","1","1","930","0","0","0","930","2023-11-03 19:40:58","2023-11-03 19:40:58");
INSERT INTO product_sales VALUES("1008","659","1216","","","","1","1","310","0","0","0","310","2023-11-03 19:57:22","2023-11-03 19:57:22");
INSERT INTO product_sales VALUES("1009","660","1191","","","","4","1","465","0","0","0","1860","2023-11-03 21:43:52","2023-11-03 21:43:52");
INSERT INTO product_sales VALUES("1010","661","1197","","","","1","1","440","0","0","0","440","2023-11-04 19:12:26","2023-11-04 19:12:26");
INSERT INTO product_sales VALUES("1011","662","1380","","","","1","1","20","0","0","0","20","2023-11-04 19:13:17","2023-11-04 19:13:17");
INSERT INTO product_sales VALUES("1012","663","1381","","","","1","1","10","0","0","0","10","2023-11-04 19:18:24","2023-11-04 19:18:24");
INSERT INTO product_sales VALUES("1013","664","1132","","","","1","1","400","0","0","0","400","2023-11-04 19:18:54","2023-11-04 19:18:54");
INSERT INTO product_sales VALUES("1014","665","1132","","","","1","1","400","0","0","0","400","2023-11-04 19:20:05","2023-11-04 19:20:05");
INSERT INTO product_sales VALUES("1015","666","1237","","","","1","1","275","0","0","0","275","2023-11-05 19:37:56","2023-11-05 19:37:56");
INSERT INTO product_sales VALUES("1016","666","1220","","","","1","1","325","0","0","0","325","2023-11-05 19:37:56","2023-11-05 19:37:56");
INSERT INTO product_sales VALUES("1017","667","1239","","","","1","1","195","0","0","0","195","2023-11-05 20:00:47","2023-11-05 20:00:47");
INSERT INTO product_sales VALUES("1018","667","1148","","","","2","1","20","0","0","0","40","2023-11-05 20:00:47","2023-11-05 20:00:47");
INSERT INTO product_sales VALUES("1019","667","1146","","","","1","1","1720","0","0","0","1720","2023-11-05 20:00:47","2023-11-05 20:00:47");
INSERT INTO product_sales VALUES("1020","667","1133","","","","2","1","100","0","0","0","200","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1021","667","1281","","","","2","1","215","0","0","0","430","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1022","667","1321","","","","1","1","220","0","0","0","220","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1023","667","1320","","","","1","1","230","0","0","0","230","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1024","667","1162","","","","1","1","435","0","0","0","435","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1025","667","1155","","","","1","1","220","0","0","0","220","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1026","667","1160","","","","1","1","320","0","0","0","320","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1027","667","1139","","","","2","1","170","0","0","0","340","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1028","667","1163","","","","1","1","550","0","0","0","550","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1029","667","1164","","","","1","1","865","0","0","0","865","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1030","667","1152","","","","1","1","570","0","0","0","570","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1031","667","1144","","","","1","1","960","0","0","0","960","2023-11-05 20:00:48","2023-11-05 20:00:48");
INSERT INTO product_sales VALUES("1032","668","1382","","","","1","1","10","0","0","0","10","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1033","668","1252","","","","1","1","75","0","0","0","75","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1034","668","1132","","","","1","1","400","0","0","0","400","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1035","668","1148","","","","2","1","20","0","0","0","40","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1036","668","1144","","","","1","1","960","0","0","0","960","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1037","668","1152","","","","1","1","570","0","0","0","570","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1038","668","1162","","","","1","1","435","0","0","0","435","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1039","668","1155","","","","1","1","220","0","0","0","220","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1040","668","1160","","","","1","1","320","0","0","0","320","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1041","668","1146","","","","1","1","1720","0","0","0","1720","2023-11-05 20:07:38","2023-11-05 20:07:38");
INSERT INTO product_sales VALUES("1042","669","1148","","","","2","1","20","0","0","0","40","2023-11-05 21:26:45","2023-11-05 21:26:45");
INSERT INTO product_sales VALUES("1043","670","1139","","","","2","1","170","0","0","0","340","2023-11-06 12:25:30","2023-11-06 12:25:30");
INSERT INTO product_sales VALUES("1044","670","1164","","","","1","1","865","0","0","0","865","2023-11-06 12:25:30","2023-11-06 12:25:30");
INSERT INTO product_sales VALUES("1045","670","1163","","","","1","1","550","0","0","0","550","2023-11-06 12:25:30","2023-11-06 12:25:30");
INSERT INTO product_sales VALUES("1046","671","1275","","","","1","1","375","0","0","0","375","2023-11-06 14:21:55","2023-11-06 14:21:55");
INSERT INTO product_sales VALUES("1047","672","1341","","","","1","1","400","0","0","0","400","2023-11-07 12:46:37","2023-11-07 12:46:37");
INSERT INTO product_sales VALUES("1048","672","1342","","","","1","1","400","0","0","0","400","2023-11-07 12:46:37","2023-11-07 12:46:37");
INSERT INTO product_sales VALUES("1049","673","1197","","","","2","1","440","0","0","0","880","2023-11-07 12:48:34","2023-11-07 12:48:34");
INSERT INTO product_sales VALUES("1050","674","1349","","","","1","1","30","0","0","0","30","2023-11-07 12:54:28","2023-11-07 12:54:28");
INSERT INTO product_sales VALUES("1051","675","1316","","","","1","1","200","0","0","0","200","2023-11-07 14:45:40","2023-11-07 14:45:40");
INSERT INTO product_sales VALUES("1052","675","1197","","","","1","1","440","0","0","0","440","2023-11-07 14:45:40","2023-11-07 14:45:40");
INSERT INTO product_sales VALUES("1053","675","1278","","","","1","1","405","0","0","0","405","2023-11-07 14:45:40","2023-11-07 14:45:40");
INSERT INTO product_sales VALUES("1054","676","1132","","","","1","1","400","0","0","0","400","2023-11-07 15:00:45","2023-11-07 15:00:45");
INSERT INTO product_sales VALUES("1055","677","1132","","","","1","1","400","0","0","0","400","2023-11-07 15:04:44","2023-11-07 15:04:44");
INSERT INTO product_sales VALUES("1056","678","1173","","","","1","1","30","0","0","0","30","2023-11-07 15:06:59","2023-11-07 15:06:59");
INSERT INTO product_sales VALUES("1057","679","1216","","","","1","1","310","0","0","0","310","2023-11-07 15:35:31","2023-11-07 15:35:31");
INSERT INTO product_sales VALUES("1058","680","1288","","","","1","1","530","0","0","0","530","2023-11-07 15:44:41","2023-11-07 15:44:41");
INSERT INTO product_sales VALUES("1059","680","1286","","","","1","1","2270","0","0","0","2270","2023-11-07 15:44:41","2023-11-07 15:44:41");
INSERT INTO product_sales VALUES("1060","680","1290","","","","1","1","145","0","0","0","145","2023-11-07 15:44:41","2023-11-07 15:44:41");
INSERT INTO product_sales VALUES("1061","681","1287","","","","1","1","320","0","0","0","320","2023-11-07 16:34:37","2023-11-07 16:34:37");
INSERT INTO product_sales VALUES("1062","682","1132","","","","1","1","400","0","0","0","400","2023-11-07 19:32:45","2023-11-07 19:32:45");
INSERT INTO product_sales VALUES("1063","683","1281","","","","1","1","215","0","0","0","215","2023-11-08 12:58:36","2023-11-08 12:58:36");
INSERT INTO product_sales VALUES("1064","683","1321","","","","1","1","220","0","0","0","220","2023-11-08 12:58:36","2023-11-08 12:58:36");
INSERT INTO product_sales VALUES("1065","683","1320","","","","1","1","230","0","0","0","230","2023-11-08 12:58:36","2023-11-08 12:58:36");
INSERT INTO product_sales VALUES("1066","683","1133","","","","2","1","100","0","0","0","200","2023-11-08 12:58:36","2023-11-08 12:58:36");
INSERT INTO product_sales VALUES("1067","684","1214","","","","1","1","2860","0","0","0","2860","2023-11-08 13:05:02","2023-11-08 13:05:02");
INSERT INTO product_sales VALUES("1068","685","1358","","","","2","1","510","0","0","0","1020","2023-11-08 13:51:34","2023-11-08 13:51:34");
INSERT INTO product_sales VALUES("1069","685","1301","","","","2","1","480","0","0","0","960","2023-11-08 13:51:34","2023-11-08 13:51:34");
INSERT INTO product_sales VALUES("1070","686","1292","","","","2","1","220","0","0","0","440","2023-11-08 15:22:35","2023-11-08 15:22:35");
INSERT INTO product_sales VALUES("1071","686","1314","","","","1","1","0","0","0","0","0","2023-11-08 15:22:35","2023-11-08 15:22:35");
INSERT INTO product_sales VALUES("1072","686","1291","","","","1","1","1690","0","0","0","1690","2023-11-08 15:22:35","2023-11-08 15:22:35");
INSERT INTO product_sales VALUES("1073","687","1144","","","","1","1","960","0","0","0","960","2023-11-09 16:16:57","2023-11-09 16:16:57");
INSERT INTO product_sales VALUES("1074","687","1139","","","","2","1","170","0","0","0","340","2023-11-09 16:16:57","2023-11-09 16:16:57");
INSERT INTO product_sales VALUES("1075","687","1164","","","","1","1","865","0","0","0","865","2023-11-09 16:16:57","2023-11-09 16:16:57");
INSERT INTO product_sales VALUES("1076","687","1163","","","","1","1","550","0","0","0","550","2023-11-09 16:16:57","2023-11-09 16:16:57");
INSERT INTO product_sales VALUES("1077","688","1325","","","","1","1","2040","0","0","0","2040","2023-11-09 16:18:16","2023-11-09 16:18:16");
INSERT INTO product_sales VALUES("1078","689","1327","","","","1","1","360","0","0","0","360","2023-11-09 19:35:52","2023-11-09 19:35:52");
INSERT INTO product_sales VALUES("1079","689","1218","","","","1","1","1640","0","0","0","1640","2023-11-09 19:35:52","2023-11-09 19:35:52");
INSERT INTO product_sales VALUES("1080","690","1148","","","","2","1","20","0","0","0","40","2023-11-09 19:44:22","2023-11-09 19:44:22");
INSERT INTO product_sales VALUES("1081","690","1146","","","","1","1","1720","0","0","0","1720","2023-11-09 19:44:22","2023-11-09 19:44:22");
INSERT INTO product_sales VALUES("1082","690","1144","","","","1","1","960","0","0","0","960","2023-11-09 19:44:22","2023-11-09 19:44:22");
INSERT INTO product_sales VALUES("1083","691","1280","","","","1","1","180","0","0","0","180","2023-11-09 19:55:03","2023-11-09 19:55:03");
INSERT INTO product_sales VALUES("1084","692","1381","","","","2","1","10","0","0","0","20","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO product_sales VALUES("1085","692","1139","","","","2","1","170","0","0","0","340","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO product_sales VALUES("1086","692","1163","","","","1","1","550","0","0","0","550","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO product_sales VALUES("1087","692","1164","","","","1","1","865","0","0","0","865","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO product_sales VALUES("1088","692","1144","","","","1","1","960","0","0","0","960","2023-11-09 19:57:42","2023-11-09 19:57:42");
INSERT INTO product_sales VALUES("1089","693","1236","","","","1","1","760","0","0","0","760","2023-11-09 20:03:17","2023-11-09 20:03:17");
INSERT INTO product_sales VALUES("1090","694","1144","","","","1","1","960","0","0","0","960","2023-11-09 20:06:11","2023-11-09 20:06:11");
INSERT INTO product_sales VALUES("1091","694","1164","","","","1","1","865","0","0","0","865","2023-11-09 20:06:11","2023-11-09 20:06:11");
INSERT INTO product_sales VALUES("1092","694","1163","","","","1","1","550","0","0","0","550","2023-11-09 20:06:11","2023-11-09 20:06:11");
INSERT INTO product_sales VALUES("1093","694","1139","","","","2","1","170","0","0","0","340","2023-11-09 20:06:11","2023-11-09 20:06:11");
INSERT INTO product_sales VALUES("1094","695","1252","","","","1","1","75","0","0","0","75","2023-11-09 21:18:48","2023-11-09 21:18:48");
INSERT INTO product_sales VALUES("1095","696","1288","","","","1","1","530","0","0","0","530","2023-11-09 21:36:16","2023-11-09 21:36:16");
INSERT INTO product_sales VALUES("1096","697","1264","","","","1","1","90","0","0","0","90","2023-11-10 12:33:35","2023-11-10 12:33:35");
INSERT INTO product_sales VALUES("1097","698","1162","","","","1","1","435","0","0","0","435","2023-11-10 12:34:31","2023-11-10 12:34:31");
INSERT INTO product_sales VALUES("1098","698","1160","","","","1","1","320","0","0","0","320","2023-11-10 12:34:31","2023-11-10 12:34:31");
INSERT INTO product_sales VALUES("1099","698","1155","","","","1","1","220","0","0","0","220","2023-11-10 12:34:31","2023-11-10 12:34:31");
INSERT INTO product_sales VALUES("1100","698","1152","","","","1","1","570","0","0","0","570","2023-11-10 12:34:31","2023-11-10 12:34:31");
INSERT INTO product_sales VALUES("1101","699","1240","","","","1","1","75","0","0","0","75","2023-11-10 20:21:00","2023-11-10 20:21:00");
INSERT INTO product_sales VALUES("1102","700","1213","","","","2","1","620","0","0","0","1240","2023-11-11 12:50:46","2023-11-11 12:50:46");
INSERT INTO product_sales VALUES("1103","701","1213","","","","2","1","620","0","0","0","1240","2023-11-11 13:16:23","2023-11-11 13:16:23");
INSERT INTO product_sales VALUES("1104","702","1215","","","","1","1","1690","0","0","0","1690","2023-11-11 15:11:22","2023-11-11 15:11:22");
INSERT INTO product_sales VALUES("1105","703","1317","","","","3","1","200","0","0","0","600","2023-11-11 18:13:04","2023-11-11 18:13:04");
INSERT INTO product_sales VALUES("1106","704","1159","","","","1","1","35","0","0","0","35","2023-11-11 21:22:02","2023-11-11 21:22:02");
INSERT INTO product_sales VALUES("1107","705","1216","","","","1","1","310","0","0","0","310","2023-11-12 17:57:01","2023-11-12 17:57:01");
INSERT INTO product_sales VALUES("1108","706","1192","","","","4","1","540","0","0","0","2160","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO product_sales VALUES("1109","706","1287","","","","1","1","320","0","0","0","320","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO product_sales VALUES("1110","706","1357","","","","2","1","395","0","0","0","790","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO product_sales VALUES("1111","706","1356","","","","1","1","280","0","0","0","280","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO product_sales VALUES("1112","706","1355","","","","1","1","305","0","0","0","305","2023-11-12 19:18:50","2023-11-12 19:18:50");
INSERT INTO product_sales VALUES("1113","707","1243","","","","1","1","2680","0","0","0","2680","2023-11-12 21:24:54","2023-11-12 21:24:54");
INSERT INTO product_sales VALUES("1114","708","1216","","","","1","1","310","0","0","0","310","2023-11-13 12:19:13","2023-11-13 12:19:13");
INSERT INTO product_sales VALUES("1115","709","1280","","","","1","1","180","0","0","0","180","2023-11-13 12:45:52","2023-11-13 12:45:52");
INSERT INTO product_sales VALUES("1116","710","1278","","","","1","1","405","0","0","0","405","2023-11-13 18:24:12","2023-11-13 18:24:12");
INSERT INTO product_sales VALUES("1117","711","1216","","","","1","1","310","0","0","0","310","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1118","711","1219","","","","3","1","75","0","0","0","225","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1119","711","1131","","","","1","1","470","0","0","0","470","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1120","711","1162","","","","1","1","435","0","0","0","435","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1121","711","1160","","","","1","1","320","0","0","0","320","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1122","711","1155","","","","4","1","220","0","0","0","880","2023-11-15 14:28:46","2023-11-15 14:28:46");
INSERT INTO product_sales VALUES("1123","712","1287","","","","3","1","320","0","0","0","960","2023-11-17 14:49:00","2023-11-17 14:49:00");
INSERT INTO product_sales VALUES("1124","713","1248","","","","3","1","120","0","0","0","360","2023-11-17 14:52:12","2023-11-17 14:52:12");
INSERT INTO product_sales VALUES("1125","713","1369","","","","1","1","10","0","0","0","10","2023-11-17 14:52:12","2023-11-17 14:52:12");
INSERT INTO product_sales VALUES("1126","714","1216","","","","1","1","310","0","0","0","310","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1127","714","1139","","","","2","1","170","0","0","0","340","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1128","714","1155","","","","1","1","220","0","0","0","220","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1129","714","1162","","","","1","1","435","0","0","0","435","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1130","714","1160","","","","1","1","320","0","0","0","320","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1131","714","1164","","","","1","1","865","0","0","0","865","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1132","714","1163","","","","1","1","550","0","0","0","550","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1133","714","1152","","","","1","1","570","0","0","0","570","2023-11-20 14:21:10","2023-11-20 14:21:10");
INSERT INTO product_sales VALUES("1134","715","1332","","","","1","1","1120","0","0","0","1120","2023-11-21 17:24:42","2023-11-21 17:24:42");
INSERT INTO product_sales VALUES("1135","716","1159","","","","1","1","35","0","0","0","35","2023-11-22 12:26:19","2023-11-22 12:26:19");
INSERT INTO product_sales VALUES("1156","722","1133","","","","1","1","100","0","0","0","100","2023-11-25 17:51:29","2023-11-25 17:51:29");
INSERT INTO product_sales VALUES("1157","722","1131","","","","1","1","470","0","0","0","470","2023-11-25 17:51:29","2023-11-25 17:51:29");
INSERT INTO product_sales VALUES("1158","723","1359","","","","1","1","590","0","0","0","590","2023-11-27 18:09:42","2023-11-27 18:09:42");
INSERT INTO product_sales VALUES("1159","724","1268","","","","1","1","2070","0","0","0","2070","2023-11-27 20:23:48","2023-11-27 20:23:48");
INSERT INTO product_sales VALUES("1160","725","1312","","","","1","1","300","0","0","0","300","2023-11-29 16:29:34","2023-11-29 16:29:34");
INSERT INTO product_sales VALUES("1161","725","1140","","","","1","1","400","0","0","0","400","2023-11-29 16:29:35","2023-11-29 16:29:35");
INSERT INTO product_sales VALUES("1162","725","1265","","","","1","1","500","0","0","0","500","2023-11-29 16:29:35","2023-11-29 16:29:35");
INSERT INTO product_sales VALUES("1163","726","1356","","","","1","1","280","0","0","0","280","2023-12-01 17:05:03","2023-12-01 17:05:03");
INSERT INTO product_sales VALUES("1164","727","1356","","","","1","1","280","0","0","0","280","2023-12-01 17:05:04","2023-12-01 17:05:04");
INSERT INTO product_sales VALUES("1165","728","1216","","","","1","1","310","0","0","0","310","2023-12-14 18:33:27","2023-12-14 18:33:27");
INSERT INTO product_sales VALUES("1173","736","1387","","","","3","1","150","0","0","0","450","2025-01-18 22:48:16","2025-01-18 22:48:16");
INSERT INTO product_sales VALUES("1174","737","1387","","","","3","1","150","0","0","0","450","2025-01-18 22:48:17","2025-01-18 22:48:17");
INSERT INTO product_sales VALUES("1175","738","1387","","","","3","1","150","0","0","0","450","2025-01-18 22:49:01","2025-01-18 22:49:01");
INSERT INTO product_sales VALUES("1178","740","1385","","","","7","1","55","0","0","0","385","2025-01-23 15:10:36","2025-01-23 15:10:36");
INSERT INTO product_sales VALUES("1179","740","1387","","","","1","1","150","0","0","0","150","2025-01-23 15:10:36","2025-01-23 15:10:36");
INSERT INTO product_sales VALUES("1188","742","1461","","","","1","1","150","0","0","0","150","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1189","742","1410","","","","3","2","70","0","0","0","210","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1190","742","1442","","","","2","2","70","0","0","0","140","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1191","742","1421","","","","1","4","100","0","0","0","100","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1192","742","1430","","","","1","9","100","0","0","0","100","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1193","742","1460","","","","1","1","180","0","0","0","180","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1194","742","1440","","","","1","3","250","0","0","0","250","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1195","742","1444","","","","2","2","100","0","0","0","200","2025-03-18 17:34:23","2025-03-18 17:34:23");
INSERT INTO product_sales VALUES("1196","743","1410","","","","3","2","70","0","0","0","210","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1197","743","1421","","","","1","4","100","0","0","0","100","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1198","743","1430","","","","1","9","100","0","0","0","100","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1199","743","1460","","","","1","1","180","0","0","0","180","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1200","743","1440","","","","1","3","250","0","0","0","250","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1201","743","1444","","","","1","2","100","0","0","0","100","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1202","743","1461","","","","3","1","150","0","0","0","450","2025-03-18 18:04:46","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1203","743","1443","","","","2","2","140","0","0","0","280","2025-03-18 18:16:53","2025-03-18 18:16:53");
INSERT INTO product_sales VALUES("1204","744","1417","","","","6","1","20","0","0","0","120","2025-03-19 19:19:05","2025-03-19 19:41:17");
INSERT INTO product_sales VALUES("1205","744","1416","","","","3","1","30","0","0","0","90","2025-03-19 19:19:05","2025-03-19 19:41:17");
INSERT INTO product_sales VALUES("1206","744","1418","","","","1","5","200","0","0","0","200","2025-03-19 19:19:05","2025-03-19 19:41:17");
INSERT INTO product_sales VALUES("1207","744","1462","","","","2","2","75","0","0","0","150","2025-03-19 19:19:05","2025-03-19 19:41:17");
INSERT INTO product_sales VALUES("1208","744","1463","","","","1","1","80","0","0","0","80","2025-03-19 19:19:05","2025-03-19 19:41:18");
INSERT INTO product_sales VALUES("1209","744","1430","","","","2","9","100","0","0","0","200","2025-03-19 19:19:05","2025-03-19 19:41:18");
INSERT INTO product_sales VALUES("1210","744","1408","","","","3","2","120","0","0","0","360","2025-03-19 19:19:06","2025-03-19 19:41:18");
INSERT INTO product_sales VALUES("1211","744","1410","","","","3","2","80","0","0","0","240","2025-03-19 19:19:06","2025-03-19 19:41:18");
INSERT INTO product_sales VALUES("1212","744","1409","","","","6","2","110","0","0","0","660","2025-03-19 19:19:06","2025-03-19 19:41:18");
INSERT INTO product_sales VALUES("1213","744","1464","","","","2","1","20","0","0","0","40","2025-03-19 19:41:17","2025-03-19 19:41:17");
INSERT INTO product_sales VALUES("1214","745","1411","","","","2","2","120","0","0","0","240","2025-03-19 20:00:19","2025-03-19 20:00:19");
INSERT INTO product_sales VALUES("1215","745","1410","","","","2","2","80","0","0","0","160","2025-03-19 20:00:19","2025-03-19 20:00:19");
INSERT INTO product_sales VALUES("1216","745","1443","","","","4","2","70","0","0","0","280","2025-03-19 20:00:19","2025-03-19 20:00:19");
INSERT INTO product_sales VALUES("1226","747","1401","","","","1","21","150","0","0","0","150","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1227","747","1468","","","","1","2","150","0","0","0","150","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1228","747","1411","","","","2","2","120","0","0","0","240","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1229","747","1409","","","","1","2","110","0","0","0","110","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1230","747","1385","","","","2","1","70","0","0","0","140","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1231","747","1467","","","","1","1","100","0","0","0","100","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1232","747","1466","","","","1","1","100","0","0","0","100","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1233","747","1465","","","","3","2","80","0","0","0","240","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1234","747","1410","","","","6","2","70","0","0","0","420","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1235","747","1417","","","","3","1","20","0","0","0","60","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1236","747","1443","","","","3","2","70","0","0","0","210","2025-03-21 12:10:55","2025-03-21 12:10:55");
INSERT INTO product_sales VALUES("1257","750","1472","","","","1","1","280","0","0","0","280","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1258","750","1469","","","","6","1","20","0","0","0","120","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1259","750","1471","","","","3","1","30","0","0","0","90","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1260","750","1468","","","","1","2","150","0","0","0","150","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1261","750","1395","","","","1","21","120","0","0","0","120","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1262","750","1408","","","","1","2","120","0","0","0","120","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1263","750","1443","","","","4","2","100","0","0","0","400","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1264","750","1417","","","","2","1","20","0","0","0","40","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1265","750","1402","","","","1","5","100","0","0","0","100","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1266","750","1410","","","","3","2","70","0","0","0","210","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1267","750","1444","","","","1","2","100","0","0","0","100","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1268","750","1465","","","","1","2","80","0","0","0","80","2025-03-21 12:54:19","2025-03-21 12:54:19");
INSERT INTO product_sales VALUES("1274","752","1406","","","","1","4","200","0","0","0","200","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1275","752","1446","","","","1","2","80","0","0","0","80","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1276","752","1421","","","","1","4","100","0","0","0","100","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1277","752","1417","","","","1","1","20","0","0","0","20","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1278","752","1443","","","","4","2","70","0","0","0","280","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1279","752","1444","","","","3","2","100","0","0","0","300","2025-03-21 13:06:13","2025-03-21 13:06:13");
INSERT INTO product_sales VALUES("1308","756","1409","","","","4","2","100","0","0","0","400","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1309","756","1470","","","","1","1","160","0","0","0","160","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1310","756","1387","","","","1","1","180","0","0","0","180","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1311","756","1471","","","","1","1","30","0","0","0","30","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1312","756","1406","","","","2","4","180","0","0","0","360","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1313","756","1466","","","","1","1","100","0","0","0","100","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1314","756","1450","","","","1","2","200","0","0","0","200","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1315","756","1432","","","","2","23","100","0","0","0","200","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1316","756","1423","","","","1","1","270","0","0","0","270","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1317","756","1473","","","","3","1","45","0","0","0","135","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1318","756","1410","","","","6","2","80","0","0","0","480","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1319","756","1408","","","","1","2","120","0","0","0","120","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1320","756","1417","","","","7","1","20","0","0","0","140","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1321","756","1400","","","","1","5","250","0","0","0","250","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1322","756","1443","","","","4","2","70","0","0","0","280","2025-03-21 20:37:41","2025-03-21 20:37:41");
INSERT INTO product_sales VALUES("1323","757","1469","","","","1","1","20","0","0","0","20","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1324","757","1417","","","","1","1","20","0","0","0","20","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1325","757","1423","","","","1","1","300","0","0","0","300","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1326","757","1418","","","","1","5","200","0","0","0","200","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1327","757","1409","","","","2","2","105","0","0","0","210","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1328","757","1410","","","","2","2","80","0","0","0","160","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1329","757","1443","","","","2","2","60","0","0","0","120","2025-03-21 20:49:02","2025-03-21 20:49:02");
INSERT INTO product_sales VALUES("1330","758","1397","","","","3","2","100","0","0","0","300","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1331","758","1470","","","","2","1","100","0","0","0","200","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1332","758","1385","","","","1","1","35","0","0","0","35","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1333","758","1396","","","","1","3","20","0","0","0","20","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1334","758","1409","","","","3","2","100","0","0","0","300","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1335","758","1408","","","","3","2","120","0","0","0","360","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1336","758","1410","","","","4","2","80","0","0","0","320","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1337","758","1417","","","","2","1","20","0","0","0","40","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1338","758","1443","","","","7","2","70","0","0","0","490","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1339","758","1406","","","","1","4","180","0","0","0","180","2025-03-21 21:30:10","2025-03-21 21:30:10");
INSERT INTO product_sales VALUES("1340","759","1443","","","","4","2","70","0","0","0","280","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1341","759","1387","","","","1","1","150","0","0","0","150","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1342","759","1417","","","","1","1","20","0","0","0","20","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1343","759","1425","","","","1","17","180","0","0","0","180","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1344","759","1409","","","","2","2","110","0","0","0","220","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1345","759","1408","","","","4","2","120","0","0","0","480","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1346","759","1410","","","","8","2","70","0","0","0","560","2025-03-21 21:38:25","2025-03-21 21:38:25");
INSERT INTO product_sales VALUES("1354","762","1423","","","","1","1","250","0","0","0","250","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO product_sales VALUES("1355","762","1408","","","","2","2","150","0","0","0","300","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO product_sales VALUES("1356","762","1443","","","","4","2","70","0","0","0","280","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO product_sales VALUES("1357","762","1465","","","","1","2","120","0","0","0","120","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO product_sales VALUES("1358","762","1425","","","","1","17","180","0","0","0","180","2025-03-22 12:37:56","2025-03-22 12:37:56");
INSERT INTO product_sales VALUES("1359","763","1444","","","","1","2","100","0","0","0","100","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1360","763","1387","","","","1","1","150","0","0","0","150","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1361","763","1430","","","","1","9","100","0","0","0","100","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1362","763","1473","","","","1","1","50","0","0","0","50","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1363","763","1418","","","","1","5","200","0","0","0","200","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1364","763","1411","","","","10","2","110","0","0","0","1100","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1365","763","1443","","","","5","2","70","0","0","0","350","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1366","763","1475","","","","1","1","100","0","0","0","100","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1367","763","1401","","","","1","21","150","0","0","0","150","2025-03-22 12:46:50","2025-03-22 12:46:50");
INSERT INTO product_sales VALUES("1374","765","1443","","","","1","2","70","0","0","0","70","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1375","765","1409","","","","1","2","100","0","0","0","100","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1376","765","1444","","","","4","2","100","0","0","0","400","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1377","765","1430","","","","1","9","150","0","0","0","150","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1378","765","1406","","","","1","4","200","0","0","0","200","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1379","765","1410","","","","5","2","70","0","0","0","350","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1380","765","1476","","","","4","1","30","0","0","0","120","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1381","765","1465","","","","3","2","80","0","0","0","240","2025-03-22 13:01:17","2025-03-22 13:01:17");
INSERT INTO product_sales VALUES("1469","771","1479","","","","2","1","250","0","0","0","500","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1470","771","1468","","","","3","2","150","0","0","0","450","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1471","771","1416","","","","7","1","30","0","0","0","210","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1472","771","1444","","","","3","2","100","0","0","0","300","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1473","771","1409","","","","2","2","100","0","0","0","200","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1474","771","1411","","","","1","2","110","0","0","0","110","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1475","771","1443","","","","3","2","70","0","0","0","210","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1476","771","1476","","","","4","1","40","0","0","0","160","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1477","771","1410","","","","13","2","70","0","0","0","910","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1478","771","1422","","","","1","1","100","0","0","0","100","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1479","771","1417","","","","6","1","20","0","0","0","120","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1480","771","1478","","","","1","1","130","0","0","0","130","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1481","771","1402","","","","1","5","100","0","0","0","100","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1482","771","1408","","","","2","2","120","0","0","0","240","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1483","771","1421","","","","1","4","100","0","0","0","100","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1484","771","1469","","","","1","1","20","0","0","0","20","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1485","771","1423","","","","1","1","270","0","0","0","270","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1486","771","1432","","","","1","23","100","0","0","0","100","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1487","771","1477","","","","1","1","220","0","0","0","220","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1488","771","1415","","","","2","4","90","0","0","0","180","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1489","771","1465","","","","3","2","112","0","0","0","336","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1490","771","1470","","","","2","1","100","0","0","0","200","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1491","771","1385","","","","2","1","55","0","0","0","110","2025-03-22 14:37:18","2025-03-22 16:16:59");
INSERT INTO product_sales VALUES("1492","772","1385","","","","1","1","100","0","0","0","100","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1493","772","1469","","","","2","1","20","0","0","0","40","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1494","772","1408","","","","1","2","120","0","0","0","120","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1495","772","1444","","","","2","2","100","0","0","0","200","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1496","772","1465","","","","2","2","80","0","0","0","160","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1497","772","1409","","","","1","2","100","0","0","0","100","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1498","772","1410","","","","6","2","70","0","0","0","420","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1499","772","1417","","","","1","1","20","0","0","0","20","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1500","772","1468","","","","1","2","150","0","0","0","150","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1501","772","1443","","","","4","2","70","0","0","0","280","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1502","772","1396","","","","2","3","70","0","0","0","140","2025-03-22 16:30:06","2025-03-22 16:30:06");
INSERT INTO product_sales VALUES("1513","774","1409","","","","1","2","110","0","0","0","110","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1514","774","1404","","","","2","10","200","0","0","0","400","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1515","774","1465","","","","1","2","80","0","0","0","80","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1516","774","1443","","","","1","2","70","0","0","0","70","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1517","774","1408","","","","3","2","120","0","0","0","360","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1518","774","1444","","","","1","2","95","0","0","0","95","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1519","774","1417","","","","1","1","20","0","0","0","20","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1520","774","1481","","","","1","1","130","0","0","0","130","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1521","774","1480","","","","1","1","180","0","0","0","180","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1522","774","1410","","","","7","2","70","0","0","0","490","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1523","774","1464","","","","1","1","20","0","0","0","20","2025-03-22 16:49:30","2025-03-22 16:49:30");
INSERT INTO product_sales VALUES("1524","775","1406","","","","1","4","200","0","0","0","200","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1525","775","1446","","","","1","2","80","0","0","0","80","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1526","775","1444","","","","1","2","95","0","0","0","95","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1527","775","1417","","","","2","1","20","0","0","0","40","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1528","775","1465","","","","1","2","70","0","0","0","70","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1529","775","1409","","","","1","2","110","0","0","0","110","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1530","775","1443","","","","4","2","70","0","0","0","280","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1531","775","1402","","","","2","5","100","0","0","0","200","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1532","775","1462","","","","3","2","70","0","0","0","210","2025-03-22 16:57:32","2025-03-22 16:57:32");
INSERT INTO product_sales VALUES("1533","776","1418","","","","1","5","200","0","0","0","200","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1534","776","1411","","","","1","2","110","0","0","0","110","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1535","776","1410","","","","1","2","80","0","0","0","80","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1536","776","1443","","","","12","2","70","0","0","0","840","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1537","776","1385","","","","2","1","70","0","0","0","140","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1538","776","1417","","","","2","1","20","0","0","0","40","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1539","776","1409","","","","1","2","100","0","0","0","100","2025-03-22 17:01:50","2025-03-22 17:01:50");
INSERT INTO product_sales VALUES("1540","777","1401","","","","1","21","150","0","0","0","150","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1541","777","1389","","","","1","2","150","0","0","0","150","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1542","777","1430","","","","1","9","100","0","0","0","100","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1543","777","1469","","","","1","1","20","0","0","0","20","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1544","777","1444","","","","1","2","100","0","0","0","100","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1545","777","1465","","","","1","2","112","0","0","0","112","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1546","777","1385","","","","2","1","55","0","0","0","110","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1547","777","1443","","","","8","2","70","0","0","0","560","2025-03-22 17:10:14","2025-03-22 17:10:14");
INSERT INTO product_sales VALUES("1548","778","1416","","","","2","1","30","0","0","0","60","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1549","778","1481","","","","1","1","130","0","0","0","130","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1550","778","1407","","","","14","2","50","0","0","0","700","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1551","778","1432","","","","1","23","100","0","0","0","100","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1552","778","1417","","","","2","1","20","0","0","0","40","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1553","778","1408","","","","1","2","120","0","0","0","120","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1554","778","1443","","","","4","2","70","0","0","0","280","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1555","778","1409","","","","3","2","110","0","0","0","330","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1556","778","1410","","","","5","2","70","0","0","0","350","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1557","778","1430","","","","2","9","100","0","0","0","200","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1558","778","1465","","","","2","2","80","0","0","0","160","2025-03-22 17:23:57","2025-03-22 17:23:57");
INSERT INTO product_sales VALUES("1559","779","1385","","","","2","1","55","0","0","0","110","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1560","779","1409","","","","1","2","100","0","0","0","100","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1561","779","1401","","","","1","21","140","0","0","0","140","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1562","779","1441","","","","1","4","160","0","0","0","160","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1563","779","1413","","","","1","1","400","0","0","0","400","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1564","779","1407","","","","15","2","50","0","0","0","750","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1565","779","1417","","","","3","1","20","0","0","0","60","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1566","779","1411","","","","1","2","110","0","0","0","110","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1567","779","1408","","","","5","2","120","0","0","0","600","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1568","779","1410","","","","7","2","70","0","0","0","490","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1569","779","1477","","","","1","1","220","0","0","0","220","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1570","779","1483","","","","1","1","220","0","0","0","220","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1571","779","1444","","","","2","2","95","0","0","0","190","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1572","779","1460","","","","1","1","180","0","0","0","180","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1573","779","1443","","","","7","2","70","0","0","0","490","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1574","779","1402","","","","1","5","100","0","0","0","100","2025-03-22 17:45:49","2025-03-22 17:45:49");
INSERT INTO product_sales VALUES("1591","782","1428","","","","1","9","150","0","0","0","150","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1592","782","1430","","","","2","9","100","0","0","0","200","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1593","782","1410","","","","6","2","80","0","0","0","480","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1594","782","1408","","","","9","2","120","0","0","0","1080","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1595","782","1465","","","","1","2","80","0","0","0","80","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1596","782","1425","","","","2","17","150","0","0","0","300","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1597","782","1443","","","","3","2","70","0","0","0","210","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1598","782","1411","","","","6","2","110","0","0","0","660","2025-03-22 18:24:18","2025-03-22 18:24:18");
INSERT INTO product_sales VALUES("1599","783","1430","","","","1","9","100","0","0","0","100","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1600","783","1385","","","","1","1","70","0","0","0","70","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1601","783","1423","","","","1","1","270","0","0","0","270","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1602","783","1441","","","","1","4","160","0","0","0","160","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1603","783","1444","","","","1","2","100","0","0","0","100","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1604","783","1424","","","","1","6","140","0","0","0","140","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1605","783","1411","","","","1","2","110","0","0","0","110","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1606","783","1415","","","","1","4","80","0","0","0","80","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1607","783","1465","","","","1","2","112","0","0","0","112","2025-03-22 18:35:18","2025-03-22 18:36:11");
INSERT INTO product_sales VALUES("1608","784","1385","","","","1","1","70","0","0","0","70","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1609","784","1443","","","","2","2","70","0","0","0","140","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1610","784","1460","","","","1","1","170","0","0","0","170","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1611","784","1407","","","","1","2","50","0","0","0","50","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1612","784","1417","","","","1","1","20","0","0","0","20","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1613","784","1408","","","","2","2","120","0","0","0","240","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1614","784","1432","","","","1","23","100","0","0","0","100","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1615","784","1418","","","","2","5","180","0","0","0","360","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1616","784","1401","","","","1","21","150","0","0","0","150","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1617","784","1444","","","","2","2","95","0","0","0","190","2025-03-22 18:46:53","2025-03-22 18:46:53");
INSERT INTO product_sales VALUES("1618","785","1410","","","","1","2","70","0","0","0","70","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO product_sales VALUES("1619","785","1385","","","","1","1","70","0","0","0","70","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO product_sales VALUES("1620","785","1476","","","","1","1","30","0","0","0","30","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO product_sales VALUES("1621","785","1444","","","","1","2","95","0","0","0","95","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO product_sales VALUES("1622","785","1443","","","","5","2","70","0","0","0","350","2025-03-22 18:50:27","2025-03-22 18:50:27");
INSERT INTO product_sales VALUES("1624","787","1465","","","","2","2","80","0","0","0","160","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1625","787","1409","","","","2","2","110","0","0","0","220","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1626","787","1481","","","","1","1","140","0","0","0","140","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1627","787","1408","","","","1","2","180","0","0","0","180","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1628","787","1404","","","","1","10","180","0","0","0","180","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1629","787","1407","","","","3","2","50","0","0","0","150","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1630","787","1443","","","","7","2","70","0","0","0","490","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1631","787","1444","","","","2","2","95","0","0","0","190","2025-03-22 19:05:20","2025-03-22 19:05:20");
INSERT INTO product_sales VALUES("1636","789","1393","","","","1","3","80","0","0","0","80","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1637","789","1444","","","","1","2","95","0","0","0","95","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1638","789","1385","","","","1","1","35","0","0","0","35","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1639","789","1485","","","","1","1","350","0","0","0","350","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1640","789","1410","","","","21","2","70","0","0","0","1470","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1641","789","1411","","","","1","2","120","0","0","0","120","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1642","789","1413","","","","1","1","400","0","0","0","400","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1643","789","1409","","","","6","2","110","0","0","0","660","2025-03-22 19:19:40","2025-03-22 19:19:40");
INSERT INTO product_sales VALUES("1652","791","1408","","","","4","2","120","0","0","0","480","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1653","791","1409","","","","5","2","110","0","0","0","550","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1654","791","1411","","","","6","2","120","0","0","0","720","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1655","791","1422","","","","1","1","100","0","0","0","100","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1656","791","1401","","","","1","21","150","0","0","0","150","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1657","791","1410","","","","9","2","70","0","0","0","630","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1658","791","1444","","","","3","2","95","0","0","0","285","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1659","791","1402","","","","1","5","120","0","0","0","120","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1660","791","1439","","","","1","4","140","0","0","0","140","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1661","791","1473","","","","2","1","45","0","0","0","90","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1662","791","1486","","","","2","1","150","0","0","0","300","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1663","791","1417","","","","2","1","20","0","0","0","40","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1664","791","1443","","","","2","2","70","0","0","0","140","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1665","791","1465","","","","1","2","112","0","0","0","112","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1666","791","1389","","","","2","2","150","0","0","0","300","2025-03-22 19:40:15","2025-03-22 19:40:15");
INSERT INTO product_sales VALUES("1667","792","1408","","","","1","2","60","0","0","0","60","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1668","792","1402","","","","1","5","120","0","0","0","120","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1669","792","1410","","","","1","2","70","0","0","0","70","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1670","792","1443","","","","1","2","70","0","0","0","70","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1671","792","1465","","","","1","2","80","0","0","0","80","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1672","792","1417","","","","1","1","20","0","0","0","20","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1673","792","1430","","","","1","9","100","0","0","0","100","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1674","792","1467","","","","1","1","100","0","0","0","100","2025-03-22 19:47:35","2025-03-22 19:47:35");
INSERT INTO product_sales VALUES("1675","793","1444","","","","1","2","145","0","0","0","145","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1676","793","1469","","","","1","1","20","0","0","0","20","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1677","793","1410","","","","1","2","105","0","0","0","105","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1678","793","1418","","","","1","5","200","0","0","0","200","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1679","793","1487","","","","1","1","400","0","0","0","400","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1680","793","1411","","","","1","2","120","0","0","0","120","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1681","793","1465","","","","1","2","80","0","0","0","80","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1682","793","1443","","","","2","2","70","0","0","0","140","2025-03-22 19:59:40","2025-03-22 19:59:40");
INSERT INTO product_sales VALUES("1683","794","1417","","","","1","1","20","0","0","0","20","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1684","794","1409","","","","1","2","55","0","0","0","55","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1685","794","1443","","","","3","2","70","0","0","0","210","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1686","794","1406","","","","1","4","200","0","0","0","200","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1687","794","1444","","","","2","2","115","0","0","0","230","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1688","794","1410","","","","2","2","95","0","0","0","190","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1689","794","1465","","","","1","2","120","0","0","0","120","2025-03-22 20:08:44","2025-03-22 20:08:44");
INSERT INTO product_sales VALUES("1690","795","1467","","","","1","1","200","0","0","0","200","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1691","795","1417","","","","1","1","20","0","0","0","20","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1692","795","1450","","","","1","2","230","0","0","0","230","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1693","795","1424","","","","1","6","150","0","0","0","150","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1694","795","1483","","","","1","1","220","0","0","0","220","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1695","795","1428","","","","1","9","150","0","0","0","150","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1696","795","1427","","","","1","10","330","0","0","0","330","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1697","795","1422","","","","2","1","100","0","0","0","200","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1698","795","1418","","","","1","5","190","0","0","0","190","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1699","795","1410","","","","1","2","35","0","0","0","35","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1700","795","1396","","","","1","3","70","0","0","0","70","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1701","795","1443","","","","3","2","70","0","0","0","210","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1702","795","1444","","","","2","2","95","0","0","0","190","2025-03-24 18:18:19","2025-03-24 18:18:19");
INSERT INTO product_sales VALUES("1703","796","1408","","","","1","2","120","0","0","0","120","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1704","796","1427","","","","1","10","330","0","0","0","330","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1705","796","1444","","","","1","2","100","0","0","0","100","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1706","796","1481","","","","1","1","130","0","0","0","130","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1707","796","1415","","","","1","4","80","0","0","0","80","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1708","796","1410","","","","1","2","70","0","0","0","70","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1709","796","1440","","","","1","3","220","0","0","0","220","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1710","796","1417","","","","1","1","20","0","0","0","20","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1711","796","1443","","","","5","2","70","0","0","0","350","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1712","796","1411","","","","3","2","120","0","0","0","360","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1713","796","1409","","","","2","2","100","0","0","0","200","2025-03-24 19:05:05","2025-03-24 19:05:05");
INSERT INTO product_sales VALUES("1714","797","1487","","","","1","1","420","0","0","0","420","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO product_sales VALUES("1715","797","1418","","","","1","5","190","0","0","0","190","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO product_sales VALUES("1716","797","1465","","","","2","2","60","0","0","0","120","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO product_sales VALUES("1717","797","1443","","","","5","2","70","0","0","0","350","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO product_sales VALUES("1718","797","1444","","","","1","2","50","0","0","0","50","2025-03-24 19:13:12","2025-03-24 19:13:12");
INSERT INTO product_sales VALUES("1719","798","1436","","","","1","23","130","0","0","0","130","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1720","798","1406","","","","1","4","170","0","0","0","170","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1721","798","1444","","","","2","2","95","0","0","0","190","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1722","798","1411","","","","2","2","110","0","0","0","220","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1723","798","1465","","","","3","2","70","0","0","0","210","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1724","798","1425","","","","1","17","150","0","0","0","150","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1725","798","1487","","","","2","1","420","0","0","0","840","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1726","798","1470","","","","2","1","100","0","0","0","200","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1727","798","1421","","","","1","4","100","0","0","0","100","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1728","798","1409","","","","4","2","110","0","0","0","440","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1729","798","1417","","","","2","1","20","0","0","0","40","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1730","798","1415","","","","1","4","80","0","0","0","80","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1731","798","1410","","","","4","2","60","0","0","0","240","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1732","798","1443","","","","9","2","70","0","0","0","630","2025-03-24 19:29:36","2025-03-24 19:29:36");
INSERT INTO product_sales VALUES("1733","799","1410","","","","1","2","70","0","0","0","70","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO product_sales VALUES("1734","799","1411","","","","9","2","110","0","0","0","990","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO product_sales VALUES("1735","799","1417","","","","1","1","20","0","0","0","20","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO product_sales VALUES("1736","799","1443","","","","1","2","70","0","0","0","70","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO product_sales VALUES("1737","799","1465","","","","2","2","80","0","0","0","160","2025-03-24 19:32:59","2025-03-24 19:32:59");
INSERT INTO product_sales VALUES("1738","800","1470","","","","1","1","100","0","0","0","100","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1739","800","1465","","","","3","2","80","0","0","0","240","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1740","800","1417","","","","5","1","20","0","0","0","100","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1741","800","1410","","","","3","2","70","0","0","0","210","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1742","800","1411","","","","4","2","110","0","0","0","440","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1743","800","1430","","","","1","9","100","0","0","0","100","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1744","800","1443","","","","4","2","70","0","0","0","280","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1745","800","1476","","","","1","1","45","0","0","0","45","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1746","800","1409","","","","3","2","110","0","0","0","330","2025-03-24 19:43:16","2025-03-24 19:43:16");
INSERT INTO product_sales VALUES("1747","801","1395","","","","1","21","100","0","0","0","100","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1748","801","1409","","","","3","2","100","0","0","0","300","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1749","801","1410","","","","4","2","70","0","0","0","280","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1750","801","1443","","","","4","2","70","0","0","0","280","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1751","801","1465","","","","3","2","80","0","0","0","240","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1752","801","1417","","","","2","1","20","0","0","0","40","2025-03-24 19:47:20","2025-03-24 19:47:20");
INSERT INTO product_sales VALUES("1753","802","1406","","","","1","4","180","0","0","0","180","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1754","802","1465","","","","1","2","80","0","0","0","80","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1755","802","1417","","","","2","1","20","0","0","0","40","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1756","802","1469","","","","2","1","20","0","0","0","40","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1757","802","1409","","","","1","2","110","0","0","0","110","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1758","802","1407","","","","2","2","50","0","0","0","100","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1759","802","1463","","","","1","1","150","0","0","0","150","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1760","802","1443","","","","4","2","70","0","0","0","280","2025-03-24 19:54:36","2025-03-24 19:54:36");
INSERT INTO product_sales VALUES("1761","803","1409","","","","1","2","110","0","0","0","110","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO product_sales VALUES("1762","803","1469","","","","2","1","20","0","0","0","40","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO product_sales VALUES("1763","803","1443","","","","5","2","70","0","0","0","350","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO product_sales VALUES("1764","803","1417","","","","1","1","20","0","0","0","20","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO product_sales VALUES("1765","803","1465","","","","5","2","80","0","0","0","400","2025-03-24 20:08:49","2025-03-24 20:08:49");
INSERT INTO product_sales VALUES("1766","804","1406","","","","2","4","180","0","0","0","360","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1767","804","1427","","","","1","10","350","0","0","0","350","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1768","804","1465","","","","2","2","80","0","0","0","160","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1769","804","1403","","","","1","10","150","0","0","0","150","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1770","804","1415","","","","1","4","80","0","0","0","80","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1771","804","1421","","","","1","4","100","0","0","0","100","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1772","804","1491","","","","1","1","100","0","0","0","100","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1773","804","1409","","","","1","2","110","0","0","0","110","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1774","804","1417","","","","2","1","20","0","0","0","40","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1775","804","1410","","","","1","2","80","0","0","0","80","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1776","804","1443","","","","1","2","70","0","0","0","70","2025-03-24 20:28:45","2025-03-24 20:28:45");
INSERT INTO product_sales VALUES("1777","805","1423","","","","1","1","250","0","0","0","250","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1778","805","1402","","","","1","5","120","0","0","0","120","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1779","805","1443","","","","5","2","70","0","0","0","350","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1780","805","1491","","","","1","1","100","0","0","0","100","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1781","805","1418","","","","1","5","200","0","0","0","200","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1782","805","1444","","","","4","2","95","0","0","0","380","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1783","805","1415","","","","1","4","80","0","0","0","80","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1784","805","1417","","","","3","1","20","0","0","0","60","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1785","805","1409","","","","14","2","110","0","0","0","1540","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1786","805","1401","","","","1","21","150","0","0","0","150","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1787","805","1471","","","","4","1","22","0","0","0","88","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1788","805","1465","","","","4","2","80","0","0","0","320","2025-03-25 16:09:13","2025-03-25 16:09:13");
INSERT INTO product_sales VALUES("1789","806","1443","","","","1","2","70","0","0","0","70","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1790","806","1391","","","","1","2","250","0","0","0","250","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1791","806","1465","","","","1","2","80","0","0","0","80","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1792","806","1487","","","","1","1","420","0","0","0","420","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1793","806","1410","","","","5","2","80","0","0","0","400","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1794","806","1408","","","","2","2","120","0","0","0","240","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1795","806","1444","","","","2","2","75","0","0","0","150","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1796","806","1405","","","","1","1","200","0","0","0","200","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1797","806","1489","","","","1","1","100","0","0","0","100","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1798","806","1402","","","","2","5","100","0","0","0","200","2025-03-25 16:15:29","2025-03-25 16:15:29");
INSERT INTO product_sales VALUES("1799","807","1443","","","","1","2","100","0","0","0","100","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1800","807","1403","","","","1","10","150","0","0","0","150","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1801","807","1444","","","","3","2","95","0","0","0","285","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1802","807","1478","","","","1","1","130","0","0","0","130","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1803","807","1415","","","","1","4","90","0","0","0","90","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1804","807","1465","","","","1","2","80","0","0","0","80","2025-03-25 16:18:53","2025-03-25 16:18:53");
INSERT INTO product_sales VALUES("1815","809","1441","","","","1","4","150","0","0","0","150","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1816","809","1443","","","","3","2","70","0","0","0","210","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1817","809","1428","","","","1","9","130","0","0","0","130","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1818","809","1465","","","","1","2","80","0","0","0","80","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1819","809","1393","","","","1","3","80","0","0","0","80","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1820","809","1476","","","","1","1","45","0","0","0","45","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1821","809","1391","","","","2","2","250","0","0","0","500","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1822","809","1408","","","","2","2","120","0","0","0","240","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1823","809","1402","","","","1","5","120","0","0","0","120","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1824","809","1403","","","","1","10","150","0","0","0","150","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1825","809","1410","","","","2","2","60","0","0","0","120","2025-03-25 17:41:26","2025-03-25 17:41:26");
INSERT INTO product_sales VALUES("1826","810","1430","","","","1","9","100","0","0","0","100","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1827","810","1465","","","","2","2","80","0","0","0","160","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1828","810","1427","","","","1","10","330","0","0","0","330","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1829","810","1443","","","","1","2","35","0","0","0","35","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1830","810","1403","","","","1","10","150","0","0","0","150","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1831","810","1406","","","","1","4","170","0","0","0","170","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1832","810","1421","","","","1","4","100","0","0","0","100","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1833","810","1409","","","","4","2","110","0","0","0","440","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1834","810","1408","","","","1","2","120","0","0","0","120","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1835","810","1410","","","","6","2","80","0","0","0","480","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1836","810","1471","","","","1","1","20","0","0","0","20","2025-03-25 17:53:32","2025-03-25 17:53:32");
INSERT INTO product_sales VALUES("1837","811","1465","","","","1","2","80","0","0","0","80","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1838","811","1443","","","","2","2","70","0","0","0","140","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1839","811","1411","","","","4","2","110","0","0","0","440","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1840","811","1408","","","","3","2","120","0","0","0","360","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1841","811","1415","","","","1","4","80","0","0","0","80","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1842","811","1409","","","","3","2","110","0","0","0","330","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1843","811","1418","","","","1","5","200","0","0","0","200","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1844","811","1426","","","","1","10","450","0","0","0","450","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1845","811","1444","","","","2","2","95","0","0","0","190","2025-03-25 18:02:31","2025-03-25 18:02:31");
INSERT INTO product_sales VALUES("1846","812","1464","","","","1","1","20","0","0","0","20","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1847","812","1443","","","","6","2","70","0","0","0","420","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1848","812","1408","","","","1","2","120","0","0","0","120","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1849","812","1444","","","","3","2","95","0","0","0","285","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1850","812","1476","","","","1","1","45","0","0","0","45","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1851","812","1478","","","","1","1","130","0","0","0","130","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1852","812","1470","","","","1","1","100","0","0","0","100","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1853","812","1465","","","","1","2","80","0","0","0","80","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1854","812","1428","","","","2","9","150","0","0","0","300","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1855","812","1417","","","","1","1","20","0","0","0","20","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1856","812","1402","","","","2","5","120","0","0","0","240","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1857","812","1463","","","","1","1","120","0","0","0","120","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1858","812","1490","","","","1","1","160","0","0","0","160","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1859","812","1430","","","","3","9","100","0","0","0","300","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1860","812","1409","","","","4","2","110","0","0","0","440","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1861","812","1410","","","","5","2","70","0","0","0","350","2025-03-25 18:24:16","2025-03-25 18:24:16");
INSERT INTO product_sales VALUES("1862","813","1411","","","","13","2","110","0","0","0","1430","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1863","813","1443","","","","3","2","70","0","0","0","210","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1864","813","1409","","","","3","2","110","0","0","0","330","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1865","813","1489","","","","2","1","100","0","0","0","200","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1866","813","1410","","","","1","2","70","0","0","0","70","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1867","813","1408","","","","1","2","120","0","0","0","120","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1868","813","1405","","","","1","1","200","0","0","0","200","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1869","813","1471","","","","1","1","25","0","0","0","25","2025-03-25 18:39:43","2025-03-25 18:39:43");
INSERT INTO product_sales VALUES("1870","814","1444","","","","1","2","95","0","0","0","95","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1871","814","1409","","","","1","2","110","0","0","0","110","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1872","814","1417","","","","2","1","20","0","0","0","40","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1873","814","1410","","","","2","2","70","0","0","0","140","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1874","814","1493","","","","1","1","280","0","0","0","280","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1875","814","1402","","","","1","5","120","0","0","0","120","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1876","814","1411","","","","2","2","120","0","0","0","240","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1877","814","1443","","","","2","2","70","0","0","0","140","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1878","814","1393","","","","1","3","70","0","0","0","70","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1879","814","1427","","","","1","10","330","0","0","0","330","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1880","814","1431","","","","1","5","180","0","0","0","180","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1881","814","1408","","","","1","2","120","0","0","0","120","2025-03-26 09:32:11","2025-03-26 09:32:11");
INSERT INTO product_sales VALUES("1882","815","1410","","","","2","2","70","0","0","0","140","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1883","815","1417","","","","2","1","20","0","0","0","40","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1884","815","1409","","","","3","2","110","0","0","0","330","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1885","815","1444","","","","2","2","95","0","0","0","190","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1886","815","1393","","","","1","3","70","0","0","0","70","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1887","815","1443","","","","3","2","70","0","0","0","210","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1888","815","1408","","","","1","2","120","0","0","0","120","2025-03-26 19:07:36","2025-03-26 19:07:36");
INSERT INTO product_sales VALUES("1889","816","1408","","","","3","2","120","0","0","0","360","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1890","816","1391","","","","1","2","250","0","0","0","250","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1891","816","1410","","","","3","2","70","0","0","0","210","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1892","816","1403","","","","1","10","150","0","0","0","150","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1893","816","1411","","","","3","2","120","0","0","0","360","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1894","816","1409","","","","5","2","110","0","0","0","550","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1895","816","1443","","","","6","2","70","0","0","0","420","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1896","816","1406","","","","1","4","180","0","0","0","180","2025-03-26 19:13:07","2025-03-26 19:13:07");
INSERT INTO product_sales VALUES("1897","817","1403","","","","1","10","150","0","0","0","150","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1898","817","1443","","","","1","2","70","0","0","0","70","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1899","817","1408","","","","4","2","120","0","0","0","480","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1900","817","1398","","","","1","2","120","0","0","0","120","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1901","817","1444","","","","4","2","95","0","0","0","380","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1902","817","1405","","","","1","1","200","0","0","0","200","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1903","817","1410","","","","5","2","70","0","0","0","350","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1904","817","1411","","","","1","2","120","0","0","0","120","2025-03-26 19:20:59","2025-03-26 19:20:59");
INSERT INTO product_sales VALUES("1905","818","1411","","","","1","2","120","0","0","0","120","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1906","818","1408","","","","3","2","120","0","0","0","360","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1907","818","1410","","","","5","2","70","0","0","0","350","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1908","818","1465","","","","1","2","80","0","0","0","80","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1909","818","1443","","","","3","2","70","0","0","0","210","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1910","818","1397","","","","1","2","100","0","0","0","100","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1911","818","1444","","","","2","2","95","0","0","0","190","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1912","818","1494","","","","1","1","150","0","0","0","150","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1913","818","1422","","","","1","1","120","0","0","0","120","2025-03-26 19:33:28","2025-03-26 19:33:28");
INSERT INTO product_sales VALUES("1914","819","1465","","","","1","2","80","0","0","0","80","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1915","819","1406","","","","1","4","200","0","0","0","200","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1916","819","1389","","","","1","2","150","0","0","0","150","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1917","819","1453","","","","1","1","350","0","0","0","350","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1918","819","1421","","","","1","4","100","0","0","0","100","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1919","819","1408","","","","3","2","120","0","0","0","360","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1920","819","1411","","","","1","2","120","0","0","0","120","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1921","819","1410","","","","3","2","70","0","0","0","210","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1922","819","1467","","","","1","1","100","0","0","0","100","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1923","819","1428","","","","1","9","150","0","0","0","150","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1924","819","1397","","","","7","2","100","0","0","0","700","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1925","819","1398","","","","4","2","120","0","0","0","480","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1926","819","1444","","","","7","2","95","0","0","0","665","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1927","819","1443","","","","3","2","70","0","0","0","210","2025-03-26 19:46:25","2025-03-26 19:46:25");
INSERT INTO product_sales VALUES("1928","820","1467","","","","1","1","100","0","0","0","100","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1929","820","1421","","","","1","4","100","0","0","0","100","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1930","820","1398","","","","1","2","120","0","0","0","120","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1931","820","1397","","","","1","2","100","0","0","0","100","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1932","820","1403","","","","1","10","150","0","0","0","150","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1933","820","1402","","","","1","5","100","0","0","0","100","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1934","820","1410","","","","4","2","70","0","0","0","280","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1935","820","1408","","","","2","2","120","0","0","0","240","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1936","820","1406","","","","1","4","180","0","0","0","180","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1937","820","1444","","","","1","2","95","0","0","0","95","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1938","820","1465","","","","1","2","80","0","0","0","80","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1939","820","1443","","","","2","2","70","0","0","0","140","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1940","820","1411","","","","6","2","120","0","0","0","720","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1941","820","1463","","","","1","1","150","0","0","0","150","2025-03-26 20:00:40","2025-03-26 20:00:40");
INSERT INTO product_sales VALUES("1942","821","1465","","","","1","2","80","0","0","0","80","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1943","821","1407","","","","1","2","50","0","0","0","50","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1944","821","1408","","","","1","2","120","0","0","0","120","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1945","821","1397","","","","1","2","100","0","0","0","100","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1946","821","1443","","","","4","2","70","0","0","0","280","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1947","821","1469","","","","1","1","20","0","0","0","20","2025-03-26 20:03:40","2025-03-26 20:03:40");
INSERT INTO product_sales VALUES("1948","822","1465","","","","1","2","80","0","0","0","80","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO product_sales VALUES("1949","822","1443","","","","1","2","70","0","0","0","70","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO product_sales VALUES("1950","822","1397","","","","1","2","100","0","0","0","100","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO product_sales VALUES("1951","822","1402","","","","1","5","100","0","0","0","100","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO product_sales VALUES("1952","822","1428","","","","1","9","150","0","0","0","150","2025-03-26 20:06:13","2025-03-26 20:06:13");
INSERT INTO product_sales VALUES("1962","824","1485","","","","1","1","260","0","0","0","260","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1963","824","1411","","","","5","2","120","0","0","0","600","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1964","824","1397","","","","4","2","100","0","0","0","400","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1965","824","1391","","","","2","2","250","0","0","0","500","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1966","824","1408","","","","4","2","120","0","0","0","480","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1967","824","1428","","","","2","9","150","0","0","0","300","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1968","824","1465","","","","3","2","80","0","0","0","240","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1969","824","1443","","","","6","2","70","0","0","0","420","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1970","824","1407","","","","3","2","50","0","0","0","150","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1971","824","1471","","","","1","1","30","0","0","0","30","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1972","824","1426","","","","1","10","450","0","0","0","450","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1973","824","1405","","","","1","1","200","0","0","0","200","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1974","824","1478","","","","1","1","130","0","0","0","130","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1975","824","1410","","","","1","2","70","0","0","0","70","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1976","824","1430","","","","1","9","100","0","0","0","100","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1977","824","1417","","","","6","1","20","0","0","0","120","2025-03-28 20:32:26","2025-03-28 20:32:26");
INSERT INTO product_sales VALUES("1978","825","1473","","","","1","1","40","0","0","0","40","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1979","825","1443","","","","2","2","70","0","0","0","140","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1980","825","1424","","","","1","6","150","0","0","0","150","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1981","825","1418","","","","1","5","200","0","0","0","200","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1982","825","1411","","","","1","2","120","0","0","0","120","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1983","825","1409","","","","5","2","110","0","0","0","550","2025-03-29 13:00:41","2025-03-29 13:00:41");
INSERT INTO product_sales VALUES("1984","826","1487","","","","1","1","500","0","0","0","500","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1985","826","1430","","","","1","9","100","0","0","0","100","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1986","826","1478","","","","1","1","130","0","0","0","130","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1987","826","1408","","","","1","2","120","0","0","0","120","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1988","826","1476","","","","5","1","40","0","0","0","200","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1989","826","1450","","","","1","2","220","0","0","0","220","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1990","826","1465","","","","2","2","80","0","0","0","160","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1991","826","1432","","","","1","23","110","0","0","0","110","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1992","826","1397","","","","3","2","100","0","0","0","300","2025-03-29 13:09:57","2025-03-29 13:09:57");
INSERT INTO product_sales VALUES("1993","827","1410","","","","1","2","70","0","0","0","70","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1994","827","1408","","","","1","2","120","0","0","0","120","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1995","827","1398","","","","1","2","120","0","0","0","120","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1996","827","1463","","","","1","1","140","0","0","0","140","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1997","827","1424","","","","1","6","150","0","0","0","150","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1998","827","1417","","","","2","1","20","0","0","0","40","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("1999","827","1411","","","","2","2","150","0","0","0","300","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2000","827","1389","","","","1","2","150","0","0","0","150","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2001","827","1465","","","","1","2","80","0","0","0","80","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2002","827","1428","","","","1","9","150","0","0","0","150","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2003","827","1436","","","","2","23","130","0","0","0","260","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2004","827","1455","","","","1","1","100","0","0","0","100","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2005","827","1432","","","","1","23","100","0","0","0","100","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2006","827","1392","","","","1","3","70","0","0","0","70","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2007","827","1478","","","","1","1","130","0","0","0","130","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2008","827","1402","","","","1","5","100","0","0","0","100","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2009","827","1393","","","","1","3","70","0","0","0","70","2025-03-31 14:59:30","2025-03-31 14:59:30");
INSERT INTO product_sales VALUES("2010","828","1414","","","","1","1","475","0","0","0","475","2025-03-31 15:05:26","2025-03-31 15:05:26");
INSERT INTO product_sales VALUES("2011","828","1408","","","","1","2","120","0","0","0","120","2025-03-31 15:05:26","2025-03-31 15:05:26");
INSERT INTO product_sales VALUES("2012","828","1463","","","","1","1","150","0","0","0","150","2025-03-31 15:05:26","2025-03-31 15:05:26");
INSERT INTO product_sales VALUES("2013","828","1443","","","","1","2","70","0","0","0","70","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2014","828","1432","","","","1","23","100","0","0","0","100","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2015","828","1487","","","","1","1","450","0","0","0","450","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2016","828","1398","","","","4","2","110","0","0","0","440","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2017","828","1405","","","","1","1","200","0","0","0","200","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2018","828","1397","","","","1","2","100","0","0","0","100","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2019","828","1410","","","","1","2","70","0","0","0","70","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2020","828","1417","","","","2","1","20","0","0","0","40","2025-03-31 15:05:27","2025-03-31 15:05:27");
INSERT INTO product_sales VALUES("2021","829","1443","","","","4","2","70","0","0","0","280","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2022","829","1393","","","","2","3","140","0","0","0","280","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2023","829","1392","","","","2","3","70","0","0","0","140","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2024","829","1426","","","","1","10","450","0","0","0","450","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2025","829","1397","","","","2","2","100","0","0","0","200","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2026","829","1430","","","","1","9","100","0","0","0","100","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2027","829","1396","","","","1","3","100","0","0","0","100","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2028","829","1418","","","","1","5","200","0","0","0","200","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2029","829","1398","","","","2","2","120","0","0","0","240","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2030","829","1413","","","","1","1","900","0","0","0","900","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2031","829","1436","","","","1","23","150","0","0","0","150","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2032","829","1498","","","","2","1","475","0","0","0","950","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2033","829","1487","","","","3","1","400","0","0","0","1200","2025-03-31 15:27:58","2025-03-31 15:27:58");
INSERT INTO product_sales VALUES("2034","830","1444","","","","1","2","95","0","0","0","95","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2035","830","1423","","","","1","1","300","0","0","0","300","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2036","830","1391","","","","1","2","250","0","0","0","250","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2037","830","1495","","","","1","1","200","0","0","0","200","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2038","830","1458","","","","1","1","180","0","0","0","180","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2039","830","1428","","","","1","9","150","0","0","0","150","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2040","830","1407","","","","2","2","50","0","0","0","100","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2041","830","1498","","","","1","1","450","0","0","0","450","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2042","830","1487","","","","1","1","450","0","0","0","450","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2043","830","1414","","","","1","1","950","0","0","0","950","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2044","830","1443","","","","5","2","70","0","0","0","350","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2045","830","1465","","","","1","2","80","0","0","0","80","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2046","830","1397","","","","2","2","100","0","0","0","200","2025-03-31 15:43:15","2025-03-31 15:43:15");
INSERT INTO product_sales VALUES("2047","831","1404","","","","1","10","250","0","0","0","250","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2048","831","1407","","","","1","2","50","0","0","0","50","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2049","831","1413","","","","1","1","600","0","0","0","600","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2050","831","1443","","","","4","2","70","0","0","0","280","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2051","831","1432","","","","1","1","100","0","0","0","100","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2052","831","1499","","","","1","1","80","0","0","0","80","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2053","831","1490","","","","1","1","160","0","0","0","160","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2054","831","1414","","","","1","1","950","0","0","0","950","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2055","831","1444","","","","1","2","95","0","0","0","95","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2056","831","1478","","","","1","1","130","0","0","0","130","2025-03-31 15:56:40","2025-03-31 15:56:40");
INSERT INTO product_sales VALUES("2057","832","1417","","","","2","1","20","0","0","0","40","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2058","832","1427","","","","1","10","350","0","0","0","350","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2059","832","1413","","","","1","1","900","0","0","0","900","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2060","832","1408","","","","2","2","145","0","0","0","290","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2061","832","1444","","","","1","2","50","0","0","0","50","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2062","832","1443","","","","1","2","70","0","0","0","70","2025-03-31 16:00:09","2025-03-31 16:00:09");
INSERT INTO product_sales VALUES("2063","833","1491","","","","1","1","100","0","0","0","100","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2064","833","1443","","","","2","2","70","0","0","0","140","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2065","833","1409","","","","1","2","55","0","0","0","55","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2066","833","1410","","","","1","2","70","0","0","0","70","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2067","833","1408","","","","2","2","90","0","0","0","180","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2068","833","1487","","","","1","1","450","0","0","0","450","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2069","833","1397","","","","1","2","100","0","0","0","100","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2070","833","1406","","","","1","4","180","0","0","0","180","2025-03-31 16:07:00","2025-03-31 16:07:00");
INSERT INTO product_sales VALUES("2071","834","1402","","","","1","5","100","0","0","0","100","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2072","834","1457","","","","2","1","250","0","0","0","500","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2073","834","1413","","","","1","1","900","0","0","0","900","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2074","834","1443","","","","3","2","70","0","0","0","210","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2075","834","1490","","","","1","1","160","0","0","0","160","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2076","834","1389","","","","1","2","150","0","0","0","150","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2077","834","1391","","","","1","2","250","0","0","0","250","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2078","834","1411","","","","22","2","78","0","0","0","1716","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2079","834","1444","","","","3","2","95","0","0","0","285","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2080","834","1409","","","","6","2","110","0","0","0","660","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2081","834","1410","","","","1","2","40","0","0","0","40","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2082","834","1430","","","","1","9","100","0","0","0","100","2025-03-31 16:25:10","2025-03-31 16:25:10");
INSERT INTO product_sales VALUES("2083","835","1444","","","","1","2","95","0","0","0","95","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2084","835","1409","","","","4","2","110","0","0","0","440","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2085","835","1411","","","","10","2","120","0","0","0","1200","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2086","835","1390","","","","1","2","250","0","0","0","250","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2087","835","1408","","","","13","2","120","0","0","0","1560","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2088","835","1405","","","","1","1","200","0","0","0","200","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2089","835","1418","","","","1","5","200","0","0","0","200","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2090","835","1410","","","","22","2","80","0","0","0","1760","2025-03-31 16:56:36","2025-03-31 16:56:36");
INSERT INTO product_sales VALUES("2091","836","1465","","","","1","2","80","0","0","0","80","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2092","836","1406","","","","1","4","200","0","0","0","200","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2093","836","1388","","2","","1","2","150","0","0","0","150","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2094","836","1453","","","","1","1","350","0","0","0","350","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2095","836","1421","","","","1","4","100","0","0","0","100","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2096","836","1408","","","","3","2","120","0","0","0","360","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2097","836","1411","","","","2","2","120","0","0","0","240","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2098","836","1410","","","","1","2","70","0","0","0","70","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2099","836","1470","","","","1","1","100","0","0","0","100","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2100","836","1428","","","","1","9","150","0","0","0","150","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2101","836","1397","","","","7","2","100","0","0","0","700","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2102","836","1398","","","","4","2","120","0","0","0","480","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2103","836","1444","","","","7","2","95","0","0","0","665","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2104","836","1443","","","","3","2","70","0","0","0","210","2025-03-31 17:10:53","2025-03-31 17:10:53");
INSERT INTO product_sales VALUES("2105","837","1443","","","","4","2","70","0","0","0","280","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2106","837","1444","","","","1","2","50","0","0","0","50","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2107","837","1408","","","","4","2","120","0","0","0","480","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2108","837","1417","","","","2","1","20","0","0","0","40","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2109","837","1495","","","","1","1","150","0","0","0","150","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2110","837","1409","","","","3","2","110","0","0","0","330","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2111","837","1410","","","","3","2","70","0","0","0","210","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2112","837","1457","","","","1","1","250","0","0","0","250","2025-03-31 17:19:05","2025-03-31 17:19:05");
INSERT INTO product_sales VALUES("2113","838","1414","","","","1","1","950","0","0","0","950","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2114","838","1413","","","","1","1","900","0","0","0","900","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2115","838","1455","","","","1","1","100","0","0","0","100","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2116","838","1443","","","","3","2","70","0","0","0","210","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2117","838","1408","","","","3","2","120","0","0","0","360","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2118","838","1411","","","","9","2","120","0","0","0","1080","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2119","838","1444","","","","2","2","95","0","0","0","190","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2120","838","1409","","","","7","2","110","0","0","0","770","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2121","838","1410","","","","3","2","70","0","0","0","210","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2122","838","1430","","","","1","9","100","0","0","0","100","2025-03-31 17:36:57","2025-03-31 17:36:57");
INSERT INTO product_sales VALUES("2123","839","1485","","","","1","1","350","0","0","0","350","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2124","839","1413","","","","1","1","900","0","0","0","900","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2125","839","1432","","","","2","1","100","0","0","0","200","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2126","839","1472","","","","1","1","280","0","0","0","280","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2127","839","1500","","","","1","1","280","0","0","0","280","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2128","839","1408","","","","1","2","120","0","0","0","120","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2129","839","1414","","","","1","1","950","0","0","0","950","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2130","839","1456","","","","1","1","230","0","0","0","230","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2131","839","1410","","","","6","2","70","0","0","0","420","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2132","839","1398","","","","4","2","120","0","0","0","480","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2133","839","1406","","","","1","4","200","0","0","0","200","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2134","839","1417","","","","1","1","20","0","0","0","20","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2135","839","1426","","","","1","10","450","0","0","0","450","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2136","839","1467","","","","1","1","100","0","0","0","100","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2137","839","1444","","","","1","2","95","0","0","0","95","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2138","839","1443","","","","1","2","70","0","0","0","70","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2139","839","1403","","","","1","10","150","0","0","0","150","2025-03-31 18:02:23","2025-03-31 18:02:23");
INSERT INTO product_sales VALUES("2140","840","1443","","","","3","2","70","0","0","0","210","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO product_sales VALUES("2141","840","1458","","","","1","1","180","0","0","0","180","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO product_sales VALUES("2142","840","1390","","","","1","2","250","0","0","0","250","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO product_sales VALUES("2143","840","1444","","","","2","2","95","0","0","0","190","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO product_sales VALUES("2144","840","1417","","","","1","1","20","0","0","0","20","2025-03-31 18:07:00","2025-03-31 18:07:00");
INSERT INTO product_sales VALUES("2145","841","1408","","","","1","2","120","0","0","0","120","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO product_sales VALUES("2146","841","1443","","","","3","2","190","0","0","0","570","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO product_sales VALUES("2147","841","1444","","","","1","2","95","0","0","0","95","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO product_sales VALUES("2148","841","1424","","","","1","6","150","0","0","0","150","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO product_sales VALUES("2149","841","1413","","","","1","1","900","0","0","0","900","2025-03-31 18:13:03","2025-03-31 18:13:03");
INSERT INTO product_sales VALUES("2150","842","1415","","","","1","4","90","0","0","0","90","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2151","842","1454","","","","1","7","100","0","0","0","100","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2152","842","1392","","","","1","3","80","0","0","0","80","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2153","842","1469","","","","1","1","20","0","0","0","20","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2154","842","1443","","","","9","2","70","0","0","0","630","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2155","842","1391","","","","2","2","250","0","0","0","500","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2156","842","1408","","","","3","2","120","0","0","0","360","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2157","842","1410","","","","2","2","70","0","0","0","140","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2158","842","1467","","","","3","1","100","0","0","0","300","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2159","842","1406","","","","2","4","180","0","0","0","360","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2160","842","1498","","","","2","1","475","0","0","0","950","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2161","842","1414","","","","3","1","950","0","0","0","2850","2025-03-31 18:37:31","2025-03-31 18:37:31");
INSERT INTO product_sales VALUES("2177","844","1498","","","","2","1","475","0","0","0","950","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2178","844","1487","","","","4","1","450","0","0","0","1800","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2179","844","1396","","","","1","3","100","0","0","0","100","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2180","844","1417","","","","3","1","20","0","0","0","60","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2181","844","1430","","","","1","9","100","0","0","0","100","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2182","844","1401","","","","1","21","150","0","0","0","150","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2183","844","1467","","","","1","1","100","0","0","0","100","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2184","844","1388","","2","","1","2","150","0","0","0","150","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2185","844","1443","","","","5","2","70","0","0","0","350","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2186","844","1410","","","","26","2","70","0","0","0","1820","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2187","844","1444","","","","1","2","95","0","0","0","95","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2188","844","1415","","","","1","4","80","0","0","0","80","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2189","844","1408","","","","4","2","120","0","0","0","480","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2190","844","1414","","","","1","1","950","0","0","0","950","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2191","844","1413","","","","1","1","900","0","0","0","900","2025-03-31 19:09:16","2025-03-31 19:09:16");
INSERT INTO product_sales VALUES("2192","845","1465","","","","2","2","80","0","0","0","160","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2193","845","1443","","","","1","2","70","0","0","0","70","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2194","845","1409","","","","1","2","110","0","0","0","110","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2195","845","1410","","","","1","2","70","0","0","0","70","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2196","845","1424","","","","1","6","150","0","0","0","150","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2197","845","1476","","","","2","1","40","0","0","0","80","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2198","845","1411","","","","1","2","110","0","0","0","110","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2199","845","1402","","","","1","5","100","0","0","0","100","2025-03-31 19:19:58","2025-03-31 19:19:58");
INSERT INTO product_sales VALUES("2200","846","1410","","","","1","2","70","0","0","0","70","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2201","846","1397","","","","1","2","100","0","0","0","100","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2202","846","1476","","","","2","1","40","0","0","0","80","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2203","846","1417","","","","1","1","20","0","0","0","20","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2204","846","1465","","","","1","2","80","0","0","0","80","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2205","846","1443","","","","2","2","70","0","0","0","140","2025-03-31 19:22:28","2025-03-31 19:22:28");
INSERT INTO product_sales VALUES("2206","847","1430","","","","1","9","100","0","0","0","100","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2207","847","1417","","","","2","1","20","0","0","0","40","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2208","847","1429","","","","1","22","300","0","0","0","300","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2209","847","1428","","","","1","9","150","0","0","0","150","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2210","847","1432","","","","1","1","100","0","0","0","100","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2211","847","1443","","","","3","2","80","0","0","0","240","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2212","847","1397","","","","1","2","100","0","0","0","100","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2213","847","1410","","","","1","2","70","0","0","0","70","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2214","847","1465","","","","3","2","80","0","0","0","240","2025-03-31 19:30:18","2025-03-31 19:30:18");
INSERT INTO product_sales VALUES("2215","848","1407","","","","1","2","50","0","0","0","50","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2216","848","1403","","","","1","10","150","0","0","0","150","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2217","848","1417","","","","1","1","20","0","0","0","20","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2218","848","1444","","","","2","2","95","0","0","0","190","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2219","848","1465","","","","2","2","80","0","0","0","160","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2220","848","1443","","","","3","2","70","0","0","0","210","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2221","848","1408","","","","1","2","120","0","0","0","120","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2222","848","1402","","","","1","5","100","0","0","0","100","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2223","848","1411","","","","12","2","120","0","0","0","1440","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2224","848","1410","","","","1","2","70","0","0","0","70","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2225","848","1469","","","","1","1","20","0","0","0","20","2025-03-31 19:38:58","2025-03-31 19:38:58");
INSERT INTO product_sales VALUES("2226","849","1425","","","","1","17","150","0","0","0","150","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2227","849","1443","","","","2","2","70","0","0","0","140","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2228","849","1395","","","","1","21","100","0","0","0","100","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2229","849","1393","","","","1","3","80","0","0","0","80","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2230","849","1411","","","","28","2","120","0","0","0","3360","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2231","849","1410","","","","5","2","85","0","0","0","425","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2232","849","1408","","","","11","2","120","0","0","0","1320","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2233","849","1409","","","","13","2","110","0","0","0","1430","2025-04-01 09:55:05","2025-04-01 09:55:05");
INSERT INTO product_sales VALUES("2234","850","1413","","","","1","1","450","0","0","0","450","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2235","850","1443","","","","3","2","70","0","0","0","210","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2236","850","1444","","","","1","2","95","0","0","0","95","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2237","850","1397","","","","1","2","100","0","0","0","100","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2238","850","1411","","","","1","2","120","0","0","0","120","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2239","850","1409","","","","3","2","110","0","0","0","330","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2240","850","1408","","","","12","2","120","0","0","0","1440","2025-04-01 15:14:42","2025-04-01 15:14:42");
INSERT INTO product_sales VALUES("2241","851","1409","","","","12","2","110","0","0","0","1320","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2242","851","1444","","","","2","2","95","0","0","0","190","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2243","851","1455","","","","1","1","100","0","0","0","100","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2244","851","1456","","","","1","1","250","0","0","0","250","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2245","851","1459","","","","1","1","250","0","0","0","250","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2246","851","1430","","","","1","9","100","0","0","0","100","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2247","851","1413","","","","1","1","900","0","0","0","900","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2248","851","1398","","","","1","2","120","0","0","0","120","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2249","851","1406","","","","1","4","180","0","0","0","180","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2250","851","1443","","","","5","2","70","0","0","0","350","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2251","851","1424","","","","1","6","150","0","0","0","150","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2252","851","1405","","","","1","1","230","0","0","0","230","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2253","851","1410","","","","3","2","70","0","0","0","210","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2254","851","1495","","","","2","1","180","0","0","0","360","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2255","851","1408","","","","13","2","120","0","0","0","1560","2025-04-01 15:37:48","2025-04-01 15:37:48");
INSERT INTO product_sales VALUES("2256","852","1443","","","","2","2","70","0","0","0","140","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2257","852","1409","","","","1","2","110","0","0","0","110","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2258","852","1417","","","","1","1","20","0","0","0","20","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2259","852","1463","","","","1","1","120","0","0","0","120","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2260","852","1491","","","","1","1","100","0","0","0","100","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2261","852","1411","","","","5","2","120","0","0","0","600","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2262","852","1410","","","","3","2","60","0","0","0","180","2025-04-01 15:49:09","2025-04-01 15:49:09");
INSERT INTO product_sales VALUES("2263","853","1401","","","","2","21","260","0","0","0","520","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2264","853","1417","","","","1","1","20","0","0","0","20","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2265","853","1411","","","","1","2","120","0","0","0","120","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2266","853","1488","","","","1","1","100","0","0","0","100","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2267","853","1444","","","","3","2","95","0","0","0","285","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2268","853","1451","","","","1","2","500","0","0","0","500","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2269","853","1413","","","","1","1","900","0","0","0","900","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2270","853","1414","","","","2","1","1175","0","0","0","2350","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2271","853","1409","","","","1","2","110","0","0","0","110","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2272","853","1410","","","","1","2","70","0","0","0","70","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2273","853","1408","","","","1","2","60","0","0","0","60","2025-04-01 16:03:16","2025-04-01 16:03:16");
INSERT INTO product_sales VALUES("2274","854","1406","","","","1","4","250","0","0","0","250","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2275","854","1410","","","","1","2","80","0","0","0","80","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2276","854","1430","","","","1","9","100","0","0","0","100","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2277","854","1403","","","","1","10","150","0","0","0","150","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2278","854","1402","","","","1","5","100","0","0","0","100","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2279","854","1443","","","","2","2","70","0","0","0","140","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2280","854","1476","","","","2","1","40","0","0","0","80","2025-04-01 16:09:03","2025-04-01 16:09:03");
INSERT INTO product_sales VALUES("2281","855","1465","","","","1","2","80","0","0","0","80","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2282","855","1397","","","","1","2","50","0","0","0","50","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2283","855","1443","","","","3","2","70","0","0","0","210","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2284","855","1398","","","","2","2","120","0","0","0","240","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2285","855","1430","","","","1","9","100","0","0","0","100","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2286","855","1425","","","","1","17","130","0","0","0","130","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2287","855","1426","","","","1","10","420","0","0","0","420","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2288","855","1406","","","","1","4","180","0","0","0","180","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2289","855","1444","","","","4","2","95","0","0","0","380","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2290","855","1409","","","","2","2","110","0","0","0","220","2025-04-01 17:46:35","2025-04-01 17:46:35");
INSERT INTO product_sales VALUES("2291","856","1406","","","","1","4","200","0","0","0","200","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2292","856","1446","","","","1","2","80","0","0","0","80","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2293","856","1444","","","","1","2","95","0","0","0","95","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2294","856","1417","","","","2","1","20","0","0","0","40","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2295","856","1465","","","","1","2","80","0","0","0","80","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2296","856","1409","","","","1","2","110","0","0","0","110","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2297","856","1443","","","","4","2","75","0","0","0","300","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2298","856","1402","","","","2","5","100","0","0","0","200","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2299","856","1462","","","","2","2","75","0","0","0","150","2025-04-01 17:58:31","2025-04-01 17:58:31");
INSERT INTO product_sales VALUES("2300","857","1422","","","","1","1","100","0","0","0","100","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2301","857","1471","","","","1","1","30","0","0","0","30","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2302","857","1424","","","","1","6","150","0","0","0","150","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2303","857","1393","","","","1","3","80","0","0","0","80","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2304","857","1432","","","","1","1","100","0","0","0","100","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2305","857","1443","","","","9","2","70","0","0","0","630","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2306","857","1470","","","","1","1","100","0","0","0","100","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2307","857","1466","","","","1","1","100","0","0","0","100","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2308","857","1387","","","","1","1","180","0","0","0","180","2025-04-01 18:09:23","2025-04-01 18:09:23");
INSERT INTO product_sales VALUES("2309","858","1390","","","","1","2","250","0","0","0","250","2025-04-01 18:17:39","2025-04-01 18:17:39");
INSERT INTO product_sales VALUES("2310","858","1408","","","","1","2","120","0","0","0","120","2025-04-01 18:17:39","2025-04-01 18:17:39");
INSERT INTO product_sales VALUES("2311","858","1402","","","","1","5","100","0","0","0","100","2025-04-01 18:17:39","2025-04-01 18:17:39");
INSERT INTO product_sales VALUES("2312","858","1403","","","","1","10","150","0","0","0","150","2025-04-01 18:17:39","2025-04-01 18:17:39");
INSERT INTO product_sales VALUES("2313","858","1410","","","","1","2","70","0","0","0","70","2025-04-01 18:17:39","2025-04-01 18:17:39");
INSERT INTO product_sales VALUES("2314","859","1388","","2","","1","2","150","0","0","0","150","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2315","859","1443","","","","4","2","70","0","0","0","280","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2316","859","1408","","","","1","2","120","0","0","0","120","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2317","859","1465","","","","1","2","80","0","0","0","80","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2318","859","1428","","","","1","9","130","0","0","0","130","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2319","859","1393","","","","1","3","80","0","0","0","80","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2320","859","1476","","","","1","1","40","0","0","0","40","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2321","859","1390","","","","2","2","250","0","0","0","500","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2322","859","1402","","","","1","5","100","0","0","0","100","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2323","859","1403","","","","1","10","150","0","0","0","150","2025-04-01 19:07:10","2025-04-01 19:07:10");
INSERT INTO product_sales VALUES("2324","859","1410","","","","2","2","70","0","0","0","140","2025-04-01 19:07:10","2025-04-01 19:07:10");



CREATE TABLE `product_transfer` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `transfer_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_variants` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `variant_id` int NOT NULL,
  `position` int NOT NULL,
  `item_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `additional_cost` double DEFAULT NULL,
  `additional_price` double DEFAULT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_variants VALUES("2","1388","2","1","150/250-03802294","","","3","2025-02-25 13:16:42","2025-04-01 19:07:10");



CREATE TABLE `product_warehouse` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `warehouse_id` int NOT NULL,
  `qty` double NOT NULL,
  `price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=824 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_warehouse VALUES("213","879","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("214","880","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("215","881","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("216","882","","","","1","3","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("217","883","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("218","884","","","","1","8","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("219","885","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("220","886","","","","1","10","","2023-09-12 00:15:10","2023-09-18 13:48:15");
INSERT INTO product_warehouse VALUES("221","887","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("222","888","","","","1","4","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("223","889","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("224","890","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("225","891","","","","1","1","","2023-09-12 00:15:10","2023-09-17 15:45:23");
INSERT INTO product_warehouse VALUES("226","892","","","","1","3","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("227","893","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("228","894","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("229","895","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("230","896","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("231","897","","","","1","49","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("232","898","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("233","899","","","","1","8","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("234","900","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("235","901","","","","1","2","","2023-09-12 00:15:10","2023-09-15 17:07:47");
INSERT INTO product_warehouse VALUES("236","902","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("237","903","","","","1","3","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("238","904","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("239","905","","","","1","6","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("240","906","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("241","907","","","","1","2","","2023-09-12 00:15:10","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("242","908","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("243","909","","","","1","16","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("244","910","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("245","911","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("246","912","","","","1","10","","2023-09-12 00:15:10","2023-09-18 19:31:00");
INSERT INTO product_warehouse VALUES("247","913","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("248","914","","","","1","90","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("249","915","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("250","916","","","","1","12","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("251","917","","","","1","2","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("252","918","","","","1","4","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("253","919","","","","1","5","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("254","920","","","","1","6","","2023-09-12 00:15:10","2023-09-16 14:22:02");
INSERT INTO product_warehouse VALUES("255","921","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("256","922","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("257","923","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("258","924","","","","1","3","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("259","925","","","","1","1","","2023-09-12 00:15:10","2023-09-17 16:21:01");
INSERT INTO product_warehouse VALUES("260","926","","","","1","9","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("261","927","","","","1","4","","2023-09-12 00:15:10","2023-09-13 13:10:52");
INSERT INTO product_warehouse VALUES("262","928","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("263","929","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("264","930","","","","1","1","","2023-09-12 00:15:10","2023-09-16 17:29:23");
INSERT INTO product_warehouse VALUES("265","931","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("266","932","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("267","933","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("268","934","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("269","935","","","","1","4","","2023-09-12 00:15:10","2023-09-17 19:08:09");
INSERT INTO product_warehouse VALUES("270","936","","","","1","5","","2023-09-12 00:15:10","2023-09-16 19:56:00");
INSERT INTO product_warehouse VALUES("271","937","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("272","938","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("273","939","","","","1","0","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("274","940","","","","1","3","","2023-09-12 00:15:10","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("275","941","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("276","942","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("277","943","","","","1","8","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("278","944","","","","1","8","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("279","945","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("280","946","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("281","947","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("282","948","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("283","949","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("284","950","","","","1","5","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("285","951","","","","1","16","","2023-09-12 00:15:10","2023-09-17 19:08:09");
INSERT INTO product_warehouse VALUES("286","952","","","","1","4","","2023-09-12 00:15:10","2023-09-16 12:56:36");
INSERT INTO product_warehouse VALUES("287","953","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("288","954","","","","1","2","","2023-09-12 00:15:10","2023-09-13 16:36:02");
INSERT INTO product_warehouse VALUES("289","955","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("290","956","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("291","957","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("292","958","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("293","959","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("294","960","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("295","961","","","","1","0","","2023-09-12 00:15:10","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("296","962","","","","1","6","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("297","963","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("298","964","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("299","965","","","","1","3","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("300","966","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("301","967","","","","1","0","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("302","968","","","","1","2","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("303","969","","","","1","4","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("304","970","","","","1","3","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("305","971","","","","1","1","","2023-09-12 00:15:10","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("306","972","","","","1","8","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("307","973","","","","1","5","","2023-09-12 00:15:10","2023-09-15 16:44:40");
INSERT INTO product_warehouse VALUES("308","974","","","","1","1","","2023-09-12 00:15:10","2023-09-12 00:15:10");
INSERT INTO product_warehouse VALUES("309","975","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("310","976","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("311","977","","","","1","14","","2023-09-12 00:15:11","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("312","978","","","","1","4","","2023-09-12 00:15:11","2023-09-18 18:15:48");
INSERT INTO product_warehouse VALUES("313","979","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("314","980","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("315","981","","","","1","1","","2023-09-12 00:15:11","2023-09-18 19:51:47");
INSERT INTO product_warehouse VALUES("316","982","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("317","983","","","","1","1","","2023-09-12 00:15:11","2023-09-15 16:41:13");
INSERT INTO product_warehouse VALUES("318","984","","","","1","7","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("319","985","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("320","986","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("321","987","","","","1","2","","2023-09-12 00:15:11","2023-09-18 21:35:32");
INSERT INTO product_warehouse VALUES("322","988","","","","1","10","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("323","989","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("324","990","","","","1","7","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("325","991","","","","1","9","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("326","992","","","","1","23","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("327","993","","","","1","8","","2023-09-12 00:15:11","2023-09-17 15:45:23");
INSERT INTO product_warehouse VALUES("328","994","","","","1","3","","2023-09-12 00:15:11","2023-09-17 15:45:23");
INSERT INTO product_warehouse VALUES("329","995","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("330","996","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("331","997","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("332","998","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("333","999","","","","1","7","","2023-09-12 00:15:11","2023-09-13 13:10:52");
INSERT INTO product_warehouse VALUES("334","1000","","","","1","2","","2023-09-12 00:15:11","2023-09-18 19:01:15");
INSERT INTO product_warehouse VALUES("335","1001","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("336","1002","","","","1","3","","2023-09-12 00:15:11","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("337","1003","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("338","1004","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("339","1005","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("340","1006","","","","1","3","","2023-09-12 00:15:11","2023-09-13 13:10:52");
INSERT INTO product_warehouse VALUES("341","1007","","","","1","4","","2023-09-12 00:15:11","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("342","1008","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("343","1009","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("344","1010","","","","1","4","","2023-09-12 00:15:11","2023-09-17 19:08:09");
INSERT INTO product_warehouse VALUES("345","1011","","","","1","16","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("346","1012","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("347","1013","","","","1","7","","2023-09-12 00:15:11","2023-09-18 13:48:15");
INSERT INTO product_warehouse VALUES("348","1014","","","","1","10","","2023-09-12 00:15:11","2023-09-18 13:48:15");
INSERT INTO product_warehouse VALUES("349","1015","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("350","1016","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("351","1017","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("352","1018","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("353","1019","","","","1","5","","2023-09-12 00:15:11","2023-09-16 17:29:23");
INSERT INTO product_warehouse VALUES("354","1020","","","","1","4","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("355","1021","","","","1","1","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("356","1022","","","","1","5","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("357","1023","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("358","1024","","","","1","5","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("359","1025","","","","1","7","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("360","1026","","","","1","7","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("361","1027","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("362","1028","","","","1","1","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("363","1029","","","","1","8","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("364","1030","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("365","1031","","","","1","10","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("366","1032","","","","1","5","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("367","1033","","","","1","5","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("368","1034","","","","1","4","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("369","1035","","","","1","16","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("370","1036","","","","1","8","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("371","1037","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("372","1038","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("373","1039","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("374","1040","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("375","1041","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("376","1042","","","","1","7","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("377","1043","","","","1","5","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("378","1044","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("379","1045","","","","1","5","","2023-09-12 00:15:11","2023-09-18 16:06:17");
INSERT INTO product_warehouse VALUES("380","1046","","","","1","16","","2023-09-12 00:15:11","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("381","1047","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("382","1048","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("383","1049","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("384","1050","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("385","1051","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("386","1052","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("387","1053","","","","1","7","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("388","1054","","","","1","11","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("389","1055","","","","1","2","","2023-09-12 00:15:11","2023-09-18 19:31:00");
INSERT INTO product_warehouse VALUES("390","1056","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("391","1057","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("392","1058","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("393","1059","","","","1","8","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("394","1060","","","","1","9","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("395","1061","","","","1","20","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("396","1062","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("397","1063","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("398","1064","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("399","1065","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("400","1066","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("401","1067","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("402","1068","","","","1","0","","2023-09-12 00:15:11","2023-09-15 18:12:05");
INSERT INTO product_warehouse VALUES("403","1069","","","","1","2","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("404","1070","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("405","1071","","","","1","2","","2023-09-12 00:15:11","2023-09-16 14:22:02");
INSERT INTO product_warehouse VALUES("406","1072","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("407","1073","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("408","1074","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("409","1075","","","","1","4","","2023-09-12 00:15:11","2023-09-13 13:10:52");
INSERT INTO product_warehouse VALUES("410","1076","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("411","1077","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("412","1078","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("413","1079","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("414","1080","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("415","1081","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("416","1082","","","","1","5","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("417","1083","","","","1","6","","2023-09-12 00:15:11","2023-09-19 13:02:53");
INSERT INTO product_warehouse VALUES("418","1084","","","","1","3","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("419","1085","","","","1","4","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("420","1086","","","","1","9","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("421","1087","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("422","1088","","","","1","0","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("423","1089","","","","1","0","","2023-09-12 00:15:11","2023-09-15 21:10:54");
INSERT INTO product_warehouse VALUES("424","1090","","","","1","1","","2023-09-12 00:15:11","2023-09-12 00:15:11");
INSERT INTO product_warehouse VALUES("425","1091","","","","1","9","1300","2023-09-13 13:19:41","2023-09-13 13:19:41");
INSERT INTO product_warehouse VALUES("426","1092","","","","1","9","","2023-09-13 13:55:59","2023-09-17 14:34:24");
INSERT INTO product_warehouse VALUES("427","1093","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("428","1094","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("429","1095","","","","1","2","","2023-09-13 13:55:59","2023-09-17 15:19:12");
INSERT INTO product_warehouse VALUES("430","1096","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("431","1097","","","","1","1","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("432","1098","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("433","1099","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("434","1100","","","","1","3","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("435","1101","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("436","1102","","","","1","3","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("437","1103","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("438","1104","","","","1","8","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("439","1105","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("440","1106","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("441","1107","","","","1","9","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("442","1108","","","","1","1","","2023-09-13 13:55:59","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("443","1109","","","","1","3","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("444","1110","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("445","1111","","","","1","4","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("446","1112","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("447","1113","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("448","1114","","","","1","1","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("449","1115","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("450","1116","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("451","1117","","","","1","5","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("452","1118","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("453","1119","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("454","1120","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("455","1121","","","","1","1","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("456","1122","","","","1","4","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("457","1123","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("458","1124","","","","1","2","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO product_warehouse VALUES("459","1125","","","","1","11","200","2023-09-13 14:33:30","2025-01-13 15:53:29");
INSERT INTO product_warehouse VALUES("460","1127","","","","1","2","140","2023-09-13 14:57:10","2023-09-13 14:57:10");
INSERT INTO product_warehouse VALUES("461","1128","","","","1","10","200","2023-09-13 19:07:11","2023-09-16 17:02:22");
INSERT INTO product_warehouse VALUES("462","1129","","","","1","9","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("463","1130","","","","1","5","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("464","1131","","","","1","1","","2023-09-19 15:50:21","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("465","1132","","","","1","-40","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("466","1133","","","","1","-7","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("467","1134","","","","1","0","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("468","1135","","","","1","-258","","2023-09-19 15:50:21","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("469","1136","","","","1","1","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("470","1137","","","","1","2","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("471","1138","","","","1","0","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("472","1139","","","","1","-18","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("473","1140","","","","1","9","","2023-09-19 15:50:21","2023-11-29 16:29:34");
INSERT INTO product_warehouse VALUES("474","1141","","","","1","2","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("475","1142","","","","1","2","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("476","1143","","","","1","1","","2023-09-19 15:50:21","2023-10-21 18:07:38");
INSERT INTO product_warehouse VALUES("477","1144","","","","1","-19","","2023-09-19 15:50:21","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("478","1145","","","","1","1","","2023-09-19 15:50:21","2023-10-21 18:07:38");
INSERT INTO product_warehouse VALUES("479","1146","","","","1","-7","","2023-09-19 15:50:21","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("480","1147","","","","1","-1","","2023-09-19 15:50:21","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("481","1148","","","","1","-17","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("482","1149","","","","1","4","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("483","1150","","","","1","3","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("484","1151","","","","1","0","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("485","1152","","","","1","-14","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("486","1153","","","","1","2","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("487","1154","","","","1","0","","2023-09-19 15:50:21","2023-11-02 19:23:24");
INSERT INTO product_warehouse VALUES("488","1155","","","","1","-29","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("489","1156","","","","1","0","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("490","1157","","","","1","0","","2023-09-19 15:50:21","2023-10-12 18:40:27");
INSERT INTO product_warehouse VALUES("491","1158","","","","1","1","","2023-09-19 15:50:21","2023-09-19 15:50:21");
INSERT INTO product_warehouse VALUES("492","1159","","","","1","2","","2023-09-19 15:50:21","2023-11-22 12:26:19");
INSERT INTO product_warehouse VALUES("493","1160","","","","1","-26","","2023-09-19 15:50:21","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("494","1161","","","","1","2","","2023-09-19 15:50:22","2023-10-04 18:38:29");
INSERT INTO product_warehouse VALUES("495","1162","","","","1","-27","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("496","1163","","","","1","-9","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("497","1164","","","","1","-12","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("498","1165","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("499","1166","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("500","1167","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("501","1168","","","","1","7","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("502","1169","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("503","1170","","","","1","6","","2023-09-19 15:50:22","2023-09-21 13:47:57");
INSERT INTO product_warehouse VALUES("504","1171","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("505","1172","","","","1","9","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("506","1173","","","","1","1","","2023-09-19 15:50:22","2023-11-07 15:06:59");
INSERT INTO product_warehouse VALUES("507","1174","","","","1","2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("508","1175","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("509","1176","","","","1","10","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("510","1177","","","","1","2","","2023-09-19 15:50:22","2023-10-14 13:46:24");
INSERT INTO product_warehouse VALUES("511","1178","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("512","1179","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("513","1180","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("514","1181","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("515","1182","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("516","1183","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("517","1184","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("518","1185","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("519","1186","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("520","1187","","","","1","4","","2023-09-19 15:50:22","2023-10-12 18:40:27");
INSERT INTO product_warehouse VALUES("521","1188","","","","1","-1","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("522","1189","","","","1","3","","2023-09-19 15:50:22","2023-10-22 16:40:08");
INSERT INTO product_warehouse VALUES("523","1190","","","","1","1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("524","1191","","","","1","-10","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("525","1192","","","","1","-3","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("526","1193","","","","1","-20","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("527","1194","","","","1","0","","2023-09-19 15:50:22","2023-10-25 16:18:30");
INSERT INTO product_warehouse VALUES("528","1195","","","","1","1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("529","1196","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("530","1197","","","","1","-7","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("531","1198","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("532","1199","","","","1","0","","2023-09-19 15:50:22","2023-11-03 19:40:58");
INSERT INTO product_warehouse VALUES("533","1200","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("534","1201","","","","1","0","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("535","1202","","","","1","3","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("536","1203","","","","1","2","","2023-09-19 15:50:22","2023-10-15 18:24:27");
INSERT INTO product_warehouse VALUES("537","1204","","","","1","0","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("538","1205","","","","1","0","","2023-09-19 15:50:22","2023-10-23 16:23:00");
INSERT INTO product_warehouse VALUES("539","1206","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("540","1207","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("541","1208","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("542","1209","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("543","1210","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("544","1211","","","","1","3","","2023-09-19 15:50:22","2023-10-04 18:38:29");
INSERT INTO product_warehouse VALUES("545","1212","","","","1","-1","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("546","1213","","","","1","3","","2023-09-19 15:50:22","2023-11-11 13:16:23");
INSERT INTO product_warehouse VALUES("547","1214","","","","1","-2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("548","1215","","","","1","0","","2023-09-19 15:50:22","2023-11-11 15:11:22");
INSERT INTO product_warehouse VALUES("549","1216","","","","1","-1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("550","1217","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("551","1218","","","","1","0","","2023-09-19 15:50:22","2023-11-09 19:35:52");
INSERT INTO product_warehouse VALUES("552","1219","","","","1","2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("553","1220","","","","1","19","","2023-09-19 15:50:22","2023-11-05 19:37:56");
INSERT INTO product_warehouse VALUES("554","1221","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("555","1222","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("556","1223","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("557","1224","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("558","1225","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("559","1226","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("560","1227","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("561","1228","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("562","1229","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("563","1230","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("564","1231","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("565","1232","","","","1","9","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("566","1233","","","","1","0","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("567","1234","","","","1","2","","2023-09-19 15:50:22","2023-10-10 14:58:20");
INSERT INTO product_warehouse VALUES("568","1235","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("569","1236","","","","1","-1","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("570","1237","","","","1","-10","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("571","1238","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("572","1239","","","","1","80","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("573","1240","","","","1","-6","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("574","1241","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("575","1242","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("576","1243","","","","1","1","","2023-09-19 15:50:22","2023-11-12 21:24:54");
INSERT INTO product_warehouse VALUES("577","1244","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("578","1245","","","","1","0","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("579","1246","","","","1","2","","2023-09-19 15:50:22","2023-10-21 17:00:39");
INSERT INTO product_warehouse VALUES("580","1247","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("581","1248","","","","1","1","","2023-09-19 15:50:22","2023-11-17 14:52:12");
INSERT INTO product_warehouse VALUES("582","1249","","","","1","0","","2023-09-19 15:50:22","2023-10-04 18:44:21");
INSERT INTO product_warehouse VALUES("583","1250","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("584","1251","","","","1","1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("585","1252","","","","1","6","","2023-09-19 15:50:22","2023-11-09 21:18:48");
INSERT INTO product_warehouse VALUES("586","1253","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("587","1254","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("588","1255","","","","1","1","","2023-09-19 15:50:22","2023-10-18 16:07:41");
INSERT INTO product_warehouse VALUES("589","1256","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("590","1257","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("591","1258","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("592","1259","","","","1","0","","2023-09-19 15:50:22","2023-10-27 21:51:15");
INSERT INTO product_warehouse VALUES("593","1260","","","","1","3","","2023-09-19 15:50:22","2023-09-23 15:28:36");
INSERT INTO product_warehouse VALUES("594","1261","","","","1","1","","2023-09-19 15:50:22","2023-09-23 15:28:36");
INSERT INTO product_warehouse VALUES("595","1262","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("596","1263","","","","1","-1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("597","1264","","","","1","0","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("598","1265","","","","1","-1","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("599","1266","","","","1","-5","","2023-09-19 15:50:22","2025-01-07 11:24:03");
INSERT INTO product_warehouse VALUES("600","1267","","","","1","0","","2023-09-19 15:50:22","2023-10-14 19:28:38");
INSERT INTO product_warehouse VALUES("601","1268","","","","1","0","","2023-09-19 15:50:22","2023-11-27 20:23:48");
INSERT INTO product_warehouse VALUES("602","1269","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("603","1270","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("604","1271","","","","1","-1","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("605","1272","","","","1","-1","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("606","1273","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("607","1274","","","","1","-4","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("608","1275","","","","1","-2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("609","1276","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("610","1277","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("611","1278","","","","1","-2","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("612","1279","","","","1","7","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("613","1280","","","","1","0","","2023-09-19 15:50:22","2023-11-13 12:45:52");
INSERT INTO product_warehouse VALUES("614","1281","","","","1","-8","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("615","1282","","","","1","9","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("616","1283","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("617","1284","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("618","1285","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("619","1286","","","","1","1","","2023-09-19 15:50:22","2023-11-07 15:44:41");
INSERT INTO product_warehouse VALUES("620","1287","","","","1","3","","2023-09-19 15:50:22","2023-11-17 14:49:00");
INSERT INTO product_warehouse VALUES("621","1288","","","","1","2","","2023-09-19 15:50:22","2023-11-09 21:36:16");
INSERT INTO product_warehouse VALUES("622","1289","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("623","1290","","","","1","6","","2023-09-19 15:50:22","2023-11-07 15:44:41");
INSERT INTO product_warehouse VALUES("624","1291","","","","1","2","","2023-09-19 15:50:22","2023-11-08 15:22:35");
INSERT INTO product_warehouse VALUES("625","1292","","","","1","3","","2023-09-19 15:50:22","2023-11-08 15:22:35");
INSERT INTO product_warehouse VALUES("626","1293","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("627","1294","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("628","1295","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("629","1296","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("630","1297","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("631","1298","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("632","1299","","","","1","4","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("633","1300","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("634","1301","","","","1","89","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("635","1302","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("636","1303","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("637","1304","","","","1","-4","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("638","1305","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("639","1306","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("640","1307","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("641","1308","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("642","1309","","","","1","5","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("643","1310","","","","1","1","","2023-09-19 15:50:22","2023-10-16 18:48:20");
INSERT INTO product_warehouse VALUES("644","1311","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("645","1312","","","","1","-2","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("646","1313","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("647","1314","","","","1","2","","2023-09-19 15:50:22","2023-11-08 15:22:35");
INSERT INTO product_warehouse VALUES("648","1315","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("649","1316","","","","1","-11","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("650","1317","","","","1","-6","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("651","1318","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("652","1319","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("653","1320","","","","1","-8","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("654","1321","","","","1","2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("655","1322","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("656","1323","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("657","1324","","","","1","9","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("658","1325","","","","1","1","","2023-09-19 15:50:22","2023-11-09 16:18:16");
INSERT INTO product_warehouse VALUES("659","1326","","","","1","2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("660","1327","","","","1","-2","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("661","1328","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("662","1329","","","","1","6","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("663","1330","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("664","1331","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("665","1332","","","","1","1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("666","1333","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("667","1334","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("668","1335","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("669","1336","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("670","1337","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("671","1338","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("672","1339","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("673","1340","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("674","1341","","","","1","-2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("675","1342","","","","1","-4","","2023-09-19 15:50:22","2025-01-07 11:24:03");
INSERT INTO product_warehouse VALUES("676","1343","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("677","1344","","","","1","4","","2023-09-19 15:50:22","2023-10-31 15:02:35");
INSERT INTO product_warehouse VALUES("678","1345","","","","1","0","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("679","1346","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("680","1347","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("681","1348","","","","1","4","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("682","1349","","","","1","6","","2023-09-19 15:50:22","2023-11-07 12:54:28");
INSERT INTO product_warehouse VALUES("683","1350","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("684","1351","","","","1","9","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("685","1352","","","","1","3","","2023-09-19 15:50:22","2023-10-19 17:19:30");
INSERT INTO product_warehouse VALUES("686","1353","","","","1","2","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("687","1354","","","","1","3","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("688","1355","","","","1","15","","2023-09-19 15:50:22","2023-11-12 19:18:50");
INSERT INTO product_warehouse VALUES("689","1356","","","","1","2","","2023-09-19 15:50:22","2023-12-01 17:05:04");
INSERT INTO product_warehouse VALUES("690","1357","","","","1","-3","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("691","1358","","","","1","-8","","2023-09-19 15:50:22","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("692","1359","","","","1","0","","2023-09-19 15:50:22","2023-11-27 18:09:42");
INSERT INTO product_warehouse VALUES("693","1360","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("694","1361","","","","1","4","","2023-09-19 15:50:22","2023-10-25 12:32:11");
INSERT INTO product_warehouse VALUES("695","1362","","","","1","2","","2023-09-19 15:50:22","2023-09-20 18:00:35");
INSERT INTO product_warehouse VALUES("696","1363","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("697","1364","","","","1","47","","2023-09-19 15:50:22","2023-10-24 20:53:53");
INSERT INTO product_warehouse VALUES("698","1365","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("699","1366","","","","1","4","","2023-09-19 15:50:22","2023-10-02 20:51:30");
INSERT INTO product_warehouse VALUES("700","1367","","","","1","2","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("701","1368","","","","1","2","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("702","1369","","","","1","2","","2023-09-19 15:50:22","2023-11-17 14:52:12");
INSERT INTO product_warehouse VALUES("703","1370","","","","1","5","","2023-09-19 15:50:22","2023-10-20 19:05:10");
INSERT INTO product_warehouse VALUES("704","1371","","","","1","8","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("705","1372","","","","1","0","","2023-09-19 15:50:22","2025-01-13 15:53:28");
INSERT INTO product_warehouse VALUES("706","1373","","","","1","3","","2023-09-19 15:50:22","2023-10-23 16:51:12");
INSERT INTO product_warehouse VALUES("707","1374","","","","1","0","","2023-09-19 15:50:22","2023-09-22 14:56:51");
INSERT INTO product_warehouse VALUES("708","1375","","","","1","1","","2023-09-19 15:50:22","2023-09-19 15:50:22");
INSERT INTO product_warehouse VALUES("709","1376","","","","1","-1","","2023-09-19 15:50:22","2025-01-07 11:25:25");
INSERT INTO product_warehouse VALUES("710","1377","","","","1","2","","2023-09-19 15:50:22","2023-09-25 17:31:15");
INSERT INTO product_warehouse VALUES("711","1378","","","","1","4","100","2023-09-19 16:39:37","2023-10-02 13:49:33");
INSERT INTO product_warehouse VALUES("712","1379","","","","1","100","20","2023-09-19 23:46:07","2023-09-19 23:47:36");
INSERT INTO product_warehouse VALUES("713","1381","","","","1","54","10","2023-10-03 17:03:03","2023-11-09 19:57:42");
INSERT INTO product_warehouse VALUES("714","1382","","","","1","39","10","2023-10-03 17:03:03","2023-11-05 20:07:38");
INSERT INTO product_warehouse VALUES("715","1380","","","","1","91","20","2023-10-03 17:03:03","2023-11-04 19:13:17");
INSERT INTO product_warehouse VALUES("716","1383","","","","1","5","100","2023-10-03 17:04:28","2023-10-03 17:04:28");
INSERT INTO product_warehouse VALUES("717","1384","","","","1","-2","","2023-10-09 20:38:39","2025-01-07 11:24:26");
INSERT INTO product_warehouse VALUES("718","1385","","","","2","37","","2025-01-07 10:48:17","2025-03-22 19:19:40");
INSERT INTO product_warehouse VALUES("719","1387","","","","2","6","","2025-01-18 22:42:25","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("720","1388","","2","","2","3","","2025-02-25 13:17:28","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("721","1389","","","","2","2","","2025-02-25 14:06:51","2025-03-31 16:25:10");
INSERT INTO product_warehouse VALUES("722","1390","","","","2","7","","2025-02-25 14:06:51","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("723","1398","","","","2","26","","2025-02-25 14:24:39","2025-04-01 17:46:35");
INSERT INTO product_warehouse VALUES("724","1397","","","","2","12","","2025-02-25 14:24:39","2025-04-01 17:46:35");
INSERT INTO product_warehouse VALUES("725","1395","","","","2","17","","2025-02-25 14:24:39","2025-04-01 09:55:05");
INSERT INTO product_warehouse VALUES("726","1393","","","","2","6","","2025-02-25 14:24:39","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("727","1396","","","","2","4","","2025-02-25 14:24:39","2025-03-31 19:09:16");
INSERT INTO product_warehouse VALUES("728","1392","","","","2","16","","2025-02-25 14:24:39","2025-03-31 18:37:31");
INSERT INTO product_warehouse VALUES("729","1401","","","","2","0","","2025-02-25 14:33:31","2025-04-01 16:03:16");
INSERT INTO product_warehouse VALUES("730","1405","","","","2","8","","2025-02-28 13:59:48","2025-04-01 15:37:48");
INSERT INTO product_warehouse VALUES("731","1404","","","","2","7","250","2025-02-28 13:59:48","2025-03-31 15:56:40");
INSERT INTO product_warehouse VALUES("732","1403","","","","2","5","","2025-02-28 13:59:48","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("733","1408","","","","2","47","120","2025-02-28 13:59:48","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("734","1402","","","","2","10","120","2025-02-28 13:59:48","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("735","1409","","","","2","5","","2025-02-28 13:59:48","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("736","1411","","","","2","20","","2025-02-28 13:59:48","2025-04-01 16:03:16");
INSERT INTO product_warehouse VALUES("737","1410","","","","2","30","","2025-02-28 14:15:36","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("738","1418","","","","2","6","200","2025-02-28 14:15:36","2025-03-31 16:56:36");
INSERT INTO product_warehouse VALUES("739","1424","","","","2","7","","2025-02-28 14:15:36","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("740","1416","","","","2","28","30","2025-02-28 14:15:36","2025-03-22 17:23:57");
INSERT INTO product_warehouse VALUES("741","1417","","","","2","5","20","2025-02-28 14:15:36","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("742","1406","","","","2","6","","2025-02-28 14:15:36","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("743","1391","","","","2","6","","2025-02-28 14:15:36","2025-03-31 18:37:31");
INSERT INTO product_warehouse VALUES("744","1426","","","","2","6","","2025-02-28 14:54:11","2025-04-01 17:46:35");
INSERT INTO product_warehouse VALUES("745","1431","","","","2","4","","2025-02-28 14:54:11","2025-03-26 09:32:11");
INSERT INTO product_warehouse VALUES("746","1430","","","","2","0","100","2025-02-28 14:54:11","2025-04-01 17:46:35");
INSERT INTO product_warehouse VALUES("747","1429","","","","2","5","350","2025-02-28 14:54:11","2025-03-31 19:30:18");
INSERT INTO product_warehouse VALUES("748","1428","","","","2","6","","2025-02-28 14:54:11","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("749","1425","","","","2","9","150","2025-02-28 14:54:11","2025-04-01 17:46:35");
INSERT INTO product_warehouse VALUES("750","1414","","","","2","25","","2025-03-13 18:10:35","2025-04-01 16:03:16");
INSERT INTO product_warehouse VALUES("751","1413","","","","2","20","","2025-03-13 18:12:20","2025-04-01 16:03:16");
INSERT INTO product_warehouse VALUES("752","1455","","","","2","3","100","2025-03-13 18:55:55","2025-04-01 15:37:48");
INSERT INTO product_warehouse VALUES("753","1458","","","","2","3","","2025-03-13 18:55:55","2025-03-31 18:07:00");
INSERT INTO product_warehouse VALUES("754","1459","","","","2","3","","2025-03-13 18:55:55","2025-04-01 15:37:48");
INSERT INTO product_warehouse VALUES("755","1415","","","","2","4","80","2025-03-13 18:55:55","2025-03-31 19:09:16");
INSERT INTO product_warehouse VALUES("756","1457","","","","2","3","250","2025-03-13 18:55:55","2025-03-31 17:19:05");
INSERT INTO product_warehouse VALUES("757","1456","","","","2","4","250","2025-03-13 18:55:55","2025-04-01 15:37:48");
INSERT INTO product_warehouse VALUES("758","1422","","","","2","4","","2025-03-13 18:55:55","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("759","1432","","","","2","4","","2025-03-13 18:55:55","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("760","1454","","","","2","9","100","2025-03-14 13:01:13","2025-03-31 18:37:31");
INSERT INTO product_warehouse VALUES("761","1441","","","","2","7","","2025-03-14 13:01:13","2025-03-25 17:43:16");
INSERT INTO product_warehouse VALUES("762","1436","","","","2","12","180","2025-03-14 13:01:13","2025-04-01 16:18:18");
INSERT INTO product_warehouse VALUES("763","1443","","","","2","69","","2025-03-14 13:01:13","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("764","1442","","","","2","0","3500","2025-03-14 13:01:13","2025-03-18 17:34:23");
INSERT INTO product_warehouse VALUES("765","1460","","","","2","2","","2025-03-18 16:20:10","2025-03-22 18:46:53");
INSERT INTO product_warehouse VALUES("766","1461","","","","2","2","","2025-03-18 16:26:48","2025-03-19 20:24:28");
INSERT INTO product_warehouse VALUES("767","1446","","","","2","0","","2025-03-18 16:57:44","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("768","1440","","","","2","2","250","2025-03-18 16:57:44","2025-03-24 19:05:05");
INSERT INTO product_warehouse VALUES("769","1444","","","","2","53","","2025-03-18 16:57:44","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("770","1421","","","","2","5","100","2025-03-18 16:57:44","2025-03-31 17:10:53");
INSERT INTO product_warehouse VALUES("771","1462","","","","2","43","","2025-03-19 18:50:35","2025-04-01 17:58:31");
INSERT INTO product_warehouse VALUES("772","1463","","","","2","3","","2025-03-19 18:55:56","2025-04-01 15:49:09");
INSERT INTO product_warehouse VALUES("773","1464","","","","2","16","","2025-03-19 19:21:38","2025-03-25 18:24:16");
INSERT INTO product_warehouse VALUES("774","1465","","","","2","18","","2025-03-21 10:18:30","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("775","1466","","","","2","7","","2025-03-21 10:20:24","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("776","1467","","","","2","0","","2025-03-21 10:28:08","2025-03-31 19:09:16");
INSERT INTO product_warehouse VALUES("777","1468","","","","2","4","","2025-03-21 11:25:32","2025-03-22 16:30:06");
INSERT INTO product_warehouse VALUES("778","1469","","","","2","1","","2025-03-21 12:42:14","2025-03-31 19:38:58");
INSERT INTO product_warehouse VALUES("779","1470","","","","2","1","","2025-03-21 12:45:59","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("780","1471","","","","2","8","","2025-03-21 12:48:24","2025-04-01 18:09:23");
INSERT INTO product_warehouse VALUES("781","1472","","","","2","8","","2025-03-21 12:53:32","2025-03-31 18:02:23");
INSERT INTO product_warehouse VALUES("782","1451","","","","2","2","450","2025-03-21 19:22:19","2025-04-01 16:03:16");
INSERT INTO product_warehouse VALUES("783","1450","","","","2","0","250","2025-03-21 19:22:19","2025-03-29 13:09:57");
INSERT INTO product_warehouse VALUES("784","1473","","","","2","13","","2025-03-21 19:27:15","2025-03-29 13:00:41");
INSERT INTO product_warehouse VALUES("785","1474","","","","2","3","","2025-03-21 19:29:11","2025-03-21 20:02:07");
INSERT INTO product_warehouse VALUES("786","1453","","","","2","1","","2025-03-21 19:55:21","2025-03-31 17:10:53");
INSERT INTO product_warehouse VALUES("787","1447","","","","2","20","30","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_warehouse VALUES("788","1439","","","","2","4","120","2025-03-21 19:55:21","2025-03-22 19:40:15");
INSERT INTO product_warehouse VALUES("789","1434","","","","2","10","300","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_warehouse VALUES("790","1438","","","","2","5","250","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_warehouse VALUES("791","1412","","","","2","13","","2025-03-21 19:55:21","2025-03-28 10:14:38");
INSERT INTO product_warehouse VALUES("792","1407","","","","2","7","50","2025-03-21 19:55:21","2025-03-31 19:38:58");
INSERT INTO product_warehouse VALUES("793","1435","","","","2","20","20","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_warehouse VALUES("794","1423","","","","2","0","300","2025-03-21 19:55:21","2025-03-31 15:43:15");
INSERT INTO product_warehouse VALUES("795","1400","","","","2","9","180","2025-03-21 19:55:21","2025-03-21 20:37:41");
INSERT INTO product_warehouse VALUES("796","1399","","","","2","10","105","2025-03-21 19:55:21","2025-03-21 19:55:21");
INSERT INTO product_warehouse VALUES("797","1427","","","","2","7","","2025-03-21 19:55:21","2025-03-31 16:00:09");
INSERT INTO product_warehouse VALUES("798","1475","","","","2","4","","2025-03-22 12:42:00","2025-03-22 14:40:37");
INSERT INTO product_warehouse VALUES("799","1476","","","","2","6","","2025-03-22 12:49:39","2025-04-01 19:07:10");
INSERT INTO product_warehouse VALUES("800","1477","","","","2","3","","2025-03-22 14:01:02","2025-03-22 17:45:49");
INSERT INTO product_warehouse VALUES("801","1478","","","","2","3","","2025-03-22 14:15:10","2025-03-31 15:56:40");
INSERT INTO product_warehouse VALUES("802","1479","","","","2","8","","2025-03-22 14:35:48","2025-03-22 16:16:59");
INSERT INTO product_warehouse VALUES("803","1480","","","","2","9","","2025-03-22 16:34:42","2025-03-22 18:07:03");
INSERT INTO product_warehouse VALUES("804","1481","","","","2","6","","2025-03-22 16:37:19","2025-03-24 19:05:05");
INSERT INTO product_warehouse VALUES("805","1482","","","","2","10","","2025-03-22 17:03:40","2025-03-22 18:06:33");
INSERT INTO product_warehouse VALUES("806","1483","","","","2","3","","2025-03-22 17:27:14","2025-03-24 18:18:19");
INSERT INTO product_warehouse VALUES("807","1484","","","","2","0","","2025-03-22 18:20:59","2025-03-22 18:26:38");
INSERT INTO product_warehouse VALUES("808","1485","","","","2","7","","2025-03-22 19:14:32","2025-03-31 18:02:23");
INSERT INTO product_warehouse VALUES("809","1486","","","","2","8","","2025-03-22 19:26:05","2025-03-22 20:11:03");
INSERT INTO product_warehouse VALUES("810","1487","","","","2","0","","2025-03-22 19:53:00","2025-03-31 19:09:16");
INSERT INTO product_warehouse VALUES("811","1488","","","","2","12","","2025-03-24 18:21:33","2025-04-01 16:16:01");
INSERT INTO product_warehouse VALUES("812","1489","","","","2","7","","2025-03-24 18:25:10","2025-03-25 18:39:43");
INSERT INTO product_warehouse VALUES("813","1490","","","","2","7","","2025-03-24 19:57:03","2025-03-31 16:25:10");
INSERT INTO product_warehouse VALUES("814","1491","","","","2","6","","2025-03-24 20:14:06","2025-04-01 15:49:09");
INSERT INTO product_warehouse VALUES("815","1492","","","","2","0","","2025-03-24 20:21:27","2025-03-24 20:26:31");
INSERT INTO product_warehouse VALUES("816","1493","","","","2","9","","2025-03-25 18:56:20","2025-03-26 09:32:11");
INSERT INTO product_warehouse VALUES("817","1494","","","","2","4","","2025-03-26 19:26:27","2025-03-26 20:25:12");
INSERT INTO product_warehouse VALUES("818","1495","","","","2","2","","2025-03-27 18:55:44","2025-04-01 15:37:48");
INSERT INTO product_warehouse VALUES("819","1497","","","","2","6","750","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_warehouse VALUES("820","1496","","","","2","6","750","2025-03-28 10:14:38","2025-03-28 10:14:38");
INSERT INTO product_warehouse VALUES("821","1498","","","","2","5","","2025-03-31 15:07:51","2025-03-31 19:09:16");
INSERT INTO product_warehouse VALUES("822","1499","","","","2","5","","2025-03-31 15:47:43","2025-03-31 16:28:38");
INSERT INTO product_warehouse VALUES("823","1500","","","","2","4","","2025-03-31 17:51:28","2025-04-01 09:15:34");



CREATE TABLE `products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_symbology` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand_id` int DEFAULT NULL,
  `category_id` int NOT NULL,
  `unit_id` int NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `sale_unit_id` int NOT NULL,
  `cost` int NOT NULL,
  `price` int NOT NULL,
  `qty` double DEFAULT NULL,
  `alert_quantity` double DEFAULT NULL,
  `daily_sale_objective` double DEFAULT NULL,
  `promotion` tinyint DEFAULT NULL,
  `promotion_price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `starting_date` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_date` date DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_method` int DEFAULT NULL,
  `image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_embeded` tinyint(1) DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT NULL,
  `is_batch` tinyint(1) DEFAULT NULL,
  `is_diffPrice` tinyint(1) DEFAULT NULL,
  `is_imei` tinyint(1) DEFAULT NULL,
  `featured` tinyint DEFAULT NULL,
  `product_list` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `variant_list` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty_list` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_list` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `variant_option` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `variant_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES("879","ADJUSTER COMP,CHA","40543-KYY-901","standard","C128","1","1","1","1","1","346","435","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("880","ARM ASSY,KICK STA","28300-KYY-900","standard","C128","1","1","1","1","1","982","1230","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("881","ARM COMP., IN. VALVE ROCKER","14430-GGC-900","standard","C128","1","1","1","1","1","1115","1394","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("882","ARM COMP.CAM CHAIN TENSIONER","14500-KYY-901","standard","C128","1","1","1","1","1","175","220","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("883","ARM, REAR BRAK","43410-KYY-900","standard","C128","1","1","1","1","1","237","330","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("884","ARM,FRONT BRAKE","45410-KVX-600","standard","C128","1","1","1","1","1","212","265","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("885","AXLE,FR WHEEL","44301-KYY-900","standard","C128","1","1","1","1","1","321","405","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("886","BALL ASSY,STEEL 6","06530-KRF-H70","standard","C128","1","1","1","1","1","72","90","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("887","BAND,BATTERY","50326-KYY-970","standard","C128","1","1","1","1","1","102","130","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("888","BAR COMP,STEP","50610-KYY-970","standard","C128","1","1","1","1","1","1253","1566","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("889","BARCOMP,SIDESTA","50530-KYY-900","standard","C128","1","1","1","1","1","365","460","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("890","BATTERY YB7BL-A","31500KG3505","standard","C128","1","1","1","1","1","2164","3300","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("891","BEARING, RADIAL BALL, 6200","96100-620-0000","standard","C128","1","1","1","1","1","297","375","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("892","BEARING, RADIAL BALL, 63/22 (N","91001-KWS-901","standard","C128","1","1","1","1","1","635","800","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("893","BEARING, RADIAL BALL, 6301UU","91051-KPN-A71","standard","C128","1","1","1","1","1","386","490","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("894","BOADCOMP,LPI","50725-KYY-970","standard","C128","1","1","1","1","1","1420","1620","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("895","BOLT, FLANGE, 6X8","95701-060-0800","standard","C128","1","1","1","1","1","9","15","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("896","BOLT, HEX 8X28","92101-080-280A","standard","C128","1","1","1","1","1","24","35","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("897","Bolt, hex,6x10","92101-060-100A","standard","C128","1","1","1","1","1","7","20","49","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("898","BOLT,DRAIN PLL","92800-120-00","standard","C128","1","1","1","1","1","48","75","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("899","BOLT,FLANGE","95701-080-4500","standard","C128","1","1","1","1","1","49","65","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("900","BOLT,FLANGE,10","90132-KBS-920","standard","C128","1","1","1","1","1","199","250","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("901","BOLT,FLANGE,SI","96001-060-2500","standard","C128","1","1","1","1","1","10","30","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("902","BOLT,HANDLE LEVER","90113-KYY-900","standard","C128","1","1","1","1","1","69","85","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("903","BOLT,SWINGARM PIV","52101-KYY-900","standard","C128","1","1","1","1","1","343","430","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("904","BOOT,HDLT STAY LO","61316-KVX-600","standard","C128","1","1","1","1","1","28","40","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("905","BOOT,HDLT STAY UP","61315-KVX-600","standard","C128","1","1","1","1","1","16","20","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("906","BRG, BAL RADIA","91005-KYY-931","standard","C128","1","1","1","1","1","200","255","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("907","BRG, BALL RADIAL 6","91053KYY903","standard","C128","1","1","1","1","1","407","508","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("908","BRG,BALL RADIA","91053-KYY-902","standard","C128","1","1","1","1","1","438","550","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("909","BRG,BALL RADIAL62","91004-KYY-931","standard","C128","1","1","1","1","1","223","280","16","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("910","BRKT, L HNDL LEVER","53172-K14-910","standard","C128","1","1","1","1","1","486","620","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("911","BRKT,NUMBER P","84701-KYY-970","standard","C128","1","1","1","1","1","355","405","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("912","BULB, HEADLIGHT (12V 35/35W)","34901-388-611","standard","C128","1","1","1","1","1","188","235","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("913","BULB, POSITION LIGHT (12V 5W)","33301-KVJ-911","standard","C128","1","1","1","1","1","341","430","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("914","BULB, TAIL &amp;amp; STOP LIGHT (12V 2","34906-447-711","standard","C128","1","1","1","1","1","127","160","90","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("915","BULB, WINKER LIGHT","34904-KYY-F01","standard","C128","1","1","1","1","1","142","180","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("916","BULB,WINKER(12V 1","34907-KSW-971","standard","C128","1","1","1","1","1","49","65","12","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:21");
INSERT INTO products VALUES("917","CABLE ASSY,SPDMT","44830-KYY-901","standard","C128","1","1","1","1","1","244","305","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("918","CABLE COMP,CLUTCH","22870-K52-N71","standard","C128","1","1","1","1","1","288","360","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("919","CABLE COMP,FR BRK","45450-KYY-970","standard","C128","1","1","1","1","1","242","305","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("920","CABLE SET,THROT","17920-KYY-970","standard","C128","1","1","1","1","1","315","395","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("921","CAP ASSY,NOISE(SU","30700-KYY-901","standard","C128","1","1","1","1","1","310","390","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("922","CAP COMP,FUEL","17620-K08-A41","standard","C128","1","1","1","1","1","746","850","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("923","CAP COMP., FUEL FILLER","17620-KVX-601","standard","C128","1","1","1","1","1","874","1095","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("924","CAP, CHAIN CASE PEEP HOLE","40545-001-000","standard","C128","1","1","1","1","1","53","100","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("925","CAP, SWINGARM END","40546-KYY-900","standard","C128","1","1","1","1","1","108","135","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("926","CAP,PIPE END","50315-KYY-900","standard","C128","1","1","1","1","1","29","40","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("927","CASE SUB ASSY,AIR","17225-KYY-970","standard","C128","1","1","1","1","1","597","750","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("928","CASE, DRIVE NH3","40520-KYY-970-ZB","standard","C128","1","1","1","1","1","2086","2610","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("929","CASE,DRIVE*NH35M*","40510-KYY-970ZB","standard","C128","1","1","1","1","1","1537","1925","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("930","CASE,HEAD LIGHT","61300-KYY-970","standard","C128","1","1","1","1","1","234","295","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("931","CASE,LBOTTOM","51520-KYY-902","standard","C128","1","1","1","1","1","3385","4235","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("932","CASE,LOWER","37223-KYY-970","standard","C128","1","1","1","1","1","492","580","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("933","CASE,R BOTTOM","51420-KYY-971","standard","C128","1","1","1","1","1","3313","4145","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("934","CENTER, CLUTCH","22120-KWS-901","standard","C128","1","1","1","1","1","714","895","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("935","CENTER,CLUTCH","22120-KYY-D01","standard","C128","1","1","1","1","1","735","920","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("936","CHAIN CAM (90L","14401-K76-T61","standard","C128","1","1","1","1","1","319","500","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("937","Chain Drive. Km","40530-K08-A42","standard","C128","1","1","1","1","1","620","700","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("938","CHAIN,CAM88LESH","14401-K08-901","standard","C128","1","1","1","1","1","413","516","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("939","CHAIN,DRIVE KMC42","40530-KYY-901","standard","C128","1","1","1","1","1","773","970","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("940","CLIP,PISTONPIN,12MM","13115-KWS-900","standard","C128","1","1","1","1","1","11","15","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:28");
INSERT INTO products VALUES("941","COIL","31120-KYY-971","standard","C128","1","1","1","1","1","2056","2300","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("942","COLLAR, COM","14532-KWS-900","standard","C128","1","1","1","1","1","22","30","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("943","COLLAR, SEAT","77201-KYY-900","standard","C128","1","1","1","1","1","30","45","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("944","COLLAR,AIR/C","17223-KVX-600","standard","C128","1","1","1","1","1","19","25","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("945","COUNTER SHAFT","23221-KYY-900","standard","C128","1","1","1","1","1","609","765","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("946","CRANK SHAFT COMP","13000-KYY-900","standard","C128","1","1","1","1","1","7061","8830","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("947","CUP SET,FUEL STRA","16953-KWK-900","standard","C128","1","1","1","1","1","143","190","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("948","CUSHION ASSY,REAR","52400-KYY-972","standard","C128","1","1","1","1","1","2137","2780","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("949","DAMPER SET, WHEEL","06410-KSP-900","standard","C128","1","1","1","1","1","312","395","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("950","DISK, CLUTCH FRICTION","22201-KWS-901","standard","C128","1","1","1","1","1","354","450","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("951","DISK,CLUTCH FRICT","22201-KBW-900","standard","C128","1","1","1","1","1","351","450","16","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("952","DRIVE KIT","41000-KYY-000","standard","C128","1","1","1","1","1","1575","1970","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("953","ELEMENT,AIR/C","17205-KYY-970","standard","C128","1","1","1","1","1","452","570","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("954","FENDER, RAER","80100-KYY-970","standard","C128","1","1","1","1","1","718","900","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("955","FENDER,FRONT","61100-KYY-970","standard","C128","1","1","1","1","1","1337","1675","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("956","FORK ASSY,L FRONT","51500-KYY-903","standard","C128","1","1","1","1","1","6067","7585","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("957","FORK ASSY,R FRONT","51400-KYY-971","standard","C128","1","1","1","1","1","6396","7995","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("958","FUSE (15A)","98200-215-00","standard","C128","1","1","1","1","1","27","35","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("959","FUSE (20A)","98200-220-00","standard","C128","1","1","1","1","1","69","90","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("960","GASKET, CYLINDER","12191-KYY-901","standard","C128","1","1","1","1","1","92","115","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("961","GASKET, CYLINDER HEAD","12251-KYY-901","standard","C128","1","1","1","1","1","258","325","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("962","GASKET,L CRANKCASE COVER","11395-KWS-901","standard","C128","1","1","1","1","1","330","415","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("963","GASKET,R.CRANKCASECOVER","11394-KWS-901","standard","C128","1","1","1","1","1","528","655","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("964","GAUGE, OIL, LEVE","15651-KWS-900","standard","C128","1","1","1","1","1","174","220","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("965","GEAR SET,SPDMT","44820-K52-K00","standard","C128","1","1","1","1","1","427","540","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("966","GRIP COMP,THROT","53140-KYY-970","standard","C128","1","1","1","1","1","192","245","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("967","GROMMET, SIDE COVER","83542-KPN-900","standard","C128","1","1","1","1","1","16","20","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("968","GUIDE,FR FORK","51414-GFM-J11","standard","C128","1","1","1","1","1","638","800","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("969","HEAD, CAM CHAIN TENSIONER PUSH","14566-086-030","standard","C128","1","1","1","1","1","19","25","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("970","HORN COMP(HIGH)","38110-KYY-901","standard","C128","1","1","1","1","1","821","1030","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("971","IGNITION COIL","30500-KYY-901","standard","C128","1","1","1","1","1","1061","1330","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("972","JOINT B, BRAKE ARM","95015-320-01","standard","C128","1","1","1","1","1","19","25","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("973","JOINT, RJ, DRIVE","40531-KYY-901","standard","C128","1","1","1","1","1","54","68","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("974","KEY SET","35010-KYY-970","standard","C128","1","1","1","1","1","3115","3895","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("975","LENS,TAIL LIGHT","33702-KCS-W70","standard","C128","1","1","1","1","1","291","365","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("976","LEVER COMP CL","22810-KYY-900","standard","C128","1","1","1","1","1","582","730","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("977","LEVER COMP,L HNDL","53178KYY900","standard","C128","1","1","1","1","1","128","161","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("978","LEVER COMP,R HNDL","53175-K52-N70","standard","C128","1","1","1","1","1","128","161","-1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("979","LIGHT ASSY, HEA","33100-KTJ-942","standard","C128","1","1","1","1","1","1411","1550","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("980","LIGHT ASSY.,HEAD","33100-KTJ-941","standard","C128","1","1","1","1","1","1637","2050","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("981","MIRROR COMP R","88210-KYY-970","standard","C128","1","1","1","1","1","301","380","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("982","MIRROR HOLDER, R","53171-K52-N70","standard","C128","1","1","1","1","1","381","480","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("983","MIRRORCOMPL","88220-KYY-970","standard","C128","1","1","1","1","1","301","380","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("984","NUT, HEX, 1MM","90301-KYY-900","standard","C128","1","1","1","1","1","19","25","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("985","NUT, STEERING","90304-159-000","standard","C128","1","1","1","1","1","188","235","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("986","NUT, TAPPET ADJUSTING","90206-001-000","standard","C128","1","1","1","1","1","28","35","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("987","NUT,HEX,10MM","94001-100-000S","standard","C128","1","1","1","1","1","14","25","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("988","NUT,INSERT 5MM (4","17217-KT8-300","standard","C128","1","1","1","1","1","13","20","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("989","O-RING","91307-035-000","standard","C128","1","1","1","1","1","30","40","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("990","O-RING EJ","16173-KEJ-900","standard","C128","1","1","1","1","1","16","20","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("991","O-RING EJ1","16958-KEJ-900","standard","C128","1","1","1","1","1","8","10","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("992","OIL 1.0LTR","08232-2MA-KJI-JY3","standard","C128","1","1","1","1","1","518","680","23","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("993","OIL SEAL, 14X22X5 (QINGDAO MAO","91203-KYY-901","standard","C128","1","1","1","1","1","68","85","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("994","OIL SEAL, 17X29X5","91204-KWB-601","standard","C128","1","1","1","1","1","207","260","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("995","OIL0.9","08232-2MA-K8JY3","standard","C128","1","1","1","1","1","580","640","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("996","OUTER COMP,CLUTCH","22100-KYY-D01","standard","C128","1","1","1","1","1","3512","4390","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("997","PANEL SUB*NH132M*","45010-KYY-900ZB","standard","C128","1","1","1","1","1","1700","2125","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("998","PANEL, COM, *NH1","43100-KYY-900-ZB","standard","C128","1","1","1","1","1","2424","3035","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("999","PEDAL COMP,BRAKE","46500-KYY-900","standard","C128","1","1","1","1","1","664","890","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1000","PEDAL,GEAR CHANGE","24701-KYY-970","standard","C128","1","1","1","1","1","487","610","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1001","PIN, GUIDE ROLLER","14615-KFL-850","standard","C128","1","1","1","1","1","55","70","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1002","PIN, PISTON","13111-KWS-900","standard","C128","1","1","1","1","1","119","150","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:28");
INSERT INTO products VALUES("1003","PIN, SPLIT 3X25","94201-302-50","standard","C128","1","1","1","1","1","2","10","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1004","PIPE,SEAT","51440-KYY-901","standard","C128","1","1","1","1","1","694","870","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1005","PIPE,STRG HANDLE","53100-KYY-970","standard","C128","1","1","1","1","1","1427","1785","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1006","PISTON","13101-K08-900","standard","C128","1","1","1","1","1","1294","1620","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1007","PISTON (STD.)","13101-KYY-900","standard","C128","1","1","1","1","1","1294","1620","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:28");
INSERT INTO products VALUES("1008","PLATE, CLUTCH","22321-KWB-601","standard","C128","1","1","1","1","1","166","210","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1009","PLATE, FIXING","23802-GN5-910","standard","C128","1","1","1","1","1","28","40","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1010","PLATE,CLUTCHPRES","22355-KYY-D01","standard","C128","1","1","1","1","1","329","415","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1011","PLUG,SPARK(CPR7EA9)(NGK)","31917-KPH-901","standard","C128","1","1","1","1","1","202","250","16","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1012","PRG, BALL RADIA","91006-KYY-931","standard","C128","1","1","1","1","1","256","325","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1013","RACE, STEERING BALL","50301-KCS-W60","standard","C128","1","1","1","1","1","159","200","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1014","RACE, STEERING BOTTOM CONE","53212-KCS-W60","standard","C128","1","1","1","1","1","160","200","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1015","RACE, STEERING TOP CONE","53211-KCS-W60","standard","C128","1","1","1","1","1","159","200","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1016","RADCOMP, TENS","14550-KYY-900","standard","C128","1","1","1","1","1","157","200","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1017","REG.RECT.,ASSY","31600-KYY-971","standard","C128","1","1","1","1","1","1108","1385","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1018","RELAY COMP,WINKER","38301-KVX-601","standard","C128","1","1","1","1","1","321","405","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1019","RIM COMP.,HEAD LI","33101-KTJ-941","standard","C128","1","1","1","1","1","71","90","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1020","RING OIL SEAL STOP","90651-KRF-H71","standard","C128","1","1","1","1","1","71","105","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1021","RING SET,PISTON","13011-KYY-970","standard","C128","1","1","1","1","1","730","855","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1022","RING SET,PISTON S","13011-K08-900","standard","C128","1","1","1","1","1","679","850","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1023","RODCOMP,RRBRK","43451-KYY-900","standard","C128","1","1","1","1","1","241","305","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1024","ROLLER COMP., CAM CHAIN GUIDE","14670-KYY-901","standard","C128","1","1","1","1","1","329","430","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1025","ROLLER COMP., CAM CHAIN GUIDE 1","14610-KYY-901","standard","C128","1","1","1","1","1","237","340","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1026","ROLLER,CAM CHAIN","14502-KYY-901","standard","C128","1","1","1","1","1","158","230","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1027","RUBBER,HANDLE WEIGHT","53107-KW7-930","standard","C128","1","1","1","1","1","14","20","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1028","RUBBER,STEP","50661-KYY-900","standard","C128","1","1","1","1","1","144","185","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1029","SCREEN SET,FUEL S","16952-KYY-710","standard","C128","1","1","1","1","1","69","90","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1030","SCREW, TAPPET ADJUSTING","90012-KYY-900","standard","C128","1","1","1","1","1","128","160","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1031","SCREW,SPECIAL 6X1","90104-KYY-900","standard","C128","1","1","1","1","1","22","30","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1032","SCREW,TAPPING,2.9","33409-KVX-600","standard","C128","1","1","1","1","1","52","70","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1033","SEAL RUBBER","33410-KTJ-870","standard","C128","1","1","1","1","1","16","25","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1034","SEAL SET,FR FORK","51490-KYY-901","standard","C128","1","1","1","1","1","313","400","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1035","SEAL, VALVE STEM (ARAI)","12209-GB4-682","standard","C128","1","1","1","1","1","121","155","16","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1036","SEAL,AIR/C COVER","17213-KYY-970","standard","C128","1","1","1","1","1","83","110","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1037","SET ILLUST *TYPE1*","83520-K52-N70ZB","standard","C128","1","1","1","1","1","1359","1700","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1038","SET ILLUST *TYPE2*","83620-K52-N70ZB","standard","C128","1","1","1","1","1","1333","1670","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1039","SET ILLUST*TYPE2*","83520-KYY-600ZA","standard","C128","1","1","1","1","1","0","0","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1040","SET, ILLUST,*TYP","83620-K52-N70-ZA","standard","C128","1","1","1","1","1","1333","1670","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1041","SET,COMB METER","37000-K08-A40","standard","C128","1","1","1","1","1","2790","3490","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1042","SH SET, TERMINAL","31201-KPH-W00","standard","C128","1","1","1","1","1","403","510","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1043","SHAFT COMP,CAM","14100-KYY-900","standard","C128","1","1","1","1","1","2008","2510","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1044","SHAFT,MAIN 11T","23211-KYY-900","standard","C128","1","1","1","1","1","781","980","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1045","SHAFT,MAIN STAND","50526-KYY-970","standard","C128","1","1","1","1","1","345","435","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1046","SHOE SET, BRAKE","06430-GBJ-K20","standard","C128","1","1","1","1","1","320","400","16","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-13 15:53:29");
INSERT INTO products VALUES("1047","SOCKET ASSY,HEAD","33130-KTJ-941","standard","C128","1","1","1","1","1","645","810","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1048","SOCKET COMP, TAIL","33705-K52-N71","standard","C128","1","1","1","1","1","93","120","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1049","SOCKET COMP.,POSI","33150-KTJ-941","standard","C128","1","1","1","1","1","318","400","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1050","SOCKETCOMP","33130-K08-A41","standard","C128","1","1","1","1","1","602","765","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1051","SPEEDOMETER ASSY","37200-KYY-971","standard","C128","1","1","1","1","1","2900","3630","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1052","SPINDLE COMP., GEARSHIFT","24610-KYY-900","standard","C128","1","1","1","1","1","979","1225","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1053","SPRING A, BRAKE ROD","95014-731-00","standard","C128","1","1","1","1","1","8","15","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1054","SPRING ASSY,MAIN","50505-KPN-A00","standard","C128","1","1","1","1","1","209","265","11","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1055","SPRING SET, BRAKE","46510-KSP-900","standard","C128","1","1","1","1","1","117","150","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1056","SPRING, GEARSHIFT RETURN","24651-KSP-910","standard","C128","1","1","1","1","1","70","90","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1057","SPRING, KICK RETURN","28281-KWB-600","standard","C128","1","1","1","1","1","112","150","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1058","SPRING,REBOUND","51413-KPN-A00","standard","C128","1","1","1","1","1","184","230","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1059","SPRING,SIDE STAND","50531-KVX-600","standard","C128","1","1","1","1","1","94","120","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1060","SPRING,STOP SWITC","35357-K52-N70","standard","C128","1","1","1","1","1","49","65","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1061","SPRING,UNIT HOLDE","33108-KTJ-941","standard","C128","1","1","1","1","1","212","270","20","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1062","SPRKT,FINAL DRIVE","41201-KYY-970","standard","C128","1","1","1","1","1","779","975","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1063","SPROCKET, CAM (32T)","14321-KYY-900","standard","C128","1","1","1","1","1","1898","2375","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1064","SPROCKET, DRIVE","23801-GF6-00","standard","C128","1","1","1","1","1","230","290","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1065","STAND COMP,MAIN","50500-KYY-971","standard","C128","1","1","1","1","1","1486","1860","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1066","STAY,FR FENDER","61102-KYY-900","standard","C128","1","1","1","1","1","173","220","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1067","STAY,HEAD LIGHT","61311-KYY-970","standard","C128","1","1","1","1","1","945","1190","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1068","STEM SUB ASSY,STR","53219-KYY-970","standard","C128","1","1","1","1","1","1628","2035","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1069","SW ASSY WINKER","35200-K52-N41","standard","C128","1","1","1","1","1","912","1145","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1070","SW ASSY,REAR STOP","35350-KYY-901","standard","C128","1","1","1","1","1","275","345","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1071","SW ASSY,START","35150-KYY-A72","standard","C128","1","1","1","1","1","720","900","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1072","SW ASSY,WINKER","35200-KYY-970","standard","C128","1","1","1","1","1","930","1165","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1073","SWASSY,FRSTOP","35340-KYY-901","standard","C128","1","1","1","1","1","242","305","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1074","SWASSY,FRSTOP 1","35340-KWK-901","standard","C128","1","1","1","1","1","192","245","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1075","SWINGARM SUB*NH1*","52200-KYY-970ZA","standard","C128","1","1","1","1","1","5328","6660","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1076","SWITCH ASSY,COMB&amp;amp;","35100-KYY-971","standard","C128","1","1","1","1","1","2038","2550","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1077","SWITCH ASSY., STARTER MAGNETIC","35850-KWK-901","standard","C128","1","1","1","1","1","1246","1560","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1078","TUBE\17","300-17","standard","C128","1","1","1","1","1","0","200","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1079","TUBE\18","300-18","standard","C128","1","1","1","1","1","0","200","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1080","UNIT COMP,DC-CDI","30410-KYY-971","standard","C128","1","1","1","1","1","1664","2080","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1081","UNIT,HEAD LIGHT","33120-KTJ-941","standard","C128","1","1","1","1","1","1286","1610","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1082","VALVE, EX.","14721-KVY-900","standard","C128","1","1","1","1","1","654","820","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1083","VALVE, IN.","14711-KWB-600","standard","C128","1","1","1","1","1","416","520","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1084","WASHER,OIL SEAL","51412-GGC-901","standard","C128","1","1","1","1","1","60","75","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1085","WASHER,RR AXLE","90559-KYY-900","standard","C128","1","1","1","1","1","85","110","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1086","WASHER,SPECIAL 8M","90544-KRF-H71","standard","C128","1","1","1","1","1","29","40","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1087","WINKER ASSY,L RR.","33650-KYY-970","standard","C128","1","1","1","1","1","305","390","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1088","WINKER, ASSY, L","33450-KYY-970","standard","C128","1","1","1","1","1","305","385","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1089","WINKER, ASSY, R","33600-KYY-970","standard","C128","1","1","1","1","1","305","385","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1090","WINKER, ASSY, R a","33400-KYY-970","standard","C128","1","1","1","1","1","305","385","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-12 00:12:06","2025-01-04 16:25:22");
INSERT INTO products VALUES("1091","LOCKS","555-KYY-000","standard","C128","1","1","1","1","1","500","1300","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:19:20","2025-01-04 16:25:22");
INSERT INTO products VALUES("1092","BOLT A, BRAKE STOPPER","9281110000","standard","C128","1","1","1","1","1","28","35","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1093","BOLT,FLANGE,8X22","957010802208","standard","C128","1","1","1","1","1","28","35","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1094","COVER,CYLN.HEAD L","12341KYY900","standard","C128","1","1","1","1","1","333","417","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1095","SPRING, CAM CHAIN TENSIONER","14541GB4681","standard","C128","1","1","1","1","1","26","32","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1096","TOP SET","16017KWS901","standard","C128","1","1","1","1","1","931","1164","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1097","CARBURETOR ASSY","16100KYYK02","standard","C128","1","1","1","1","1","9843","12303","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1098","COCK ASSY,FUEL","16950KWK901","standard","C128","1","1","1","1","1","459","500","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1099","FILTER,CUP","16959KEJ900","standard","C128","1","1","1","1","1","15","19","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1100","DUCT,AIR/C","17219KYY900","standard","C128","1","1","1","1","1","133","167","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1101","COVER,AIR/C CASE","17220KYY970","standard","C128","1","1","1","1","1","282","353","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1102","TUBE,BREATHER","17368KYY900","standard","C128","1","1","1","1","1","80","99","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1103","RUBBER,RR TANK MO","17508KYY900","standard","C128","1","1","1","1","1","177","221","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1104","COLLAR,FUEL TANKM","17509KVX600","standard","C128","1","1","1","1","1","64","80","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1105","PLATE, CLUTCH PRESSURE","22355KWS901","standard","C128","1","1","1","1","1","298","373","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1106","BASE,WINKER","33451KTJ870","standard","C128","1","1","1","1","1","98","122","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1107","COLLAR,FR.WINKER","33650KAF000","standard","C128","1","1","1","1","1","18","22","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1108","SOCKET COMP.TAIL","33705KYY970","standard","C128","1","1","1","1","1","469","587","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-13 15:53:29");
INSERT INTO products VALUES("1109","KEYSET","35010K08A40","standard","C128","1","1","1","1","1","2799","3499","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1110","COVER,COMB SW","35106KVX600","standard","C128","1","1","1","1","1","95","119","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1111","SWITCH COMP FR LEVER","35330KWK901","standard","C128","1","1","1","1","1","70","88","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1112","METER CASE COMP","37210KYY970","standard","C128","1","1","1","1","1","1523","1904","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1113","BOX,BATTERY","50325KYY900","standard","C128","1","1","1","1","1","521","651","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1114","PLATE,FRONT ENG H","50351KYY920","standard","C128","1","1","1","1","1","1024","1280","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1115","PIPE COMP,FR FORK","51410KYY902","standard","C128","1","1","1","1","1","3914","4892","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1116","BOOT FR FORK","51611KYY761","standard","C128","1","1","1","1","1","394","493","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1117","BUSH,RUBBERUNDER","52486KYY901","standard","C128","1","1","1","1","1","190","237","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1118","GRIP,L HANDLE","53166KYY970","standard","C128","1","1","1","1","1","118","147","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1119","GUARD,R KNUC*NH1*","53190KYY760ZB","standard","C128","1","1","1","1","1","1046","1308","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1120","BRIDGE,FORK *NH1*","53230K52N70ZB","standard","C128","1","1","1","1","1","1880","2350","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1121","SET ILLUS,*TYPE1*","83520K08A40ZA","standard","C128","1","1","1","1","1","1026","1282","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1122","CAP,LOCKNUT","88113GN5900","standard","C128","1","1","1","1","1","38","48","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1123","BOLT, FR. FORK","90123KRM860","standard","C128","1","1","1","1","1","30","37","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1124","SCREW,PAN,3X20","93500030200G","standard","C128","1","1","1","1","1","23","29","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 13:54:02","2025-01-04 16:25:22");
INSERT INTO products VALUES("1125","LEVEL COMP, L HNDL","53178-K52-N70","standard","C128","1","1","1","1","1","145","200","11","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 14:32:53","2025-01-13 15:53:29");
INSERT INTO products VALUES("1126","HOLDER COMP, ELEME","17250-KYY-970","standard","C128","1","1","1","1","1","107","130","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 14:53:50","2025-01-04 16:25:22");
INSERT INTO products VALUES("1127","BAND,FR FORK BOOT","51612-KTJ-C00","standard","C128","1","1","1","1","1","130","140","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 14:56:47","2025-01-04 16:25:22");
INSERT INTO products VALUES("1128","Test","02138251","standard","C128","","1","1","1","1","100","200","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-13 19:06:25","2025-01-04 16:25:22");
INSERT INTO products VALUES("1129","BOLT A, BRAKE STOPPER","92811-100-00","standard","C128","1","1","1","1","1","40","50","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:35","2025-01-04 16:25:22");
INSERT INTO products VALUES("1130","BOLT,FLANGE,8X22","95701-0802-208","standard","C128","1","1","1","1","1","40","50","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1131","DAMPER SET, WHEEL","06410-KSP-900","standard","C128","1","1","1","1","1","399","470","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1132","SHOE SET, BRAKE","06430-GBJ-K20","standard","C128","1","1","1","1","1","338","400","-40","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1133","BALL ASSY,STEEL 6","06530-KRF-H70","standard","C128","1","1","1","1","1","77","100","-7","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1134","OIL0.9","08232-2MA-K8JY3","standard","C128","1","1","1","1","1","580","640","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1135","OIL 1.0LTR","08232-2MA-KJI-JY3","standard","C128","1","1","1","1","1","518","680","-258","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1136","GASKET,R.CRANKCASECOVER","11394-KWS-901","standard","C128","1","1","1","1","1","694","810","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1137","GASKET,L CRANKCASE COVER","11395-KWS-901","standard","C128","1","1","1","1","1","434","505","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1138","GASKET, CYLINDER","12191-KYY-901","standard","C128","1","1","1","1","1","122","145","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1139","SEAL, VALVE STEM (ARAI)","12209-GB4-682","standard","C128","1","1","1","1","1","129","170","-18","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1140","GASKET, CYLINDER HEAD","12251-KYY-901","standard","C128","1","1","1","1","1","341","400","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1141","COVER,CYLN.HEAD L","12341KYY900","standard","C128","1","1","1","1","1","461","540","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1142","CRANK SHAFT COMP","13000-KYY-900","standard","C128","1","1","1","1","1","9275","10760","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1143","RING SET,PISTON S","13011-K08-900","standard","C128","1","1","1","1","1","893","1040","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1144","RING SET,PISTON","13011-KYY-970","standard","C128","1","1","1","1","1","768","960","-19","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1145","PISTON","13101-K08-900","standard","C128","1","1","1","1","1","1700","1980","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1146","PISTON (STD.)","13101-KYY-900","standard","C128","1","1","1","1","1","1711","1720","-7","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1147","PIN, PISTON","13111-KWS-900","standard","C128","1","1","1","1","1","159","185","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1148","CLIP,PISTONPIN,12MM","13115-KWS-900","standard","C128","1","1","1","1","1","16","20","-17","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1149","SHAFT COMP,CAM","14100-KYY-900","standard","C128","1","1","1","1","1","2641","3070","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1150","SPROCKET, CAM (32T)","14321-KYY-900","standard","C128","1","1","1","1","1","2493","2900","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1151","CHAIN,CAM88LESH","14401-K08-901","standard","C128","1","1","1","1","1","544","635","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1152","CHAIN CAM (90L","14401-K76-T61","standard","C128","1","1","1","1","1","452","570","-14","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1153","ARM COMP., IN. VALVE ROCKER","14430-GGC-900","standard","C128","1","1","1","1","1","1465","1475","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1154","ARM COMP.CAM CHAIN TENSIONER","14500-KYY-901","standard","C128","1","1","1","1","1","231","270","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1155","ROLLER,CAM CHAIN","14502-KYY-901","standard","C128","1","1","1","1","1","169","220","-29","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1156","COLLAR, COM","14532-KWS-900","standard","C128","1","1","1","1","1","30","40","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1157","SPRING, CAM CHAIN TENSIONER","14541GB4681","standard","C128","1","1","1","1","1","37","45","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1158","RADCOMP, TENS","14550-KYY-900","standard","C128","1","1","1","1","1","207","245","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1159","HEAD, CAM CHAIN TENSIONER PUSH","14566-086-030","standard","C128","1","1","1","1","1","26","35","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1160","ROLLER COMP., CAM CHAIN GUIDE 1","14610-KYY-901","standard","C128","1","1","1","1","1","252","320","-26","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1161","PIN, GUIDE ROLLER","14615-KFL-850","standard","C128","1","1","1","1","1","74","85","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1162","ROLLER COMP., CAM CHAIN GUIDE","14670-KYY-901","standard","C128","1","1","1","1","1","348","435","-27","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1163","VALVE, IN.","14711-KWB-600","standard","C128","1","1","1","1","1","440","550","-9","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1164","VALVE, EX.","14721-KVY-900","standard","C128","1","1","1","1","1","690","865","-12","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1165","GAUGE, OIL, LEVE","15651-KWS-900","standard","C128","1","1","1","1","1","229","270","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1166","TOP SET","16017KWS901","standard","C128","1","1","1","1","1","1164","935","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1167","CARBURETOR ASSY","16100KYYK02","standard","C128","1","1","1","1","1","13570","15745","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1168","O-RING EJ","16173-KEJ-900","standard","C128","1","1","1","1","1","21","30","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1169","COCK ASSY,FUEL","16950KWK901","standard","C128","1","1","1","1","1","645","750","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1170","SCREEN SET,FUEL S","16952-KYY-710","standard","C128","1","1","1","1","1","91","110","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1171","CUP SET,FUEL STRA","16953-KWK-900","standard","C128","1","1","1","1","1","187","220","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1172","O-RING EJ1","16958-KEJ-900","standard","C128","1","1","1","1","1","11","15","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1173","FILTER,CUP","16959KEJ900","standard","C128","1","1","1","1","1","21","30","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1174","ELEMENT,AIR/C","17205-KYY-970","standard","C128","1","1","1","1","1","593","690","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1175","SEAL,AIR/C COVER","17213-KYY-970","standard","C128","1","1","1","1","1","109","130","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1176","NUT,INSERT 5MM (4","17217-KT8-300","standard","C128","1","1","1","1","1","16","20","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1177","DUCT,AIR/C","17219KYY900","standard","C128","1","1","1","1","1","182","215","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1178","COVER,AIR/C CASE","17220KYY970","standard","C128","1","1","1","1","1","389","455","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1179","COLLAR,AIR/C","17223-KVX-600","standard","C128","1","1","1","1","1","25","30","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1180","CASE SUB ASSY,AIR","17225-KYY-970","standard","C128","1","1","1","1","1","784","910","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1181","HOLDER COMP, ELEME","17250-KYY-970","standard","C128","1","1","1","1","1","113","135","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1182","TUBE,BREATHER","17368KYY900","standard","C128","1","1","1","1","1","109","130","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1183","RUBBER,RR TANK MO","17508KYY900","standard","C128","1","1","1","1","1","244","290","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1184","COLLAR,FUEL TANKM","17509KVX600","standard","C128","1","1","1","1","1","88","110","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1185","CAP COMP,FUEL","17620-K08-A41","standard","C128","1","1","1","1","1","1135","1320","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1186","CAP COMP., FUEL FILLER","17620-KVX-601","standard","C128","1","1","1","1","1","1147","1335","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1187","CABLE SET,THROT","17920-KYY-970","standard","C128","1","1","1","1","1","413","480","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1188","OUTER COMP,CLUTCH","22100-KYY-D01","standard","C128","1","1","1","1","1","3687","4200","-1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1189","CENTER, CLUTCH","22120-KWS-901","standard","C128","1","1","1","1","1","937","1090","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1190","CENTER,CLUTCH","22120-KYY-D01","standard","C128","1","1","1","1","1","771","970","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1191","DISK,CLUTCH FRICT","22201-KBW-900","standard","C128","1","1","1","1","1","370","465","-10","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1192","DISK, CLUTCH FRICTION","22201-KWS-901","standard","C128","1","1","1","1","1","465","540","-3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1193","PLATE, CLUTCH","22321-KWB-601","standard","C128","1","1","1","1","1","175","220","-20","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1194","PLATE, CLUTCH PRESSURE","22355KWS901","standard","C128","1","1","1","1","1","448","520","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1195","PLATE,CLUTCHPRES","22355-KYY-D01","standard","C128","1","1","1","1","1","345","435","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1196","LEVER COMP CL","22810-KYY-900","standard","C128","1","1","1","1","1","764","890","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1197","CABLE COMP,CLUTCH","22870-K52-N71","standard","C128","1","1","1","1","1","377","440","-7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1198","SHAFT,MAIN 11T","23211-KYY-900","standard","C128","1","1","1","1","1","1026","1190","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1199","COUNTER SHAFT","23221-KYY-900","standard","C128","1","1","1","1","1","799","930","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1200","SPROCKET, DRIVE","23801-GF6-00","standard","C128","1","1","1","1","1","302","355","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1201","PLATE, FIXING","23802-GN5-910","standard","C128","1","1","1","1","1","37","50","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1202","SPINDLE COMP., GEARSHIFT","24610-KYY-900","standard","C128","1","1","1","1","1","1285","1500","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1203","SPRING, GEARSHIFT RETURN","24651-KSP-910","standard","C128","1","1","1","1","1","92","110","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1204","PEDAL,GEAR CHANGE","24701-KYY-970","standard","C128","1","1","1","1","1","639","745","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1205","SPRING, KICK RETURN","28281-KWB-600","standard","C128","1","1","1","1","1","147","175","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1206","ARM ASSY,KICK STA","28300-KYY-900","standard","C128","1","1","1","1","1","1289","1300","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1207","TUBE\17","300-17","standard","C128","1","1","1","1","1","0","200","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1208","TUBE\18","300-18","standard","C128","1","1","1","1","1","0","200","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1209","UNIT COMP,DC-CDI","30410-KYY-971","standard","C128","1","1","1","1","1","2184","2535","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1210","IGNITION COIL","30500-KYY-901","standard","C128","1","1","1","1","1","1393","1620","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1211","CAP ASSY,NOISE(SU","30700-KYY-901","standard","C128","1","1","1","1","1","407","480","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1212","COIL","31120-KYY-971","standard","C128","1","1","1","1","1","3131","3635","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1213","SH SET, TERMINAL","31201-KPH-W00","standard","C128","1","1","1","1","1","529","620","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1214","BATTERY YB7BL-A","31500-KG3-505","standard","C128","1","1","1","1","1","2840","2860","-2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1215","REG.RECT.,ASSY","31600-KYY-971","standard","C128","1","1","1","1","1","1454","1690","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1216","PLUG,SPARK(CPR7EA9)(NGK)","31917-KPH-901","standard","C128","1","1","1","1","1","265","310","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1217","LIGHT ASSY.,HEAD","33100-KTJ-941","standard","C128","1","1","1","1","1","1550","1415","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1218","LIGHT ASSY, HEA","33100-KTJ-942","standard","C128","1","1","1","1","1","2050","1640","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1219","RIM COMP.,HEAD LI","33101-KTJ-941","standard","C128","1","1","1","1","1","90","75","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1220","SPRING,UNIT HOLDE","33108-KTJ-941","standard","C128","1","1","1","1","1","278","325","19","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1221","UNIT,HEAD LIGHT","33120-KTJ-941","standard","C128","1","1","1","1","1","1687","1960","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1222","SOCKETCOMP","33130-K08-A41","standard","C128","1","1","1","1","1","790","920","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1223","SOCKET ASSY,HEAD","33130-KTJ-941","standard","C128","1","1","1","1","1","847","985","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1224","SOCKET COMP.,POSI","33150-KTJ-941","standard","C128","1","1","1","1","1","417","485","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1225","BULB, POSITION LIGHT (12V 5W)","33301-KVJ-911","standard","C128","1","1","1","1","1","447","464","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1226","WINKER, ASSY, R a","33400-KYY-970","standard","C128","1","1","1","1","1","400","465","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1227","SCREW,TAPPING,2.9","33409-KVX-600","standard","C128","1","1","1","1","1","68","80","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1228","SEAL RUBBER","33410-KTJ-870","standard","C128","1","1","1","1","1","21","30","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1229","WINKER, ASSY, L","33450-KYY-970","standard","C128","1","1","1","1","1","400","465","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1230","BASE,WINKER","33451-KTJ-870","standard","C128","1","1","1","1","1","135","145","5","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1231","WINKER, ASSY, R","33600-KYY-970","standard","C128","1","1","1","1","1","400","470","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1232","COLLAR,FR.WINKER","33650KAF000","standard","C128","1","1","1","1","1","25","30","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1233","WINKER ASSY,L RR.","33650-KYY-970","standard","C128","1","1","1","1","1","400","470","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1234","LENS,TAIL LIGHT","33702-KCS-W70","standard","C128","1","1","1","1","1","382","445","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1235","SOCKET COMP, TAIL","33705-K52-N71","standard","C128","1","1","1","1","1","122","145","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1236","SOCKET COMP.TAIL","33705-KYY-970","standard","C128","1","1","1","1","1","653","760","-1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1237","BULB, HEADLIGHT (12V 35/35W)","34901-388-611","standard","C128","1","1","1","1","1","246","275","-10","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1238","BULB, WINKER LIGHT","34904-KYY-F01","standard","C128","1","1","1","1","1","186","220","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1239","BULB, TAIL STOP LIGHT (12V 2","34906-447-711","standard","C128","1","1","1","1","1","167","195","80","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1240","BULB,WINKER(12V 1","34907-KSW-971","standard","C128","1","1","1","1","1","64","75","-6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1241","KEYSET","35010K08A40","standard","C128","1","1","1","1","1","3935","4560","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1242","KEY SET","35010-KYY-970","standard","C128","1","1","1","1","1","4088","4750","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1243","SWITCH ASSY,COMB&amp;amp;amp;amp;","35100-KYY-971","standard","C128","1","1","1","1","1","2140","2680","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1244","COVER,COMB SW","35106KVX600","standard","C128","1","1","1","1","1","126","150","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1245","SW ASSY,START","35150-KYY-A72","standard","C128","1","1","1","1","1","945","1100","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1246","SW ASSY WINKER","35200-K52-N41","standard","C128","1","1","1","1","1","1198","1390","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1247","SW ASSY,WINKER","35200-KYY-970","standard","C128","1","1","1","1","1","1221","1420","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1248","SWITCH COMP FR LEVER","35330KWK901","standard","C128","1","1","1","1","1","98","120","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1249","SWASSY,FRSTOP 1","35340-KWK-901","standard","C128","1","1","1","1","1","252","295","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1250","SWASSY,FRSTOP","35340-KYY-901","standard","C128","1","1","1","1","1","318","370","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1251","SW ASSY,REAR STOP","35350-KYY-901","standard","C128","1","1","1","1","1","360","420","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1252","SPRING,STOP SWITC","35357-K52-N70","standard","C128","1","1","1","1","1","64","75","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1253","SWITCH ASSY., STARTER MAGNETIC","35850-KWK-901","standard","C128","1","1","1","1","1","1636","1900","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1254","SET,COMB METER","37000-K08-A40","standard","C128","1","1","1","1","1","3662","4250","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1255","SPEEDOMETER ASSY","37200-KYY-971","standard","C128","1","1","1","1","1","3806","4420","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1256","METER CASE COMP","37210KYY970","standard","C128","1","1","1","1","1","2079","2415","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1257","CASE,LOWER","37223-KYY-970","standard","C128","1","1","1","1","1","749","870","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1258","HORN COMP(HIGH)","38110-KYY-901","standard","C128","1","1","1","1","1","1078","1255","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1259","RELAY COMP,WINKER","38301-KVX-601","standard","C128","1","1","1","1","1","421","490","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1260","CASE,DRIVE*NH35M*","40510-KYY-970ZB","standard","C128","1","1","1","1","1","2017","2345","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1261","CASE, DRIVE NH3","40520-KYY-970-ZB","standard","C128","1","1","1","1","1","2738","3180","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1262","Chain Drive. Km","40530-K08-A42","standard","C128","1","1","1","1","1","700","620","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1263","CHAIN,DRIVE KMC42","40530-KYY-901","standard","C128","1","1","1","1","1","1015","1180","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1264","JOINT, RJ, DRIVE","40531-KYY-901","standard","C128","1","1","1","1","1","71","90","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1265","ADJUSTER COMP,CHA","40543-KYY-901","standard","C128","1","1","1","1","1","454","500","-1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1266","CAP, CHAIN CASE PEEP HOLE","40545-001-000","standard","C128","1","1","1","1","1","80","100","-5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:03");
INSERT INTO products VALUES("1267","CAP, SWINGARM END","40546-KYY-900","standard","C128","1","1","1","1","1","142","165","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1268","DRIVE KIT","41000-KYY-000","standard","C128","1","1","1","1","1","1654","2070","0","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1269","SPRKT,FINAL DRIVE","41201-KYY-970","standard","C128","1","1","1","1","1","1022","1190","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1270","PANEL, COM, *NH1","43100-KYY-900-ZB","standard","C128","1","1","1","1","1","3182","3700","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1271","ARM, REAR BRAK","43410-KYY-900","standard","C128","1","1","1","1","1","360","370","-1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1272","RODCOMP,RRBRK","43451-KYY-900","standard","C128","1","1","1","1","1","317","370","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1273","AXLE,FR WHEEL","44301-KYY-900","standard","C128","1","1","1","1","1","422","435","5","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1274","GEAR SET,SPDMT","44820-K52-K00","standard","C128","1","1","1","1","1","560","655","-4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1275","CABLE ASSY,SPDMT","44830-KYY-901","standard","C128","1","1","1","1","1","321","375","-2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1276","PANEL SUB*NH132M*","45010-KYY-900ZB","standard","C128","1","1","1","1","1","2231","2590","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1277","ARM,FRONT BRAKE","45410-KVX-600","standard","C128","1","1","1","1","1","278","305","8","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1278","CABLE COMP,FR BRK","45450-KYY-970","standard","C128","1","1","1","1","1","347","405","-2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1279","PEDAL COMP,BRAKE","46500-KYY-900","standard","C128","1","1","1","1","1","934","1085","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1280","SPRING SET, BRAKE","46510-KSP-900","standard","C128","1","1","1","1","1","154","180","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1281","RACE, STEERING BALL","50301-KCS-W60","standard","C128","1","1","1","1","1","167","215","-8","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1282","CAP,PIPE END","50315-KYY-900","standard","C128","1","1","1","1","1","29","40","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1283","BOX,BATTERY","50325KYY900","standard","C128","1","1","1","1","1","689","800","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1284","BAND,BATTERY","50326-KYY-970","standard","C128","1","1","1","1","1","134","145","5","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1285","PLATE,FRONT ENG H","50351KYY920","standard","C128","1","1","1","1","1","1411","1640","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1286","STAND COMP,MAIN","50500-KYY-971","standard","C128","1","1","1","1","1","1951","2270","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1287","SPRING ASSY,MAIN","50505-KPN-A00","standard","C128","1","1","1","1","1","274","320","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1288","SHAFT,MAIN STAND","50526-KYY-970","standard","C128","1","1","1","1","1","454","530","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1289","BARCOMP,SIDESTA","50530-KYY-900","standard","C128","1","1","1","1","1","480","490","0","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1290","SPRING,SIDE STAND","50531-KVX-600","standard","C128","1","1","1","1","1","123","145","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1291","BAR COMP,STEP","50610-KYY-970","standard","C128","1","1","1","1","1","1645","1690","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1292","RUBBER,STEP","50661-KYY-900","standard","C128","1","1","1","1","1","189","220","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1293","BOADCOMP,LPI","50725-KYY-970","standard","C128","1","1","1","1","1","2163","2200","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1294","FORK ASSY,R FRONT","51400-KYY-971","standard","C128","1","1","1","1","1","8395","9740","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1295","PIPE COMP,FR FORK","51410KYY902","standard","C128","1","1","1","1","1","5342","6200","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1296","WASHER,OIL SEAL","51412-GGC-901","standard","C128","1","1","1","1","1","78","95","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1297","SPRING,REBOUND","51413-KPN-A00","standard","C128","1","1","1","1","1","241","280","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1298","GUIDE,FR FORK","51414-GFM-J11","standard","C128","1","1","1","1","1","837","975","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1299","CASE,R BOTTOM","51420-KYY-971","standard","C128","1","1","1","1","1","4348","5045","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1300","PIPE,SEAT","51440-KYY-901","standard","C128","1","1","1","1","1","911","1060","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1301","SEAL SET,FR FORK","51490-KYY-901","standard","C128","1","1","1","1","1","411","480","89","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1302","FORK ASSY,L FRONT","51500-KYY-903","standard","C128","1","1","1","1","1","7963","9240","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1303","CASE,LBOTTOM","51520-KYY-902","standard","C128","1","1","1","1","1","4442","5155","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1304","BOOT FR FORK","51611-KYY-761","standard","C128","1","1","1","1","1","448","565","-4","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1305","BAND,FR FORK BOOT","51612-KTJ-C00","standard","C128","1","1","1","1","1","137","145","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1306","BOLT,SWINGARM PIV","52101-KYY-900","standard","C128","1","1","1","1","1","451","525","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1307","SWINGARM SUB*NH1*","52200-KYY-970ZA","standard","C128","1","1","1","1","1","6994","8115","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1308","CUSHION ASSY,REAR","52400-KYY-972","standard","C128","1","1","1","1","1","2778","3005","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1309","BUSH,RUBBERUNDER","52486KYY901","standard","C128","1","1","1","1","1","251","300","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1310","PIPE,STRG HANDLE","53100-KYY-970","standard","C128","1","1","1","1","1","1873","2175","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1311","RUBBER,HANDLE WEIGHT","53107-KW7-930","standard","C128","1","1","1","1","1","18","25","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1312","GRIP COMP,THROT","53140-KYY-970","standard","C128","1","1","1","1","1","252","300","-2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1313","GRIP,L HANDLE","53166KYY970","standard","C128","1","1","1","1","1","166","195","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1314","MIRROR HOLDER, R","53171-K52-N70","standard","C128","1","1","1","1","1","500","0","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1315","BRKT, L HNDL LEVER","53172-K14-910","standard","C128","1","1","1","1","1","638","655","0","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1316","LEVER COMP,R HNDL","53175-K52-N70","standard","C128","1","1","1","1","1","186","200","-11","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1317","LEVEL COMP, L HNDL","53178-K52-N70","standard","C128","1","1","1","1","1","190","200","-6","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1318","LEVER COMP,L HNDL","53178KYY900","standard","C128","1","1","1","1","1","181","210","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1319","GUARD,R KNUC*NH1*","53190KYY760ZB","standard","C128","1","1","1","1","1","1457","1690","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1320","RACE, STEERING TOP CONE","53211-KCS-W60","standard","C128","1","1","1","1","1","167","230","-8","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1321","RACE, STEERING BOTTOM CONE","53212-KCS-W60","standard","C128","1","1","1","1","1","168","220","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1322","STEM SUB ASSY,STR","53219-KYY-970","standard","C128","1","1","1","1","1","2136","2480","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1323","BRIDGE,FORK *NH1*","53230K52N70ZB","standard","C128","1","1","1","1","1","2592","3010","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1324","LOCKS","555-KYY-000","standard","C128","1","1","1","1","1","500","1300","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1325","FENDER,FRONT","61100-KYY-970","standard","C128","1","1","1","1","1","1755","2040","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1326","STAY,FR FENDER","61102-KYY-900","standard","C128","1","1","1","1","1","227","265","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1327","CASE,HEAD LIGHT","61300-KYY-970","standard","C128","1","1","1","1","1","307","360","-2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1328","STAY,HEAD LIGHT","61311-KYY-970","standard","C128","1","1","1","1","1","1240","1440","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1329","BOOT,HDLT STAY UP","61315-KVX-600","standard","C128","1","1","1","1","1","21","25","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1330","BOOT,HDLT STAY LO","61316-KVX-600","standard","C128","1","1","1","1","1","37","50","4","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1331","COLLAR, SEAT","77201-KYY-900","standard","C128","1","1","1","1","1","46","60","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1332","FENDER, RAER","80100-KYY-970","standard","C128","1","1","1","1","1","963","1120","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1333","SET ILLUS,*TYPE1*","83520K08A40ZA","standard","C128","1","1","1","1","1","1456","1690","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1334","SET ILLUST *TYPE1*","83520-K52-N70ZB","standard","C128","1","1","1","1","1","1784","2070","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1335","SET ILLUST*TYPE2*","83520-KYY-600ZA","standard","C128","1","1","1","1","1","0","0","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1336","GROMMET, SIDE COVER","83542-KPN-900","standard","C128","1","1","1","1","1","21","30","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1337","SET, ILLUST,*TYP","83620-K52-N70-ZA","standard","C128","1","1","1","1","1","1750","2030","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1338","SET ILLUST *TYPE2*","83620-K52-N70ZB","standard","C128","1","1","1","1","1","1750","2030","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1339","BRKT,NUMBER P","84701-KYY-970","standard","C128","1","1","1","1","1","541","560","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1340","CAP,LOCKNUT","88113GN5900","standard","C128","1","1","1","1","1","53","65","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1341","MIRROR COMP R","88210-KYY-970","standard","C128","1","1","1","1","1","316","400","-2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1342","MIRRORCOMPL","88220-KYY-970","standard","C128","1","1","1","1","1","316","400","-4","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:03");
INSERT INTO products VALUES("1343","SCREW, TAPPET ADJUSTING","90012-KYY-900","standard","C128","1","1","1","1","1","168","195","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1344","SCREW,SPECIAL 6X1","90104-KYY-900","standard","C128","1","1","1","1","1","29","35","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1345","BOLT,HANDLE LEVER","90113-KYY-900","standard","C128","1","1","1","1","1","90","105","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1346","BOLT, FR. FORK","90123KRM860","standard","C128","1","1","1","1","1","42","50","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1347","BOLT,FLANGE,10","90132-KBS-920","standard","C128","1","1","1","1","1","199","250","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1348","NUT, TAPPET ADJUSTING","90206-001-000","standard","C128","1","1","1","1","1","36","45","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1349","NUT, HEX, 1MM","90301-KYY-900","standard","C128","1","1","1","1","1","25","30","6","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1350","NUT, STEERING","90304-159-000","standard","C128","1","1","1","1","1","247","290","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1351","WASHER,SPECIAL 8M","90544-KRF-H71","standard","C128","1","1","1","1","1","39","45","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1352","WASHER,RR AXLE","90559-KYY-900","standard","C128","1","1","1","1","1","112","130","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1353","RING OIL SEAL STOP","90651-KRF-H71","standard","C128","1","1","1","1","1","94","110","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1354","BEARING, RADIAL BALL, 63/22 (N","91001-KWS-901","standard","C128","1","1","1","1","1","833","970","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1355","BRG,BALL RADIAL62","91004-KYY-931","standard","C128","1","1","1","1","1","293","305","15","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1356","BRG, BAL RADIA","91005-KYY-931","standard","C128","1","1","1","1","1","263","280","2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1357","PRG, BALL RADIA","91006-KYY-931","standard","C128","1","1","1","1","1","336","395","-3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1358","BEARING, RADIAL BALL, 6301UU","91051-KPN-A71","standard","C128","1","1","1","1","1","507","510","-8","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:24:26");
INSERT INTO products VALUES("1359","BRG,BALL RADIA","91053-KYY-902","standard","C128","1","1","1","1","1","575","590","0","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1360","BRG, BALL RADIAL 6","91053-KYY-903","standard","C128","1","1","1","1","1","549","570","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1361","OIL SEAL, 14X22X5 (QINGDAO MAO","91203-KYY-901","standard","C128","1","1","1","1","1","89","105","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1362","OIL SEAL, 17X29X5","91204-KWB-601","standard","C128","1","1","1","1","1","271","315","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1363","O-RING","91307-035-000","standard","C128","1","1","1","1","1","39","50","1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1364","Bolt, hex,6x10","92101-060-100A","standard","C128","1","1","1","1","1","11","15","47","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1365","BOLT, HEX 8X28","92101-080-280A","standard","C128","1","1","1","1","1","32","40","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1366","BOLT,DRAIN PLL","92800-120-00","standard","C128","1","1","1","1","1","73","85","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1367","SCREW,PAN,3X20","93500030200G","standard","C128","1","1","1","1","1","31","40","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1368","NUT,HEX,10MM","94001-100-000S","standard","C128","1","1","1","1","1","22","30","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1369","PIN, SPLIT 3X25","94201-302-50","standard","C128","1","1","1","1","1","4","10","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1370","SPRING A, BRAKE ROD","95014-731-00","standard","C128","1","1","1","1","1","11","15","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1371","JOINT B, BRAKE ARM","95015-320-01","standard","C128","1","1","1","1","1","26","30","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1372","BOLT, FLANGE, 6X8","95701-060-0800","standard","C128","1","1","1","1","1","12","20","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-13 15:53:28");
INSERT INTO products VALUES("1373","BOLT,FLANGE","95701-080-4500","standard","C128","1","1","1","1","1","75","90","3","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1374","BOLT,FLANGE,SI","96001-060-2500","standard","C128","1","1","1","1","1","10","30","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1375","BEARING, RADIAL BALL, 6200","96100-620-0000","standard","C128","1","1","1","1","1","389","400","1","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1376","FUSE (15A)","98200-215-00","standard","C128","1","1","1","1","1","36","45","-1","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-07 11:25:25");
INSERT INTO products VALUES("1377","FUSE (20A)","98200-220-00","standard","C128","1","1","1","1","1","90","105","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 15:47:36","2025-01-04 16:25:22");
INSERT INTO products VALUES("1378","INSURANCE LOCK","444-KYY-000","standard","C128","1","1","1","1","1","70","100","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 16:38:53","2025-01-04 16:25:22");
INSERT INTO products VALUES("1379","Testing","123789","standard","C128","1","1","1","1","1","10","20","100","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-09-19 23:45:43","2025-01-04 16:25:22");
INSERT INTO products VALUES("1380","BOLT 13mm","M13","standard","C128","1","1","1","1","1","5","20","91","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-10-03 16:59:38","2025-01-04 16:25:22");
INSERT INTO products VALUES("1381","BOLT 10mm","M10","standard","C128","","1","1","1","1","5","10","54","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-10-03 17:00:46","2025-01-04 16:25:22");
INSERT INTO products VALUES("1382","BOLT 8mm","M8","standard","C128","","1","1","1","1","5","10","39","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-10-03 17:01:34","2025-01-04 16:25:22");
INSERT INTO products VALUES("1383","TUBELESS VALVE","TB-V","standard","C128","","1","1","1","1","40","100","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2023-10-03 17:03:58","2025-01-04 16:25:22");
INSERT INTO products VALUES("1384","CHAIN CAM 88LE-SH","14401-K73-T31","standard","C128","1","1","1","1","1","468","555","-2","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2023-10-09 20:36:05","2025-01-07 11:24:26");
INSERT INTO products VALUES("1385","Sigma Layers Mash","41795233","standard","C128","2","2","1","1","1","50","55","37","10","","","","","","","1","202502260344332.png","","0","","","0","","0","","","","","","","","1","2025-01-07 10:48:17","2025-03-27 18:08:04");
INSERT INTO products VALUES("1386","Tester","89210682","standard","C128","","2","1","1","1","120","56","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-01-13 18:52:04","2025-01-13 18:52:11");
INSERT INTO products VALUES("1387","Tick Fix","29933740","standard","C128","","6","1","1","1","100","150","6","5","","","","","","","1","202502260448232.png","","0","","","0","","0","","","","","","","","1","2025-01-18 22:42:25","2025-04-01 18:09:23");
INSERT INTO products VALUES("1388","Bio plus lick 1KG (BEEF)","03802294","standard","C128","5","11","2","2","2","100","150","3","3","","","","","","","1","202502260225172.jpg","","0","1","","0","","0","","","","","","["1KG","2kg"]","[null,null]","1","2025-02-25 13:06:54","2025-04-01 19:07:10");
INSERT INTO products VALUES("1389","BIO PLUS LICK 1KG (MAZIWA)","75692114","standard","C128","5","11","2","2","2","100","150","2","3","","","","","","","1","202502260225542.jpg","","0","","","0","","0","","","","","","","","1","2025-02-25 13:21:01","2025-03-31 16:25:10");
INSERT INTO products VALUES("1390","BIO PLUS 2KG (BEEF)","62531451","standard","C128","5","11","2","2","2","180","250","7","3","","","","","","","1","202502270251062.png","","0","","","0","","0","","","","","","","","1","2025-02-25 13:26:24","2025-04-01 19:07:10");
INSERT INTO products VALUES("1391","BIO PLUS 2KG(MAZIWA)","72371089","standard","C128","5","11","2","2","2","176","250","6","3","","","","","","","1","202502260224462.jpg","","0","","","0","","0","","","","","","","","1","2025-02-25 13:27:33","2025-03-31 18:37:31");
INSERT INTO products VALUES("1392","COLLARDS 10Grm(SUKUMA WIKI)","52849161","standard","C128","3","4","3","3","3","47","100","16","","","","","","","","1","202502260220592.png","","0","","","0","","0","","","","","","","","1","2025-02-25 13:51:58","2025-03-31 18:37:31");
INSERT INTO products VALUES("1393","SPINACH 10Grams","90818332","standard","C128","3","4","3","3","3","39","80","6","10","","","","","","","1","202502260339192.png","","0","","","0","","0","","","","","","","","1","2025-02-25 13:53:18","2025-04-01 19:07:10");
INSERT INTO products VALUES("1394","BIO TRIM (VET)","23706861","standard","C128","5","5","21","21","21","96","150","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-25 13:57:40","2025-02-25 14:21:12");
INSERT INTO products VALUES("1395","ASCAREX 30Grms","21962683","standard","C128","5","7","21","21","21","80","120","17","6","","","","","","","1","202502260350372.png","","0","","","0","","0","","","","","","","","1","2025-02-25 13:59:07","2025-04-01 09:55:05");
INSERT INTO products VALUES("1396","DANIA 10Grms","13223925","standard","C128","3","4","3","3","3","73","100","4","6","","","","","","","1","202502260337512.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:00:21","2025-03-31 19:09:16");
INSERT INTO products VALUES("1397","UREA Fertilizer","46260758","standard","C128","9","8","2","2","2","76","100","12","25","","","","","","","1","202502260342302.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:03:07","2025-04-01 17:46:35");
INSERT INTO products VALUES("1398","WINNER Fertilizer (YARA)","05172950","standard","C128","8","8","2","2","2","101","120","26","","","","","","","","1","202502260341042.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:04:20","2025-04-01 17:46:35");
INSERT INTO products VALUES("1399","COLLARDS 25 GRMS (SUKUMA WIKI)","81230701","standard","C128","3","13","4","4","4","85","105","10","6","","","","","","","1","202502260219412.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:09:54","2025-03-21 19:55:21");
INSERT INTO products VALUES("1400","COLLARDS 50GRMS (SUKUMA WIKI)","65863094","standard","C128","3","4","5","5","5","115","180","9","6","","","","","","","1","202502260220252.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:10:52","2025-03-21 20:37:41");
INSERT INTO products VALUES("1401","BIO TRIM 30Grms(VET)","47892016","standard","C128","5","7","21","21","21","96","150","0","6","","","","","","","1","202502260349102.png","","0","","","0","","0","","","","","","","","1","2025-02-25 14:18:59","2025-04-01 16:03:16");
INSERT INTO products VALUES("1402","Milthane super 50g","40936803","standard","C128","5","4","5","5","5","80","120","10","5","","","","","","","1","202502260347372.png","","0","","","0","","0","","","","","","","","1","2025-02-26 11:59:08","2025-04-01 19:07:10");
INSERT INTO products VALUES("1403","Alpha Water Guard 50mls","70712256","standard","C128","5","4","10","10","10","104","150","5","5","","","","","","","1","202502260435512.png","","0","","","0","","0","","","","","","","","1","2025-02-26 12:01:08","2025-04-01 19:07:10");
INSERT INTO products VALUES("1404","Klassic 50ml","16370523","standard","C128","","4","10","10","10","153","250","7","5","","","","","","","1","202502260445372.png","","0","","","0","","0","","","","","","","","1","2025-02-26 12:03:11","2025-03-31 15:56:40");
INSERT INTO products VALUES("1405","Dynamec 10mls","10062393","standard","C128","","4","1","1","1","181","200","8","3","","","","","","","1","202502260442132.png","","0","","","0","","0","","","","","","","","1","2025-02-26 12:06:50","2025-04-01 15:37:48");
INSERT INTO products VALUES("1406","Tylodoxy 25g","22695360","standard","C128","","2","4","4","4","125","180","6","5","","","","","","","1","202502260439102.png","","0","","","0","","0","","","","","","","","1","2025-02-26 12:08:50","2025-04-01 17:58:31");
INSERT INTO products VALUES("1407","DAIRY MEAL","53466232","standard","C128","2","3","2","2","2","46","50","7","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 15:15:25","2025-03-31 19:38:58");
INSERT INTO products VALUES("1408","DAP Fertilizer","93562580","standard","C128","8","8","2","2","2","104","120","47","20","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-27 15:19:13","2025-04-01 19:07:10");
INSERT INTO products VALUES("1409","17.17.17 NPK Fertilizer","93050828","standard","C128","7","8","2","2","2","84","110","5","20","","","","","","","1","202503050417162.png","","0","","","0","","0","","","","","","","","1","2025-02-27 15:21:48","2025-04-01 17:58:31");
INSERT INTO products VALUES("1410","CAN Fertilizer","35221466","standard","C128","8","8","2","2","2","56","70","30","20","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-27 15:28:00","2025-04-01 19:07:10");
INSERT INTO products VALUES("1411","23.23.0 NPK Blend Fertilizer","92253111","standard","C128","9","8","2","2","2","92","120","20","20","","","","","","","1","202503050418362.png","","0","","","0","","0","","","","","","","","1","2025-02-27 15:30:13","2025-04-01 16:03:16");
INSERT INTO products VALUES("1412","DK 8033 2KG","53159860","standard","C128","5","13","1","1","1","800","900","13","5","","","","","","","1","202503050414382.png","","0","","","0","","1","","","","","","","","1","2025-02-27 15:33:50","2025-03-28 10:14:38");
INSERT INTO products VALUES("1413","DK 8031 2KG","63464831","standard","C128","4","13","1","1","1","800","900","20","3","","","","","","","1","202503050415592.png","","0","","","0","","1","","","","","","","","1","2025-02-27 15:35:31","2025-04-01 16:03:16");
INSERT INTO products VALUES("1414","DUMA 43 2KG","12122951","standard","C128","5","13","1","1","1","850","950","25","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","1","","","","","","","","1","2025-02-27 15:37:27","2025-04-01 16:03:16");
INSERT INTO products VALUES("1415","Chick Formulae","28009372","standard","C128","5","11","4","4","4","45","80","4","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 15:42:38","2025-03-31 19:09:16");
INSERT INTO products VALUES("1416","Diseptoprim 5grm","39690772","standard","C128","4","11","1","1","1","19","30","28","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 15:45:37","2025-03-22 17:23:57");
INSERT INTO products VALUES("1417","Redcat 1grm","38237607","standard","C128","5","6","1","1","1","12","20","5","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-27 15:47:50","2025-04-01 17:58:31");
INSERT INTO products VALUES("1418","Ridomil 50gms","15304726","standard","C128","5","9","5","5","5","157","200","6","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 15:50:43","2025-03-31 16:56:36");
INSERT INTO products VALUES("1419","Ascaten p Tabs 20","36899132","standard","C128","5","7","1","1","1","13","20","0","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-27 15:56:08","2025-03-21 12:43:21");
INSERT INTO products VALUES("1420","Sevin Dudu 100grm","79408735","standard","C128","5","6","6","6","6","85","100","0","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-27 15:57:43","2025-03-21 19:47:01");
INSERT INTO products VALUES("1421","Egocin Soluble25grm","63492897","standard","C128","5","7","4","4","4","45","100","5","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 15:59:55","2025-03-31 17:10:53");
INSERT INTO products VALUES("1422","Easy Gro Flower 120grm","05039016","standard","C128","5","5","1","1","1","70","120","4","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-27 16:02:28","2025-04-01 18:09:23");
INSERT INTO products VALUES("1423","Ciplick Maziwa 2kg","04101622","standard","C128","","5","1","1","1","210","300","0","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-27 16:04:38","2025-03-31 15:43:15");
INSERT INTO products VALUES("1424","Milking salve 100g(coopers)","20949132","standard","C128","","5","6","6","6","115","150","7","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 14:07:53","2025-04-01 18:09:23");
INSERT INTO products VALUES("1425","booster foliar 500ml","19693225","standard","C128","","4","17","17","17","70","150","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 14:22:04","2025-04-01 17:46:35");
INSERT INTO products VALUES("1426","Absolute 50ml","62034111","standard","C128","","4","10","10","10","361","450","6","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 14:24:09","2025-04-01 17:46:35");
INSERT INTO products VALUES("1427","Escort 50ml","92390181","standard","C128","","4","10","10","10","266","350","7","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 14:26:25","2025-03-31 16:00:09");
INSERT INTO products VALUES("1428","Actraz 40ml BIMEDA","69437570","standard","C128","11","5","9","9","9","90","150","6","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 14:30:54","2025-04-01 19:07:10");
INSERT INTO products VALUES("1429","nilzan plus 125mls","19732093","standard","C128","","5","22","22","22","247","350","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 14:41:06","2025-03-31 19:30:18");
INSERT INTO products VALUES("1430","Albendazole 40mls","63446787","standard","C128","","5","9","9","9","61","100","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 14:44:08","2025-04-01 17:46:35");
INSERT INTO products VALUES("1431","Trinity Gold 50gms","51039401","standard","C128","5","4","5","5","5","114","180","4","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 14:47:39","2025-03-26 09:32:11");
INSERT INTO products VALUES("1432","Dizon 25mls","40813016","standard","C128","","4","1","1","1","83","100","4","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 18:36:53","2025-04-01 18:09:23");
INSERT INTO products VALUES("1433","Ascarex 30g","07406351","standard","C128","","7","21","21","21","80","120","0","","","","","","","","1","202503130747102.png","","0","","","0","","0","","","","","","","","0","2025-02-28 18:39:39","2025-03-21 19:46:27");
INSERT INTO products VALUES("1434","Pics sacks 100kgs","33464122","standard","C128","","4","1","1","1","200","300","10","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 18:41:23","2025-03-21 19:55:21");
INSERT INTO products VALUES("1435","Disposable syringes 20ml","32048501","standard","C128","","5","1","1","1","15","20","20","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 18:44:21","2025-03-21 19:55:21");
INSERT INTO products VALUES("1436","Neocidol 28mls","69540910","standard","C128","","5","23","23","23","116","180","12","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 18:45:48","2025-04-01 16:18:18");
INSERT INTO products VALUES("1437","Actelic gold 50g","28700551","standard","C128","","4","5","5","5","80","100","0","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2025-02-28 18:47:31","2025-03-19 18:54:05");
INSERT INTO products VALUES("1438","Spinach 50g","25025319","standard","C128","","4","5","5","5","140","250","5","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 18:49:11","2025-03-21 19:55:21");
INSERT INTO products VALUES("1439","Dania 25g","60181392","standard","C128","","4","4","4","4","75","120","4","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 18:50:47","2025-03-22 19:40:15");
INSERT INTO products VALUES("1440","Capsicum (HOHO) super wonder 25g","15735204","standard","C128","","4","3","3","3","185","250","2","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 18:53:01","2025-03-24 19:05:05");
INSERT INTO products VALUES("1441","Nantes (CARROTS) 25gms","59987178","standard","C128","3","13","4","4","4","115","180","7","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 18:55:26","2025-03-25 17:43:16");
INSERT INTO products VALUES("1442","Growers mash 50kgs","95288236","standard","C128","","5","2","2","2","3150","3500","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-28 19:00:00","2025-03-18 18:10:08");
INSERT INTO products VALUES("1443","Growers Mash 1Kg","47152641","standard","C128","","5","2","2","2","60","70","69","10","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 19:04:51","2025-04-01 19:07:10");
INSERT INTO products VALUES("1444","Broiler Starter crumbs 1kgs","29208701","standard","C128","","5","2","2","2","83","95","53","10","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 19:06:40","2025-04-01 17:58:31");
INSERT INTO products VALUES("1445","Dairy meal 50kgs","48029037","standard","C128","","5","2","2","2","2000","2500","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-28 19:08:25","2025-03-21 19:53:16");
INSERT INTO products VALUES("1446","Dog Food Super 1Kg","11626984","standard","C128","5","3","2","2","2","60","100","0","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 19:10:05","2025-04-01 17:58:31");
INSERT INTO products VALUES("1447","Magadi salt 50kg","36099847","standard","C128","","5","2","2","2","16","30","20","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 19:13:26","2025-03-21 19:55:21");
INSERT INTO products VALUES("1448","Chick mash 50kg","01399923","standard","C128","","5","2","2","2","4700","5600","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-28 19:16:50","2025-03-21 10:18:42");
INSERT INTO products VALUES("1449","Layers mash 50kgs","20058311","standard","C128","","2","2","2","2","3250","4000","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-28 19:19:09","2025-03-21 10:28:39");
INSERT INTO products VALUES("1450","Afya bora maziwa 1kg","36198294","standard","C128","","5","2","2","2","196","250","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 19:21:58","2025-03-29 13:09:57");
INSERT INTO products VALUES("1451","Afya bora maziwa 2kg","98191126","standard","C128","","5","2","2","2","368","450","2","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 19:23:34","2025-04-01 16:03:16");
INSERT INTO products VALUES("1452","Ascaten p tabs","53192201","standard","C128","","5","1","1","1","13","20","0","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-02-28 19:26:01","2025-03-21 12:43:01");
INSERT INTO products VALUES("1453","Burnweed","10704082","standard","C128","","4","1","1","1","205","350","1","2","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-02-28 19:28:16","2025-03-31 17:10:53");
INSERT INTO products VALUES("1454","Episom salt 250g","67389108","standard","C128","","5","7","7","7","65","100","9","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-02-28 19:31:31","2025-03-31 18:37:31");
INSERT INTO products VALUES("1455","Fukokill 25 grms","28532107","standard","C128","5","6","1","1","1","77","100","3","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-13 18:22:38","2025-04-01 15:37:48");
INSERT INTO products VALUES("1456","Score 20Ml","10293421","standard","C128","5","10","1","1","1","214","250","4","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-13 18:38:01","2025-04-01 15:37:48");
INSERT INTO products VALUES("1457","Ortiva 20Ml","29320431","standard","C128","5","6","1","1","1","209","250","3","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-13 18:41:27","2025-03-31 17:19:05");
INSERT INTO products VALUES("1458","Karate Zeon 60 Mls","21090362","standard","C128","5","10","1","1","1","129","180","3","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-13 18:43:37","2025-03-31 18:07:00");
INSERT INTO products VALUES("1459","Trinity Gold 100gms","92011245","standard","C128","","7","1","1","1","171","250","3","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-13 18:48:11","2025-04-01 15:37:48");
INSERT INTO products VALUES("1460","Tomato M82 10gms","50701783","standard","C128","3","13","1","1","1","150","180","2","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-18 16:20:10","2025-03-22 18:46:53");
INSERT INTO products VALUES("1461","ONION Red Creole 10gms","63207551","standard","C128","3","13","1","1","1","100","150","2","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-18 16:26:48","2025-03-19 20:24:28");
INSERT INTO products VALUES("1462","Calf Pallets","20033944","standard","C128","2","3","2","2","2","50","75","43","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-19 18:50:35","2025-04-01 17:58:31");
INSERT INTO products VALUES("1463","Actelic gold 50g","72305276","standard","C128","5","7","1","1","1","80","120","3","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-19 18:55:56","2025-04-01 15:49:09");
INSERT INTO products VALUES("1464","Syringe","61382992","standard","C128","5","12","1","1","1","15","20","16","10","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-19 19:21:38","2025-03-25 18:24:16");
INSERT INTO products VALUES("1465","CHICK MASH","29580693","standard","C128","2","3","2","2","2","60","80","18","10","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 10:18:30","2025-04-01 19:07:10");
INSERT INTO products VALUES("1466","DEXABION","02261918","standard","C128","4","7","1","1","1","80","100","7","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 10:20:24","2025-04-01 18:09:23");
INSERT INTO products VALUES("1467","SEVIN Dudu120gms","96753141","standard","C128","5","7","1","1","1","80","100","0","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 10:28:08","2025-03-31 19:09:16");
INSERT INTO products VALUES("1468","FUGA Lick BEEF BLOCK 1Kg","21533992","standard","C128","2","3","2","2","2","100","150","4","2","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 11:25:32","2025-03-22 16:30:06");
INSERT INTO products VALUES("1469","Ascaten P Tablets","84939212","standard","C128","5","11","1","1","1","13","20","1","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 12:42:14","2025-03-31 19:38:58");
INSERT INTO products VALUES("1470","Sevin Dudu 100gms","06805233","standard","C128","4","10","1","1","1","85","100","1","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-21 12:45:59","2025-04-01 18:09:23");
INSERT INTO products VALUES("1471","DESPOTRIM","99811223","standard","C128","5","7","1","1","1","20","30","8","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-21 12:48:24","2025-04-01 18:09:23");
INSERT INTO products VALUES("1472","AGRO Z Bags","90475546","standard","C128","5","5","1","1","1","200","280","8","","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-21 12:53:32","2025-03-31 18:02:23");
INSERT INTO products VALUES("1473","S-Dime Bolus","52441103","standard","C128","5","7","1","1","1","20","45","13","4","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-21 19:27:15","2025-03-29 13:00:41");
INSERT INTO products VALUES("1474","CIP-LICK Maziwa1Kg","57182299","standard","C128","2","3","1","1","1","100","150","3","2","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2025-03-21 19:29:11","2025-03-22 11:28:43");
INSERT INTO products VALUES("1475","Poltricin Chick","55921919","standard","C128","4","7","1","1","1","80","100","4","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 12:42:00","2025-03-22 14:40:37");
INSERT INTO products VALUES("1476","EMPTY SACKS","19508277","standard","C128","6","12","1","1","1","0","40","6","","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-22 12:49:39","2025-04-01 19:07:10");
INSERT INTO products VALUES("1477","DRINKERS","92060324","standard","C128","6","12","1","1","1","180","220","3","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 14:01:02","2025-03-22 17:45:49");
INSERT INTO products VALUES("1478","Martano Super 10grm","54917332","standard","C128","5","10","1","1","1","100","130","3","5","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 14:15:10","2025-03-31 15:56:40");
INSERT INTO products VALUES("1479","FUGA Lick BEEF BLOCK 2Kg","57391466","standard","C128","2","11","1","1","1","200","250","8","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 14:35:48","2025-03-22 16:16:59");
INSERT INTO products VALUES("1480","Albendazole 120mls","25133917","standard","C128","5","7","1","1","1","120","180","9","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 16:34:42","2025-03-22 18:07:03");
INSERT INTO products VALUES("1481","SPINACH 25Grams","14963897","standard","C128","3","13","1","1","1","100","130","6","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 16:37:19","2025-03-24 19:05:05");
INSERT INTO products VALUES("1482","DCP","46919312","standard","C128","5","6","1","1","1","100","130","10","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 17:03:40","2025-03-22 18:06:33");
INSERT INTO products VALUES("1483","FEEDER CHICKEN","01178120","standard","C128","6","12","1","1","1","180","220","3","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 17:27:14","2025-03-24 18:18:19");
INSERT INTO products VALUES("1484","ACHAZ 40ml","04055729","standard","C128","5","4","1","1","1","100","150","0","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-03-22 18:20:59","2025-03-22 18:26:38");
INSERT INTO products VALUES("1485","Easy Gro Flower n F 500grm","07431149","standard","C128","5","4","1","1","1","280","350","7","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-22 19:14:32","2025-03-31 18:02:23");
INSERT INTO products VALUES("1486","Ciplick Maziwa 1kg","54873931","standard","C128","2","11","1","1","1","100","150","8","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-22 19:26:05","2025-03-22 20:11:03");
INSERT INTO products VALUES("1487","DK 8031 1KG","41802672","standard","C128","5","13","1","1","1","350","450","0","2","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","0","2025-03-22 19:53:00","2025-04-01 18:37:37");
INSERT INTO products VALUES("1488","SEVIN Dudu200gms","02041365","standard","C128","5","6","1","1","1","150","180","12","4","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-24 18:21:33","2025-04-01 16:16:01");
INSERT INTO products VALUES("1489","Easy Gro Vegetative 120grm","46095763","standard","C128","5","4","1","1","1","80","100","7","5","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-24 18:25:10","2025-03-25 18:39:43");
INSERT INTO products VALUES("1490","Actelic Super 100g","74416059","standard","C128","5","5","1","1","1","100","160","7","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-24 19:57:03","2025-03-31 16:25:10");
INSERT INTO products VALUES("1491","ASCAREX 25gms","41123523","standard","C128","5","5","1","1","1","80","100","6","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-24 20:14:06","2025-04-01 15:49:09");
INSERT INTO products VALUES("1492","Alpha Water Guard 50ml","05347252","standard","C128","4","4","1","1","1","100","150","0","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","0","2025-03-24 20:21:27","2025-03-24 20:26:31");
INSERT INTO products VALUES("1493","KINGA NJAA NGUNIA","15097337","standard","C128","6","4","1","1","1","250","280","9","3","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-25 18:56:20","2025-03-26 09:32:11");
INSERT INTO products VALUES("1494","RCP 250gms","23798961","standard","C128","5","4","1","1","1","100","150","4","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-26 19:26:27","2025-03-26 20:25:12");
INSERT INTO products VALUES("1495","Milthane Super 100gms","13290503","standard","C128","5","9","1","1","1","150","220","2","3","","","","","","","1","zummXD2dvAtI.png","","0","","","0","","0","","","","","","","","1","2025-03-27 18:28:56","2025-04-01 15:37:48");
INSERT INTO products VALUES("1496","DH 02 2Kg","50301129","standard","C128","5","13","1","1","1","650","750","6","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-28 10:05:41","2025-03-28 10:14:38");
INSERT INTO products VALUES("1497","DH 04 2Kg","91025268","standard","C128","5","13","1","1","1","650","750","6","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-28 10:06:39","2025-03-28 10:14:38");
INSERT INTO products VALUES("1498","DUMA 43 1KG","36183540","standard","C128","5","13","1","1","1","400","475","5","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","1","","","","","","","","1","2025-03-31 15:07:51","2025-03-31 19:09:16");
INSERT INTO products VALUES("1499","Carrots 10Grms","85569046","standard","C128","3","13","1","1","1","60","80","5","2","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-31 15:47:43","2025-03-31 16:28:38");
INSERT INTO products VALUES("1500","Actraz 120Ml","27130508","standard","C128","5","5","1","1","1","200","280","4","1","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","","","","1","2025-03-31 17:51:28","2025-04-01 09:15:34");



CREATE TABLE `purchase_product_return` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int NOT NULL,
  `product_id` int NOT NULL,
  `product_batch_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `imei_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `qty` double NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `purchases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `currency_id` int DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `paid_amount` double NOT NULL,
  `status` int NOT NULL,
  `payment_status` int NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchases VALUES("1","pr-20230911-081909","1","1","","","","207","804","0","0","293856","0","0","","","293856","0","1","1","","","2023-09-11 23:19:09","2023-09-11 23:19:09");
INSERT INTO purchases VALUES("2","pr-20230911-084005","1","1","","2","10","5","20","0","0","1155.98","0","0","0","0","1155.98","0","1","1","","","2023-09-11 23:40:05","2023-09-11 23:40:05");
INSERT INTO purchases VALUES("3","pr-20230911-091510","1","1","","","","212","824","0","0","295012","0","0","","","295012","0","1","1","","","2023-09-12 00:15:10","2023-09-12 00:15:11");
INSERT INTO purchases VALUES("4","pr-20230913-101052","1","1","","2","1","18","166","0","0","62663","0","0","0","0","62663","0","1","1","","","2023-09-13 13:10:52","2023-09-13 13:10:52");
INSERT INTO purchases VALUES("5","pr-20230913-101941","1","1","","2","1","1","9","0","0","4500","0","0","0","0","4500","0","1","1","","","2023-09-13 13:19:41","2023-09-13 13:19:41");
INSERT INTO purchases VALUES("6","pr-20230913-105559","1","1","","","","36","120","0","0","53287","0","0","","","53287","0","1","1","","","2023-09-13 13:55:59","2023-09-13 13:55:59");
INSERT INTO purchases VALUES("7","pr-20230913-113330","1","1","","2","1","1","11","0","0","1595","0","0","0","0","1595","0","1","1","","","2023-09-13 14:33:30","2023-09-13 14:33:30");
INSERT INTO purchases VALUES("8","pr-20230913-115710","1","1","","2","1","1","2","0","0","260","0","0","0","0","260","0","1","1","","","2023-09-13 14:57:10","2023-09-13 14:57:10");
INSERT INTO purchases VALUES("9","pr-20230913-040711","1","1","","2","1","1","10","0","0","1000","0","0","0","0","1000","0","1","1","","","2023-09-13 19:07:11","2023-09-13 19:07:11");
INSERT INTO purchases VALUES("10","pr-20230919-125021","1","1","","","","249","962","0","0","472144","0","0","","","472144","0","1","1","","","2023-09-19 15:50:21","2023-09-19 15:50:22");
INSERT INTO purchases VALUES("11","pr-20230919-013937","1","1","","2","1","1","5","0","0","350","0","0","0","0","350","0","1","1","","","2023-09-19 16:39:37","2023-09-19 16:39:37");
INSERT INTO purchases VALUES("12","pr-20230919-084607","1","1","","2","1","1","100","0","0","1000","0","0","0","0","1000","0","1","1","","","2023-09-19 23:46:07","2023-09-19 23:46:07");
INSERT INTO purchases VALUES("13","pr-20230923-120341","1","1","","2","1","1","48","0","0","24864","0","0","0","0","24864","0","1","1","","","2023-09-23 15:03:41","2023-09-23 15:03:41");
INSERT INTO purchases VALUES("14","pr-20230923-121906","1","1","","2","1","1","5","0","0","1975","0","0","0","0","1975","0","1","1","","","2023-09-23 15:19:06","2023-09-23 15:19:06");
INSERT INTO purchases VALUES("15","pr-20230923-122133","1","1","","2","1","1","5","0","0","1975","0","0","0","0","1975","0","1","1","","","2023-09-23 15:21:33","2023-09-23 15:21:33");
INSERT INTO purchases VALUES("16","pr-20230923-122226","1","1","","2","1","1","20","0","0","5300","0","0","0","0","5300","0","1","1","","","2023-09-23 15:22:26","2023-09-23 15:22:26");
INSERT INTO purchases VALUES("17","pr-20230923-122401","1","1","","2","1","1","10","0","0","1860","0","0","0","0","1860","0","1","1","","","2023-09-23 15:24:01","2023-09-23 15:24:01");
INSERT INTO purchases VALUES("18","pr-20230923-122539","1","1","","2","1","1","5","0","0","1705","0","0","0","0","1705","0","1","1","","","2023-09-23 15:25:39","2023-09-23 15:25:39");
INSERT INTO purchases VALUES("19","pr-20230923-122539","1","1","","2","1","1","5","0","0","1705","0","0","0","0","1705","0","1","1","","","2023-09-23 15:25:39","2023-09-23 15:25:39");
INSERT INTO purchases VALUES("20","pr-20230923-122616","1","1","","2","1","1","2","0","0","1186","0","0","0","0","1186","0","1","1","","","2023-09-23 15:26:16","2023-09-23 15:26:16");
INSERT INTO purchases VALUES("21","pr-20230923-122704","1","1","","2","1","1","1","0","0","2017","0","0","0","0","2017","0","1","1","","","2023-09-23 15:27:04","2023-09-23 15:27:04");
INSERT INTO purchases VALUES("22","pr-20230923-122836","1","1","","2","1","2","3","0","0","6772","0","0","0","0","6772","0","1","1","","","2023-09-23 15:28:36","2023-09-23 15:28:36");
INSERT INTO purchases VALUES("23","pr-20230923-122921","1","1","","2","1","1","5","0","0","945","0","0","0","0","945","0","1","1","","","2023-09-23 15:29:21","2023-09-23 15:29:21");
INSERT INTO purchases VALUES("24","pr-20230923-123016","1","1","","2","1","1","10","0","0","3770","0","0","0","0","3770","0","1","1","","","2023-09-23 15:30:16","2023-09-23 15:30:16");
INSERT INTO purchases VALUES("25","pr-20230923-123141","1","1","","2","1","1","2","0","0","4100","0","0","0","0","4100","0","1","1","","","2023-09-23 15:31:41","2023-09-23 15:31:41");
INSERT INTO purchases VALUES("26","pr-20230923-123222","1","1","","2","1","1","2","0","0","7612","0","0","0","0","7612","0","1","1","","","2023-09-23 15:32:22","2023-09-23 15:32:22");
INSERT INTO purchases VALUES("27","pr-20230923-123334","1","1","","2","1","1","2","0","0","2396","0","0","0","0","2396","0","1","1","","","2023-09-23 15:33:34","2023-09-23 15:33:34");
INSERT INTO purchases VALUES("28","pr-20230923-123909","1","1","","2","1","6","160","0","0","65550","0","0","0","0","65550","0","1","1","","","2023-09-23 15:39:09","2023-09-23 15:39:09");
INSERT INTO purchases VALUES("29","pr-20231003-020302","1","1","","2","1","3","229","0","0","1145","0","0","0","0","1145","0","1","1","","","2023-10-03 03:00:00","2023-10-03 17:03:02");
INSERT INTO purchases VALUES("30","pr-20231003-020427","1","1","","2","1","1","5","0","0","200","0","0","0","0","200","0","1","1","","","2023-10-03 03:00:00","2023-10-03 17:04:27");
INSERT INTO purchases VALUES("31","pr-20231009-053839","1","1","","2","1","1","1","0","0","4685","0","0","0","0","4685","0","1","1","","","2023-10-09 20:38:39","2023-10-09 20:38:39");
INSERT INTO purchases VALUES("39","pr-20250225-023331","3","2","2","2","1","10","168","0","0","14480","0","0","0","0","14480","14480","1","2","","KSH 69.00 Discount on Dania, Spinach and Collards","2025-02-22 00:00:00","2025-02-25 14:35:46");
INSERT INTO purchases VALUES("40","pr-20250228-015948","3","2","2","2","1","7","132","0","0","12242","0","0","0","0","12242","12242","1","2","","discounted products =104","2025-02-14 00:00:00","2025-02-28 20:04:33");
INSERT INTO purchases VALUES("41","pr-20250228-021536","3","2","2","2","1","10","257","0","0","15603","0","0","0","0","15603","15603","1","2","","","2025-02-08 00:00:00","2025-02-28 20:04:48");
INSERT INTO purchases VALUES("42","pr-20250228-025411","3","2","2","2","1","8","61","0","0","7520","0","0","0","0","7520","7520","1","2","","","2025-01-15 00:00:00","2025-02-28 20:05:03");
INSERT INTO purchases VALUES("43","pr-20250313-061035","3","2","2","2","1","1","12","0","0","10200","0","0","0","0","10200","10200","1","2","","","2025-03-11 00:00:00","2025-03-13 19:09:44");
INSERT INTO purchases VALUES("44","pr-20250313-061220","3","2","2","2","1","4","172","0","0","28150","0","0","0","0","28150","28150","1","2","20250401010046.jpeg","","2025-03-12 00:00:00","2025-04-01 13:00:46");
INSERT INTO purchases VALUES("45","pr-20250313-065555","1","2","2","2","1","12","139","0","0","11675","0","0","","0","11675","11675","1","2","20250313070756.jpeg","Discount on Fukokill 16%","2025-03-05 00:00:00","2025-03-13 19:08:48");
INSERT INTO purchases VALUES("46","pr-20250314-010113","3","2","2","2","1","10","116","0","0","19476","0","0","0","0","19476","19476","1","2","","TO PAY","2025-03-12 00:00:00","2025-03-22 20:36:16");
INSERT INTO purchases VALUES("47","pr-20250318-042010","1","2","2","","","1","1","0","0","150","0","0","0","0","150","150","1","2","","","2025-01-02 00:00:00","2025-03-19 20:23:19");
INSERT INTO purchases VALUES("48","pr-20250318-042648","1","2","","","","1","1","0","0","100","0","0","0","0","100","100","1","2","","","2025-01-02 00:00:00","2025-03-19 20:24:28");
INSERT INTO purchases VALUES("49","pr-20250318-045744","1","2","2","2","1","4","23","0","0","5610","0","0","0","0","5610","0","1","1","","","2025-01-01 00:00:00","2025-03-18 16:57:44");
INSERT INTO purchases VALUES("50","pr-20250319-065035","1","2","","","","1","50","0","0","2500","0","0","0","0","2500","2500","1","2","","","2025-01-02 00:00:00","2025-03-19 20:24:59");
INSERT INTO purchases VALUES("51","pr-20250319-065556","1","2","2","","","1","10","0","0","800","0","0","0","0","800","800","1","2","","","2025-01-02 00:00:00","2025-03-19 20:22:33");
INSERT INTO purchases VALUES("52","pr-20250319-072138","1","2","2","","","1","20","0","0","300","0","0","0","0","300","300","1","2","","","2025-01-02 00:00:00","2025-03-19 20:21:58");
INSERT INTO purchases VALUES("53","pr-20250321-101830","1","2","2","","","1","50","0","0","4700","0","0","0","0","4700","4700","1","2","","","2025-01-01 00:00:00","2025-03-21 12:12:22");
INSERT INTO purchases VALUES("54","pr-20250321-102024","1","2","2","","","1","10","0","0","800","0","0","0","0","800","800","1","2","","","2025-01-01 00:00:00","2025-03-21 12:12:58");
INSERT INTO purchases VALUES("55","pr-20250321-102808","1","2","2","","","1","10","0","0","800","0","0","0","0","800","800","1","2","","","2025-01-01 00:00:00","2025-03-21 12:13:34");
INSERT INTO purchases VALUES("56","pr-20250321-112532","1","2","2","","","1","5","0","0","500","0","0","0","0","500","500","1","2","","","2025-01-01 00:00:00","2025-03-21 12:14:12");
INSERT INTO purchases VALUES("57","pr-20250321-124214","1","2","2","","","1","20","0","0","360","0","0","0","0","360","360","1","2","","","2025-01-01 00:00:00","2025-03-21 12:57:07");
INSERT INTO purchases VALUES("58","pr-20250321-124559","1","2","2","","","1","10","0","0","850","0","0","0","0","850","850","1","2","","","2025-01-01 00:00:00","2025-03-21 12:57:31");
INSERT INTO purchases VALUES("59","pr-20250321-124824","1","2","2","","","1","20","0","0","400","0","0","0","0","400","400","1","2","","","2025-01-01 00:00:00","2025-03-21 12:57:55");
INSERT INTO purchases VALUES("60","pr-20250321-125332","1","2","2","","","1","10","0","0","2000","0","0","0","0","2000","2000","1","2","","","2025-01-01 00:00:00","2025-03-21 12:56:33");
INSERT INTO purchases VALUES("61","pr-20250321-072219","1","2","2","2","1","2","6","0","0","1692","0","0","0","0","1692","1692","1","2","","","2025-01-01 00:00:00","2025-03-22 12:23:04");
INSERT INTO purchases VALUES("62","pr-20250321-072715","1","2","2","","","1","20","0","0","400","0","0","0","0","400","400","1","2","","","2025-01-01 00:00:00","2025-03-21 20:01:14");
INSERT INTO purchases VALUES("63","pr-20250321-072911","1","2","2","","","1","3","0","0","600","0","0","0","0","600","600","1","2","","","2025-01-01 00:00:00","2025-03-21 20:02:07");
INSERT INTO purchases VALUES("64","pr-20250321-075521","1","2","2","2","1","14","153","0","0","14532","0","0","0","0","14532","0","1","1","","","2025-01-01 00:00:00","2025-03-21 19:55:21");
INSERT INTO purchases VALUES("65","pr-20250322-122223","1","2","2","2","1","2","55","0","0","3550","0","0","0","0","3550","3550","1","2","","","2025-01-01 00:00:00","2025-03-22 12:23:27");
INSERT INTO purchases VALUES("66","pr-20250322-124200","1","2","","","","1","5","0","0","400","0","0","0","0","400","400","1","2","","","2025-01-01 00:00:00","2025-03-22 14:40:37");
INSERT INTO purchases VALUES("67","pr-20250322-124939","1","2","","","","1","30","0","0","0","0","0","0","0","0","0","1","2","","","2025-01-01 00:00:00","2025-03-22 14:40:22");
INSERT INTO purchases VALUES("68","pr-20250322-020102","1","2","","","","1","5","0","0","900","0","0","0","0","900","900","1","2","","","2025-01-01 00:00:00","2025-03-22 14:40:07");
INSERT INTO purchases VALUES("69","pr-20250322-021510","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-01-01 00:00:00","2025-03-22 14:39:31");
INSERT INTO purchases VALUES("70","pr-20250322-023548","1","2","","","","1","10","0","0","2000","0","0","0","0","2000","2000","1","2","","","2025-01-01 00:00:00","2025-03-22 14:39:13");
INSERT INTO purchases VALUES("71","pr-20250322-043442","1","2","","","","1","10","0","0","1200","0","0","0","0","1200","1200","1","2","","","2025-01-01 00:00:00","2025-03-22 18:07:03");
INSERT INTO purchases VALUES("72","pr-20250322-043719","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-01-01 00:00:00","2025-03-22 18:06:46");
INSERT INTO purchases VALUES("73","pr-20250322-050340","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-01-01 00:00:00","2025-03-22 18:06:33");
INSERT INTO purchases VALUES("74","pr-20250322-052714","1","2","","","","1","5","0","0","900","0","0","0","0","900","900","1","2","","","2025-01-01 00:00:00","2025-03-22 18:06:12");
INSERT INTO purchases VALUES("76","pr-20250322-071432","1","2","","","","1","10","0","0","2800","0","0","0","0","2800","2800","1","2","","","2025-01-01 00:00:00","2025-03-22 20:10:40");
INSERT INTO purchases VALUES("77","pr-20250322-072605","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-01-01 00:00:00","2025-03-22 20:11:03");
INSERT INTO purchases VALUES("78","pr-20250322-075300","1","2","","","","1","10","0","0","3500","0","0","0","0","3500","3500","1","2","","","2025-01-01 00:00:00","2025-03-22 20:11:38");
INSERT INTO purchases VALUES("79","pr-20250322-083337","1","2","2","2","1","5","210","0","0","24800","0","0","0","0","24800","24800","1","2","20250322083337.jpeg","","2025-03-19 00:00:00","2025-03-27 10:26:36");
INSERT INTO purchases VALUES("80","pr-20250324-062133","1","2","","","","1","10","0","0","1500","0","0","0","0","1500","1500","1","2","","","2025-02-01 00:00:00","2025-03-24 19:05:43");
INSERT INTO purchases VALUES("81","pr-20250324-062510","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-02-01 00:00:00","2025-03-24 19:06:02");
INSERT INTO purchases VALUES("82","pr-20250324-075703","1","2","","","","1","10","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-02-01 00:00:00","2025-03-24 20:31:02");
INSERT INTO purchases VALUES("83","pr-20250324-081406","1","2","","","","1","10","0","0","800","0","0","0","0","800","800","1","2","","","2025-02-01 00:00:00","2025-03-24 20:31:19");
INSERT INTO purchases VALUES("85","pr-20250325-065620","1","2","","","","1","10","0","0","2500","0","0","0","0","2500","2500","1","2","","","2025-02-01 00:00:00","2025-03-25 18:57:10");
INSERT INTO purchases VALUES("86","pr-20250326-072627","1","2","","","","1","5","0","0","500","0","0","0","0","500","500","1","2","","","2025-02-01 00:00:00","2025-03-26 20:25:12");
INSERT INTO purchases VALUES("87","pr-20250327-065544","1","2","2","2","1","11","400","0","0","37794","0","0","0","0","37794","0","1","1","20250327065544.jpeg","","2025-03-27 00:00:00","2025-03-27 18:55:44");
INSERT INTO purchases VALUES("88","pr-20250327-070457","1","2","","2","1","1","10","0","0","1810","0","0","0","0","1810","1810","1","2","","","2025-03-27 00:00:00","2025-03-27 19:08:54");
INSERT INTO purchases VALUES("89","pr-20250328-101438","1","2","2","2","1","5","44","0","0","34000","0","0","0","0","34000","6550","1","1","","","2025-03-24 00:00:00","2025-03-31 19:50:42");
INSERT INTO purchases VALUES("90","pr-20250331-030751","1","2","","","","1","6","0","0","2400","0","0","0","0","2400","2400","1","2","","","2025-03-01 00:00:00","2025-03-31 16:28:09");
INSERT INTO purchases VALUES("91","pr-20250331-034743","1","2","","","","1","6","0","0","360","0","0","0","0","360","360","1","2","","","2025-03-01 00:00:00","2025-03-31 16:28:38");
INSERT INTO purchases VALUES("92","pr-20250331-055128","1","2","","","","1","5","0","0","1000","0","0","0","0","1000","1000","1","2","","","2025-03-01 00:00:00","2025-04-01 09:15:34");



CREATE TABLE `quotations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `quotation_status` int NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotations VALUES("2","qr-20250313-084649","1","1","2","2","2","3","3","0","0","325","0","0","0","200","525","1","","Test","2025-03-13 20:46:49","2025-03-13 21:05:28");



CREATE TABLE `return_purchases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_id` int DEFAULT NULL,
  `warehouse_id` int NOT NULL,
  `user_id` int NOT NULL,
  `purchase_id` int DEFAULT NULL,
  `account_id` int NOT NULL,
  `currency_id` int DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `staff_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `returns` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `sale_id` int DEFAULT NULL,
  `cash_register_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `biller_id` int NOT NULL,
  `account_id` int NOT NULL,
  `currency_id` int DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `staff_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `reward_point_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `per_point_amount` double NOT NULL,
  `minimum_amount` double NOT NULL,
  `duration` int DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO reward_point_settings VALUES("1","100","100","","Month","1","","2025-01-07 11:04:22");
INSERT INTO reward_point_settings VALUES("2","10","100","3","Month","1","","2023-08-08 22:07:14");



CREATE TABLE `role_has_permissions` (
  `permission_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES("4","1");
INSERT INTO role_has_permissions VALUES("5","1");
INSERT INTO role_has_permissions VALUES("6","1");
INSERT INTO role_has_permissions VALUES("7","1");
INSERT INTO role_has_permissions VALUES("8","1");
INSERT INTO role_has_permissions VALUES("9","1");
INSERT INTO role_has_permissions VALUES("10","1");
INSERT INTO role_has_permissions VALUES("11","1");
INSERT INTO role_has_permissions VALUES("12","1");
INSERT INTO role_has_permissions VALUES("13","1");
INSERT INTO role_has_permissions VALUES("14","1");
INSERT INTO role_has_permissions VALUES("15","1");
INSERT INTO role_has_permissions VALUES("16","1");
INSERT INTO role_has_permissions VALUES("17","1");
INSERT INTO role_has_permissions VALUES("18","1");
INSERT INTO role_has_permissions VALUES("19","1");
INSERT INTO role_has_permissions VALUES("20","1");
INSERT INTO role_has_permissions VALUES("21","1");
INSERT INTO role_has_permissions VALUES("22","1");
INSERT INTO role_has_permissions VALUES("23","1");
INSERT INTO role_has_permissions VALUES("24","1");
INSERT INTO role_has_permissions VALUES("25","1");
INSERT INTO role_has_permissions VALUES("26","1");
INSERT INTO role_has_permissions VALUES("27","1");
INSERT INTO role_has_permissions VALUES("28","1");
INSERT INTO role_has_permissions VALUES("29","1");
INSERT INTO role_has_permissions VALUES("30","1");
INSERT INTO role_has_permissions VALUES("31","1");
INSERT INTO role_has_permissions VALUES("32","1");
INSERT INTO role_has_permissions VALUES("33","1");
INSERT INTO role_has_permissions VALUES("34","1");
INSERT INTO role_has_permissions VALUES("35","1");
INSERT INTO role_has_permissions VALUES("36","1");
INSERT INTO role_has_permissions VALUES("37","1");
INSERT INTO role_has_permissions VALUES("38","1");
INSERT INTO role_has_permissions VALUES("39","1");
INSERT INTO role_has_permissions VALUES("40","1");
INSERT INTO role_has_permissions VALUES("41","1");
INSERT INTO role_has_permissions VALUES("42","1");
INSERT INTO role_has_permissions VALUES("43","1");
INSERT INTO role_has_permissions VALUES("44","1");
INSERT INTO role_has_permissions VALUES("45","1");
INSERT INTO role_has_permissions VALUES("46","1");
INSERT INTO role_has_permissions VALUES("47","1");
INSERT INTO role_has_permissions VALUES("48","1");
INSERT INTO role_has_permissions VALUES("49","1");
INSERT INTO role_has_permissions VALUES("50","1");
INSERT INTO role_has_permissions VALUES("51","1");
INSERT INTO role_has_permissions VALUES("52","1");
INSERT INTO role_has_permissions VALUES("53","1");
INSERT INTO role_has_permissions VALUES("54","1");
INSERT INTO role_has_permissions VALUES("55","1");
INSERT INTO role_has_permissions VALUES("56","1");
INSERT INTO role_has_permissions VALUES("57","1");
INSERT INTO role_has_permissions VALUES("58","1");
INSERT INTO role_has_permissions VALUES("59","1");
INSERT INTO role_has_permissions VALUES("60","1");
INSERT INTO role_has_permissions VALUES("61","1");
INSERT INTO role_has_permissions VALUES("62","1");
INSERT INTO role_has_permissions VALUES("63","1");
INSERT INTO role_has_permissions VALUES("64","1");
INSERT INTO role_has_permissions VALUES("65","1");
INSERT INTO role_has_permissions VALUES("66","1");
INSERT INTO role_has_permissions VALUES("67","1");
INSERT INTO role_has_permissions VALUES("68","1");
INSERT INTO role_has_permissions VALUES("69","1");
INSERT INTO role_has_permissions VALUES("70","1");
INSERT INTO role_has_permissions VALUES("71","1");
INSERT INTO role_has_permissions VALUES("72","1");
INSERT INTO role_has_permissions VALUES("73","1");
INSERT INTO role_has_permissions VALUES("74","1");
INSERT INTO role_has_permissions VALUES("75","1");
INSERT INTO role_has_permissions VALUES("76","1");
INSERT INTO role_has_permissions VALUES("77","1");
INSERT INTO role_has_permissions VALUES("78","1");
INSERT INTO role_has_permissions VALUES("79","1");
INSERT INTO role_has_permissions VALUES("80","1");
INSERT INTO role_has_permissions VALUES("81","1");
INSERT INTO role_has_permissions VALUES("82","1");
INSERT INTO role_has_permissions VALUES("83","1");
INSERT INTO role_has_permissions VALUES("84","1");
INSERT INTO role_has_permissions VALUES("85","1");
INSERT INTO role_has_permissions VALUES("86","1");
INSERT INTO role_has_permissions VALUES("87","1");
INSERT INTO role_has_permissions VALUES("88","1");
INSERT INTO role_has_permissions VALUES("89","1");
INSERT INTO role_has_permissions VALUES("90","1");
INSERT INTO role_has_permissions VALUES("91","1");
INSERT INTO role_has_permissions VALUES("92","1");
INSERT INTO role_has_permissions VALUES("93","1");
INSERT INTO role_has_permissions VALUES("94","1");
INSERT INTO role_has_permissions VALUES("95","1");
INSERT INTO role_has_permissions VALUES("96","1");
INSERT INTO role_has_permissions VALUES("97","1");
INSERT INTO role_has_permissions VALUES("98","1");
INSERT INTO role_has_permissions VALUES("99","1");
INSERT INTO role_has_permissions VALUES("100","1");
INSERT INTO role_has_permissions VALUES("101","1");
INSERT INTO role_has_permissions VALUES("102","1");
INSERT INTO role_has_permissions VALUES("103","1");
INSERT INTO role_has_permissions VALUES("104","1");
INSERT INTO role_has_permissions VALUES("105","1");
INSERT INTO role_has_permissions VALUES("106","1");
INSERT INTO role_has_permissions VALUES("107","1");
INSERT INTO role_has_permissions VALUES("108","1");
INSERT INTO role_has_permissions VALUES("109","1");
INSERT INTO role_has_permissions VALUES("110","1");
INSERT INTO role_has_permissions VALUES("111","1");
INSERT INTO role_has_permissions VALUES("112","1");
INSERT INTO role_has_permissions VALUES("113","1");
INSERT INTO role_has_permissions VALUES("114","1");
INSERT INTO role_has_permissions VALUES("115","1");
INSERT INTO role_has_permissions VALUES("116","1");
INSERT INTO role_has_permissions VALUES("117","1");
INSERT INTO role_has_permissions VALUES("118","1");
INSERT INTO role_has_permissions VALUES("119","1");
INSERT INTO role_has_permissions VALUES("120","1");
INSERT INTO role_has_permissions VALUES("121","1");
INSERT INTO role_has_permissions VALUES("122","1");
INSERT INTO role_has_permissions VALUES("123","1");
INSERT INTO role_has_permissions VALUES("124","1");
INSERT INTO role_has_permissions VALUES("125","1");
INSERT INTO role_has_permissions VALUES("126","1");
INSERT INTO role_has_permissions VALUES("4","2");
INSERT INTO role_has_permissions VALUES("5","2");
INSERT INTO role_has_permissions VALUES("6","2");
INSERT INTO role_has_permissions VALUES("7","2");
INSERT INTO role_has_permissions VALUES("8","2");
INSERT INTO role_has_permissions VALUES("9","2");
INSERT INTO role_has_permissions VALUES("10","2");
INSERT INTO role_has_permissions VALUES("11","2");
INSERT INTO role_has_permissions VALUES("12","2");
INSERT INTO role_has_permissions VALUES("13","2");
INSERT INTO role_has_permissions VALUES("14","2");
INSERT INTO role_has_permissions VALUES("15","2");
INSERT INTO role_has_permissions VALUES("16","2");
INSERT INTO role_has_permissions VALUES("17","2");
INSERT INTO role_has_permissions VALUES("18","2");
INSERT INTO role_has_permissions VALUES("19","2");
INSERT INTO role_has_permissions VALUES("20","2");
INSERT INTO role_has_permissions VALUES("21","2");
INSERT INTO role_has_permissions VALUES("22","2");
INSERT INTO role_has_permissions VALUES("23","2");
INSERT INTO role_has_permissions VALUES("24","2");
INSERT INTO role_has_permissions VALUES("25","2");
INSERT INTO role_has_permissions VALUES("26","2");
INSERT INTO role_has_permissions VALUES("27","2");
INSERT INTO role_has_permissions VALUES("28","2");
INSERT INTO role_has_permissions VALUES("29","2");
INSERT INTO role_has_permissions VALUES("30","2");
INSERT INTO role_has_permissions VALUES("31","2");
INSERT INTO role_has_permissions VALUES("32","2");
INSERT INTO role_has_permissions VALUES("33","2");
INSERT INTO role_has_permissions VALUES("34","2");
INSERT INTO role_has_permissions VALUES("35","2");
INSERT INTO role_has_permissions VALUES("36","2");
INSERT INTO role_has_permissions VALUES("37","2");
INSERT INTO role_has_permissions VALUES("38","2");
INSERT INTO role_has_permissions VALUES("39","2");
INSERT INTO role_has_permissions VALUES("40","2");
INSERT INTO role_has_permissions VALUES("41","2");
INSERT INTO role_has_permissions VALUES("42","2");
INSERT INTO role_has_permissions VALUES("43","2");
INSERT INTO role_has_permissions VALUES("44","2");
INSERT INTO role_has_permissions VALUES("45","2");
INSERT INTO role_has_permissions VALUES("46","2");
INSERT INTO role_has_permissions VALUES("47","2");
INSERT INTO role_has_permissions VALUES("48","2");
INSERT INTO role_has_permissions VALUES("49","2");
INSERT INTO role_has_permissions VALUES("50","2");
INSERT INTO role_has_permissions VALUES("51","2");
INSERT INTO role_has_permissions VALUES("52","2");
INSERT INTO role_has_permissions VALUES("53","2");
INSERT INTO role_has_permissions VALUES("54","2");
INSERT INTO role_has_permissions VALUES("55","2");
INSERT INTO role_has_permissions VALUES("56","2");
INSERT INTO role_has_permissions VALUES("57","2");
INSERT INTO role_has_permissions VALUES("58","2");
INSERT INTO role_has_permissions VALUES("63","2");
INSERT INTO role_has_permissions VALUES("64","2");
INSERT INTO role_has_permissions VALUES("65","2");
INSERT INTO role_has_permissions VALUES("66","2");
INSERT INTO role_has_permissions VALUES("67","2");
INSERT INTO role_has_permissions VALUES("68","2");
INSERT INTO role_has_permissions VALUES("69","2");
INSERT INTO role_has_permissions VALUES("73","2");
INSERT INTO role_has_permissions VALUES("74","2");
INSERT INTO role_has_permissions VALUES("75","2");
INSERT INTO role_has_permissions VALUES("76","2");
INSERT INTO role_has_permissions VALUES("77","2");
INSERT INTO role_has_permissions VALUES("78","2");
INSERT INTO role_has_permissions VALUES("79","2");
INSERT INTO role_has_permissions VALUES("82","2");
INSERT INTO role_has_permissions VALUES("83","2");
INSERT INTO role_has_permissions VALUES("85","2");
INSERT INTO role_has_permissions VALUES("87","2");
INSERT INTO role_has_permissions VALUES("88","2");
INSERT INTO role_has_permissions VALUES("90","2");
INSERT INTO role_has_permissions VALUES("91","2");
INSERT INTO role_has_permissions VALUES("92","2");
INSERT INTO role_has_permissions VALUES("93","2");
INSERT INTO role_has_permissions VALUES("94","2");
INSERT INTO role_has_permissions VALUES("95","2");
INSERT INTO role_has_permissions VALUES("96","2");
INSERT INTO role_has_permissions VALUES("97","2");
INSERT INTO role_has_permissions VALUES("98","2");
INSERT INTO role_has_permissions VALUES("99","2");
INSERT INTO role_has_permissions VALUES("100","2");
INSERT INTO role_has_permissions VALUES("101","2");
INSERT INTO role_has_permissions VALUES("102","2");
INSERT INTO role_has_permissions VALUES("103","2");
INSERT INTO role_has_permissions VALUES("105","2");
INSERT INTO role_has_permissions VALUES("106","2");
INSERT INTO role_has_permissions VALUES("107","2");
INSERT INTO role_has_permissions VALUES("108","2");
INSERT INTO role_has_permissions VALUES("109","2");
INSERT INTO role_has_permissions VALUES("110","2");
INSERT INTO role_has_permissions VALUES("111","2");
INSERT INTO role_has_permissions VALUES("113","2");
INSERT INTO role_has_permissions VALUES("114","2");
INSERT INTO role_has_permissions VALUES("115","2");
INSERT INTO role_has_permissions VALUES("116","2");
INSERT INTO role_has_permissions VALUES("117","2");
INSERT INTO role_has_permissions VALUES("118","2");
INSERT INTO role_has_permissions VALUES("119","2");
INSERT INTO role_has_permissions VALUES("120","2");
INSERT INTO role_has_permissions VALUES("122","2");
INSERT INTO role_has_permissions VALUES("123","2");
INSERT INTO role_has_permissions VALUES("125","2");
INSERT INTO role_has_permissions VALUES("4","3");
INSERT INTO role_has_permissions VALUES("6","3");
INSERT INTO role_has_permissions VALUES("7","3");
INSERT INTO role_has_permissions VALUES("8","3");
INSERT INTO role_has_permissions VALUES("9","3");
INSERT INTO role_has_permissions VALUES("10","3");
INSERT INTO role_has_permissions VALUES("12","3");
INSERT INTO role_has_permissions VALUES("13","3");
INSERT INTO role_has_permissions VALUES("14","3");
INSERT INTO role_has_permissions VALUES("28","3");
INSERT INTO role_has_permissions VALUES("29","3");
INSERT INTO role_has_permissions VALUES("30","3");
INSERT INTO role_has_permissions VALUES("32","3");
INSERT INTO role_has_permissions VALUES("33","3");
INSERT INTO role_has_permissions VALUES("34","3");
INSERT INTO role_has_permissions VALUES("55","3");
INSERT INTO role_has_permissions VALUES("56","3");
INSERT INTO role_has_permissions VALUES("57","3");
INSERT INTO role_has_permissions VALUES("63","3");
INSERT INTO role_has_permissions VALUES("64","3");
INSERT INTO role_has_permissions VALUES("65","3");



CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES("1","Admin","Can Access Data/ Customize System Settings","web","1","2018-06-02 02:46:44","2024-12-30 23:02:17");
INSERT INTO roles VALUES("2","Manager","Can Access All Operational Records","web","1","2018-10-22 05:38:13","2024-12-30 23:01:11");
INSERT INTO roles VALUES("3","Cashier/Sales","Cashier has specific access","web","1","2018-06-02 03:05:27","2024-12-30 22:59:37");
INSERT INTO roles VALUES("4","Guest","Very Limited Access","web","1","2020-11-05 09:43:16","2024-12-30 23:03:19");



CREATE TABLE `sales` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `cash_register_id` int DEFAULT NULL,
  `table_id` int DEFAULT NULL,
  `queue` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `warehouse_id` int NOT NULL,
  `biller_id` int DEFAULT NULL,
  `item` int NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `grand_total` double NOT NULL,
  `currency_id` int DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_discount_value` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `coupon_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `sale_status` int NOT NULL,
  `payment_status` int NOT NULL,
  `document` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `sale_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `staff_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `muri_kha` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=860 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sales VALUES("23","posr-20230914-092302","2","2","","","1","1","1","1","1","0","0","1970","1970","2","1","0","0","Flat","","0","","","0","1","4","","1970","","","2023-09-14 12:23:02","2023-09-14 12:23:02","");
INSERT INTO sales VALUES("24","posr-20230915-101545","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 13:15:45","2023-09-15 13:15:45","");
INSERT INTO sales VALUES("25","posr-20230915-122259","2","2","","","1","1","1","5","5","0","0","2180","2180","2","1","0","0","Flat","","0","","","0","1","4","","2180","","","2023-09-15 15:22:59","2023-09-15 15:22:59","");
INSERT INTO sales VALUES("26","posr-20230915-012527","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 16:25:27","2023-09-15 16:25:27","");
INSERT INTO sales VALUES("27","posr-20230915-013532","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 16:35:32","2023-09-15 16:35:32","");
INSERT INTO sales VALUES("28","posr-20230915-014113","2","2","","","1","1","1","2","2","0","0","2000","2000","2","1","0","0","Flat","","0","","","0","1","4","","2000","","","2023-09-15 16:41:13","2023-09-15 16:41:13","");
INSERT INTO sales VALUES("29","posr-20230915-014331","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 16:43:31","2023-09-15 16:43:31","");
INSERT INTO sales VALUES("30","posr-20230915-014440","2","2","","","1","1","1","1","1","0","0","68","68","2","1","0","0","Flat","","0","","","0","1","4","","68","","","2023-09-15 16:44:40","2023-09-15 16:44:40","");
INSERT INTO sales VALUES("31","posr-20230915-015201","2","2","","","1","1","1","1","1","0","0","375","375","2","1","0","0","Flat","","0","","","0","1","4","","375","","","2023-09-15 16:52:01","2023-09-15 16:52:01","");
INSERT INTO sales VALUES("32","posr-20230915-020747","2","2","","","1","1","1","1","7","0","0","210","210","2","1","0","0","Flat","","0","","","0","1","4","","210","","","2023-09-15 17:07:47","2023-09-15 17:07:47","");
INSERT INTO sales VALUES("33","posr-20230915-031205","2","2","","","1","1","1","2","2","0","0","2715","2715","2","1","0","0","Flat","","0","","","0","1","4","","2715","","","2023-09-15 18:12:05","2023-09-15 18:12:05","");
INSERT INTO sales VALUES("34","posr-20230915-033655","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 18:36:55","2023-09-15 18:36:55","");
INSERT INTO sales VALUES("35","posr-20230915-041651","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 19:16:51","2023-09-15 19:16:51","");
INSERT INTO sales VALUES("36","posr-20230915-043500","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-09-15 19:35:00","2023-09-15 19:35:00","");
INSERT INTO sales VALUES("37","posr-20230915-050928","2","2","","","1","1","1","1","1","0","0","32","32","2","1","0","0","Flat","","0","","","0","1","4","","32","","","2023-09-15 20:09:28","2023-09-15 20:09:28","");
INSERT INTO sales VALUES("38","posr-20230915-052821","2","2","","","1","1","1","1","1","0","0","587","587","2","1","0","0","Flat","","0","","","0","1","4","","587","","","2023-09-15 20:28:21","2023-09-15 20:28:21","");
INSERT INTO sales VALUES("39","posr-20230915-054837","2","2","","","1","1","1","1","1","0","0","500","500","2","1","0","0","Flat","","0","","","0","1","4","","500","","","2023-09-15 20:48:37","2023-09-15 20:48:37","");
INSERT INTO sales VALUES("40","posr-20230915-061054","2","2","","","1","1","1","2","2","0","0","1065","1065","2","1","0","0","Flat","","0","","","0","1","4","","1065","","","2023-09-15 21:10:54","2023-09-15 21:10:54","");
INSERT INTO sales VALUES("41","posr-20230915-061155","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 21:11:55","2023-09-15 21:11:55","");
INSERT INTO sales VALUES("42","posr-20230915-062607","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-15 21:26:07","2023-09-15 21:26:07","");
INSERT INTO sales VALUES("43","posr-20230916-095636","2","2","","","1","1","1","1","1","0","0","1970","1970","2","1","0","0","Flat","","0","","","0","1","4","","1970","","","2023-09-16 12:56:36","2023-09-16 12:56:36","");
INSERT INTO sales VALUES("44","posr-20230916-101732","2","2","","","1","1","1","3","3","0","0","1000","1000","2","1","0","0","Flat","","0","","","0","1","4","","1000","","","2023-09-16 13:17:32","2023-09-16 13:17:32","");
INSERT INTO sales VALUES("45","posr-20230916-103757","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 13:37:57","2023-09-16 13:37:57","");
INSERT INTO sales VALUES("46","posr-20230916-112202","2","2","","","1","1","1","2","2","0","0","1295","1295","2","1","0","0","Flat","","0","","","0","1","4","","1295","","","2023-09-16 14:22:02","2023-09-16 14:22:02","");
INSERT INTO sales VALUES("47","posr-20230916-112515","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 14:25:15","2023-09-16 14:25:15","");
INSERT INTO sales VALUES("48","posr-20230916-123504","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 15:35:04","2023-09-16 15:35:04","");
INSERT INTO sales VALUES("49","posr-20230916-013151","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-09-16 16:31:51","2023-09-16 16:31:51","");
INSERT INTO sales VALUES("50","posr-20230916-014630","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 16:46:30","2023-09-16 16:46:30","");
INSERT INTO sales VALUES("53","posr-20230916-022923","2","2","","","1","1","1","3","3","0","0","785","785","2","1","0","0","Flat","","0","","","0","1","4","","785","","","2023-09-16 17:29:23","2023-09-16 17:29:23","");
INSERT INTO sales VALUES("54","posr-20230916-025942","2","2","","","1","1","1","1","1","0","0","360","360","2","1","0","0","Flat","","0","","","0","1","4","","360","","","2023-09-16 17:59:42","2023-09-16 17:59:42","");
INSERT INTO sales VALUES("55","posr-20230916-030325","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 18:03:25","2023-09-16 18:03:25","");
INSERT INTO sales VALUES("56","posr-20230916-045600","2","2","","","1","1","1","5","5","0","0","2180","2180","2","1","0","0","Flat","","0","","","0","1","4","","2180","","","2023-09-16 19:56:00","2023-09-16 19:56:00","");
INSERT INTO sales VALUES("57","posr-20230916-062514","2","2","","","1","1","1","1","1","0","0","235","235","2","1","0","0","Flat","","0","","","0","1","4","","235","","","2023-09-16 21:25:14","2023-09-16 21:25:14","");
INSERT INTO sales VALUES("58","posr-20230916-064017","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-16 21:40:17","2023-09-16 21:40:17","");
INSERT INTO sales VALUES("59","posr-20230917-113424","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-09-17 14:34:24","2023-09-17 14:34:24","");
INSERT INTO sales VALUES("60","posr-20230917-115407","2","2","","","1","1","1","1","1","0","0","250","250","2","1","0","0","Flat","","0","","","0","1","4","","250","","","2023-09-17 14:54:07","2023-09-17 14:54:07","");
INSERT INTO sales VALUES("61","posr-20230917-121912","2","2","","","1","1","1","2","2","0","0","712","712","2","1","0","0","Flat","","0","","","0","1","4","","712","","","2023-09-17 15:19:12","2023-09-17 15:19:12","");
INSERT INTO sales VALUES("62","posr-20230917-124523","2","2","","","1","1","1","5","5","0","0","1800","1800","2","1","0","0","Flat","","0","","","0","1","4","","1800","","","2023-09-17 15:45:23","2023-09-17 15:45:23","");
INSERT INTO sales VALUES("63","posr-20230917-125758","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 15:57:58","2023-09-17 15:57:58","");
INSERT INTO sales VALUES("64","posr-20230917-125918","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 15:59:18","2023-09-17 15:59:18","");
INSERT INTO sales VALUES("65","posr-20230917-012101","2","2","","","1","1","1","1","1","0","0","135","135","2","1","0","0","Flat","","0","","","0","1","4","","135","","","2023-09-17 16:21:01","2023-09-17 16:21:01","");
INSERT INTO sales VALUES("66","posr-20230917-012151","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 16:21:51","2023-09-17 16:21:51","");
INSERT INTO sales VALUES("67","posr-20230917-023253","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 17:32:53","2023-09-17 17:32:53","");
INSERT INTO sales VALUES("68","posr-20230917-024939","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 17:49:39","2023-09-17 17:49:39","");
INSERT INTO sales VALUES("69","posr-20230917-034750","2","2","","","1","1","1","2","2","0","0","505","505","2","1","0","0","Flat","","0","","","0","1","4","","505","","","2023-09-17 18:47:50","2023-09-17 18:47:50","");
INSERT INTO sales VALUES("70","posr-20230917-040809","2","2","","","1","1","1","4","7","0","0","3815","3815","2","1","0","0","Flat","","0","","","0","1","4","","3815","","","2023-09-17 19:08:09","2023-09-17 19:08:09","");
INSERT INTO sales VALUES("71","posr-20230917-051529","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-17 20:15:29","2023-09-17 20:15:29","");
INSERT INTO sales VALUES("72","posr-20230917-064519","2","2","","","1","1","1","6","7","0","0","2650","2650","2","1","0","0","Flat","","0","","","0","1","4","","2650","","","2023-09-17 21:45:19","2023-09-17 21:45:19","");
INSERT INTO sales VALUES("73","posr-20230918-094734","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-09-18 12:47:34","2023-09-18 12:47:34","");
INSERT INTO sales VALUES("74","posr-20230918-104815","2","2","","","1","1","1","3","5","0","0","780","780","2","1","0","0","Flat","","0","","","0","1","4","","780","","","2023-09-18 13:48:15","2023-09-18 13:48:15","");
INSERT INTO sales VALUES("75","posr-20230918-110035","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-09-18 14:00:35","2023-09-18 14:00:35","");
INSERT INTO sales VALUES("76","posr-20230918-122618","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-18 15:26:18","2023-09-18 15:26:18","");
INSERT INTO sales VALUES("77","posr-20230918-122826","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-18 15:28:26","2023-09-18 15:28:26","");
INSERT INTO sales VALUES("78","posr-20230918-010617","2","2","","","1","1","1","2","2","0","0","596","596","2","1","0","0","Flat","","0","","","0","1","4","","596","","","2023-09-18 16:06:17","2023-09-18 16:06:17","");
INSERT INTO sales VALUES("79","posr-20230918-012212","2","2","","","1","1","1","1","1","0","0","161","161","2","1","0","0","Flat","","0","","","0","1","4","","161","","","2023-09-18 16:22:12","2023-09-18 16:22:12","");
INSERT INTO sales VALUES("80","posr-20230918-031548","2","2","","","1","1","1","1","1","0","0","161","161","2","1","0","0","Flat","","0","","","0","1","4","","161","","","2023-09-18 18:15:48","2023-09-18 18:15:48","");
INSERT INTO sales VALUES("81","posr-20230918-040115","2","2","","","1","1","1","1","1","0","0","610","610","2","1","0","0","Flat","","0","","","0","1","4","","610","","","2023-09-18 19:01:15","2023-09-18 19:01:15","");
INSERT INTO sales VALUES("82","posr-20230918-043100","2","2","","","1","1","1","4","4","0","0","1465","1465","2","1","0","0","Flat","","0","","","0","1","4","","1465","","","2023-09-18 19:31:00","2023-09-18 19:31:00","");
INSERT INTO sales VALUES("83","posr-20230918-045147","2","2","","","1","1","1","1","1","0","0","380","380","2","1","0","0","Flat","","0","","","0","1","4","","380","","","2023-09-18 19:51:47","2023-09-18 19:51:47","");
INSERT INTO sales VALUES("84","posr-20230918-063532","2","2","","","1","1","1","1","1","0","0","25","25","2","1","0","0","Flat","","0","","","0","1","4","","25","","","2023-09-18 21:35:32","2023-09-18 21:35:32","");
INSERT INTO sales VALUES("85","posr-20230919-093300","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 12:33:00","2023-09-19 12:33:00","");
INSERT INTO sales VALUES("86","posr-20230919-100253","2","2","","","1","1","1","7","8","0","0","2975","2975","2","1","0","0","Flat","","0","","","0","1","4","","2975","","","2023-09-19 13:02:53","2023-09-19 13:02:53","");
INSERT INTO sales VALUES("87","posr-20230919-100435","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 13:04:35","2023-09-19 13:04:35","");
INSERT INTO sales VALUES("88","posr-20230919-020741","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 17:07:41","2023-09-19 17:07:41","");
INSERT INTO sales VALUES("89","posr-20230919-021348","2","2","","","1","1","1","3","3","0","0","1295","1295","2","1","0","0","Flat","","0","","","0","1","4","","1295","","","2023-09-19 17:13:48","2023-09-19 17:13:48","");
INSERT INTO sales VALUES("90","posr-20230919-022810","2","2","","","1","1","1","2","2","0","0","1720","1720","2","1","0","0","Flat","","0","","","0","1","4","","1720","","","2023-09-19 17:28:10","2023-09-19 17:28:10","");
INSERT INTO sales VALUES("91","posr-20230919-023044","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 17:30:44","2023-09-19 17:30:44","");
INSERT INTO sales VALUES("92","posr-20230919-023127","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 17:31:27","2023-09-19 17:31:27","");
INSERT INTO sales VALUES("93","posr-20230919-024940","2","2","","","1","1","1","3","6","0","0","1840","1840","2","1","0","0","Flat","","0","","","0","1","4","","1840","","","2023-09-19 17:49:40","2023-09-19 17:49:40","");
INSERT INTO sales VALUES("94","posr-20230919-034521","2","2","","","1","1","1","2","2","0","0","1830","1830","2","1","0","0","Flat","","0","","","0","1","4","","1830","","","2023-09-19 18:45:21","2023-09-19 18:45:21","");
INSERT INTO sales VALUES("95","posr-20230919-041118","2","2","","","1","1","1","1","1","0","0","490","490","2","1","0","0","Flat","","0","","","0","1","4","","490","","","2023-09-19 19:11:18","2023-09-19 19:11:18","");
INSERT INTO sales VALUES("96","posr-20230919-042437","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-09-19 19:24:37","2023-09-19 19:24:37","");
INSERT INTO sales VALUES("97","posr-20230919-043403","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 19:34:03","2023-09-19 19:34:03","");
INSERT INTO sales VALUES("98","posr-20230919-043504","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 19:35:04","2023-09-19 19:35:04","");
INSERT INTO sales VALUES("99","posr-20230919-044813","2","2","","","1","1","1","4","4","0","0","1780","1780","2","1","0","0","Flat","","0","","","0","1","4","","1780","","","2023-09-19 19:48:13","2023-09-19 19:48:13","");
INSERT INTO sales VALUES("100","posr-20230919-050126","2","2","","","1","1","1","1","1","0","0","2400","2400","2","1","0","0","Flat","","0","","","0","1","4","","2400","","","2023-09-19 20:01:26","2023-09-19 20:01:26","");
INSERT INTO sales VALUES("101","posr-20230919-061038","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-19 21:10:38","2023-09-19 21:10:38","");
INSERT INTO sales VALUES("103","posr-20230920-095141","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-20 12:51:41","2023-09-20 12:51:41","");
INSERT INTO sales VALUES("104","posr-20230920-095558","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-20 12:55:58","2023-09-20 12:55:58","");
INSERT INTO sales VALUES("105","posr-20230920-104539","2","2","","","1","1","1","5","5","0","0","4180","4180","2","1","0","0","Flat","","0","","","0","1","4","","4180","","","2023-09-20 13:45:39","2023-09-20 13:45:39","");
INSERT INTO sales VALUES("106","posr-20230920-105000","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-20 13:50:00","2023-09-20 13:50:00","");
INSERT INTO sales VALUES("107","posr-20230920-030035","2","2","","","1","1","1","1","1","0","0","315","315","2","1","0","0","Flat","","0","","","0","1","4","","315","","","2023-09-20 18:00:35","2023-09-20 18:00:35","");
INSERT INTO sales VALUES("108","posr-20230920-045125","2","2","","","1","1","1","1","1","0","0","3070","3070","2","1","0","0","Flat","","0","","","0","1","4","","3070","","","2023-09-20 19:51:25","2023-09-20 19:51:25","");
INSERT INTO sales VALUES("109","posr-20230920-053313","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-20 20:33:13","2023-09-20 20:33:13","");
INSERT INTO sales VALUES("110","posr-20230920-053748","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-20 20:37:48","2023-09-20 20:37:48","");
INSERT INTO sales VALUES("111","posr-20230921-091533","2","2","","","1","1","1","1","1","0","0","460","460","2","1","0","0","Flat","","0","","","0","1","4","","460","","","2023-09-21 12:15:33","2023-09-21 12:15:33","");
INSERT INTO sales VALUES("112","posr-20230921-091706","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-21 12:17:06","2023-09-21 12:17:06","");
INSERT INTO sales VALUES("113","posr-20230921-091803","2","2","","","1","1","1","1","1","0","0","495","495","2","1","0","0","Flat","","0","","","0","1","4","","495","","","2023-09-21 12:18:03","2023-09-21 12:18:03","");
INSERT INTO sales VALUES("114","posr-20230921-104757","2","2","","","1","1","1","1","1","0","0","110","110","2","1","0","0","Flat","","0","","","0","1","4","","110","","","2023-09-21 13:47:57","2023-09-21 13:47:57","");
INSERT INTO sales VALUES("115","posr-20230921-105746","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-21 13:57:46","2023-09-21 13:57:46","");
INSERT INTO sales VALUES("116","posr-20230921-111635","2","2","","","1","1","1","2","2","0","0","990","990","2","1","0","0","Flat","","0","","","0","1","4","","990","","","2023-09-21 14:16:35","2023-09-21 14:16:35","");
INSERT INTO sales VALUES("117","posr-20230921-111836","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-21 14:18:36","2023-09-21 14:18:36","");
INSERT INTO sales VALUES("118","posr-20230921-025613","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-21 17:56:13","2023-09-21 17:56:13","");
INSERT INTO sales VALUES("119","posr-20230921-061405","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-21 21:14:05","2023-09-21 21:14:05","");
INSERT INTO sales VALUES("120","posr-20230922-095721","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-22 12:57:21","2023-09-22 12:57:21","");
INSERT INTO sales VALUES("121","posr-20230922-105515","2","2","","","1","1","1","1","1","0","0","1100","1100","2","1","0","0","Flat","","0","","","0","1","4","","1100","","","2023-09-22 13:55:15","2023-09-22 13:55:15","");
INSERT INTO sales VALUES("122","posr-20230922-115651","2","2","","","1","1","1","1","2","0","0","60","60","2","1","0","0","Flat","","0","","","0","1","4","","60","","","2023-09-22 14:56:51","2023-09-22 14:56:51","");
INSERT INTO sales VALUES("123","posr-20230922-015618","2","2","","","1","1","1","2","2","0","0","825","825","2","1","0","0","Flat","","0","","","0","1","4","","825","","","2023-09-22 16:56:18","2023-09-22 16:56:18","");
INSERT INTO sales VALUES("124","posr-20230922-020403","2","2","","","1","1","1","2","2","0","0","990","990","2","1","0","0","Flat","","0","","","0","1","4","","990","","","2023-09-22 17:04:03","2023-09-22 17:04:03","");
INSERT INTO sales VALUES("125","posr-20230922-055154","2","2","","","1","1","1","4","4","0","0","1800","1800","2","1","0","0","Flat","","0","","","0","1","4","","1800","","","2023-09-22 20:51:54","2023-09-22 20:51:54","");
INSERT INTO sales VALUES("126","posr-20230922-055542","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-22 20:55:42","2023-09-22 20:55:42","");
INSERT INTO sales VALUES("127","posr-20230922-062201","2","2","","","1","1","1","2","2","0","0","1175","1175","2","1","0","0","Flat","","0","","","0","1","4","","1175","","","2023-09-22 21:22:01","2023-09-22 21:22:01","");
INSERT INTO sales VALUES("128","posr-20230922-063009","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-09-22 21:30:09","2023-09-22 21:30:09","");
INSERT INTO sales VALUES("129","posr-20230923-085240","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 11:52:40","2023-09-23 11:52:40","");
INSERT INTO sales VALUES("130","posr-20230923-104332","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 13:43:32","2023-09-23 13:43:32","");
INSERT INTO sales VALUES("131","posr-20230923-115453","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 14:54:53","2023-09-23 14:54:53","");
INSERT INTO sales VALUES("132","posr-20230923-011525","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 16:15:25","2023-09-23 16:15:25","");
INSERT INTO sales VALUES("133","posr-20230923-012537","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-09-23 16:25:37","2023-09-23 16:25:37","");
INSERT INTO sales VALUES("134","posr-20230923-013100","2","2","","","1","1","1","1","1","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-09-23 16:31:00","2023-09-23 16:31:00","");
INSERT INTO sales VALUES("135","posr-20230923-015132","2","2","","","1","1","1","1","1","0","0","1100","1100","2","1","0","0","Flat","","0","","","0","1","4","","1100","","","2023-09-23 16:51:32","2023-09-23 16:51:32","");
INSERT INTO sales VALUES("136","posr-20230923-035403","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 18:54:03","2023-09-23 18:54:03","");
INSERT INTO sales VALUES("137","posr-20230923-044813","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 19:48:13","2023-09-23 19:48:13","");
INSERT INTO sales VALUES("138","posr-20230923-044931","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 19:49:31","2023-09-23 19:49:31","");
INSERT INTO sales VALUES("139","posr-20230923-064239","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-23 21:42:39","2023-09-23 21:42:39","");
INSERT INTO sales VALUES("140","posr-20230924-102007","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 13:20:07","2023-09-24 13:20:07","");
INSERT INTO sales VALUES("141","posr-20230924-111010","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 14:10:10","2023-09-24 14:10:10","");
INSERT INTO sales VALUES("142","posr-20230924-112109","2","2","","","1","1","1","2","3","0","0","1660","1660","2","1","0","0","Flat","","0","","","0","1","4","","1660","","","2023-09-24 14:21:09","2023-09-24 14:21:09","");
INSERT INTO sales VALUES("143","posr-20230924-011457","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 16:14:57","2023-09-24 16:14:57","");
INSERT INTO sales VALUES("144","posr-20230924-011753","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 16:17:53","2023-09-24 16:17:53","");
INSERT INTO sales VALUES("145","posr-20230924-011753","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 16:17:53","2023-09-24 16:17:53","");
INSERT INTO sales VALUES("146","posr-20230924-015842","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 16:58:42","2023-09-24 16:58:42","");
INSERT INTO sales VALUES("147","posr-20230924-035306","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-09-24 18:53:06","2023-09-24 18:53:06","");
INSERT INTO sales VALUES("148","posr-20230924-045429","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 19:54:29","2023-09-24 19:54:29","");
INSERT INTO sales VALUES("149","posr-20230924-052117","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-24 20:21:17","2023-09-24 20:21:17","");
INSERT INTO sales VALUES("150","posr-20230924-052853","2","2","","","1","1","1","1","1","0","0","495","495","2","1","0","0","Flat","","0","","","0","1","4","","495","","","2023-09-24 20:28:53","2023-09-24 20:28:53","");
INSERT INTO sales VALUES("151","posr-20230925-080130","2","2","","","1","1","1","1","1","0","0","45","45","2","1","0","0","Flat","","0","","","0","1","4","","45","","","2023-09-25 11:01:30","2023-09-25 11:01:30","");
INSERT INTO sales VALUES("152","posr-20230925-085213","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-25 11:52:13","2023-09-25 11:52:13","");
INSERT INTO sales VALUES("153","posr-20230925-092742","2","2","","","1","1","1","1","1","0","0","495","495","2","1","0","0","Flat","","0","","","0","1","4","","495","","","2023-09-25 12:27:42","2023-09-25 12:27:42","");
INSERT INTO sales VALUES("154","posr-20230925-101528","2","2","","","1","1","1","4","5","0","0","3145","3145","2","1","0","0","Flat","","0","","","0","1","4","","3145","","","2023-09-25 13:15:28","2023-09-25 13:15:28","");
INSERT INTO sales VALUES("155","posr-20230925-112059","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-09-25 14:20:59","2023-09-25 14:20:59","");
INSERT INTO sales VALUES("156","posr-20230925-112149","2","2","","","1","1","1","1","1","0","0","495","495","2","1","0","0","Flat","","0","","","0","1","4","","495","","","2023-09-25 14:21:49","2023-09-25 14:21:49","");
INSERT INTO sales VALUES("157","posr-20230925-120732","2","2","","","1","1","1","14","17","0","0","10161","10161","2","1","0","0","Flat","","0","","","0","1","4","","10161","","","2023-09-25 15:07:32","2023-09-25 15:07:32","");
INSERT INTO sales VALUES("158","posr-20230925-122536","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-09-25 15:25:36","2023-09-25 15:25:36","");
INSERT INTO sales VALUES("159","posr-20230925-013338","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-25 16:33:38","2023-09-25 16:33:38","");
INSERT INTO sales VALUES("160","posr-20230925-023115","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-09-25 17:31:15","2023-09-25 17:31:15","");
INSERT INTO sales VALUES("161","posr-20230925-031447","2","2","","","1","1","1","6","7","0","0","4135","4135","2","1","0","0","Flat","","0","","","0","1","4","","4135","","","2023-09-25 18:14:47","2023-09-25 18:14:47","");
INSERT INTO sales VALUES("162","posr-20230925-031818","2","2","","","1","1","1","5","5","0","0","810","810","2","1","0","0","Flat","","0","","","0","1","4","","810","","","2023-09-25 18:18:18","2023-09-25 18:18:18","");
INSERT INTO sales VALUES("163","posr-20230925-032138","2","2","","","1","1","1","3","3","0","0","1120","1120","2","1","0","0","Flat","","0","","","0","1","4","","1120","","","2023-09-25 18:21:38","2023-09-25 18:21:38","");
INSERT INTO sales VALUES("164","posr-20230925-032832","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-25 18:28:32","2023-09-25 18:28:32","");
INSERT INTO sales VALUES("165","posr-20230925-042017","2","2","","","1","1","1","5","5","0","0","2460","2460","2","1","0","0","Flat","","0","","","0","1","4","","2460","","","2023-09-25 19:20:17","2023-09-25 19:20:17","");
INSERT INTO sales VALUES("166","posr-20230925-044242","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-25 19:42:42","2023-09-25 19:42:42","");
INSERT INTO sales VALUES("167","posr-20230925-045913","2","2","","","1","1","1","1","1","0","0","505","505","2","1","0","0","Flat","","0","","","0","1","4","","505","","","2023-09-25 19:59:13","2023-09-25 19:59:13","");
INSERT INTO sales VALUES("168","posr-20230925-050653","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-09-25 20:06:53","2023-09-25 20:06:53","");
INSERT INTO sales VALUES("169","posr-20230925-060027","2","2","","","1","1","1","1","1","0","0","495","495","2","1","0","0","Flat","","0","","","0","1","4","","495","","","2023-09-25 21:00:27","2023-09-25 21:00:27","");
INSERT INTO sales VALUES("170","posr-20230926-084908","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 11:49:08","2023-09-26 11:49:08","");
INSERT INTO sales VALUES("171","BM-20230926-0001","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 12:23:50","2023-09-26 12:23:50","");
INSERT INTO sales VALUES("172","BM-20230926-0002","2","2","","","1","1","1","2","2","0","0","896","896","2","1","0","0","Flat","","0","","","0","1","4","","896","","","2023-09-26 13:13:26","2023-09-26 13:13:26","");
INSERT INTO sales VALUES("173","BM-20230926-0003","2","2","","","1","1","1","3","8","0","0","3620","3620","2","1","0","0","Flat","","0","","","0","1","4","","3620","","","2023-09-26 19:41:30","2023-09-26 19:41:30","");
INSERT INTO sales VALUES("174","BM-20230926-0004","2","2","","","1","1","1","1","3","0","0","225","225","2","1","0","0","Flat","","0","","","0","1","4","","225","","","2023-09-26 19:43:33","2023-09-26 19:43:33","");
INSERT INTO sales VALUES("175","BM-20230926-0005","2","2","","","1","1","1","4","5","0","0","5240","5240","2","1","0","0","Flat","","0","","","0","1","4","","5240","","","2023-09-26 19:47:20","2023-09-26 19:47:20","");
INSERT INTO sales VALUES("176","BM-20230926-0006","2","2","","","1","1","1","1","1","0","0","265","265","2","1","0","0","Flat","","0","","","0","1","4","","265","","","2023-09-26 19:49:43","2023-09-26 19:49:43","");
INSERT INTO sales VALUES("177","BM-20230926-0007","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 19:51:07","2023-09-26 19:51:07","");
INSERT INTO sales VALUES("178","BM-20230926-0008","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 19:52:26","2023-09-26 19:52:26","");
INSERT INTO sales VALUES("179","BM-20230926-0009","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 19:53:46","2023-09-26 19:53:46","");
INSERT INTO sales VALUES("180","BM-20230926-0010","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 19:54:58","2023-09-26 19:54:58","");
INSERT INTO sales VALUES("181","BM-20230926-0011","2","2","","","1","1","1","5","5","0","0","2460","2460","2","1","0","0","Flat","","0","","","0","1","4","","2460","","","2023-09-26 20:38:56","2023-09-26 20:38:56","");
INSERT INTO sales VALUES("182","BM-20230926-0012","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-26 21:20:31","2023-09-26 21:20:31","");
INSERT INTO sales VALUES("183","BM-20230927-0013","2","2","","","1","1","1","4","4","0","0","1780","1780","2","1","0","0","Flat","","0","","","0","1","4","","1780","","","2023-09-27 14:30:31","2023-09-27 14:30:31","");
INSERT INTO sales VALUES("184","BM-20230927-0014","2","2","","","1","1","1","4","4","0","0","1800","1800","2","1","0","0","Flat","","0","","","0","1","4","","1800","","","2023-09-27 16:07:55","2023-09-27 16:07:55","");
INSERT INTO sales VALUES("185","BM-20230927-0015","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-27 16:41:47","2023-09-27 16:41:47","");
INSERT INTO sales VALUES("186","BM-20230927-0016","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-27 17:32:10","2023-09-27 17:32:10","");
INSERT INTO sales VALUES("187","BM-20230927-0017","2","2","","","1","1","1","5","5","0","0","2460","2460","2","1","0","0","Flat","","0","","","0","1","4","","2460","","","2023-09-27 18:13:45","2023-09-27 18:13:45","");
INSERT INTO sales VALUES("188","BM-20230927-0018","2","2","","","1","1","1","1","1","0","0","270","270","2","1","0","0","Flat","","0","","","0","1","4","","270","","","2023-09-27 18:29:56","2023-09-27 18:29:56","");
INSERT INTO sales VALUES("189","BM-20230927-0019","2","2","","","1","1","1","3","3","0","0","1225","1225","2","1","0","0","Flat","","0","","","0","1","4","","1225","","","2023-09-27 19:17:04","2023-09-27 19:17:04","");
INSERT INTO sales VALUES("190","BM-20230927-0020","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-27 19:21:18","2023-09-27 19:21:18","");
INSERT INTO sales VALUES("191","BM-20230927-0021","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-27 19:25:24","2023-09-27 19:25:24","");
INSERT INTO sales VALUES("192","BM-20230927-0022","2","2","","","1","1","1","4","4","0","0","2910","2910","2","1","0","0","Flat","","0","","","0","1","4","","2910","","","2023-09-27 19:37:03","2023-09-27 19:37:03","");
INSERT INTO sales VALUES("193","BM-20230927-0023","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-09-27 20:09:36","2023-09-27 20:09:36","");
INSERT INTO sales VALUES("194","BM-20230927-0024","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-27 21:23:57","2023-09-27 21:23:57","");
INSERT INTO sales VALUES("195","BM-20230927-0025","2","2","","","1","1","1","1","1","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-09-27 21:34:52","2023-09-27 21:34:52","");
INSERT INTO sales VALUES("196","BM-20230928-0026","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-09-28 14:33:27","2023-09-28 14:33:27","");
INSERT INTO sales VALUES("197","BM-20230928-0027","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-28 15:49:58","2023-09-28 15:49:58","");
INSERT INTO sales VALUES("198","BM-20230928-0028","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-28 17:34:34","2023-09-28 17:34:34","");
INSERT INTO sales VALUES("199","BM-20230928-0029","2","2","","","1","1","1","3","3","0","0","1555","1555","2","1","0","0","Flat","","0","","","0","1","4","","1555","","","2023-09-28 18:22:17","2023-09-28 18:22:17","");
INSERT INTO sales VALUES("200","BM-20230929-0030","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 11:42:39","2023-09-29 11:42:39","");
INSERT INTO sales VALUES("201","BM-20230929-0031","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 12:12:46","2023-09-29 12:12:46","");
INSERT INTO sales VALUES("202","BM-20230929-0032","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 13:18:05","2023-09-29 13:18:05","");
INSERT INTO sales VALUES("203","BM-20230929-0033","2","2","","","1","1","1","2","2","0","0","1110","1110","2","1","0","0","Flat","","0","","","0","1","4","","1110","","","2023-09-29 14:46:36","2023-09-29 14:46:36","");
INSERT INTO sales VALUES("204","BM-20230929-0034","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 16:29:19","2023-09-29 16:29:19","");
INSERT INTO sales VALUES("205","BM-20230929-0035","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 16:30:20","2023-09-29 16:30:20","");
INSERT INTO sales VALUES("206","BM-20230929-0036","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 17:19:01","2023-09-29 17:19:01","");
INSERT INTO sales VALUES("207","BM-20230929-0037","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-29 19:53:30","2023-09-29 19:53:30","");
INSERT INTO sales VALUES("208","BM-20230929-0038","2","2","","","1","1","1","1","1","0","0","430","430","2","1","0","0","Flat","","0","","","0","1","4","","430","","","2023-09-29 20:58:53","2023-09-29 20:58:53","");
INSERT INTO sales VALUES("209","BM-20230930-0039","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 11:36:39","2023-09-30 11:36:39","");
INSERT INTO sales VALUES("210","BM-20230930-0040","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 11:38:51","2023-09-30 11:38:51","");
INSERT INTO sales VALUES("211","BM-20230930-0041","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 12:29:40","2023-09-30 12:29:40","");
INSERT INTO sales VALUES("212","BM-20230930-0042","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 12:46:29","2023-09-30 12:46:29","");
INSERT INTO sales VALUES("213","BM-20230930-0043","2","2","","","1","1","1","4","9","0","0","3925","3925","2","1","0","0","Flat","","0","","","0","1","4","","3925","","","2023-09-30 15:00:42","2023-09-30 15:00:42","");
INSERT INTO sales VALUES("214","BM-20230930-0044","2","2","","","1","1","1","1","2","0","0","960","960","2","1","0","0","Flat","","0","","","0","1","4","","960","","","2023-09-30 15:04:58","2023-09-30 15:04:58","");
INSERT INTO sales VALUES("215","BM-20230930-0045","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 15:06:50","2023-09-30 15:06:50","");
INSERT INTO sales VALUES("216","BM-20230930-0046","2","2","","","1","1","1","1","1","0","0","2070","2070","2","1","0","0","Flat","","0","","","0","1","4","","2070","","","2023-09-30 15:07:40","2023-09-30 15:07:40","");
INSERT INTO sales VALUES("217","BM-20230930-0047","2","2","","","1","1","1","9","11","0","0","5780","5780","2","1","0","0","Flat","","0","","","0","1","4","","5780","","","2023-09-30 15:11:33","2023-09-30 15:11:33","");
INSERT INTO sales VALUES("218","BM-20230930-0048","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 15:34:50","2023-09-30 15:34:50","");
INSERT INTO sales VALUES("219","BM-20230930-0049","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-09-30 16:01:23","2023-09-30 16:01:23","");
INSERT INTO sales VALUES("220","BM-20230930-0050","2","2","","","1","1","1","1","2","0","0","960","960","2","1","0","0","Flat","","0","","","0","1","4","","960","","","2023-09-30 18:30:31","2023-09-30 18:30:31","");
INSERT INTO sales VALUES("221","BM-20230930-0051","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 18:35:57","2023-09-30 18:35:57","");
INSERT INTO sales VALUES("222","BM-20230930-0052","2","2","","","1","1","1","6","6","0","0","3185","3185","2","1","0","0","Flat","","0","","","0","1","4","","3185","","","2023-09-30 18:51:34","2023-09-30 18:51:34","");
INSERT INTO sales VALUES("223","BM-20230930-0053","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 19:35:15","2023-09-30 19:35:15","");
INSERT INTO sales VALUES("224","BM-20230930-0054","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 19:43:53","2023-09-30 19:43:53","");
INSERT INTO sales VALUES("225","BM-20230930-0055","2","2","","","1","1","1","4","4","0","0","1655","1655","2","1","0","0","Flat","","0","","","0","1","4","","1655","","","2023-09-30 19:50:00","2023-09-30 19:50:00","");
INSERT INTO sales VALUES("226","BM-20230930-0056","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-09-30 20:59:37","2023-09-30 20:59:37","");
INSERT INTO sales VALUES("227","BM-20231001-0057","2","2","","","1","1","1","6","6","0","0","4335","4335","2","1","0","0","Flat","","0","","","0","1","4","","4335","","","2023-10-01 13:31:56","2023-10-01 13:31:56","");
INSERT INTO sales VALUES("228","BM-20231001-0058","2","2","","","1","1","1","1","1","0","0","570","570","2","1","0","0","Flat","","0","","","0","1","4","","570","","","2023-10-01 13:38:48","2023-10-01 13:38:48","");
INSERT INTO sales VALUES("229","BM-20231001-0059","2","2","","","1","1","1","1","1","0","0","225","225","2","1","0","0","Flat","","0","","","0","1","4","","225","","","2023-10-01 13:43:24","2023-10-01 13:43:24","");
INSERT INTO sales VALUES("230","BM-20231001-0060","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 14:05:50","2023-10-01 14:05:50","");
INSERT INTO sales VALUES("231","BM-20231001-0061","2","2","","","1","1","1","1","1","0","0","225","225","2","1","0","0","Flat","","0","","","0","1","4","","225","","","2023-10-01 15:18:59","2023-10-01 15:18:59","");
INSERT INTO sales VALUES("232","BM-20231001-0062","2","2","","","1","1","1","1","1","0","0","505","505","2","1","0","0","Flat","","0","","","0","1","4","","505","","","2023-10-01 15:28:50","2023-10-01 15:28:50","");
INSERT INTO sales VALUES("233","BM-20231001-0063","2","2","","","1","1","1","5","6","0","0","2970","2970","2","1","0","0","Flat","","0","","","0","1","4","","2970","","","2023-10-01 15:38:58","2023-10-01 15:38:58","");
INSERT INTO sales VALUES("234","BM-20231001-0064","2","2","","","1","1","1","1","1","0","0","216","216","2","1","0","0","Flat","","0","","","0","1","4","","216","","","2023-10-01 15:49:22","2023-10-01 15:49:22","");
INSERT INTO sales VALUES("235","BM-20231001-0065","2","2","","","1","1","1","2","2","0","0","875","875","2","1","0","0","Flat","","0","","","0","1","4","","875","","","2023-10-01 17:14:28","2023-10-01 17:14:28","");
INSERT INTO sales VALUES("236","BM-20231001-0066","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 17:49:17","2023-10-01 17:49:17","");
INSERT INTO sales VALUES("237","BM-20231001-0067","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 18:15:06","2023-10-01 18:15:06","");
INSERT INTO sales VALUES("238","BM-20231001-0068","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 18:46:07","2023-10-01 18:46:07","");
INSERT INTO sales VALUES("239","BM-20231001-0069","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-01 20:23:37","2023-10-01 20:23:37","");
INSERT INTO sales VALUES("240","BM-20231001-0070","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 21:01:04","2023-10-01 21:01:04","");
INSERT INTO sales VALUES("241","BM-20231001-0071","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-01 21:01:59","2023-10-01 21:01:59","");
INSERT INTO sales VALUES("242","BM-20231001-0072","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-01 21:13:19","2023-10-01 21:13:19","");
INSERT INTO sales VALUES("243","BM-20231001-0073","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-01 21:14:34","2023-10-01 21:14:34","");
INSERT INTO sales VALUES("244","BM-20231001-0074","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-10-01 21:23:05","2023-10-01 21:23:05","");
INSERT INTO sales VALUES("245","BM-20231001-0075","2","2","","","1","1","1","2","2","0","0","1160","1160","2","1","0","0","Flat","","0","","","0","1","4","","1160","","","2023-10-01 21:47:24","2023-10-01 21:47:24","");
INSERT INTO sales VALUES("246","BM-20231002-0076","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 11:51:28","2023-10-02 11:51:28","");
INSERT INTO sales VALUES("247","BM-20231002-0077","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 12:08:26","2023-10-02 12:08:26","");
INSERT INTO sales VALUES("248","BM-20231002-0078","2","2","","","1","1","1","2","2","0","0","2000","2000","2","1","0","0","Flat","","0","","","0","1","4","","2000","","","2023-10-02 12:18:37","2023-10-02 12:18:37","");
INSERT INTO sales VALUES("249","BM-20231002-0079","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 12:32:53","2023-10-02 12:32:53","");
INSERT INTO sales VALUES("250","BM-20231002-0080","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-10-02 13:22:13","2023-10-02 13:22:13","");
INSERT INTO sales VALUES("251","BM-20231002-0081","2","2","","","1","1","1","1","1","0","0","100","100","2","1","0","0","Flat","","0","","","0","1","4","","100","","","2023-10-02 13:49:33","2023-10-02 13:49:33","");
INSERT INTO sales VALUES("252","BM-20231002-0082","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-02 14:10:53","2023-10-02 14:10:53","");
INSERT INTO sales VALUES("253","BM-20231002-0083","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 14:11:44","2023-10-02 14:11:44","");
INSERT INTO sales VALUES("254","BM-20231002-0084","2","2","","","1","1","1","2","2","0","0","896","896","2","1","0","0","Flat","","0","","","0","1","4","","896","","","2023-10-02 17:51:53","2023-10-02 17:51:53","");
INSERT INTO sales VALUES("255","BM-20231002-0085","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 19:14:15","2023-10-02 19:14:15","");
INSERT INTO sales VALUES("256","BM-20231002-0086","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 19:20:16","2023-10-02 19:20:16","");
INSERT INTO sales VALUES("257","BM-20231002-0087","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-02 19:57:50","2023-10-02 19:57:50","");
INSERT INTO sales VALUES("258","BM-20231002-0088","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-02 20:03:42","2023-10-02 20:03:42","");
INSERT INTO sales VALUES("259","BM-20231002-0089","2","2","","","1","1","1","1","1","0","0","85","85","2","1","0","0","Flat","","0","","","0","1","4","","85","","","2023-10-02 20:51:30","2023-10-02 20:51:30","");
INSERT INTO sales VALUES("260","BM-20231003-0090","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 11:19:11","2023-10-03 11:19:11","");
INSERT INTO sales VALUES("261","BM-20231003-0091","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 11:19:39","2023-10-03 11:19:39","");
INSERT INTO sales VALUES("262","BM-20231003-0092","2","2","","","1","1","1","1","1","0","0","470","470","2","1","0","0","Flat","","0","","","0","1","4","","470","","","2023-10-03 12:08:43","2023-10-03 12:08:43","");
INSERT INTO sales VALUES("263","BM-20231003-0093","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:04:13","2023-10-03 13:04:13","");
INSERT INTO sales VALUES("264","BM-20231003-0094","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:10:52","2023-10-03 13:10:52","");
INSERT INTO sales VALUES("265","BM-20231003-0095","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:17:24","2023-10-03 13:17:24","");
INSERT INTO sales VALUES("266","BM-20231003-0096","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:32:50","2023-10-03 13:32:50","");
INSERT INTO sales VALUES("267","BM-20231003-0097","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:33:11","2023-10-03 13:33:11","");
INSERT INTO sales VALUES("268","BM-20231003-0098","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 13:50:57","2023-10-03 13:50:57","");
INSERT INTO sales VALUES("269","BM-20231003-0099","2","2","","","1","1","1","1","1","0","0","570","570","2","1","0","0","Flat","","0","","","0","1","4","","570","","","2023-10-03 15:58:49","2023-10-03 15:58:49","");
INSERT INTO sales VALUES("270","BM-20231003-0100","2","2","","","1","1","1","1","2","0","0","1180","1180","2","1","0","0","Flat","","0","","","0","1","4","","1180","","","2023-10-03 16:20:20","2023-10-03 16:20:20","");
INSERT INTO sales VALUES("271","BM-20231003-0101","2","2","","","1","1","1","4","6","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-03 18:55:04","2023-10-03 18:55:04","");
INSERT INTO sales VALUES("272","BM-20231003-0102","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 19:57:07","2023-10-03 19:57:07","");
INSERT INTO sales VALUES("273","BM-20231003-0103","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 21:05:44","2023-10-03 21:05:44","");
INSERT INTO sales VALUES("274","BM-20231003-0104","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-03 21:38:17","2023-10-03 21:38:17","");
INSERT INTO sales VALUES("275","BM-20231004-0105","2","2","","","1","1","1","1","1","0","0","1040","1040","2","1","0","0","Flat","","0","","","0","1","4","","1040","","","2023-10-04 11:33:21","2023-10-04 11:33:21","");
INSERT INTO sales VALUES("276","BM-20231004-0106","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 12:04:48","2023-10-04 12:04:48","");
INSERT INTO sales VALUES("277","BM-20231004-0107","2","2","","","1","1","1","2","2","0","0","1270","1270","2","1","0","0","Flat","","0","","","0","1","4","","1270","","","2023-10-04 12:30:17","2023-10-04 12:30:17","");
INSERT INTO sales VALUES("278","BM-20231004-0108","2","2","","","1","1","1","1","1","0","0","216","216","2","1","0","0","Flat","","0","","","0","1","4","","216","","","2023-10-04 12:32:08","2023-10-04 12:32:08","");
INSERT INTO sales VALUES("279","BM-20231004-0109","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 12:49:56","2023-10-04 12:49:56","");
INSERT INTO sales VALUES("280","BM-20231004-0110","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 13:40:44","2023-10-04 13:40:44","");
INSERT INTO sales VALUES("281","BM-20231004-0111","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-10-04 13:58:25","2023-10-04 13:58:25","");
INSERT INTO sales VALUES("282","BM-20231004-0112","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 15:13:08","2023-10-04 15:13:08","");
INSERT INTO sales VALUES("283","BM-20231004-0113","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 16:44:17","2023-10-04 16:44:17","");
INSERT INTO sales VALUES("284","BM-20231004-0114","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 16:59:19","2023-10-04 16:59:19","");
INSERT INTO sales VALUES("285","BM-20231004-0115","2","2","","","1","1","1","2","2","0","0","880","880","2","1","0","0","Flat","","0","","","0","1","4","","880","","","2023-10-04 17:36:17","2023-10-04 17:36:17","");
INSERT INTO sales VALUES("286","BM-20231004-0116","2","2","","","1","1","1","5","10","0","0","4605","4605","2","1","0","0","Flat","","0","","","0","1","4","","4605","","","2023-10-04 18:03:07","2023-10-04 18:03:07","");
INSERT INTO sales VALUES("287","BM-20231004-0117","2","2","","","1","1","1","1","1","0","0","3295","3295","2","1","0","0","Flat","","0","","","0","1","4","","3295","","","2023-10-04 18:08:44","2023-10-04 18:08:44","");
INSERT INTO sales VALUES("288","BM-20231004-0118","2","2","","","1","1","1","2","2","0","0","565","565","2","1","0","0","Flat","","0","","","0","1","4","","565","","","2023-10-04 18:38:29","2023-10-04 18:38:29","");
INSERT INTO sales VALUES("289","BM-20231004-0119","2","2","","","1","1","1","1","1","0","0","295","295","2","1","0","0","Flat","","0","","","0","1","4","","295","","","2023-10-04 18:44:21","2023-10-04 18:44:21","");
INSERT INTO sales VALUES("290","BM-20231004-0120","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 19:04:01","2023-10-04 19:04:01","");
INSERT INTO sales VALUES("291","BM-20231004-0121","2","2","","","1","1","1","1","1","0","0","100","100","2","1","0","0","Flat","","0","","","0","1","4","","100","","","2023-10-04 20:58:11","2023-10-04 20:58:11","");
INSERT INTO sales VALUES("292","BM-20231004-0122","2","2","","","1","1","1","1","1","0","0","570","570","2","1","0","0","Flat","","0","","","0","1","4","","570","","","2023-10-04 21:04:56","2023-10-04 21:04:56","");
INSERT INTO sales VALUES("293","BM-20231004-0123","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-10-04 21:11:15","2023-10-04 21:11:15","");
INSERT INTO sales VALUES("294","BM-20231004-0124","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-04 21:13:14","2023-10-04 21:13:14","");
INSERT INTO sales VALUES("295","BM-20231004-0125","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-04 21:15:45","2023-10-04 21:15:45","");
INSERT INTO sales VALUES("296","BM-20231005-0126","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-05 12:57:28","2023-10-05 12:57:28","");
INSERT INTO sales VALUES("297","BM-20231005-0127","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-05 19:44:56","2023-10-05 19:44:56","");
INSERT INTO sales VALUES("298","BM-20231005-0128","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-05 19:46:33","2023-10-05 19:46:33","");
INSERT INTO sales VALUES("299","BM-20231005-0129","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-05 20:47:43","2023-10-05 20:47:43","");
INSERT INTO sales VALUES("300","BM-20231005-0130","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-05 20:49:54","2023-10-05 20:49:54","");
INSERT INTO sales VALUES("301","BM-20231005-0131","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-05 20:50:39","2023-10-05 20:50:39","");
INSERT INTO sales VALUES("302","BM-20231006-0132","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-06 12:10:26","2023-10-06 12:10:26","");
INSERT INTO sales VALUES("303","BM-20231006-0133","2","2","","","1","1","1","1","1","0","0","216","216","2","1","0","0","Flat","","0","","","0","1","4","","216","","","2023-10-06 12:47:32","2023-10-06 12:47:32","");
INSERT INTO sales VALUES("304","BM-20231006-0134","2","2","","","1","1","1","1","2","0","0","150","150","2","1","0","0","Flat","","0","","","0","1","4","","150","","","2023-10-06 12:52:40","2023-10-06 12:52:40","");
INSERT INTO sales VALUES("305","BM-20231006-0135","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-06 14:35:52","2023-10-06 14:35:52","");
INSERT INTO sales VALUES("306","BM-20231006-0136","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-06 18:11:12","2023-10-06 18:11:12","");
INSERT INTO sales VALUES("307","BM-20231006-0137","2","2","","","1","1","1","1","1","0","0","570","570","2","1","0","0","Flat","","0","","","0","1","4","","570","","","2023-10-06 18:16:29","2023-10-06 18:16:29","");
INSERT INTO sales VALUES("308","BM-20231006-0138","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-06 19:19:11","2023-10-06 19:19:11","");
INSERT INTO sales VALUES("309","BM-20231006-0139","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-06 19:24:38","2023-10-06 19:24:38","");
INSERT INTO sales VALUES("310","BM-20231006-0140","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-06 19:50:15","2023-10-06 19:50:15","");
INSERT INTO sales VALUES("311","BM-20231006-0141","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-10-06 20:04:41","2023-10-06 20:04:41","");
INSERT INTO sales VALUES("312","BM-20231006-0142","2","2","","","1","1","1","1","2","0","0","860","860","2","1","0","0","Flat","","0","","","0","1","4","","860","","","2023-10-06 20:56:18","2023-10-06 20:56:18","");
INSERT INTO sales VALUES("313","BM-20231006-0143","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-06 21:01:45","2023-10-06 21:01:45","");
INSERT INTO sales VALUES("314","BM-20231006-0144","2","2","","","1","1","1","2","2","0","0","2590","2590","2","1","0","0","Flat","","0","","","0","1","4","","2590","","","2023-10-06 21:37:25","2023-10-06 21:37:25","");
INSERT INTO sales VALUES("315","BM-20231006-0145","2","2","","","1","1","1","1","1","0","0","530","530","2","1","0","0","Flat","","0","","","0","1","4","","530","","","2023-10-06 21:48:58","2023-10-06 21:48:58","");
INSERT INTO sales VALUES("316","BM-20231007-0146","2","2","","","1","1","1","1","1","0","0","290","290","2","1","0","0","Flat","","0","","","0","1","4","","290","","","2023-10-07 14:06:07","2023-10-07 14:06:07","");
INSERT INTO sales VALUES("317","BM-20231007-0147","2","2","","","1","1","1","1","2","0","0","1020","1020","2","1","0","0","Flat","","0","","","0","1","4","","1020","","","2023-10-07 14:26:59","2023-10-07 14:26:59","");
INSERT INTO sales VALUES("318","BM-20231007-0148","2","2","","","1","1","1","1","1","0","0","45","45","2","1","0","0","Flat","","0","","","0","1","4","","45","","","2023-10-07 14:38:37","2023-10-07 14:38:37","");
INSERT INTO sales VALUES("319","BM-20231007-0149","2","2","","","1","1","1","1","2","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-07 14:39:27","2023-10-07 14:39:27","");
INSERT INTO sales VALUES("320","BM-20231007-0150","2","2","","","1","1","1","1","1","0","0","430","430","2","1","0","0","Flat","","0","","","0","1","4","","430","","","2023-10-07 14:43:44","2023-10-07 14:43:44","");
INSERT INTO sales VALUES("321","BM-20231007-0151","2","2","","","1","1","1","1","1","0","0","0","0","2","1","0","0","Flat","","0","","","0","1","4","","0","","","2023-10-07 14:49:46","2023-10-07 14:49:46","");
INSERT INTO sales VALUES("322","BM-20231007-0152","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-07 16:58:41","2023-10-07 16:58:41","");
INSERT INTO sales VALUES("323","BM-20231007-0153","2","2","","","1","1","1","1","2","0","0","180","180","2","1","0","0","Flat","","0","","","0","1","4","","180","","","2023-10-07 17:25:39","2023-10-07 17:25:39","");
INSERT INTO sales VALUES("324","BM-20231007-0154","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-07 17:42:19","2023-10-07 17:42:19","");
INSERT INTO sales VALUES("325","BM-20231007-0155","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-07 17:44:16","2023-10-07 17:44:16","");
INSERT INTO sales VALUES("326","BM-20231007-0156","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-07 18:01:44","2023-10-07 18:01:44","");
INSERT INTO sales VALUES("327","BM-20231007-0157","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-07 20:13:26","2023-10-07 20:13:26","");
INSERT INTO sales VALUES("328","BM-20231007-0158","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-07 20:47:39","2023-10-07 20:47:39","");
INSERT INTO sales VALUES("329","BM-20231008-0159","2","2","","","1","1","1","4","6","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-08 15:23:18","2023-10-08 15:23:18","");
INSERT INTO sales VALUES("330","BM-20231008-0160","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-08 15:24:53","2023-10-08 15:24:53","");
INSERT INTO sales VALUES("331","BM-20231008-0161","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-08 15:27:23","2023-10-08 15:27:23","");
INSERT INTO sales VALUES("332","BM-20231008-0162","2","2","","","1","1","1","1","2","0","0","1130","1130","2","1","0","0","Flat","","0","","","0","1","4","","1130","","","2023-10-08 15:34:04","2023-10-08 15:34:04","");
INSERT INTO sales VALUES("333","BM-20231008-0163","2","2","","","1","1","1","2","2","0","0","835","835","2","1","0","0","Flat","","0","","","0","1","4","","835","","","2023-10-08 15:51:58","2023-10-08 15:51:58","");
INSERT INTO sales VALUES("334","BM-20231008-0164","2","2","","","1","1","1","1","1","0","0","216","216","2","1","0","0","Flat","","0","","","0","1","4","","216","","","2023-10-08 16:34:31","2023-10-08 16:34:31","");
INSERT INTO sales VALUES("335","BM-20231008-0165","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-08 16:35:34","2023-10-08 16:35:34","");
INSERT INTO sales VALUES("336","BM-20231008-0166","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-08 16:56:29","2023-10-08 16:56:29","");
INSERT INTO sales VALUES("337","BM-20231008-0167","2","2","","","1","1","1","2","2","0","0","1335","1335","2","1","0","0","Flat","","0","","","0","1","4","","1335","","","2023-10-08 18:18:11","2023-10-08 18:18:11","");
INSERT INTO sales VALUES("338","BM-20231008-0168","2","2","","","1","1","1","1","1","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-10-08 19:03:11","2023-10-08 19:03:11","");
INSERT INTO sales VALUES("339","BM-20231008-0169","2","2","","","1","1","1","1","1","0","0","375","375","2","1","0","0","Flat","","0","","","0","1","4","","375","","","2023-10-08 19:09:29","2023-10-08 19:09:29","");
INSERT INTO sales VALUES("340","BM-20231009-0170","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 12:35:03","2023-10-09 12:35:03","");
INSERT INTO sales VALUES("341","BM-20231009-0171","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 12:36:21","2023-10-09 12:36:21","");
INSERT INTO sales VALUES("342","BM-20231009-0172","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 13:28:44","2023-10-09 13:28:44","");
INSERT INTO sales VALUES("343","BM-20231009-0173","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 14:24:35","2023-10-09 14:24:35","");
INSERT INTO sales VALUES("344","BM-20231009-0174","2","2","","","1","1","1","1","1","0","0","510","510","2","1","0","0","Flat","","0","","","0","1","4","","510","","","2023-10-09 14:52:36","2023-10-09 14:52:36","");
INSERT INTO sales VALUES("345","BM-20231009-0175","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 14:56:27","2023-10-09 14:56:27","");
INSERT INTO sales VALUES("346","BM-20231009-0176","2","2","","","1","1","1","1","2","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-09 15:11:21","2023-10-09 15:11:21","");
INSERT INTO sales VALUES("347","BM-20231009-0177","2","2","","","1","1","1","1","2","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-09 15:11:21","2023-10-09 15:11:21","");
INSERT INTO sales VALUES("348","BM-20231009-0178","2","2","","","1","1","1","1","3","0","0","30","30","2","1","0","0","Flat","","0","","","0","1","4","","30","","","2023-10-09 15:16:26","2023-10-09 15:16:26","");
INSERT INTO sales VALUES("349","BM-20231009-0179","2","2","","","1","1","1","1","2","0","0","40","40","2","1","0","0","Flat","","0","","","0","1","4","","40","","","2023-10-09 15:33:02","2023-10-09 15:33:02","");
INSERT INTO sales VALUES("350","BM-20231009-0180","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 17:21:02","2023-10-09 17:21:02","");
INSERT INTO sales VALUES("351","BM-20231009-0181","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 17:49:59","2023-10-09 17:49:59","");
INSERT INTO sales VALUES("352","BM-20231009-0182","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 17:49:59","2023-10-09 17:49:59","");
INSERT INTO sales VALUES("353","BM-20231009-0183","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 18:04:54","2023-10-09 18:04:54","");
INSERT INTO sales VALUES("354","BM-20231009-0184","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-09 19:00:13","2023-10-09 19:00:13","");
INSERT INTO sales VALUES("355","BM-20231009-0185","2","2","","","1","1","1","4","4","0","0","1655","1655","2","1","0","0","Flat","","0","","","0","1","4","","1655","","","2023-10-09 19:41:05","2023-10-09 19:41:05","");
INSERT INTO sales VALUES("356","BM-20231009-0186","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 20:34:46","2023-10-09 20:34:46","");
INSERT INTO sales VALUES("357","BM-20231009-0187","2","2","","","1","1","1","1","1","0","0","50","50","2","1","0","0","Flat","","0","","","0","1","4","","50","","","2023-10-09 20:36:41","2023-10-09 20:36:41","");
INSERT INTO sales VALUES("358","BM-20231009-0188","2","2","","","1","1","1","1","1","0","0","430","430","2","1","0","0","Flat","","0","","","0","1","4","","430","","","2023-10-09 20:59:39","2023-10-09 20:59:39","");
INSERT INTO sales VALUES("359","BM-20231009-0189","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 21:09:54","2023-10-09 21:09:54","");
INSERT INTO sales VALUES("360","BM-20231009-0190","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-09 21:09:55","2023-10-09 21:09:55","");
INSERT INTO sales VALUES("361","BM-20231010-0191","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-10 11:50:09","2023-10-10 11:50:09","");
INSERT INTO sales VALUES("362","BM-20231010-0192","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 12:16:35","2023-10-10 12:16:35","");
INSERT INTO sales VALUES("363","BM-20231010-0193","2","2","","","1","1","1","1","1","0","0","745","745","2","1","0","0","Flat","","0","","","0","1","4","","745","","","2023-10-10 12:44:27","2023-10-10 12:44:27","");
INSERT INTO sales VALUES("364","BM-20231010-0194","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 14:58:00","2023-10-10 14:58:00","");
INSERT INTO sales VALUES("365","BM-20231010-0195","2","2","","","1","1","1","1","1","0","0","445","445","2","1","0","0","Flat","","0","","","0","1","4","","445","","","2023-10-10 14:58:20","2023-10-10 14:58:20","");
INSERT INTO sales VALUES("366","BM-20231010-0196","2","2","","","1","1","1","1","2","0","0","960","960","2","1","0","0","Flat","","0","","","0","1","4","","960","","","2023-10-10 15:26:25","2023-10-10 15:26:25","");
INSERT INTO sales VALUES("367","BM-20231010-0197","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-10 15:55:35","2023-10-10 15:55:35","");
INSERT INTO sales VALUES("368","BM-20231010-0198","2","2","","","1","1","1","1","1","0","0","960","960","2","1","0","0","Flat","","0","","","0","1","4","","960","","","2023-10-10 17:34:14","2023-10-10 17:34:14","");
INSERT INTO sales VALUES("369","BM-20231010-0199","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 17:42:48","2023-10-10 17:42:48","");
INSERT INTO sales VALUES("370","BM-20231010-0200","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 17:45:57","2023-10-10 17:45:57","");
INSERT INTO sales VALUES("371","BM-20231010-0201","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 19:18:44","2023-10-10 19:18:44","");
INSERT INTO sales VALUES("372","BM-20231010-0202","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 20:19:33","2023-10-10 20:19:33","");
INSERT INTO sales VALUES("373","BM-20231010-0203","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 20:24:23","2023-10-10 20:24:23","");
INSERT INTO sales VALUES("374","BM-20231010-0204","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-10 20:36:13","2023-10-10 20:36:13","");
INSERT INTO sales VALUES("375","BM-20231011-0205","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-11 12:13:25","2023-10-11 12:13:25","");
INSERT INTO sales VALUES("376","BM-20231011-0206","2","2","","","1","1","1","1","1","0","0","480","480","2","1","0","0","Flat","","0","","","0","1","4","","480","","","2023-10-11 14:05:15","2023-10-11 14:05:15","");
INSERT INTO sales VALUES("377","BM-20231011-0207","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-11 14:05:46","2023-10-11 14:05:46","");
INSERT INTO sales VALUES("378","BM-20231011-0208","2","2","","","1","1","1","4","12","0","0","8595","8595","2","1","0","0","Flat","","0","","","0","1","4","","8595","","","2023-10-11 15:43:08","2023-10-11 15:43:08","");
INSERT INTO sales VALUES("379","BM-20231011-0209","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-11 17:16:51","2023-10-11 17:16:51","");
INSERT INTO sales VALUES("380","BM-20231011-0210","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-11 17:59:15","2023-10-11 17:59:15","");
INSERT INTO sales VALUES("381","BM-20231011-0211","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-11 18:52:36","2023-10-11 18:52:36","");
INSERT INTO sales VALUES("382","BM-20231011-0212","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-11 20:03:48","2023-10-11 20:03:48","");
INSERT INTO sales VALUES("383","BM-20231012-0213","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-12 13:09:24","2023-10-12 13:09:24","");
INSERT INTO sales VALUES("384","BM-20231012-0214","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-12 13:45:56","2023-10-12 13:45:56","");
INSERT INTO sales VALUES("385","BM-20231012-0215","2","2","","","1","1","1","5","6","0","0","4435","4435","2","1","0","0","Flat","","0","","","0","1","4","","4435","","","2023-10-12 16:54:33","2023-10-12 16:54:33","");
INSERT INTO sales VALUES("386","BM-20231012-0216","2","2","","","1","1","1","1","1","0","0","360","360","2","1","0","0","Flat","","0","","","0","1","4","","360","","","2023-10-12 17:47:40","2023-10-12 17:47:40","");
INSERT INTO sales VALUES("387","BM-20231012-0217","2","2","","","1","1","1","3","3","0","0","1205","1205","2","1","0","0","Flat","","0","","","0","1","4","","1205","","","2023-10-12 18:40:27","2023-10-12 18:40:27","");
INSERT INTO sales VALUES("388","BM-20231012-0218","2","2","","","1","1","1","1","2","0","0","930","930","2","1","0","0","Flat","","0","","","0","1","4","","930","","","2023-10-12 19:55:06","2023-10-12 19:55:06","");
INSERT INTO sales VALUES("389","BM-20231012-0219","2","2","","","1","1","1","3","4","0","0","1755","1755","2","1","0","0","Flat","","0","","","0","1","4","","1755","","","2023-10-12 19:57:22","2023-10-12 19:57:22","");
INSERT INTO sales VALUES("390","BM-20231012-0220","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-12 20:02:43","2023-10-12 20:02:43","");
INSERT INTO sales VALUES("391","BM-20231012-0221","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-12 20:32:04","2023-10-12 20:32:04","");
INSERT INTO sales VALUES("392","BM-20231012-0222","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-12 20:56:32","2023-10-12 20:56:32","");
INSERT INTO sales VALUES("393","BM-20231012-0223","2","2","","","1","1","1","2","4","0","0","850","850","2","1","0","0","Flat","","0","","","0","1","4","","850","","","2023-10-12 22:03:44","2023-10-12 22:03:44","");
INSERT INTO sales VALUES("394","BM-20231013-0224","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 11:18:16","2023-10-13 11:18:16","");
INSERT INTO sales VALUES("395","BM-20231013-0225","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 12:27:35","2023-10-13 12:27:35","");
INSERT INTO sales VALUES("396","BM-20231013-0226","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 13:37:09","2023-10-13 13:37:09","");
INSERT INTO sales VALUES("397","BM-20231013-0227","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 13:37:09","2023-10-13 13:37:09","");
INSERT INTO sales VALUES("398","BM-20231013-0228","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-13 13:42:44","2023-10-13 13:42:44","");
INSERT INTO sales VALUES("399","BM-20231013-0229","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 14:14:01","2023-10-13 14:14:01","");
INSERT INTO sales VALUES("400","BM-20231013-0230","2","2","","","1","1","1","1","2","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-13 14:20:39","2023-10-13 14:20:39","");
INSERT INTO sales VALUES("401","BM-20231013-0231","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 16:16:52","2023-10-13 16:16:52","");
INSERT INTO sales VALUES("402","BM-20231013-0232","2","2","","","1","1","1","2","3","0","0","1480","1480","2","1","0","0","Flat","","0","","","0","1","4","","1480","","","2023-10-13 17:00:54","2023-10-13 17:00:54","");
INSERT INTO sales VALUES("403","BM-20231013-0233","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 17:30:48","2023-10-13 17:30:48","");
INSERT INTO sales VALUES("404","BM-20231013-0234","2","2","","","1","1","1","5","6","0","0","4435","4435","2","1","0","0","Flat","","0","","","0","1","4","","4435","","","2023-10-13 18:34:57","2023-10-13 18:34:57","");
INSERT INTO sales VALUES("405","BM-20231013-0235","2","2","","","1","1","1","1","1","0","0","480","480","2","1","0","0","Flat","","0","","","0","1","4","","480","","","2023-10-13 19:09:18","2023-10-13 19:09:18","");
INSERT INTO sales VALUES("406","BM-20231013-0236","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 20:08:00","2023-10-13 20:08:00","");
INSERT INTO sales VALUES("407","BM-20231013-0237","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-13 20:09:42","2023-10-13 20:09:42","");
INSERT INTO sales VALUES("408","BM-20231013-0238","2","2","","","1","1","1","2","2","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-13 20:11:09","2023-10-13 20:11:09","");
INSERT INTO sales VALUES("409","BM-20231013-0239","2","2","","","1","1","1","2","3","0","0","225","225","2","1","0","0","Flat","","0","","","0","1","4","","225","","","2023-10-13 20:15:39","2023-10-13 20:15:39","");
INSERT INTO sales VALUES("410","BM-20231013-0240","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-13 20:22:56","2023-10-13 20:22:56","");
INSERT INTO sales VALUES("411","BM-20231014-0241","2","2","","","1","1","1","1","1","0","0","3635","3635","2","1","0","0","Flat","","0","","","0","1","4","","3635","","","2023-10-14 13:17:26","2023-10-14 13:17:26","");
INSERT INTO sales VALUES("412","BM-20231014-0242","2","2","","","1","1","1","1","1","0","0","215","215","2","1","0","0","Flat","","0","","","0","1","4","","215","","","2023-10-14 13:46:24","2023-10-14 13:46:24","");
INSERT INTO sales VALUES("413","BM-20231014-0243","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-14 13:47:49","2023-10-14 13:47:49","");
INSERT INTO sales VALUES("414","BM-20231014-0244","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-14 13:48:53","2023-10-14 13:48:53","");
INSERT INTO sales VALUES("415","BM-20231014-0245","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-14 19:26:29","2023-10-14 19:26:29","");
INSERT INTO sales VALUES("416","BM-20231014-0246","2","2","","","1","1","1","3","4","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-10-14 19:28:38","2023-10-14 19:28:38","");
INSERT INTO sales VALUES("417","BM-20231014-0247","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-14 20:21:45","2023-10-14 20:21:45","");
INSERT INTO sales VALUES("418","BM-20231014-0248","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-14 20:28:26","2023-10-14 20:28:26","");
INSERT INTO sales VALUES("419","BM-20231014-0249","2","2","","","1","1","1","1","3","0","0","30","30","2","1","0","0","Flat","","0","","","0","1","4","","30","","","2023-10-14 20:41:01","2023-10-14 20:41:01","");
INSERT INTO sales VALUES("420","BM-20231015-0250","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-15 13:05:10","2023-10-15 13:05:10","");
INSERT INTO sales VALUES("421","BM-20231015-0251","2","2","","","1","1","1","1","1","0","0","320","320","2","1","0","0","Flat","","0","","","0","1","4","","320","","","2023-10-15 13:42:12","2023-10-15 13:42:12","");
INSERT INTO sales VALUES("422","BM-20231015-0252","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-10-15 14:23:50","2023-10-15 14:23:50","");
INSERT INTO sales VALUES("423","BM-20231015-0253","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-15 14:24:29","2023-10-15 14:24:29","");
INSERT INTO sales VALUES("424","BM-20231015-0254","2","2","","","1","1","1","1","3","0","0","2040","2040","2","1","0","0","Flat","","0","","","0","1","4","","2040","","","2023-10-15 14:26:25","2023-10-15 14:26:25","");
INSERT INTO sales VALUES("425","BM-20231015-0255","2","2","","","1","1","1","1","1","0","0","420","420","2","1","0","0","Flat","","0","","","0","1","4","","420","","","2023-10-15 15:17:48","2023-10-15 15:17:48","");
INSERT INTO sales VALUES("426","BM-20231015-0256","2","2","","","1","1","1","1","1","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-10-15 15:25:25","2023-10-15 15:25:25","");
INSERT INTO sales VALUES("427","BM-20231015-0257","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-15 17:13:42","2023-10-15 17:13:42","");
INSERT INTO sales VALUES("428","BM-20231015-0258","2","2","","","1","1","1","3","3","0","0","1230","1230","2","1","0","0","Flat","","0","","","0","1","4","","1230","","","2023-10-15 18:24:27","2023-10-15 18:24:27","");
INSERT INTO sales VALUES("429","BM-20231015-0259","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-15 18:51:30","2023-10-15 18:51:30","");
INSERT INTO sales VALUES("430","BM-20231015-0260","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-15 19:52:34","2023-10-15 19:52:34","");
INSERT INTO sales VALUES("431","BM-20231015-0261","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-15 20:32:37","2023-10-15 20:32:37","");
INSERT INTO sales VALUES("432","BM-20231015-0262","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-15 20:34:15","2023-10-15 20:34:15","");
INSERT INTO sales VALUES("433","BM-20231015-0263","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-15 21:18:12","2023-10-15 21:18:12","");
INSERT INTO sales VALUES("434","BM-20231016-0264","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 12:43:45","2023-10-16 12:43:45","");
INSERT INTO sales VALUES("435","BM-20231016-0265","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 12:44:36","2023-10-16 12:44:36","");
INSERT INTO sales VALUES("436","BM-20231016-0266","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 12:45:35","2023-10-16 12:45:35","");
INSERT INTO sales VALUES("437","BM-20231016-0267","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-16 12:49:59","2023-10-16 12:49:59","");
INSERT INTO sales VALUES("438","BM-20231016-0268","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 15:59:40","2023-10-16 15:59:40","");
INSERT INTO sales VALUES("439","BM-20231016-0269","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-16 17:00:28","2023-10-16 17:00:28","");
INSERT INTO sales VALUES("440","BM-20231016-0270","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 17:01:42","2023-10-16 17:01:42","");
INSERT INTO sales VALUES("441","BM-20231016-0271","2","2","","","1","1","1","2","2","0","0","990","990","2","1","0","0","Flat","","0","","","0","1","4","","990","","","2023-10-16 17:02:52","2023-10-16 17:02:52","");
INSERT INTO sales VALUES("442","BM-20231016-0272","2","2","","","1","1","1","1","1","0","0","370","370","2","1","0","0","Flat","","0","","","0","1","4","","370","","","2023-10-16 18:24:02","2023-10-16 18:24:02","");
INSERT INTO sales VALUES("443","BM-20231016-0273","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-16 18:34:16","2023-10-16 18:34:16","");
INSERT INTO sales VALUES("444","BM-20231016-0274","2","2","","","1","1","1","1","1","0","0","2175","2175","2","1","0","0","Flat","","0","","","0","1","4","","2175","","","2023-10-16 18:48:20","2023-10-16 18:48:20","");
INSERT INTO sales VALUES("445","BM-20231016-0275","2","2","","","1","1","1","3","4","0","0","1515","1515","2","1","0","0","Flat","","0","","","0","1","4","","1515","","","2023-10-16 19:21:35","2023-10-16 19:21:35","");
INSERT INTO sales VALUES("446","BM-20231016-0276","2","2","","","1","1","1","2","2","0","0","770","770","2","1","0","0","Flat","","0","","","0","1","4","","770","","","2023-10-16 19:28:51","2023-10-16 19:28:51","");
INSERT INTO sales VALUES("447","BM-20231016-0277","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-16 20:01:10","2023-10-16 20:01:10","");
INSERT INTO sales VALUES("448","BM-20231016-0278","2","2","","","1","1","1","1","1","0","0","4200","4200","2","1","0","0","Flat","","0","","","0","1","4","","4200","","","2023-10-16 22:30:02","2023-10-16 22:30:02","");
INSERT INTO sales VALUES("449","BM-20231017-0279","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 12:49:35","2023-10-17 12:49:35","");
INSERT INTO sales VALUES("450","BM-20231017-0280","2","2","","","1","1","1","1","1","0","0","300","300","2","1","0","0","Flat","","0","","","0","1","4","","300","","","2023-10-17 14:28:59","2023-10-17 14:28:59","");
INSERT INTO sales VALUES("451","BM-20231017-0281","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-17 15:00:01","2023-10-17 15:00:01","");
INSERT INTO sales VALUES("452","BM-20231017-0282","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 15:08:45","2023-10-17 15:08:45","");
INSERT INTO sales VALUES("453","BM-20231017-0283","2","2","","","1","1","1","8","9","0","0","4325","4325","2","1","0","0","Flat","","0","","","0","1","4","","4325","","","2023-10-17 15:41:24","2023-10-17 15:41:24","");
INSERT INTO sales VALUES("454","BM-20231017-0284","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 16:02:31","2023-10-17 16:02:31","");
INSERT INTO sales VALUES("455","BM-20231017-0285","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-17 16:35:38","2023-10-17 16:35:38","");
INSERT INTO sales VALUES("456","BM-20231017-0286","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-17 17:31:49","2023-10-17 17:31:49","");
INSERT INTO sales VALUES("457","BM-20231017-0287","2","2","","","1","1","1","2","2","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-17 19:13:57","2023-10-17 19:13:57","");
INSERT INTO sales VALUES("458","BM-20231017-0288","2","2","","","1","1","1","4","6","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-17 20:01:16","2023-10-17 20:01:16","");
INSERT INTO sales VALUES("459","BM-20231017-0289","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 21:18:00","2023-10-17 21:18:00","");
INSERT INTO sales VALUES("460","BM-20231017-0290","2","2","","","1","1","1","1","1","0","0","1980","1980","2","1","0","0","Flat","","0","","","0","1","4","","1980","","","2023-10-17 21:19:24","2023-10-17 21:19:24","");
INSERT INTO sales VALUES("461","BM-20231017-0291","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-17 21:21:01","2023-10-17 21:21:01","");
INSERT INTO sales VALUES("462","BM-20231017-0292","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 21:22:32","2023-10-17 21:22:32","");
INSERT INTO sales VALUES("463","BM-20231017-0293","2","2","","","1","1","1","2","2","0","0","880","880","2","1","0","0","Flat","","0","","","0","1","4","","880","","","2023-10-17 21:27:45","2023-10-17 21:27:45","");
INSERT INTO sales VALUES("464","BM-20231017-0294","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-17 21:31:09","2023-10-17 21:31:09","");
INSERT INTO sales VALUES("465","BM-20231018-0295","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-18 12:37:21","2023-10-18 12:37:21","");
INSERT INTO sales VALUES("466","BM-20231018-0296","2","2","","","1","1","1","2","2","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-18 12:47:41","2023-10-18 12:47:41","");
INSERT INTO sales VALUES("467","BM-20231018-0297","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-18 13:14:51","2023-10-18 13:14:51","");
INSERT INTO sales VALUES("468","BM-20231018-0298","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-18 15:47:17","2023-10-18 15:47:17","");
INSERT INTO sales VALUES("469","BM-20231018-0299","2","2","","","1","1","1","2","2","0","0","4440","4440","2","1","0","0","Flat","","0","","","0","1","4","","4440","","","2023-10-18 16:07:41","2023-10-18 16:07:41","");
INSERT INTO sales VALUES("470","BM-20231018-0300","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-18 19:52:22","2023-10-18 19:52:22","");
INSERT INTO sales VALUES("471","BM-20231018-0301","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-18 21:14:50","2023-10-18 21:14:50","");
INSERT INTO sales VALUES("472","BM-20231019-0302","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-19 11:44:05","2023-10-19 11:44:05","");
INSERT INTO sales VALUES("473","BM-20231019-0303","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-19 12:25:35","2023-10-19 12:25:35","");
INSERT INTO sales VALUES("474","BM-20231019-0304","2","2","","","1","1","1","1","1","0","0","510","510","2","1","0","0","Flat","","0","","","0","1","4","","510","","","2023-10-19 13:49:00","2023-10-19 13:49:00","");
INSERT INTO sales VALUES("475","BM-20231019-0305","2","2","","","1","1","1","2","3","0","0","1785","1785","2","1","0","0","Flat","","0","","","0","1","4","","1785","","","2023-10-19 14:05:20","2023-10-19 14:05:20","");
INSERT INTO sales VALUES("476","BM-20231019-0306","2","2","","","1","1","1","3","3","0","0","1710","1710","2","1","0","0","Flat","","0","","","0","1","4","","1710","","","2023-10-19 14:29:42","2023-10-19 14:29:42","");
INSERT INTO sales VALUES("477","BM-20231019-0307","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-19 15:09:42","2023-10-19 15:09:42","");
INSERT INTO sales VALUES("478","BM-20231019-0308","2","2","","","1","1","1","1","1","0","0","130","130","2","1","0","0","Flat","","0","","","0","1","4","","130","","","2023-10-19 17:19:30","2023-10-19 17:19:30","");
INSERT INTO sales VALUES("479","BM-20231019-0309","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-19 19:34:06","2023-10-19 19:34:06","");
INSERT INTO sales VALUES("480","BM-20231019-0310","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-19 19:34:06","2023-10-19 19:34:06","");
INSERT INTO sales VALUES("481","BM-20231019-0311","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-19 20:14:03","2023-10-19 20:14:03","");
INSERT INTO sales VALUES("482","BM-20231019-0312","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-19 22:17:01","2023-10-19 22:17:01","");
INSERT INTO sales VALUES("483","BM-20231020-0313","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-20 11:59:34","2023-10-20 11:59:34","");
INSERT INTO sales VALUES("484","BM-20231020-0314","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-10-20 12:29:27","2023-10-20 12:29:27","");
INSERT INTO sales VALUES("485","BM-20231020-0315","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-20 13:23:49","2023-10-20 13:23:49","");
INSERT INTO sales VALUES("486","BM-20231020-0316","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 13:28:52","2023-10-20 13:28:52","");
INSERT INTO sales VALUES("487","BM-20231020-0317","2","2","","","1","1","1","1","2","0","0","1020","1020","2","1","0","0","Flat","","0","","","0","1","4","","1020","","","2023-10-20 14:05:47","2023-10-20 14:05:47","");
INSERT INTO sales VALUES("488","BM-20231020-0318","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 14:14:57","2023-10-20 14:14:57","");
INSERT INTO sales VALUES("489","BM-20231020-0319","2","2","","","1","1","1","5","5","0","0","2225","2225","2","1","0","0","Flat","","0","","","0","1","4","","2225","","","2023-10-20 14:59:24","2023-10-20 14:59:24","");
INSERT INTO sales VALUES("490","BM-20231020-0320","2","2","","","1","1","1","2","2","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-20 15:18:34","2023-10-20 15:18:34","");
INSERT INTO sales VALUES("491","BM-20231020-0321","2","2","","","1","1","1","4","6","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-20 18:44:10","2023-10-20 18:44:10","");
INSERT INTO sales VALUES("492","BM-20231020-0322","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-20 18:49:54","2023-10-20 18:49:54","");
INSERT INTO sales VALUES("493","BM-20231020-0323","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 18:50:44","2023-10-20 18:50:44","");
INSERT INTO sales VALUES("494","BM-20231020-0324","2","2","","","1","1","1","1","1","0","0","370","370","2","1","0","0","Flat","","0","","","0","1","4","","370","","","2023-10-20 18:52:53","2023-10-20 18:52:53","");
INSERT INTO sales VALUES("495","BM-20231020-0325","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 18:57:55","2023-10-20 18:57:55","");
INSERT INTO sales VALUES("496","BM-20231020-0326","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 18:59:19","2023-10-20 18:59:19","");
INSERT INTO sales VALUES("497","BM-20231020-0327","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-20 19:00:32","2023-10-20 19:00:32","");
INSERT INTO sales VALUES("498","BM-20231020-0328","2","2","","","1","1","1","1","1","0","0","15","15","2","1","0","0","Flat","","0","","","0","1","4","","15","","","2023-10-20 19:05:10","2023-10-20 19:05:10","");
INSERT INTO sales VALUES("499","BM-20231020-0329","2","2","","","1","1","1","1","1","0","0","655","655","2","1","0","0","Flat","","0","","","0","1","4","","655","","","2023-10-20 20:43:28","2023-10-20 20:43:28","");
INSERT INTO sales VALUES("500","BM-20231020-0330","2","2","","","1","1","1","1","1","0","0","655","655","2","1","0","0","Flat","","0","","","0","1","4","","655","","","2023-10-20 20:43:29","2023-10-20 20:43:29","");
INSERT INTO sales VALUES("501","BM-20231020-0331","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-20 20:45:08","2023-10-20 20:45:08","");
INSERT INTO sales VALUES("502","BM-20231020-0332","2","2","","","1","1","1","5","5","0","0","2225","2225","2","1","0","0","Flat","","0","","","0","1","4","","2225","","","2023-10-20 21:42:02","2023-10-20 21:42:02","");
INSERT INTO sales VALUES("503","BM-20231021-0333","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-21 12:12:59","2023-10-21 12:12:59","");
INSERT INTO sales VALUES("504","BM-20231021-0334","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-21 14:40:34","2023-10-21 14:40:34","");
INSERT INTO sales VALUES("505","BM-20231021-0335","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-21 15:13:55","2023-10-21 15:13:55","");
INSERT INTO sales VALUES("506","BM-20231021-0336","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-21 15:14:30","2023-10-21 15:14:30","");
INSERT INTO sales VALUES("507","BM-20231021-0337","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-21 16:56:16","2023-10-21 16:56:16","");
INSERT INTO sales VALUES("508","BM-20231021-0338","2","2","","","1","1","1","3","6","0","0","1950","1950","2","1","0","0","Flat","","0","","","0","1","4","","1950","","","2023-10-21 16:58:02","2023-10-21 16:58:02","");
INSERT INTO sales VALUES("509","BM-20231021-0339","2","2","","","1","1","1","1","1","0","0","555","555","2","1","0","0","Flat","","0","","","0","1","4","","555","","","2023-10-21 16:59:07","2023-10-21 16:59:07","");
INSERT INTO sales VALUES("510","BM-20231021-0340","2","2","","","1","1","1","5","5","0","0","2705","2705","2","1","0","0","Flat","","0","","","0","1","4","","2705","","","2023-10-21 17:00:39","2023-10-21 17:00:39","");
INSERT INTO sales VALUES("511","BM-20231021-0341","2","2","","","1","1","1","2","2","0","0","710","710","2","1","0","0","Flat","","0","","","0","1","4","","710","","","2023-10-21 17:58:37","2023-10-21 17:58:37","");
INSERT INTO sales VALUES("512","BM-20231021-0342","2","2","","","1","1","1","2","2","0","0","3020","3020","2","1","0","0","Flat","","0","","","0","1","4","","3020","","","2023-10-21 18:07:38","2023-10-21 18:07:38","");
INSERT INTO sales VALUES("513","BM-20231021-0343","2","2","","","1","1","1","9","10","0","0","4420","4420","2","1","0","0","Flat","","0","","","0","1","4","","4420","","","2023-10-21 18:47:58","2023-10-21 18:47:58","");
INSERT INTO sales VALUES("514","BM-20231021-0344","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-21 19:36:48","2023-10-21 19:36:48","");
INSERT INTO sales VALUES("515","BM-20231021-0345","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-21 20:57:18","2023-10-21 20:57:18","");
INSERT INTO sales VALUES("516","BM-20231021-0346","2","2","","","1","1","1","7","8","0","0","2965","2965","2","1","0","0","Flat","","0","","","0","1","4","","2965","","","2023-10-21 21:32:19","2023-10-21 21:32:19","");
INSERT INTO sales VALUES("517","BM-20231021-0347","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-10-21 21:33:30","2023-10-21 21:33:30","");
INSERT INTO sales VALUES("518","BM-20231021-0348","2","2","","","1","1","1","1","1","0","0","490","490","2","1","0","0","Flat","","0","","","0","1","4","","490","","","2023-10-21 21:36:56","2023-10-21 21:36:56","");
INSERT INTO sales VALUES("519","BM-20231022-0349","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-22 13:50:15","2023-10-22 13:50:15","");
INSERT INTO sales VALUES("520","BM-20231022-0350","2","2","","","1","1","1","12","14","0","0","7010","7010","2","1","0","0","Flat","","0","","","0","1","4","","7010","","","2023-10-22 14:40:52","2023-10-22 14:40:52","");
INSERT INTO sales VALUES("521","BM-20231022-0351","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-22 14:46:53","2023-10-22 14:46:53","");
INSERT INTO sales VALUES("522","BM-20231022-0352","2","2","","","1","1","1","2","2","0","0","1250","1250","2","1","0","0","Flat","","0","","","0","1","4","","1250","","","2023-10-22 15:57:05","2023-10-22 15:57:05","");
INSERT INTO sales VALUES("523","BM-20231022-0353","2","2","","","1","1","1","2","2","0","0","1160","1160","2","1","0","0","Flat","","0","","","0","1","4","","1160","","","2023-10-22 16:01:22","2023-10-22 16:01:22","");
INSERT INTO sales VALUES("524","BM-20231022-0354","2","2","","","1","1","1","12","17","0","0","10180","10180","2","1","0","0","Flat","","0","","","0","1","4","","10180","","","2023-10-22 16:40:08","2023-10-22 16:40:08","");
INSERT INTO sales VALUES("525","BM-20231022-0355","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-22 17:31:25","2023-10-22 17:31:25","");
INSERT INTO sales VALUES("526","BM-20231022-0356","2","2","","","1","1","1","4","4","0","0","2075","2075","2","1","0","0","Flat","","0","","","0","1","4","","2075","","","2023-10-22 18:32:51","2023-10-22 18:32:51","");
INSERT INTO sales VALUES("527","BM-20231022-0357","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-22 19:07:05","2023-10-22 19:07:05","");
INSERT INTO sales VALUES("528","BM-20231022-0358","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-22 20:39:48","2023-10-22 20:39:48","");
INSERT INTO sales VALUES("529","BM-20231022-0359","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-10-22 20:41:08","2023-10-22 20:41:08","");
INSERT INTO sales VALUES("530","BM-20231022-0360","2","2","","","1","1","1","2","2","0","0","880","880","2","1","0","0","Flat","","0","","","0","1","4","","880","","","2023-10-22 21:30:48","2023-10-22 21:30:48","");
INSERT INTO sales VALUES("531","BM-20231022-0361","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-22 21:35:59","2023-10-22 21:35:59","");
INSERT INTO sales VALUES("532","BM-20231022-0362","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-22 21:37:16","2023-10-22 21:37:16","");
INSERT INTO sales VALUES("533","BM-20231023-0363","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 11:35:53","2023-10-23 11:35:53","");
INSERT INTO sales VALUES("534","BM-20231023-0364","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 12:20:44","2023-10-23 12:20:44","");
INSERT INTO sales VALUES("535","BM-20231023-0365","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 12:26:42","2023-10-23 12:26:42","");
INSERT INTO sales VALUES("536","BM-20231023-0366","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 12:40:19","2023-10-23 12:40:19","");
INSERT INTO sales VALUES("537","BM-20231023-0367","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-23 13:45:17","2023-10-23 13:45:17","");
INSERT INTO sales VALUES("538","BM-20231023-0368","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 14:30:16","2023-10-23 14:30:16","");
INSERT INTO sales VALUES("539","BM-20231023-0369","2","2","","","1","1","1","2","2","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-23 14:31:36","2023-10-23 14:31:36","");
INSERT INTO sales VALUES("540","BM-20231023-0370","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 15:48:15","2023-10-23 15:48:15","");
INSERT INTO sales VALUES("541","BM-20231023-0371","2","2","","","1","1","1","3","3","0","0","1250","1250","2","1","0","0","Flat","","0","","","0","1","4","","1250","","","2023-10-23 16:23:00","2023-10-23 16:23:00","");
INSERT INTO sales VALUES("542","BM-20231023-0372","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 16:47:22","2023-10-23 16:47:22","");
INSERT INTO sales VALUES("543","BM-20231023-0373","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-23 16:51:12","2023-10-23 16:51:12","");
INSERT INTO sales VALUES("544","BM-20231023-0374","2","2","","","1","1","1","1","1","0","0","90","90","2","1","0","0","Flat","","0","","","0","1","4","","90","","","2023-10-23 18:37:33","2023-10-23 18:37:33","");
INSERT INTO sales VALUES("545","BM-20231023-0375","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-23 18:49:24","2023-10-23 18:49:24","");
INSERT INTO sales VALUES("546","BM-20231023-0376","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-23 20:46:19","2023-10-23 20:46:19","");
INSERT INTO sales VALUES("547","BM-20231023-0377","2","2","","","1","1","1","2","2","0","0","955","955","2","1","0","0","Flat","","0","","","0","1","4","","955","","","2023-10-23 21:25:02","2023-10-23 21:25:02","");
INSERT INTO sales VALUES("548","BM-20231023-0378","2","2","","","1","1","1","1","1","0","0","420","420","2","1","0","0","Flat","","0","","","0","1","4","","420","","","2023-10-23 21:31:50","2023-10-23 21:31:50","");
INSERT INTO sales VALUES("549","BM-20231024-0379","2","2","","","1","1","1","1","2","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-24 12:43:02","2023-10-24 12:43:02","");
INSERT INTO sales VALUES("550","BM-20231024-0380","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-24 13:30:56","2023-10-24 13:30:56","");
INSERT INTO sales VALUES("551","BM-20231024-0381","2","2","","","1","1","1","4","6","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-24 14:41:10","2023-10-24 14:41:10","");
INSERT INTO sales VALUES("552","BM-20231024-0382","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-24 20:09:31","2023-10-24 20:09:31","");
INSERT INTO sales VALUES("553","BM-20231024-0383","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-24 20:12:14","2023-10-24 20:12:14","");
INSERT INTO sales VALUES("554","BM-20231024-0384","2","2","","","1","1","1","1","2","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-24 20:13:43","2023-10-24 20:13:43","");
INSERT INTO sales VALUES("555","BM-20231024-0385","2","2","","","1","1","1","2","3","0","0","80","80","2","1","0","0","Flat","","0","","","0","1","4","","80","","","2023-10-24 20:53:52","2023-10-24 20:53:53","");
INSERT INTO sales VALUES("556","BM-20231025-0386","2","2","","","1","1","1","2","2","0","0","600","600","2","1","0","0","Flat","","0","","","0","1","4","","600","","","2023-10-25 11:54:59","2023-10-25 11:54:59","");
INSERT INTO sales VALUES("557","BM-20231025-0387","2","2","","","1","1","1","1","1","0","0","105","105","2","1","0","0","Flat","","0","","","0","1","4","","105","","","2023-10-25 12:32:11","2023-10-25 12:32:11","");
INSERT INTO sales VALUES("558","BM-20231025-0388","2","2","","","1","1","1","4","9","0","0","3925","3925","2","1","0","0","Flat","","0","","","0","1","4","","3925","","","2023-10-25 13:33:56","2023-10-25 13:33:56","");
INSERT INTO sales VALUES("559","BM-20231025-0389","2","2","","","1","1","1","1","1","0","0","520","520","2","1","0","0","Flat","","0","","","0","1","4","","520","","","2023-10-25 16:18:30","2023-10-25 16:18:30","");
INSERT INTO sales VALUES("560","BM-20231025-0390","2","2","","","1","1","1","2","3","0","0","1710","1710","2","1","0","0","Flat","","0","","","0","1","4","","1710","","","2023-10-25 18:14:26","2023-10-25 18:14:26","");
INSERT INTO sales VALUES("561","BM-20231025-0391","2","2","","","1","1","1","1","1","0","0","510","510","2","1","0","0","Flat","","0","","","0","1","4","","510","","","2023-10-25 18:30:25","2023-10-25 18:30:25","");
INSERT INTO sales VALUES("562","BM-20231025-0392","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-25 19:04:36","2023-10-25 19:04:36","");
INSERT INTO sales VALUES("563","BM-20231025-0393","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-25 19:06:05","2023-10-25 19:06:05","");
INSERT INTO sales VALUES("564","BM-20231025-0394","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-10-25 19:21:20","2023-10-25 19:21:20","");
INSERT INTO sales VALUES("565","BM-20231026-0395","2","2","","","1","1","1","1","13","0","0","8840","8840","2","1","0","0","Flat","","0","","","0","1","4","","8840","","","2023-10-26 10:40:33","2023-10-26 10:40:33","");
INSERT INTO sales VALUES("566","BM-20231026-0396","2","2","","","1","1","1","1","3","0","0","300","300","2","1","0","0","Flat","","0","","","0","1","4","","300","","","2023-10-26 10:41:35","2023-10-26 10:41:35","");
INSERT INTO sales VALUES("567","BM-20231026-0397","2","2","","","1","1","1","1","4","0","0","80","80","2","1","0","0","Flat","","0","","","0","1","4","","80","","","2023-10-26 10:43:17","2023-10-26 10:43:17","");
INSERT INTO sales VALUES("568","BM-20231026-0398","2","2","","","1","1","1","1","2","0","0","800","800","2","1","0","0","Flat","","0","","","0","1","4","","800","","","2023-10-26 10:55:04","2023-10-26 10:55:04","");
INSERT INTO sales VALUES("569","BM-20231026-0399","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-26 12:31:29","2023-10-26 12:31:29","");
INSERT INTO sales VALUES("570","BM-20231026-0400","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-26 12:34:56","2023-10-26 12:34:56","");
INSERT INTO sales VALUES("571","BM-20231026-0401","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-26 12:44:52","2023-10-26 12:44:52","");
INSERT INTO sales VALUES("572","BM-20231026-0402","2","2","","","1","1","1","2","2","0","0","990","990","2","1","0","0","Flat","","0","","","0","1","4","","990","","","2023-10-26 13:00:37","2023-10-26 13:00:37","");
INSERT INTO sales VALUES("573","BM-20231026-0403","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-26 13:10:56","2023-10-26 13:10:56","");
INSERT INTO sales VALUES("574","BM-20231026-0404","2","2","","","1","1","1","2","2","0","0","1080","1080","2","1","0","0","Flat","","0","","","0","1","4","","1080","","","2023-10-26 18:06:03","2023-10-26 18:06:03","");
INSERT INTO sales VALUES("575","BM-20231026-0405","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-26 18:08:29","2023-10-26 18:08:29","");
INSERT INTO sales VALUES("576","BM-20231026-0406","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-26 19:09:06","2023-10-26 19:09:06","");
INSERT INTO sales VALUES("577","BM-20231026-0407","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-26 19:41:27","2023-10-26 19:41:27","");
INSERT INTO sales VALUES("578","BM-20231027-0408","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-27 11:27:24","2023-10-27 11:27:24","");
INSERT INTO sales VALUES("579","BM-20231027-0409","2","2","","","1","1","1","7","8","0","0","3320","3320","2","1","0","0","Flat","","0","","","0","1","4","","3320","","","2023-10-27 13:14:26","2023-10-27 13:14:26","");
INSERT INTO sales VALUES("580","BM-20231027-0410","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-27 14:13:25","2023-10-27 14:13:25","");
INSERT INTO sales VALUES("581","BM-20231027-0411","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-27 14:36:47","2023-10-27 14:36:47","");
INSERT INTO sales VALUES("582","BM-20231027-0412","2","2","","","1","1","1","2","3","0","0","1640","1640","2","1","0","0","Flat","","0","","","0","1","4","","1640","","","2023-10-27 14:55:29","2023-10-27 14:55:29","");
INSERT INTO sales VALUES("583","BM-20231027-0413","2","2","","","1","1","1","2","2","0","0","1160","1160","2","1","0","0","Flat","","0","","","0","1","4","","1160","","","2023-10-27 17:42:10","2023-10-27 17:42:10","");
INSERT INTO sales VALUES("584","BM-20231027-0414","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-27 19:12:34","2023-10-27 19:12:34","");
INSERT INTO sales VALUES("585","BM-20231027-0415","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-27 19:14:17","2023-10-27 19:14:17","");
INSERT INTO sales VALUES("586","BM-20231027-0416","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-27 19:50:37","2023-10-27 19:50:37","");
INSERT INTO sales VALUES("587","BM-20231027-0417","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-27 20:02:18","2023-10-27 20:02:18","");
INSERT INTO sales VALUES("588","BM-20231027-0418","2","2","","","1","1","1","1","1","0","0","320","320","2","1","0","0","Flat","","0","","","0","1","4","","320","","","2023-10-27 20:12:00","2023-10-27 20:12:00","");
INSERT INTO sales VALUES("589","BM-20231027-0419","2","2","","","1","1","1","2","4","0","0","2090","2090","2","1","0","0","Flat","","0","","","0","1","4","","2090","","","2023-10-27 21:34:53","2023-10-27 21:34:53","");
INSERT INTO sales VALUES("590","BM-20231027-0420","2","2","","","1","1","1","2","3","0","0","640","640","2","1","0","0","Flat","","0","","","0","1","4","","640","","","2023-10-27 21:51:15","2023-10-27 21:51:15","");
INSERT INTO sales VALUES("591","BM-20231028-0421","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-28 11:50:59","2023-10-28 11:50:59","");
INSERT INTO sales VALUES("592","BM-20231028-0422","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-28 11:50:59","2023-10-28 11:50:59","");
INSERT INTO sales VALUES("593","BM-20231028-0423","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-28 11:52:26","2023-10-28 11:52:26","");
INSERT INTO sales VALUES("594","BM-20231028-0424","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-28 12:55:12","2023-10-28 12:55:12","");
INSERT INTO sales VALUES("595","BM-20231028-0425","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-28 13:43:11","2023-10-28 13:43:11","");
INSERT INTO sales VALUES("596","BM-20231028-0426","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-28 15:26:25","2023-10-28 15:26:25","");
INSERT INTO sales VALUES("597","BM-20231028-0427","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-28 16:50:33","2023-10-28 16:50:33","");
INSERT INTO sales VALUES("598","BM-20231028-0428","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-28 17:12:53","2023-10-28 17:12:53","");
INSERT INTO sales VALUES("599","BM-20231028-0429","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-28 17:20:41","2023-10-28 17:20:41","");
INSERT INTO sales VALUES("600","BM-20231028-0430","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-28 17:29:07","2023-10-28 17:29:07","");
INSERT INTO sales VALUES("601","BM-20231028-0431","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-28 18:00:30","2023-10-28 18:00:30","");
INSERT INTO sales VALUES("602","BM-20231028-0432","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-10-28 18:13:10","2023-10-28 18:13:10","");
INSERT INTO sales VALUES("603","BM-20231028-0433","2","2","","","1","1","1","4","4","0","0","1655","1655","2","1","0","0","Flat","","0","","","0","1","4","","1655","","","2023-10-28 20:45:32","2023-10-28 20:45:32","");
INSERT INTO sales VALUES("604","BM-20231028-0434","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-28 20:52:39","2023-10-28 20:52:39","");
INSERT INTO sales VALUES("605","BM-20231029-0435","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-10-29 17:58:58","2023-10-29 17:58:58","");
INSERT INTO sales VALUES("606","BM-20231029-0436","2","2","","","1","1","1","3","3","0","0","1480","1480","2","1","0","0","Flat","","0","","","0","1","4","","1480","","","2023-10-29 18:00:09","2023-10-29 18:00:09","");
INSERT INTO sales VALUES("607","BM-20231029-0437","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-10-29 18:01:06","2023-10-29 18:01:06","");
INSERT INTO sales VALUES("608","BM-20231029-0438","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 18:02:08","2023-10-29 18:02:08","");
INSERT INTO sales VALUES("609","BM-20231029-0439","2","2","","","1","1","1","2","2","0","0","690","690","2","1","0","0","Flat","","0","","","0","1","4","","690","","","2023-10-29 18:03:27","2023-10-29 18:03:27","");
INSERT INTO sales VALUES("610","BM-20231029-0440","2","2","","","1","1","1","2","2","0","0","1120","1120","2","1","0","0","Flat","","0","","","0","1","4","","1120","","","2023-10-29 18:12:36","2023-10-29 18:12:36","");
INSERT INTO sales VALUES("611","BM-20231029-0441","2","2","","","1","1","1","1","2","0","0","1360","1360","2","1","0","0","Flat","","0","","","0","1","4","","1360","","","2023-10-29 18:21:15","2023-10-29 18:21:15","");
INSERT INTO sales VALUES("612","BM-20231029-0442","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 18:23:42","2023-10-29 18:23:42","");
INSERT INTO sales VALUES("613","BM-20231029-0443","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 18:24:24","2023-10-29 18:24:24","");
INSERT INTO sales VALUES("614","BM-20231029-0444","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 18:36:24","2023-10-29 18:36:24","");
INSERT INTO sales VALUES("615","BM-20231029-0445","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 18:55:29","2023-10-29 18:55:29","");
INSERT INTO sales VALUES("616","BM-20231029-0446","2","2","","","1","1","1","2","2","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-29 19:31:04","2023-10-29 19:31:04","");
INSERT INTO sales VALUES("617","BM-20231029-0447","2","2","","","1","1","1","6","8","0","0","2720","2720","2","1","0","0","Flat","","0","","","0","1","4","","2720","","","2023-10-29 21:04:38","2023-10-29 21:04:38","");
INSERT INTO sales VALUES("618","BM-20231029-0448","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-29 21:06:12","2023-10-29 21:06:12","");
INSERT INTO sales VALUES("619","BM-20231029-0449","2","2","","","1","1","1","1","1","0","0","405","405","2","1","0","0","Flat","","0","","","0","1","4","","405","","","2023-10-29 21:11:04","2023-10-29 21:11:04","");
INSERT INTO sales VALUES("620","BM-20231030-0450","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-30 11:40:46","2023-10-30 11:40:46","");
INSERT INTO sales VALUES("621","BM-20231030-0451","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-10-30 12:40:46","2023-10-30 12:40:46","");
INSERT INTO sales VALUES("622","BM-20231030-0452","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-30 12:47:15","2023-10-30 12:47:15","");
INSERT INTO sales VALUES("623","BM-20231030-0453","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-30 13:56:19","2023-10-30 13:56:19","");
INSERT INTO sales VALUES("624","BM-20231030-0454","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-30 14:27:11","2023-10-30 14:27:11","");
INSERT INTO sales VALUES("625","BM-20231030-0455","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-10-30 14:27:57","2023-10-30 14:27:57","");
INSERT INTO sales VALUES("626","BM-20231030-0456","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-30 15:03:58","2023-10-30 15:03:58","");
INSERT INTO sales VALUES("627","BM-20231030-0457","2","2","","","1","1","1","1","1","0","0","270","270","2","1","0","0","Flat","","0","","","0","1","4","","270","","","2023-10-30 17:07:57","2023-10-30 17:07:57","");
INSERT INTO sales VALUES("628","BM-20231030-0458","2","2","","","1","1","1","1","1","0","0","680","680","2","1","0","0","Flat","","0","","","0","1","4","","680","","","2023-10-30 17:41:55","2023-10-30 17:41:55","");
INSERT INTO sales VALUES("629","BM-20231030-0459","2","2","","","1","1","1","2","2","0","0","600","600","2","1","0","0","Flat","","0","","","0","1","4","","600","","","2023-10-30 20:33:29","2023-10-30 20:33:29","");
INSERT INTO sales VALUES("630","BM-20231030-0460","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-30 20:51:28","2023-10-30 20:51:28","");
INSERT INTO sales VALUES("631","BM-20231030-0461","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-30 20:59:40","2023-10-30 20:59:40","");
INSERT INTO sales VALUES("632","BM-20231030-0462","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-30 21:18:08","2023-10-30 21:18:08","");
INSERT INTO sales VALUES("633","BM-20231030-0463","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-10-30 21:35:52","2023-10-30 21:35:52","");
INSERT INTO sales VALUES("634","BM-20231030-0464","2","2","","","1","1","1","1","1","0","0","195","195","2","1","0","0","Flat","","0","","","0","1","4","","195","","","2023-10-30 21:45:21","2023-10-30 21:45:21","");
INSERT INTO sales VALUES("635","BM-20231030-0465","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-10-30 21:56:55","2023-10-30 21:56:55","");
INSERT INTO sales VALUES("636","BM-20231031-0466","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-31 13:08:49","2023-10-31 13:08:49","");
INSERT INTO sales VALUES("637","BM-20231031-0467","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-10-31 13:24:18","2023-10-31 13:24:18","");
INSERT INTO sales VALUES("638","BM-20231031-0468","2","2","","","1","1","1","1","1","0","0","35","35","2","1","0","0","Flat","","0","","","0","1","4","","35","","","2023-10-31 15:02:35","2023-10-31 15:02:35","");
INSERT INTO sales VALUES("639","BM-20231031-0469","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-10-31 15:25:06","2023-10-31 15:25:06","");
INSERT INTO sales VALUES("640","BM-20231031-0470","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-31 16:01:58","2023-10-31 16:01:58","");
INSERT INTO sales VALUES("641","BM-20231031-0471","2","2","","","1","1","1","4","8","0","0","3670","3670","2","1","0","0","Flat","","0","","","0","1","4","","3670","","","2023-10-31 18:13:22","2023-10-31 18:13:22","");
INSERT INTO sales VALUES("642","BM-20231031-0472","2","2","","","1","1","1","1","1","0","0","200","200","2","1","0","0","Flat","","0","","","0","1","4","","200","","","2023-10-31 18:24:53","2023-10-31 18:24:53","");
INSERT INTO sales VALUES("643","BM-20231031-0473","2","2","","","1","1","1","3","3","0","0","975","975","2","1","0","0","Flat","","0","","","0","1","4","","975","","","2023-10-31 19:58:07","2023-10-31 19:58:07","");
INSERT INTO sales VALUES("644","BM-20231101-0474","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-01 12:23:14","2023-11-01 12:23:14","");
INSERT INTO sales VALUES("645","BM-20231101-0475","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-01 12:54:58","2023-11-01 12:54:58","");
INSERT INTO sales VALUES("646","BM-20231101-0476","2","2","","","1","1","1","1","1","0","0","75","75","2","1","0","0","Flat","","0","","","0","1","4","","75","","","2023-11-01 13:03:26","2023-11-01 13:03:26","");
INSERT INTO sales VALUES("647","BM-20231101-0477","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-11-01 14:45:18","2023-11-01 14:45:18","");
INSERT INTO sales VALUES("648","BM-20231102-0478","2","2","","","1","1","1","1","2","0","0","550","550","2","1","0","0","Flat","","0","","","0","1","4","","550","","","2023-11-02 13:13:49","2023-11-02 13:13:49","");
INSERT INTO sales VALUES("649","BM-20231102-0479","2","2","","","1","1","1","4","4","0","0","1545","1545","2","1","0","0","Flat","","0","","","0","1","4","","1545","","","2023-11-02 19:13:13","2023-11-02 19:13:13","");
INSERT INTO sales VALUES("650","BM-20231102-0480","2","2","","","1","1","1","1","1","0","0","270","270","2","1","0","0","Flat","","0","","","0","1","4","","270","","","2023-11-02 19:23:24","2023-11-02 19:23:24","");
INSERT INTO sales VALUES("651","BM-20231102-0481","2","2","","","1","1","1","1","2","0","0","800","800","2","1","0","0","Flat","","0","","","0","1","4","","800","","","2023-11-02 19:25:41","2023-11-02 19:25:41","");
INSERT INTO sales VALUES("652","BM-20231102-0482","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-02 19:27:35","2023-11-02 19:27:35","");
INSERT INTO sales VALUES("653","BM-20231102-0483","2","2","","","1","1","1","1","1","0","0","100","100","2","1","0","0","Flat","","0","","","0","1","4","","100","","","2023-11-02 19:28:42","2023-11-02 19:28:42","");
INSERT INTO sales VALUES("654","BM-20231102-0484","2","2","","","1","1","1","1","2","0","0","150","150","2","1","0","0","Flat","","0","","","0","1","4","","150","","","2023-11-02 19:48:19","2023-11-02 19:48:19","");
INSERT INTO sales VALUES("655","BM-20231103-0485","2","2","","","1","1","1","1","1","0","0","275","275","2","1","0","0","Flat","","0","","","0","1","4","","275","","","2023-11-03 11:18:07","2023-11-03 11:18:07","");
INSERT INTO sales VALUES("656","BM-20231103-0486","2","2","","","1","1","1","1","1","0","0","100","100","2","1","0","0","Flat","","0","","","0","1","4","","100","","","2023-11-03 13:27:28","2023-11-03 13:27:28","");
INSERT INTO sales VALUES("657","BM-20231103-0487","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-03 14:03:06","2023-11-03 14:03:06","");
INSERT INTO sales VALUES("658","BM-20231103-0488","2","2","","","1","1","1","1","1","0","0","930","930","2","1","0","0","Flat","","0","","","0","1","4","","930","","","2023-11-03 19:40:58","2023-11-03 19:40:58","");
INSERT INTO sales VALUES("659","BM-20231103-0489","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-11-03 19:57:22","2023-11-03 19:57:22","");
INSERT INTO sales VALUES("660","BM-20231103-0490","2","2","","","1","1","1","1","4","0","0","1860","1860","2","1","0","0","Flat","","0","","","0","1","4","","1860","","","2023-11-03 21:43:52","2023-11-03 21:43:52","");
INSERT INTO sales VALUES("661","BM-20231104-0491","2","2","","","1","1","1","1","1","0","0","440","440","2","1","0","0","Flat","","0","","","0","1","4","","440","","","2023-11-04 19:12:26","2023-11-04 19:12:26","");
INSERT INTO sales VALUES("662","BM-20231104-0492","2","2","","","1","1","1","1","1","0","0","20","20","2","1","0","0","Flat","","0","","","0","1","4","","20","","","2023-11-04 19:13:17","2023-11-04 19:13:17","");
INSERT INTO sales VALUES("663","BM-20231104-0493","2","2","","","1","1","1","1","1","0","0","10","10","2","1","0","0","Flat","","0","","","0","1","4","","10","","","2023-11-04 19:18:24","2023-11-04 19:18:24","");
INSERT INTO sales VALUES("664","BM-20231104-0494","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-04 19:18:54","2023-11-04 19:18:54","");
INSERT INTO sales VALUES("665","BM-20231104-0495","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-04 19:20:05","2023-11-04 19:20:05","");
INSERT INTO sales VALUES("666","BM-20231105-0496","2","2","","","1","1","1","2","2","0","0","600","600","2","1","0","0","Flat","","0","","","0","1","4","","600","","","2023-11-05 19:37:56","2023-11-05 19:37:56","");
INSERT INTO sales VALUES("667","BM-20231105-0497","2","2","","","1","1","1","15","19","0","0","7295","7295","2","1","0","0","Flat","","0","","","0","1","4","","7295","","","2023-11-05 20:00:47","2023-11-05 20:00:47","");
INSERT INTO sales VALUES("668","BM-20231105-0498","2","2","","","1","1","1","10","11","0","0","4750","4750","2","1","0","0","Flat","","0","","","0","1","4","","4750","","","2023-11-05 20:07:38","2023-11-05 20:07:38","");
INSERT INTO sales VALUES("669","BM-20231105-0499","2","2","","","1","1","1","1","2","0","0","40","40","2","1","0","0","Flat","","0","","","0","1","4","","40","","","2023-11-05 21:26:45","2023-11-05 21:26:45","");
INSERT INTO sales VALUES("670","BM-20231106-0500","2","2","","","1","1","1","3","4","0","0","1755","1755","2","1","0","0","Flat","","0","","","0","1","4","","1755","","","2023-11-06 12:25:30","2023-11-06 12:25:30","");
INSERT INTO sales VALUES("671","BM-20231106-0501","2","2","","","1","1","1","1","1","0","0","375","375","2","1","0","0","Flat","","0","","","0","1","4","","375","","","2023-11-06 14:21:55","2023-11-06 14:21:55","");
INSERT INTO sales VALUES("672","BM-20231107-0502","2","2","","","1","1","1","2","2","0","0","800","800","2","1","0","0","Flat","","0","","","0","1","4","","800","","","2023-11-07 12:46:37","2023-11-07 12:46:37","");
INSERT INTO sales VALUES("673","BM-20231107-0503","2","2","","","1","1","1","1","2","0","0","880","880","2","1","0","0","Flat","","0","","","0","1","4","","880","","","2023-11-07 12:48:34","2023-11-07 12:48:34","");
INSERT INTO sales VALUES("674","BM-20231107-0504","2","2","","","1","1","1","1","1","0","0","30","30","2","1","0","0","Flat","","0","","","0","1","4","","30","","","2023-11-07 12:54:28","2023-11-07 12:54:28","");
INSERT INTO sales VALUES("675","BM-20231107-0505","2","2","","","1","1","1","3","3","0","0","1045","1045","2","1","0","0","Flat","","0","","","0","1","4","","1045","","","2023-11-07 14:45:40","2023-11-07 14:45:40","");
INSERT INTO sales VALUES("676","BM-20231107-0506","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-07 15:00:45","2023-11-07 15:00:45","");
INSERT INTO sales VALUES("677","BM-20231107-0507","2","2","","","1","1","1","1","1","0","0","400","400","2","1","0","0","Flat","","0","","","0","1","4","","400","","","2023-11-07 15:04:44","2023-11-07 15:04:44","");
INSERT INTO sales VALUES("678","BM-20231107-0508","2","2","","","1","1","1","1","1","0","0","30","30","2","1","0","0","Flat","","0","","","0","1","4","","30","","","2023-11-07 15:06:59","2023-11-07 15:06:59","");
INSERT INTO sales VALUES("679","BM-20231107-0509","2","2","","","1","1","1","1","1","0","0","310","310","2","1","0","0","Flat","","0","","","0","1","4","","310","","","2023-11-07 15:35:31","2023-11-07 15:35:31","");
INSERT INTO sales VALUES("680","BM-20231107-0510","2","2","","","1","1","1","3","3","0","0","2945","2945","2","1","0","0","Flat","","0","","","0","1","4","","2945","","","2023-11-07 15:44:41","2023-11-07 15:44:41","");
INSERT INTO sales VALUES("681","BM-20231107-0511","2","2","","","1","1","1","1","1","0","0","320","320","2","1","0","0","Fl