 <?php $__env->startSection('content'); ?>

<?php if(session()->has('message')): ?>
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('message')); ?></div>
<?php endif; ?>
<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
<?php endif; ?>
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4><?php echo e(trans('file.Mail Setting')); ?></h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                        <?php echo Form::open(['route' => 'setting.mailStore', 'files' => true, 'method' => 'post']); ?>

                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Mail Driver')); ?> *</label>
                                <input type="text" name="driver" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->driver); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Mail Host')); ?> *</label>
                                <input type="text" name="host" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->host); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Mail Port')); ?> *</label>
                                <input type="text" name="port" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->port); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Mail Address')); ?> *</label>
                                <input type="text" name="from_address" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->from_address); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Mail From Name')); ?> *</label>
                                <input type="text" name="from_name" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->from_name); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.UserName')); ?> *</label>
                                <input type="text" name="username" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->username); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Password')); ?> *</label>
                                <input type="password" name="password" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->password); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo e(trans('file.Encryption')); ?> *</label>
                                <input type="text" name="encryption" class="form-control" value="<?php if($mail_setting_data): ?><?php echo e($mail_setting_data->encryption); ?><?php endif; ?>" required />
                            </div>
                            <div class="col-md-12 form-group">
                                <input type="submit" value="<?php echo e(trans('file.submit')); ?>" class="btn btn-primary">
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    $("ul#setting").siblings('a').attr('aria-expanded','true');
    $("ul#setting").addClass("show");
    $("ul#setting #mail-setting-menu").addClass("active");
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/homecar1/istock.myne.co.ke/resources/views/backend/setting/mail_setting.blade.php ENDPATH**/ ?>